#@(#) Tables for contacts

CREATE TABLE prg_dlist (
    intfield01 INT4 NOT NULL,
    intfield02 INT4,
    intfield03 INT4,
    intfield04 INT4,
    field01 VARCHAR(320),
    field02 VARCHAR(128),
    field03 VARCHAR(128),
    field04 VARCHAR(128),
    cid INT4,
    INDEX (intfield01, cid),
    INDEX (intfield01, intfield02, intfield03, cid)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE del_dlist (
    intfield01 INT4 NOT NULL,
    intfield02 INT4,
    intfield03 INT4,
    intfield04 INT4,
    field01 VARCHAR(320),
    field02 VARCHAR(128),
    field03 VARCHAR(128),
    field04 VARCHAR(128),
    cid INT4 NOT NULL,
    INDEX (intfield01, cid),
    INDEX (intfield01, intfield02, intfield03, cid)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE prg_contacts_linkage (
    intfield01 INT4 NOT NULL,
    intfield02 INT4 NOT NULL,
    field01 VARCHAR(320),
    field02 VARCHAR(320),
    cid INT4 NOT NULL,
    INDEX (intfield01, intfield02, cid),
    INDEX (cid)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE prg_contacts_image (
    intfield01 INT4 NOT NULL,
    image1 MEDIUMBLOB,
    changing_date INT8 NOT NULL,
    mime_type VARCHAR(32) NOT NULL,
    cid INT4 NOT NULL,
    PRIMARY KEY (cid, intfield01)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE del_contacts_image (
    intfield01 INT4 NOT NULL,
    image1 MEDIUMBLOB,
    changing_date INT8 NOT NULL,
    mime_type VARCHAR(32) NOT NULL,
    cid INT4 NOT NULL,
    PRIMARY KEY (cid, intfield01)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE del_contacts (
    creating_date INT8 NOT NULL,
    created_from INT4 NOT NULL,
    changing_date INT8 NOT NULL,
    changed_from INT4,
    fid INT4 NOT NULL,
    cid INT4 NOT NULL,
    userid INT4,
    pflag INT4,
    timestampfield01 DATE,
    timestampfield02 DATE,
    intfield01 INT4 NOT NULL,
    intfield02 INT4,
    intfield03 INT4,
    intfield04 INT4,
    intfield05 INT4,
    intfield06 INT4,
    intfield07 INT4,
    intfield08 INT4,
    field01 VARCHAR(320),
    field02 VARCHAR(128),
    field03 VARCHAR(128),
    field04 VARCHAR(128),
    field05 VARCHAR(64),
    field06 VARCHAR(64),
    field07 VARCHAR(256),
    field08 VARCHAR(64),
    field09 VARCHAR(64),
    field10 VARCHAR(64),
    field11 VARCHAR(64),
    field12 VARCHAR(64),
    field13 VARCHAR(64),
    field14 VARCHAR(64),
    field15 VARCHAR(64),
    field16 VARCHAR(64),
    field17 VARCHAR(5680),
    field18 VARCHAR(512),
    field19 VARCHAR(128),
    field20 VARCHAR(128),
    field21 VARCHAR(64),
    field22 VARCHAR(64),
    field23 VARCHAR(256),
    field24 VARCHAR(64),
    field25 VARCHAR(128),
    field26 VARCHAR(64),
    field27 VARCHAR(64),
    field28 VARCHAR(64),
    field29 VARCHAR(64),
    field30 VARCHAR(128),
    field31 VARCHAR(64),
    field32 VARCHAR(64),
    field33 VARCHAR(64),
    field34 TEXT,
    field35 VARCHAR(64),
    field36 VARCHAR(64),
    field37 VARCHAR(256),
    field38 VARCHAR(64),
    field39 VARCHAR(64),
    field40 VARCHAR(64),
    field41 VARCHAR(64),
    field42 VARCHAR(64),
    field43 VARCHAR(64),
    field44 VARCHAR(128),
    field45 VARCHAR(64),
    field46 VARCHAR(64),
    field47 VARCHAR(64),
    field48 VARCHAR(64),
    field49 VARCHAR(64),
    field50 VARCHAR(64),
    field51 VARCHAR(64),
    field52 VARCHAR(64),
    field53 VARCHAR(64),
    field54 VARCHAR(64),
    field55 VARCHAR(64),
    field56 VARCHAR(64),
    field57 VARCHAR(64),
    field58 VARCHAR(64),
    field59 VARCHAR(64),
    field60 VARCHAR(64),
    field61 VARCHAR(64),
    field62 VARCHAR(64),
    field63 VARCHAR(64),
    field64 VARCHAR(64),
    field65 VARCHAR(256),
    field66 VARCHAR(256),
    field67 VARCHAR(256),
    field68 VARCHAR(128),
    field69 VARCHAR(1024),
    field70 VARCHAR(64),
    field71 VARCHAR(64),
    field72 VARCHAR(64),
    field73 VARCHAR(64),
    field74 VARCHAR(64),
    field75 VARCHAR(64),
    field76 VARCHAR(64),
    field77 VARCHAR(64),
    field78 VARCHAR(64),
    field79 VARCHAR(64),
    field80 VARCHAR(64),
    field81 VARCHAR(64),
    field82 VARCHAR(64),
    field83 VARCHAR(64),
    field84 VARCHAR(64),
    field85 VARCHAR(64),
    field86 VARCHAR(64),
    field87 VARCHAR(64),
    field88 VARCHAR(64),
    field89 VARCHAR(64),
    field90 VARCHAR(320),
    useCount INT4 UNSIGNED,
    yomiFirstName VARCHAR(128),
    yomiLastName VARCHAR(128),
    yomiCompany VARCHAR(512),
    homeAddress VARCHAR(512) collate utf8_unicode_ci default NULL,
    businessAddress VARCHAR(512) collate utf8_unicode_ci default NULL,
    otherAddress VARCHAR(512) collate utf8_unicode_ci default NULL,
    uid VARCHAR(255) collate utf8_unicode_ci default NULL,
    filename VARCHAR(255) collate utf8_unicode_ci default NULL,
    INDEX (created_from),
    INDEX (changing_date),
    INDEX (userid),
    INDEX (cid, fid),
    INDEX `givenname` (`cid`,`field03`),
    INDEX `surname` (`cid`,`field02`),
    INDEX `displayname` (`cid`,`field01`(255)),
    INDEX `email1` (`cid`,`field65`(255)),
    INDEX `email2` (`cid`,`field66`(255)),
    INDEX `email3` (`cid`,`field67`(255)),
    PRIMARY KEY (cid, intfield01)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE prg_contacts (
    creating_date INT8 NOT NULL,
    created_from INT4 NOT NULL,
    changing_date INT8 NOT NULL,
    changed_from INT4,
    fid INT4 NOT NULL,
    cid INT4 NOT NULL,
    userid INT4,
    pflag INT4,
    timestampfield01 DATE,
    timestampfield02 DATE,
    intfield01 INT4 NOT NULL,
    intfield02 INT4,
    intfield03 INT4,
    intfield04 INT4,
    intfield05 INT4,
    intfield06 INT4,
    intfield07 INT4,
    intfield08 INT4,
    field01 VARCHAR(320),
    field02 VARCHAR(128),
    field03 VARCHAR(128),
    field04 VARCHAR(128),
    field05 VARCHAR(64),
    field06 VARCHAR(64),
    field07 VARCHAR(256),
    field08 VARCHAR(64),
    field09 VARCHAR(64),
    field10 VARCHAR(64),
    field11 VARCHAR(64),
    field12 VARCHAR(64),
    field13 VARCHAR(64),
    field14 VARCHAR(64),
    field15 VARCHAR(64),
    field16 VARCHAR(64),
    field17 VARCHAR(5680),
    field18 VARCHAR(512),
    field19 VARCHAR(128),
    field20 VARCHAR(128),
    field21 VARCHAR(64),
    field22 VARCHAR(64),
    field23 VARCHAR(256),
    field24 VARCHAR(64),
    field25 VARCHAR(128),
    field26 VARCHAR(64),
    field27 VARCHAR(64),
    field28 VARCHAR(64),
    field29 VARCHAR(64),
    field30 VARCHAR(128),
    field31 VARCHAR(64),
    field32 VARCHAR(64),
    field33 VARCHAR(64),
    field34 TEXT,
    field35 VARCHAR(64),
    field36 VARCHAR(64),
    field37 VARCHAR(256),
    field38 VARCHAR(64),
    field39 VARCHAR(64),
    field40 VARCHAR(64),
    field41 VARCHAR(64),
    field42 VARCHAR(64),
    field43 VARCHAR(64),
    field44 VARCHAR(128),
    field45 VARCHAR(64),
    field46 VARCHAR(64),
    field47 VARCHAR(64),
    field48 VARCHAR(64),
    field49 VARCHAR(64),
    field50 VARCHAR(64),
    field51 VARCHAR(64),
    field52 VARCHAR(64),
    field53 VARCHAR(64),
    field54 VARCHAR(64),
    field55 VARCHAR(64),
    field56 VARCHAR(64),
    field57 VARCHAR(64),
    field58 VARCHAR(64),
    field59 VARCHAR(64),
    field60 VARCHAR(64),
    field61 VARCHAR(64),
    field62 VARCHAR(64),
    field63 VARCHAR(64),
    field64 VARCHAR(64),
    field65 VARCHAR(256),
    field66 VARCHAR(256),
    field67 VARCHAR(256),
    field68 VARCHAR(128),
    field69 VARCHAR(1024),
    field70 VARCHAR(64),
    field71 VARCHAR(64),
    field72 VARCHAR(64),
    field73 VARCHAR(64),
    field74 VARCHAR(64),
    field75 VARCHAR(64),
    field76 VARCHAR(64),
    field77 VARCHAR(64),
    field78 VARCHAR(64),
    field79 VARCHAR(64),
    field80 VARCHAR(64),
    field81 VARCHAR(64),
    field82 VARCHAR(64),
    field83 VARCHAR(64),
    field84 VARCHAR(64),
    field85 VARCHAR(64),
    field86 VARCHAR(64),
    field87 VARCHAR(64),
    field88 VARCHAR(64),
    field89 VARCHAR(64),
    field90 VARCHAR(320),
    useCount INT4 UNSIGNED DEFAULT 0,
    yomiFirstName VARCHAR(128),
    yomiLastName VARCHAR(128),
    yomiCompany VARCHAR(512),
    homeAddress VARCHAR(512) collate utf8_unicode_ci default NULL,
    businessAddress VARCHAR(512) collate utf8_unicode_ci default NULL,
    otherAddress VARCHAR(512) collate utf8_unicode_ci default NULL,
    uid VARCHAR(255) collate utf8_unicode_ci default NULL,
    filename VARCHAR(255) collate utf8_unicode_ci default NULL,
    INDEX (created_from),
    INDEX (changing_date),
    INDEX (userid),
    INDEX (cid, fid),
    INDEX `givenname` (`cid`,`field03`),
    INDEX `surname` (`cid`,`field02`),
    INDEX `displayname` (`cid`,`field01`(255)),
    INDEX `email1` (`cid`,`field65`(255)),
    INDEX `email2` (`cid`,`field66`(255)),
    INDEX `email3` (`cid`,`field67`(255)),
    PRIMARY KEY (cid, intfield01)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
