define('ace/mode/xquery/XQueryParser', function(require, exports, module) {
// $ANTLR 3.3 Nov 30, 2010 12:50:56 xquery/XQueryParser.g 2012-05-25 02:35:45

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Ajax.org Code Editor (ACE).
 *
 * The Initial Developer of the Original Code is
 * Ajax.org B.V.
 * Portions created by the Initial Developer are Copyright (C) 2010
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *      William Candillon <wcandillon AT gmail DOT com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL. *
 * ***** END LICENSE BLOCK ***** */
var org =  require("./antlr3-all").org;
var StringLexer   = require("./StringLexer").StringLexer;
var XMLLexer   = require("./XMLLexer").XMLLexer;
var XQueryLexer   = require("./XQueryLexer").XQueryLexer;
var XQDTParser = require("./XQDTParser").XQDTParser;
var Position = require("./Position").Position;
var Exception = function(){};

var XQS = true;
var XQU = true;
var ZORBA = true;
var MLS = false;



var XQueryParser = function(input, state) {
    if (!state) {
        state = new org.antlr.runtime.RecognizerSharedState();
    }

    (function(){


        this.isInAttr = false;

        this.errors = [];

        this.hasErrors = function(){
          return this.errors.length > 0;
        };

        this.addError = function(error){
          this.errors.push(error);
        };

        this.getErrors = function(){
          return this.errors;
        };

        this.source = null;
        this.setSource = function(s){
          this.source = s;
          this.highlighter.setSource(s);
        };

        this.lexerStack = new Array();

        this.lc = function(b){ return b; };
        this.popLexer = function (){
          //console.log("popLexer");
          if(this.lexerStack.length == 0) return;
          this.getTokenStream().mark();
          var oldLexer = this.getTokenStream().getTokenSource();
          var newLexer = this.lexerStack.pop();
          if(oldLexer instanceof StringLexer && newLexer instanceof XQueryLexer) {
            newLexer.inStr = false;
          }
          this.getTokenStream().setTokenSource(newLexer);
        };

        this.pushXQueryLexer = function() {
          xqueryLexer = new XQueryLexer(this.source);
          this.pushLexer(xqueryLexer);
        };

        this.pushStringLexer = function(isAposStr){
          //console.log("pushStringLexer");
          var stringLexer = new StringLexer(this.source);
          stringLexer.inAposStr = isAposStr;
          stringLexer.inQuotStr = !isAposStr;
          stringLexer.setIsWsExplicit(true);
          this.pushLexer(stringLexer);
        };

        this.pushXMLLexer = function(){
          //console.log("pushXMLLexer");
          var xmlLexer = new XMLLexer(this.source);
          xmlLexer.setIsWsExplicit(true);
          this.pushLexer(xmlLexer);
        };

        this.pushLexer = function(lexer){
          var oldLexer = this.getTokenStream().getTokenSource();
          oldLexer.addToStack(this.lexerStack);
          this.getTokenStream().setTokenSource(lexer);
        };

        this.setWsExplicit = function(isExplicit){
          this.getTokenStream().setWsExplicit(isExplicit);
        };

        this.ap = function(token)
        {
          this.addToken(token, "xml_pe");
        };

        this.ax = function(start, stop)
        {
          this.highlighter.addToken(start.getStartIndex(), stop.getStopIndex(), "xml_pe");
        };

        this.at = function(start, stop)
        {
          this.highlighter.addToken(start.getStartIndex(), stop.getStopIndex(), "meta.tag");
        };

        this.av = function(start, stop)
        {
          this.highlighter.addToken(start.getStartIndex(), stop.getStopIndex(), "variable");
        };

        this.af = function(start, stop)
        {
          this.highlighter.addToken(start.getStartIndex(), stop.getStopIndex(), "support.function");
        };

        this.ao = function(t)
        {
          this.addToken(t, "keyword.operator");
        };

        this.ak = function(t)
        {
          this.addToken(t, "keyword");
        };

        this.ad = function(t)
        {
          this.addToken(t, "constant");
        };

        this.addString = function(start, stop)
        {
         if(stop == undefined) {
           this.addToken(start, "string");
         } else {
           this.highlighter.addToken(start.getStartIndex(), stop.getStopIndex(), "string");
         }
        };

        this.ac = function(t)
        {
          this.addToken(t, "comment");
        };

        this.addToken = function(k, type){
          if(org.antlr.lang.isArray(k)){
            for(i in k)
            {
              this.highlighter.addToken(k[i].getStartIndex(), k[i].getStopIndex(), type);
            }
          } else if(k != null ) {
            this.highlighter.addToken(k.getStartIndex(), k.getStopIndex(), type); 
          }
        };


    }).call(this);

    XQueryParser.superclass.constructor.call(this, input, state);

    this.dfa1 = new XQueryParser.DFA1(this);
    this.dfa2 = new XQueryParser.DFA2(this);
    this.dfa6 = new XQueryParser.DFA6(this);
    this.dfa9 = new XQueryParser.DFA9(this);
    this.dfa44 = new XQueryParser.DFA44(this);
    this.dfa46 = new XQueryParser.DFA46(this);
    this.dfa117 = new XQueryParser.DFA117(this);
    this.dfa119 = new XQueryParser.DFA119(this);
    this.dfa121 = new XQueryParser.DFA121(this);
    this.dfa126 = new XQueryParser.DFA126(this);
    this.dfa134 = new XQueryParser.DFA134(this);
    this.dfa162 = new XQueryParser.DFA162(this);
    this.dfa164 = new XQueryParser.DFA164(this);
    this.dfa218 = new XQueryParser.DFA218(this);
    this.dfa237 = new XQueryParser.DFA237(this);
    this.dfa253 = new XQueryParser.DFA253(this);

         

    /* @todo only create adaptor if output=AST */
    this.adaptor = new org.antlr.runtime.tree.CommonTreeAdaptor();

};

org.antlr.lang.augmentObject(XQueryParser, {
    EOF: -1,
    L_QuotAttrContentChar: 4,
    L_AposAttrContentChar: 5,
    L_ElementContentChar: 6,
    L_CDataSection: 7,
    L_PredefinedEntityRef: 8,
    L_CharRef: 9,
    ESCAPE_LBRACKET: 10,
    ESCAPE_RBRACKET: 11,
    ESCAPE_APOS: 12,
    ESCAPE_QUOT: 13,
    CDATA_START: 14,
    CDATA_END: 15,
    ANCESTOR: 16,
    ANCESTOR_OR_SELF: 17,
    AND: 18,
    AS: 19,
    ASCENDING: 20,
    AT: 21,
    ATTRIBUTE: 22,
    BASE_URI: 23,
    BOUNDARY_SPACE: 24,
    BY: 25,
    CASE: 26,
    CAST: 27,
    CASTABLE: 28,
    CHILD: 29,
    COLLATION: 30,
    COMMENT: 31,
    CONSTRUCTION: 32,
    COPY_NAMESPACES: 33,
    DECLARE: 34,
    DEFAULT: 35,
    DESCENDANT: 36,
    DESCENDANT_OR_SELF: 37,
    DESCENDING: 38,
    DIV: 39,
    DOCUMENT: 40,
    DOCUMENT_NODE: 41,
    ELEMENT: 42,
    ELSE: 43,
    EMPTY: 44,
    EMPTY_SEQUENCE: 45,
    ENCODING: 46,
    EQ: 47,
    EVERY: 48,
    EXCEPT: 49,
    EXTERNAL: 50,
    FOLLOWING: 51,
    FOLLOWING_SIBLING: 52,
    FOR: 53,
    FUNCTION: 54,
    GE: 55,
    GREATEST: 56,
    GT: 57,
    IDIV: 58,
    IF: 59,
    IMPORT: 60,
    IN: 61,
    INHERIT: 62,
    INSTANCE: 63,
    INTERSECT: 64,
    IS: 65,
    ITEM: 66,
    LAX: 67,
    LE: 68,
    LEAST: 69,
    LET: 70,
    LT: 71,
    MOD: 72,
    MODULE: 73,
    NAMESPACE: 74,
    NE: 75,
    NO_INHERIT: 76,
    NO_PRESERVE: 77,
    NODE: 78,
    OF: 79,
    OPTION: 80,
    OR: 81,
    ORDER: 82,
    ORDERED: 83,
    ORDERING: 84,
    PARENT: 85,
    PRECEDING: 86,
    PRECEDING_SIBLING: 87,
    PRESERVE: 88,
    PROCESSING_INSTRUCTION: 89,
    RETURN: 90,
    SATISFIES: 91,
    SCHEMA: 92,
    SCHEMA_ATTRIBUTE: 93,
    SCHEMA_ELEMENT: 94,
    SELF: 95,
    SOME: 96,
    STABLE: 97,
    STRICT: 98,
    STRIP: 99,
    TEXT: 100,
    THEN: 101,
    TO: 102,
    TREAT: 103,
    TYPESWITCH: 104,
    UNION: 105,
    UNORDERED: 106,
    VALIDATE: 107,
    VARIABLE: 108,
    VERSION: 109,
    WHERE: 110,
    XQUERY: 111,
    ALLOWING: 112,
    CATCH: 113,
    CONTEXT: 114,
    COUNT: 115,
    DECIMAL_FORMAT: 116,
    DECIMAL_SEPARATOR: 117,
    DIGIT: 118,
    END: 119,
    GROUP: 120,
    GROUPING_SEPARATOR: 121,
    INFINITY: 122,
    MINUS_SIGN: 123,
    NAMESPACE_NODE: 124,
    NAN: 125,
    NEXT: 126,
    ONLY: 127,
    PATTERN_SEPARATOR: 128,
    PERCENT: 129,
    PER_MILLE: 130,
    PREVIOUS: 131,
    SLIDING: 132,
    START: 133,
    SWITCH: 134,
    TRY: 135,
    TUMBLING: 136,
    TYPE: 137,
    WHEN: 138,
    WINDOW: 139,
    ZERO_DIGIT: 140,
    AFTER: 141,
    BEFORE: 142,
    COPY: 143,
    DELETE: 144,
    FIRST: 145,
    INSERT: 146,
    INTO: 147,
    LAST: 148,
    MODIFY: 149,
    NODES: 150,
    RENAME: 151,
    REPLACE: 152,
    REVALIDATION: 153,
    SKIP: 154,
    UPDATING: 155,
    VALUE: 156,
    WITH: 157,
    ALL: 158,
    ANY: 159,
    CONTAINS: 160,
    CONTENT: 161,
    DIACRITICS: 162,
    DIFFERENT: 163,
    DISTANCE: 164,
    ENTIRE: 165,
    EXACTLY: 166,
    FROM: 167,
    FT_OPTION: 168,
    FTAND: 169,
    FTNOT: 170,
    FTOR: 171,
    INSENSITIVE: 172,
    LANGUAGE: 173,
    LEVELS: 174,
    LOWERCASE: 175,
    MOST: 176,
    NO: 177,
    NOT: 178,
    OCCURS: 179,
    PARAGRAPH: 180,
    PARAGRAPHS: 181,
    PHRASE: 182,
    RELATIONSHIP: 183,
    SAME: 184,
    SCORE: 185,
    SENSITIVE: 186,
    SENTENCE: 187,
    SENTENCES: 188,
    STEMMING: 189,
    STOP: 190,
    THESAURUS: 191,
    TIMES: 192,
    UPPERCASE: 193,
    USING: 194,
    WEIGHT: 195,
    WILDCARDS: 196,
    WITHOUT: 197,
    WORD: 198,
    WORDS: 199,
    BREAK: 200,
    CONTINUE: 201,
    EXIT: 202,
    LOOP: 203,
    RETURNING: 204,
    WHILE: 205,
    CHECK: 206,
    COLLECTION: 207,
    CONSTRAINT: 208,
    FOREACH: 209,
    FOREIGN: 210,
    INDEX: 211,
    INTEGRITY: 212,
    KEY: 213,
    ON: 214,
    UNIQUE: 215,
    BINARY: 216,
    AMP_ER: 217,
    APOS_ER: 218,
    QUOT_ER: 219,
    CONCAT: 220,
    LPAREN: 221,
    RPAREN: 222,
    DOLLAR: 223,
    LBRACKET: 224,
    RBRACKET: 225,
    LSQUARE: 226,
    RSQUARE: 227,
    EQUAL: 228,
    BIND: 229,
    NOTEQUAL: 230,
    ANN_PERCENT: 231,
    HASH: 232,
    AMP: 233,
    COMMA: 234,
    QUESTION: 235,
    STAR: 236,
    PLUS: 237,
    MINUS: 238,
    SMALLER: 239,
    GREATER: 240,
    SMALLEREQ: 241,
    GREATEREQ: 242,
    SMALLER_SMALLER: 243,
    GREATER_GREATER: 244,
    SLASH: 245,
    SLASH_SLASH: 246,
    DOT: 247,
    DOT_DOT: 248,
    COLON: 249,
    COLON_COLON: 250,
    EMPTY_CLOSE_TAG: 251,
    CLOSE_TAG: 252,
    SEMICOLON: 253,
    VBAR: 254,
    PRAGMA_START: 255,
    PRAGMA_END: 256,
    XML_COMMENT_START: 257,
    XML_COMMENT_END: 258,
    PI_START: 259,
    PI_END: 260,
    ATTR_SIGN: 261,
    CHARREF_DEC: 262,
    CHARREF_HEX: 263,
    APOS: 264,
    QUOT: 265,
    NCNameStartChar: 266,
    NCNameChar: 267,
    L_NCName: 268,
    Letter: 269,
    HexLetter: 270,
    Digit: 271,
    Digits: 272,
    S: 273,
    SU: 274,
    L_Pragma: 275,
    L_DirCommentConstructor: 276,
    L_DirPIConstructor: 277,
    L_IntegerLiteral: 278,
    L_DecimalLiteral: 279,
    L_DoubleLiteral: 280,
    L_Comment: 281,
    L_AnyChar: 282,
    L_QuotStringLiteralChar: 283,
    L_AposStringLiteralChar: 284,
    LibraryModule: 285,
    MainModule: 286,
    VersionDecl: 287,
    VersionDeclEncoding: 288,
    VersionDeclVersion: 289,
    ModuleDecl: 290,
    Prolog: 291,
    DefaultNamespaceDecls: 292,
    DefaultNamespaceDecl: 293,
    Setters: 294,
    Setter: 295,
    NamespaceDecls: 296,
    NamespaceDecl: 297,
    Imports: 298,
    FTOptionDecls: 299,
    SchemaImport: 300,
    SchemaPrefix: 301,
    NamespaceName: 302,
    DefaultElementNamespace: 303,
    AtHints: 304,
    ModuleImport: 305,
    BaseURIDecl: 306,
    OrderedDecls: 307,
    VarDecl: 308,
    VarType: 309,
    VarValue: 310,
    VarDefaultValue: 311,
    VarVariableDecl: 312,
    FunctionDecl: 313,
    ParamList: 314,
    ReturnType: 315,
    OptionDecl: 316,
    TypeDeclaration: 317,
    Param: 318,
    EnclosedExpr: 319,
    QueryBody: 320,
    UnaryExpr: 321,
    DirElemConstructor: 322,
    DirAttributeList: 323,
    DirAttributeValue: 324,
    DirElemContent: 325,
    CommonContent: 326,
    SequenceType: 327,
    EmptySequenceTest: 328,
    KindTest: 329,
    ItemTest: 330,
    FunctionTest: 331,
    AtomicType: 332,
    AtomicOrUnionType: 333,
    StringLiteral: 334,
    ElementContentChar: 335,
    AttributeValueChar: 336,
    QName: 337,
    BlockExpr: 338,
    BinaryTest: 339,
    EXPLICITLY: 340
});

(function(){
// public class variables
var EOF= -1,
    L_QuotAttrContentChar= 4,
    L_AposAttrContentChar= 5,
    L_ElementContentChar= 6,
    L_CDataSection= 7,
    L_PredefinedEntityRef= 8,
    L_CharRef= 9,
    ESCAPE_LBRACKET= 10,
    ESCAPE_RBRACKET= 11,
    ESCAPE_APOS= 12,
    ESCAPE_QUOT= 13,
    CDATA_START= 14,
    CDATA_END= 15,
    ANCESTOR= 16,
    ANCESTOR_OR_SELF= 17,
    AND= 18,
    AS= 19,
    ASCENDING= 20,
    AT= 21,
    ATTRIBUTE= 22,
    BASE_URI= 23,
    BOUNDARY_SPACE= 24,
    BY= 25,
    CASE= 26,
    CAST= 27,
    CASTABLE= 28,
    CHILD= 29,
    COLLATION= 30,
    COMMENT= 31,
    CONSTRUCTION= 32,
    COPY_NAMESPACES= 33,
    DECLARE= 34,
    DEFAULT= 35,
    DESCENDANT= 36,
    DESCENDANT_OR_SELF= 37,
    DESCENDING= 38,
    DIV= 39,
    DOCUMENT= 40,
    DOCUMENT_NODE= 41,
    ELEMENT= 42,
    ELSE= 43,
    EMPTY= 44,
    EMPTY_SEQUENCE= 45,
    ENCODING= 46,
    EQ= 47,
    EVERY= 48,
    EXCEPT= 49,
    EXTERNAL= 50,
    FOLLOWING= 51,
    FOLLOWING_SIBLING= 52,
    FOR= 53,
    FUNCTION= 54,
    GE= 55,
    GREATEST= 56,
    GT= 57,
    IDIV= 58,
    IF= 59,
    IMPORT= 60,
    IN= 61,
    INHERIT= 62,
    INSTANCE= 63,
    INTERSECT= 64,
    IS= 65,
    ITEM= 66,
    LAX= 67,
    LE= 68,
    LEAST= 69,
    LET= 70,
    LT= 71,
    MOD= 72,
    MODULE= 73,
    NAMESPACE= 74,
    NE= 75,
    NO_INHERIT= 76,
    NO_PRESERVE= 77,
    NODE= 78,
    OF= 79,
    OPTION= 80,
    OR= 81,
    ORDER= 82,
    ORDERED= 83,
    ORDERING= 84,
    PARENT= 85,
    PRECEDING= 86,
    PRECEDING_SIBLING= 87,
    PRESERVE= 88,
    PROCESSING_INSTRUCTION= 89,
    RETURN= 90,
    SATISFIES= 91,
    SCHEMA= 92,
    SCHEMA_ATTRIBUTE= 93,
    SCHEMA_ELEMENT= 94,
    SELF= 95,
    SOME= 96,
    STABLE= 97,
    STRICT= 98,
    STRIP= 99,
    TEXT= 100,
    THEN= 101,
    TO= 102,
    TREAT= 103,
    TYPESWITCH= 104,
    UNION= 105,
    UNORDERED= 106,
    VALIDATE= 107,
    VARIABLE= 108,
    VERSION= 109,
    WHERE= 110,
    XQUERY= 111,
    ALLOWING= 112,
    CATCH= 113,
    CONTEXT= 114,
    COUNT= 115,
    DECIMAL_FORMAT= 116,
    DECIMAL_SEPARATOR= 117,
    DIGIT= 118,
    END= 119,
    GROUP= 120,
    GROUPING_SEPARATOR= 121,
    INFINITY= 122,
    MINUS_SIGN= 123,
    NAMESPACE_NODE= 124,
    NAN= 125,
    NEXT= 126,
    ONLY= 127,
    PATTERN_SEPARATOR= 128,
    PERCENT= 129,
    PER_MILLE= 130,
    PREVIOUS= 131,
    SLIDING= 132,
    START= 133,
    SWITCH= 134,
    TRY= 135,
    TUMBLING= 136,
    TYPE= 137,
    WHEN= 138,
    WINDOW= 139,
    ZERO_DIGIT= 140,
    AFTER= 141,
    BEFORE= 142,
    COPY= 143,
    DELETE= 144,
    FIRST= 145,
    INSERT= 146,
    INTO= 147,
    LAST= 148,
    MODIFY= 149,
    NODES= 150,
    RENAME= 151,
    REPLACE= 152,
    REVALIDATION= 153,
    SKIP= 154,
    UPDATING= 155,
    VALUE= 156,
    WITH= 157,
    ALL= 158,
    ANY= 159,
    CONTAINS= 160,
    CONTENT= 161,
    DIACRITICS= 162,
    DIFFERENT= 163,
    DISTANCE= 164,
    ENTIRE= 165,
    EXACTLY= 166,
    FROM= 167,
    FT_OPTION= 168,
    FTAND= 169,
    FTNOT= 170,
    FTOR= 171,
    INSENSITIVE= 172,
    LANGUAGE= 173,
    LEVELS= 174,
    LOWERCASE= 175,
    MOST= 176,
    NO= 177,
    NOT= 178,
    OCCURS= 179,
    PARAGRAPH= 180,
    PARAGRAPHS= 181,
    PHRASE= 182,
    RELATIONSHIP= 183,
    SAME= 184,
    SCORE= 185,
    SENSITIVE= 186,
    SENTENCE= 187,
    SENTENCES= 188,
    STEMMING= 189,
    STOP= 190,
    THESAURUS= 191,
    TIMES= 192,
    UPPERCASE= 193,
    USING= 194,
    WEIGHT= 195,
    WILDCARDS= 196,
    WITHOUT= 197,
    WORD= 198,
    WORDS= 199,
    BREAK= 200,
    CONTINUE= 201,
    EXIT= 202,
    LOOP= 203,
    RETURNING= 204,
    WHILE= 205,
    CHECK= 206,
    COLLECTION= 207,
    CONSTRAINT= 208,
    FOREACH= 209,
    FOREIGN= 210,
    INDEX= 211,
    INTEGRITY= 212,
    KEY= 213,
    ON= 214,
    UNIQUE= 215,
    BINARY= 216,
    AMP_ER= 217,
    APOS_ER= 218,
    QUOT_ER= 219,
    CONCAT= 220,
    LPAREN= 221,
    RPAREN= 222,
    DOLLAR= 223,
    LBRACKET= 224,
    RBRACKET= 225,
    LSQUARE= 226,
    RSQUARE= 227,
    EQUAL= 228,
    BIND= 229,
    NOTEQUAL= 230,
    ANN_PERCENT= 231,
    HASH= 232,
    AMP= 233,
    COMMA= 234,
    QUESTION= 235,
    STAR= 236,
    PLUS= 237,
    MINUS= 238,
    SMALLER= 239,
    GREATER= 240,
    SMALLEREQ= 241,
    GREATEREQ= 242,
    SMALLER_SMALLER= 243,
    GREATER_GREATER= 244,
    SLASH= 245,
    SLASH_SLASH= 246,
    DOT= 247,
    DOT_DOT= 248,
    COLON= 249,
    COLON_COLON= 250,
    EMPTY_CLOSE_TAG= 251,
    CLOSE_TAG= 252,
    SEMICOLON= 253,
    VBAR= 254,
    PRAGMA_START= 255,
    PRAGMA_END= 256,
    XML_COMMENT_START= 257,
    XML_COMMENT_END= 258,
    PI_START= 259,
    PI_END= 260,
    ATTR_SIGN= 261,
    CHARREF_DEC= 262,
    CHARREF_HEX= 263,
    APOS= 264,
    QUOT= 265,
    NCNameStartChar= 266,
    NCNameChar= 267,
    L_NCName= 268,
    Letter= 269,
    HexLetter= 270,
    Digit= 271,
    Digits= 272,
    S= 273,
    SU= 274,
    L_Pragma= 275,
    L_DirCommentConstructor= 276,
    L_DirPIConstructor= 277,
    L_IntegerLiteral= 278,
    L_DecimalLiteral= 279,
    L_DoubleLiteral= 280,
    L_Comment= 281,
    L_AnyChar= 282,
    L_QuotStringLiteralChar= 283,
    L_AposStringLiteralChar= 284,
    LibraryModule= 285,
    MainModule= 286,
    VersionDecl= 287,
    VersionDeclEncoding= 288,
    VersionDeclVersion= 289,
    ModuleDecl= 290,
    Prolog= 291,
    DefaultNamespaceDecls= 292,
    DefaultNamespaceDecl= 293,
    Setters= 294,
    Setter= 295,
    NamespaceDecls= 296,
    NamespaceDecl= 297,
    Imports= 298,
    FTOptionDecls= 299,
    SchemaImport= 300,
    SchemaPrefix= 301,
    NamespaceName= 302,
    DefaultElementNamespace= 303,
    AtHints= 304,
    ModuleImport= 305,
    BaseURIDecl= 306,
    OrderedDecls= 307,
    VarDecl= 308,
    VarType= 309,
    VarValue= 310,
    VarDefaultValue= 311,
    VarVariableDecl= 312,
    FunctionDecl= 313,
    ParamList= 314,
    ReturnType= 315,
    OptionDecl= 316,
    TypeDeclaration= 317,
    Param= 318,
    EnclosedExpr= 319,
    QueryBody= 320,
    UnaryExpr= 321,
    DirElemConstructor= 322,
    DirAttributeList= 323,
    DirAttributeValue= 324,
    DirElemContent= 325,
    CommonContent= 326,
    SequenceType= 327,
    EmptySequenceTest= 328,
    KindTest= 329,
    ItemTest= 330,
    FunctionTest= 331,
    AtomicType= 332,
    AtomicOrUnionType= 333,
    StringLiteral= 334,
    ElementContentChar= 335,
    AttributeValueChar= 336,
    QName= 337,
    BlockExpr= 338,
    BinaryTest= 339,
    EXPLICITLY= 340;

// public instance methods/vars
org.antlr.lang.extend(XQueryParser, XQDTParser, {
        
    setTreeAdaptor: function(adaptor) {
        this.adaptor = adaptor;
    },
    getTreeAdaptor: function() {
        return this.adaptor;
    },

    getTokenNames: function() { return XQueryParser.tokenNames; },
    getGrammarFileName: function() { return "xquery/XQueryParser.g"; }
});
org.antlr.lang.augmentObject(XQueryParser.prototype, {

    // inline static return class
    p_Module_return: (function() {
        XQueryParser.p_Module_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Module_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:295:1: p_Module : (vd= p_VersionDecl )? (lm= p_LibraryModule[$vd.tree] -> | mm= p_MainModule[$vd.tree] ->) EOF ;
    // $ANTLR start "p_Module"
    p_Module: function() {
        var retval = new XQueryParser.p_Module_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var EOF1 = null;
         var vd = null;
         var lm = null;
         var mm = null;

        var EOF1_tree=null;
        var stream_EOF=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EOF");
        var stream_p_VersionDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_VersionDecl");
        var stream_p_LibraryModule=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_LibraryModule");
        var stream_p_MainModule=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_MainModule");
        try {
            // xquery/XQueryParser.g:296:9: ( (vd= p_VersionDecl )? (lm= p_LibraryModule[$vd.tree] -> | mm= p_MainModule[$vd.tree] ->) EOF )
            // xquery/XQueryParser.g:296:11: (vd= p_VersionDecl )? (lm= p_LibraryModule[$vd.tree] -> | mm= p_MainModule[$vd.tree] ->) EOF
            // xquery/XQueryParser.g:296:13: (vd= p_VersionDecl )?
            var alt1=2;
            alt1 = this.dfa1.predict(this.input);
            switch (alt1) {
                case 1 :
                    // xquery/XQueryParser.g:296:13: vd= p_VersionDecl
                    this.pushFollow(XQueryParser.FOLLOW_p_VersionDecl_in_p_Module507);
                    vd=this.p_VersionDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_VersionDecl.add(vd.getTree());


                    break;

            }

            // xquery/XQueryParser.g:297:13: (lm= p_LibraryModule[$vd.tree] -> | mm= p_MainModule[$vd.tree] ->)
            var alt2=2;
            alt2 = this.dfa2.predict(this.input);
            switch (alt2) {
                case 1 :
                    // xquery/XQueryParser.g:298:15: lm= p_LibraryModule[$vd.tree]
                    this.pushFollow(XQueryParser.FOLLOW_p_LibraryModule_in_p_Module540);
                    lm=this.p_LibraryModule((vd?vd.tree:null));

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_LibraryModule.add(lm.getTree());


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 298:44: ->
                    {
                        this.adaptor.addChild(root_0, (lm?lm.tree:null));

                    }

                    retval.tree = root_0;}

                    break;
                case 2 :
                    // xquery/XQueryParser.g:299:15: mm= p_MainModule[$vd.tree]
                    this.pushFollow(XQueryParser.FOLLOW_p_MainModule_in_p_Module563);
                    mm=this.p_MainModule((vd?vd.tree:null));

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_MainModule.add(mm.getTree());


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 299:44: ->
                    {
                        this.adaptor.addChild(root_0, (mm?mm.tree:null));

                    }

                    retval.tree = root_0;}

                    break;

            }

            EOF1=this.match(this.input,EOF,XQueryParser.FOLLOW_EOF_in_p_Module587); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_EOF.add(EOF1);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_VersionDecl_return: (function() {
        XQueryParser.p_VersionDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_VersionDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:304:1: p_VersionDecl : k= XQUERY ( (k= ENCODING enc= p_StringLiteral ) | (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? ) ) SEMICOLON -> ^( VersionDecl ^( VersionDeclVersion ( $ver)? ) ^( VersionDeclEncoding ( $enc)? ) ) ;
    // $ANTLR start "p_VersionDecl"
    p_VersionDecl: function() {
        var retval = new XQueryParser.p_VersionDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON2 = null;
         var enc = null;
         var ver = null;

        var k_tree=null;
        var SEMICOLON2_tree=null;
        var stream_ENCODING=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token ENCODING");
        var stream_VERSION=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token VERSION");
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_XQUERY=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token XQUERY");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // xquery/XQueryParser.g:305:9: (k= XQUERY ( (k= ENCODING enc= p_StringLiteral ) | (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? ) ) SEMICOLON -> ^( VersionDecl ^( VersionDeclVersion ( $ver)? ) ^( VersionDeclEncoding ( $enc)? ) ) )
            // xquery/XQueryParser.g:305:11: k= XQUERY ( (k= ENCODING enc= p_StringLiteral ) | (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? ) ) SEMICOLON
            k=this.match(this.input,XQUERY,XQueryParser.FOLLOW_XQUERY_in_p_VersionDecl615); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_XQUERY.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:305:35: ( (k= ENCODING enc= p_StringLiteral ) | (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? ) )
            var alt4=2;
            var LA4_0 = this.input.LA(1);

            if ( (LA4_0==ENCODING) ) {
                alt4=1;
            }
            else if ( (LA4_0==VERSION) ) {
                alt4=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 4, 0, this.input);

                throw nvae;
            }
            switch (alt4) {
                case 1 :
                    // xquery/XQueryParser.g:305:36: (k= ENCODING enc= p_StringLiteral )
                    // xquery/XQueryParser.g:305:36: (k= ENCODING enc= p_StringLiteral )
                    // xquery/XQueryParser.g:305:37: k= ENCODING enc= p_StringLiteral
                    k=this.match(this.input,ENCODING,XQueryParser.FOLLOW_ENCODING_in_p_VersionDecl623); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_ENCODING.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_VersionDecl629);
                    enc=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(enc.getTree());





                    break;
                case 2 :
                    // xquery/XQueryParser.g:306:13: (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? )
                    // xquery/XQueryParser.g:306:13: (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? )
                    // xquery/XQueryParser.g:306:14: k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )?
                    k=this.match(this.input,VERSION,XQueryParser.FOLLOW_VERSION_in_p_VersionDecl650); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_VERSION.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_VersionDecl656);
                    ver=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(ver.getTree());
                    // xquery/XQueryParser.g:306:59: (k= ENCODING enc= p_StringLiteral )?
                    var alt3=2;
                    var LA3_0 = this.input.LA(1);

                    if ( (LA3_0==ENCODING) ) {
                        alt3=1;
                    }
                    switch (alt3) {
                        case 1 :
                            // xquery/XQueryParser.g:306:60: k= ENCODING enc= p_StringLiteral
                            k=this.match(this.input,ENCODING,XQueryParser.FOLLOW_ENCODING_in_p_VersionDecl661); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_ENCODING.add(k);

                            if ( this.state.backtracking===0 ) {
                              this.ak(k);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_VersionDecl667);
                            enc=this.p_StringLiteral();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(enc.getTree());


                            break;

                    }






                    break;

            }

            SEMICOLON2=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_p_VersionDecl673); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON2);



            // AST REWRITE
            // elements: enc, ver
            // token labels: 
            // rule labels: retval, ver, enc
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_ver=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token ver",ver!=null?ver.tree:null);
            var stream_enc=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token enc",enc!=null?enc.tree:null);

            root_0 = this.adaptor.nil();
            // 307:17: -> ^( VersionDecl ^( VersionDeclVersion ( $ver)? ) ^( VersionDeclEncoding ( $enc)? ) )
            {
                // xquery/XQueryParser.g:307:20: ^( VersionDecl ^( VersionDeclVersion ( $ver)? ) ^( VersionDeclEncoding ( $enc)? ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(VersionDecl, "VersionDecl"), root_1);

                // xquery/XQueryParser.g:307:34: ^( VersionDeclVersion ( $ver)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(VersionDeclVersion, "VersionDeclVersion"), root_2);

                // xquery/XQueryParser.g:307:55: ( $ver)?
                if ( stream_ver.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_ver.nextTree());

                }
                stream_ver.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // xquery/XQueryParser.g:307:62: ^( VersionDeclEncoding ( $enc)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(VersionDeclEncoding, "VersionDeclEncoding"), root_2);

                // xquery/XQueryParser.g:307:84: ( $enc)?
                if ( stream_enc.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_enc.nextTree());

                }
                stream_enc.reset();

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_MainModule_return: (function() {
        XQueryParser.p_MainModule_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_MainModule_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:311:1: p_MainModule[vd] : pm_Prolog pm_QueryBody -> ^( MainModule pm_Prolog ) ;
    // $ANTLR start "p_MainModule"
    p_MainModule: function(vd) {
        var retval = new XQueryParser.p_MainModule_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pm_Prolog3 = null;
         var pm_QueryBody4 = null;

        var stream_pm_QueryBody=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_QueryBody");
        var stream_pm_Prolog=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_Prolog");
        try {
            // xquery/XQueryParser.g:312:9: ( pm_Prolog pm_QueryBody -> ^( MainModule pm_Prolog ) )
            // xquery/XQueryParser.g:312:11: pm_Prolog pm_QueryBody
            this.pushFollow(XQueryParser.FOLLOW_pm_Prolog_in_p_MainModule739);
            pm_Prolog3=this.pm_Prolog();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_pm_Prolog.add(pm_Prolog3.getTree());
            this.pushFollow(XQueryParser.FOLLOW_pm_QueryBody_in_p_MainModule741);
            pm_QueryBody4=this.pm_QueryBody();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_pm_QueryBody.add(pm_QueryBody4.getTree());


            // AST REWRITE
            // elements: pm_Prolog
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 313:17: -> ^( MainModule pm_Prolog )
            {
                // xquery/XQueryParser.g:313:20: ^( MainModule pm_Prolog )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(MainModule, "MainModule"), root_1);

                this.adaptor.addChild(root_1, vd);
                this.adaptor.addChild(root_1, stream_pm_Prolog.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_LibraryModule_return: (function() {
        XQueryParser.p_LibraryModule_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_LibraryModule_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:317:1: p_LibraryModule[vd] : p_ModuleDecl pm_Prolog -> ^( LibraryModule p_ModuleDecl pm_Prolog ) ;
    // $ANTLR start "p_LibraryModule"
    p_LibraryModule: function(vd) {
        var retval = new XQueryParser.p_LibraryModule_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ModuleDecl5 = null;
         var pm_Prolog6 = null;

        var stream_pm_Prolog=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_Prolog");
        var stream_p_ModuleDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_ModuleDecl");
        try {
            // xquery/XQueryParser.g:318:9: ( p_ModuleDecl pm_Prolog -> ^( LibraryModule p_ModuleDecl pm_Prolog ) )
            // xquery/XQueryParser.g:318:11: p_ModuleDecl pm_Prolog
            this.pushFollow(XQueryParser.FOLLOW_p_ModuleDecl_in_p_LibraryModule797);
            p_ModuleDecl5=this.p_ModuleDecl();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_ModuleDecl.add(p_ModuleDecl5.getTree());
            this.pushFollow(XQueryParser.FOLLOW_pm_Prolog_in_p_LibraryModule799);
            pm_Prolog6=this.pm_Prolog();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_pm_Prolog.add(pm_Prolog6.getTree());


            // AST REWRITE
            // elements: p_ModuleDecl, pm_Prolog
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 319:17: -> ^( LibraryModule p_ModuleDecl pm_Prolog )
            {
                // xquery/XQueryParser.g:319:20: ^( LibraryModule p_ModuleDecl pm_Prolog )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(LibraryModule, "LibraryModule"), root_1);

                this.adaptor.addChild(root_1, vd);
                this.adaptor.addChild(root_1, stream_p_ModuleDecl.nextTree());
                this.adaptor.addChild(root_1, stream_pm_Prolog.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ModuleDecl_return: (function() {
        XQueryParser.p_ModuleDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ModuleDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:323:1: p_ModuleDecl : k+= MODULE k+= NAMESPACE p_NCName EQUAL p_StringLiteral SEMICOLON -> ^( ModuleDecl p_NCName p_StringLiteral ) ;
    // $ANTLR start "p_ModuleDecl"
    p_ModuleDecl: function() {
        var retval = new XQueryParser.p_ModuleDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var EQUAL8 = null;
        var SEMICOLON10 = null;
        var k = null;
        var list_k=null;
         var p_NCName7 = null;
         var p_StringLiteral9 = null;

        var EQUAL8_tree=null;
        var SEMICOLON10_tree=null;
        var k_tree=null;
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_MODULE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token MODULE");
        var stream_NAMESPACE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token NAMESPACE");
        var stream_EQUAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EQUAL");
        var stream_p_NCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_NCName");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // xquery/XQueryParser.g:324:9: (k+= MODULE k+= NAMESPACE p_NCName EQUAL p_StringLiteral SEMICOLON -> ^( ModuleDecl p_NCName p_StringLiteral ) )
            // xquery/XQueryParser.g:324:11: k+= MODULE k+= NAMESPACE p_NCName EQUAL p_StringLiteral SEMICOLON
            k=this.match(this.input,MODULE,XQueryParser.FOLLOW_MODULE_in_p_ModuleDecl855); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_MODULE.add(k);

            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_p_ModuleDecl859); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_NAMESPACE.add(k);

            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_p_ModuleDecl863);
            p_NCName7=this.p_NCName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_NCName.add(p_NCName7.getTree());
            EQUAL8=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_p_ModuleDecl865); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_EQUAL.add(EQUAL8);

            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_ModuleDecl867);
            p_StringLiteral9=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(p_StringLiteral9.getTree());
            SEMICOLON10=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_p_ModuleDecl869); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON10);



            // AST REWRITE
            // elements: p_StringLiteral, p_NCName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 325:17: -> ^( ModuleDecl p_NCName p_StringLiteral )
            {
                // xquery/XQueryParser.g:325:21: ^( ModuleDecl p_NCName p_StringLiteral )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(ModuleDecl, "ModuleDecl"), root_1);

                this.adaptor.addChild(root_1, stream_p_NCName.nextTree());
                this.adaptor.addChild(root_1, stream_p_StringLiteral.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_Prolog_return: (function() {
        XQueryParser.pm_Prolog_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_Prolog_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:331:1: pm_Prolog : ( (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl ) )* (od+= pg_OrderedDecl )* -> ^( Prolog ^( DefaultNamespaceDecls ( $dnd)* ) ^( Setters ( $s)* ) ^( NamespaceDecls ( $nd)* ) ^( Imports ( $i)* ) ^( FTOptionDecls ( $fto)* ) ^( OrderedDecls ( $od)* ) ) ;
    // $ANTLR start "pm_Prolog"
    pm_Prolog: function() {
        var retval = new XQueryParser.pm_Prolog_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var list_dnd=null;
        var list_s=null;
        var list_nd=null;
        var list_i=null;
        var list_fto=null;
        var list_od=null;
        var dnd = null;
        var s = null;
        var nd = null;
        var i = null;
        var fto = null;
        var od = null;
        var stream_pm_NamespaceDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_NamespaceDecl");
        var stream_p_Import=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_Import");
        var stream_p_Setter=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_Setter");
        var stream_pm_DefaultNamespaceDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_DefaultNamespaceDecl");
        var stream_pg_OrderedDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pg_OrderedDecl");
        var stream_pm_FTOptionDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_FTOptionDecl");
        try {
            // xquery/XQueryParser.g:332:9: ( ( (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl ) )* (od+= pg_OrderedDecl )* -> ^( Prolog ^( DefaultNamespaceDecls ( $dnd)* ) ^( Setters ( $s)* ) ^( NamespaceDecls ( $nd)* ) ^( Imports ( $i)* ) ^( FTOptionDecls ( $fto)* ) ^( OrderedDecls ( $od)* ) ) )
            // xquery/XQueryParser.g:332:11: ( (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl ) )* (od+= pg_OrderedDecl )*
            // xquery/XQueryParser.g:332:11: ( (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl ) )*
            loop6:
            do {
                var alt6=2;
                alt6 = this.dfa6.predict(this.input);
                switch (alt6) {
                case 1 :
                    // xquery/XQueryParser.g:332:12: (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl )
                    // xquery/XQueryParser.g:332:12: (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl )
                    var alt5=5;
                    var LA5_0 = this.input.LA(1);

                    if ( (LA5_0==DECLARE) ) {
                        var LA5_1 = this.input.LA(2);

                        if ( (LA5_1==REVALIDATION) && ((this.lc(XQU)))) {
                            alt5=2;
                        }
                        else if ( (LA5_1==FT_OPTION) ) {
                            alt5=5;
                        }
                        else if ( (LA5_1==DEFAULT) ) {
                            var LA5_5 = this.input.LA(3);

                            if ( (LA5_5==ELEMENT||LA5_5==FUNCTION) ) {
                                alt5=1;
                            }
                            else if ( (LA5_5==COLLATION||LA5_5==ORDER||LA5_5==DECIMAL_FORMAT) ) {
                                alt5=2;
                            }
                            else {
                                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                                var nvae =
                                    new org.antlr.runtime.NoViableAltException("", 5, 5, this.input);

                                throw nvae;
                            }
                        }
                        else if ( ((LA5_1>=BASE_URI && LA5_1<=BOUNDARY_SPACE)||(LA5_1>=CONSTRUCTION && LA5_1<=COPY_NAMESPACES)||LA5_1==ORDERING||LA5_1==DECIMAL_FORMAT) ) {
                            alt5=2;
                        }
                        else if ( (LA5_1==NAMESPACE) ) {
                            alt5=3;
                        }
                        else {
                            if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                            var nvae =
                                new org.antlr.runtime.NoViableAltException("", 5, 1, this.input);

                            throw nvae;
                        }
                    }
                    else if ( (LA5_0==IMPORT) ) {
                        alt5=4;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var nvae =
                            new org.antlr.runtime.NoViableAltException("", 5, 0, this.input);

                        throw nvae;
                    }
                    switch (alt5) {
                        case 1 :
                            // xquery/XQueryParser.g:332:13: dnd+= pm_DefaultNamespaceDecl
                            this.pushFollow(XQueryParser.FOLLOW_pm_DefaultNamespaceDecl_in_pm_Prolog928);
                            dnd=this.pm_DefaultNamespaceDecl();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_pm_DefaultNamespaceDecl.add(dnd.getTree());
                            if (org.antlr.lang.isNull(list_dnd)) list_dnd = [];
                            list_dnd.push(dnd.getTree());



                            break;
                        case 2 :
                            // xquery/XQueryParser.g:332:44: s+= p_Setter
                            this.pushFollow(XQueryParser.FOLLOW_p_Setter_in_pm_Prolog934);
                            s=this.p_Setter();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_Setter.add(s.getTree());
                            if (org.antlr.lang.isNull(list_s)) list_s = [];
                            list_s.push(s.getTree());



                            break;
                        case 3 :
                            // xquery/XQueryParser.g:332:58: nd+= pm_NamespaceDecl
                            this.pushFollow(XQueryParser.FOLLOW_pm_NamespaceDecl_in_pm_Prolog940);
                            nd=this.pm_NamespaceDecl();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_pm_NamespaceDecl.add(nd.getTree());
                            if (org.antlr.lang.isNull(list_nd)) list_nd = [];
                            list_nd.push(nd.getTree());



                            break;
                        case 4 :
                            // xquery/XQueryParser.g:332:81: i+= p_Import
                            this.pushFollow(XQueryParser.FOLLOW_p_Import_in_pm_Prolog946);
                            i=this.p_Import();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_Import.add(i.getTree());
                            if (org.antlr.lang.isNull(list_i)) list_i = [];
                            list_i.push(i.getTree());



                            break;
                        case 5 :
                            // xquery/XQueryParser.g:332:95: fto+= pm_FTOptionDecl
                            this.pushFollow(XQueryParser.FOLLOW_pm_FTOptionDecl_in_pm_Prolog952);
                            fto=this.pm_FTOptionDecl();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_pm_FTOptionDecl.add(fto.getTree());
                            if (org.antlr.lang.isNull(list_fto)) list_fto = [];
                            list_fto.push(fto.getTree());



                            break;

                    }



                    break;

                default :
                    break loop6;
                }
            } while (true);

            // xquery/XQueryParser.g:332:121: (od+= pg_OrderedDecl )*
            loop7:
            do {
                var alt7=2;
                var LA7_0 = this.input.LA(1);

                if ( (LA7_0==DECLARE) ) {
                    var LA7_3 = this.input.LA(2);

                    if ( (LA7_3==FUNCTION||LA7_3==OPTION||LA7_3==VARIABLE||LA7_3==CONTEXT||LA7_3==UPDATING||LA7_3==COLLECTION||(LA7_3>=INDEX && LA7_3<=INTEGRITY)||LA7_3==ANN_PERCENT) ) {
                        alt7=1;
                    }


                }


                switch (alt7) {
                case 1 :
                    // xquery/XQueryParser.g:332:121: od+= pg_OrderedDecl
                    this.pushFollow(XQueryParser.FOLLOW_pg_OrderedDecl_in_pm_Prolog959);
                    od=this.pg_OrderedDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_pg_OrderedDecl.add(od.getTree());
                    if (org.antlr.lang.isNull(list_od)) list_od = [];
                    list_od.push(od.getTree());



                    break;

                default :
                    break loop7;
                }
            } while (true);



            // AST REWRITE
            // elements: nd, i, s, od, fto, dnd
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: od, fto, s, nd, dnd, i
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_od=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token od",list_od);
            var stream_fto=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token fto",list_fto);
            var stream_s=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token s",list_s);
            var stream_nd=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token nd",list_nd);
            var stream_dnd=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token dnd",list_dnd);
            var stream_i=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token i",list_i);
            root_0 = this.adaptor.nil();
            // 333:17: -> ^( Prolog ^( DefaultNamespaceDecls ( $dnd)* ) ^( Setters ( $s)* ) ^( NamespaceDecls ( $nd)* ) ^( Imports ( $i)* ) ^( FTOptionDecls ( $fto)* ) ^( OrderedDecls ( $od)* ) )
            {
                // xquery/XQueryParser.g:333:21: ^( Prolog ^( DefaultNamespaceDecls ( $dnd)* ) ^( Setters ( $s)* ) ^( NamespaceDecls ( $nd)* ) ^( Imports ( $i)* ) ^( FTOptionDecls ( $fto)* ) ^( OrderedDecls ( $od)* ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(Prolog, "Prolog"), root_1);

                // xquery/XQueryParser.g:334:33: ^( DefaultNamespaceDecls ( $dnd)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(DefaultNamespaceDecls, "DefaultNamespaceDecls"), root_2);

                // xquery/XQueryParser.g:334:57: ( $dnd)*
                while ( stream_dnd.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_dnd.nextTree());

                }
                stream_dnd.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // xquery/XQueryParser.g:335:33: ^( Setters ( $s)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(Setters, "Setters"), root_2);

                // xquery/XQueryParser.g:335:43: ( $s)*
                while ( stream_s.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_s.nextTree());

                }
                stream_s.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // xquery/XQueryParser.g:336:33: ^( NamespaceDecls ( $nd)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(NamespaceDecls, "NamespaceDecls"), root_2);

                // xquery/XQueryParser.g:336:50: ( $nd)*
                while ( stream_nd.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_nd.nextTree());

                }
                stream_nd.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // xquery/XQueryParser.g:337:33: ^( Imports ( $i)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(Imports, "Imports"), root_2);

                // xquery/XQueryParser.g:337:43: ( $i)*
                while ( stream_i.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_i.nextTree());

                }
                stream_i.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // xquery/XQueryParser.g:338:33: ^( FTOptionDecls ( $fto)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(FTOptionDecls, "FTOptionDecls"), root_2);

                // xquery/XQueryParser.g:338:49: ( $fto)*
                while ( stream_fto.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_fto.nextTree());

                }
                stream_fto.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // xquery/XQueryParser.g:339:33: ^( OrderedDecls ( $od)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(OrderedDecls, "OrderedDecls"), root_2);

                // xquery/XQueryParser.g:339:48: ( $od)*
                while ( stream_od.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_od.nextTree());

                }
                stream_od.reset();

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pg_OrderedDecl_return: (function() {
        XQueryParser.pg_OrderedDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pg_OrderedDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:347:1: pg_OrderedDecl : ( pm_ContextItemDecl | pm_AnnotatedDecl | pm_OptionDecl );
    // $ANTLR start "pg_OrderedDecl"
    pg_OrderedDecl: function() {
        var retval = new XQueryParser.pg_OrderedDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pm_ContextItemDecl11 = null;
         var pm_AnnotatedDecl12 = null;
         var pm_OptionDecl13 = null;


        try {
            // xquery/XQueryParser.g:348:9: ( pm_ContextItemDecl | pm_AnnotatedDecl | pm_OptionDecl )
            var alt8=3;
            var LA8_0 = this.input.LA(1);

            if ( (LA8_0==DECLARE) ) {
                switch ( this.input.LA(2) ) {
                case CONTEXT:
                    alt8=1;
                    break;
                case FUNCTION:
                case VARIABLE:
                case UPDATING:
                case COLLECTION:
                case INDEX:
                case INTEGRITY:
                case ANN_PERCENT:
                    alt8=2;
                    break;
                case OPTION:
                    alt8=3;
                    break;
                default:
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 8, 1, this.input);

                    throw nvae;
                }

            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 8, 0, this.input);

                throw nvae;
            }
            switch (alt8) {
                case 1 :
                    // xquery/XQueryParser.g:348:11: pm_ContextItemDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_ContextItemDecl_in_pg_OrderedDecl1274);
                    pm_ContextItemDecl11=this.pm_ContextItemDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_ContextItemDecl11.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:349:11: pm_AnnotatedDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_AnnotatedDecl_in_pg_OrderedDecl1286);
                    pm_AnnotatedDecl12=this.pm_AnnotatedDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_AnnotatedDecl12.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:350:11: pm_OptionDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_OptionDecl_in_pg_OrderedDecl1298);
                    pm_OptionDecl13=this.pm_OptionDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_OptionDecl13.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Setter_return: (function() {
        XQueryParser.p_Setter_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Setter_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:358:1: p_Setter : ( pm_BoundarySpaceDecl | pm_DefaultCollationDecl | pm_BaseURIDecl | pm_ConstructionDecl | pm_OrderingModeDecl | pm_EmptyOrderDecl | {...}? => pm_RevalidationDecl | pm_CopyNamespacesDecl | pm_DecimalFormatDecl );
    // $ANTLR start "p_Setter"
    p_Setter: function() {
        var retval = new XQueryParser.p_Setter_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pm_BoundarySpaceDecl14 = null;
         var pm_DefaultCollationDecl15 = null;
         var pm_BaseURIDecl16 = null;
         var pm_ConstructionDecl17 = null;
         var pm_OrderingModeDecl18 = null;
         var pm_EmptyOrderDecl19 = null;
         var pm_RevalidationDecl20 = null;
         var pm_CopyNamespacesDecl21 = null;
         var pm_DecimalFormatDecl22 = null;


        try {
            // xquery/XQueryParser.g:359:9: ( pm_BoundarySpaceDecl | pm_DefaultCollationDecl | pm_BaseURIDecl | pm_ConstructionDecl | pm_OrderingModeDecl | pm_EmptyOrderDecl | {...}? => pm_RevalidationDecl | pm_CopyNamespacesDecl | pm_DecimalFormatDecl )
            var alt9=9;
            alt9 = this.dfa9.predict(this.input);
            switch (alt9) {
                case 1 :
                    // xquery/XQueryParser.g:359:11: pm_BoundarySpaceDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_BoundarySpaceDecl_in_p_Setter1328);
                    pm_BoundarySpaceDecl14=this.pm_BoundarySpaceDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_BoundarySpaceDecl14.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:360:11: pm_DefaultCollationDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_DefaultCollationDecl_in_p_Setter1340);
                    pm_DefaultCollationDecl15=this.pm_DefaultCollationDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_DefaultCollationDecl15.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:361:11: pm_BaseURIDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_BaseURIDecl_in_p_Setter1352);
                    pm_BaseURIDecl16=this.pm_BaseURIDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_BaseURIDecl16.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:362:11: pm_ConstructionDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_ConstructionDecl_in_p_Setter1364);
                    pm_ConstructionDecl17=this.pm_ConstructionDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_ConstructionDecl17.getTree());


                    break;
                case 5 :
                    // xquery/XQueryParser.g:363:11: pm_OrderingModeDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_OrderingModeDecl_in_p_Setter1376);
                    pm_OrderingModeDecl18=this.pm_OrderingModeDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_OrderingModeDecl18.getTree());


                    break;
                case 6 :
                    // xquery/XQueryParser.g:364:11: pm_EmptyOrderDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_EmptyOrderDecl_in_p_Setter1388);
                    pm_EmptyOrderDecl19=this.pm_EmptyOrderDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_EmptyOrderDecl19.getTree());


                    break;
                case 7 :
                    // xquery/XQueryParser.g:365:11: {...}? => pm_RevalidationDecl
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(XQU))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "p_Setter", "this.lc(XQU)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_pm_RevalidationDecl_in_p_Setter1403);
                    pm_RevalidationDecl20=this.pm_RevalidationDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_RevalidationDecl20.getTree());


                    break;
                case 8 :
                    // xquery/XQueryParser.g:366:11: pm_CopyNamespacesDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_CopyNamespacesDecl_in_p_Setter1415);
                    pm_CopyNamespacesDecl21=this.pm_CopyNamespacesDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_CopyNamespacesDecl21.getTree());


                    break;
                case 9 :
                    // xquery/XQueryParser.g:367:11: pm_DecimalFormatDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_DecimalFormatDecl_in_p_Setter1427);
                    pm_DecimalFormatDecl22=this.pm_DecimalFormatDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_DecimalFormatDecl22.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_BoundarySpaceDecl_return: (function() {
        XQueryParser.pm_BoundarySpaceDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_BoundarySpaceDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:371:1: pm_BoundarySpaceDecl : k= DECLARE k= BOUNDARY_SPACE ( (k= PRESERVE ) | (k= STRIP ) ) SEMICOLON ;
    // $ANTLR start "pm_BoundarySpaceDecl"
    pm_BoundarySpaceDecl: function() {
        var retval = new XQueryParser.pm_BoundarySpaceDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON23 = null;

        var k_tree=null;
        var SEMICOLON23_tree=null;

        try {
            // xquery/XQueryParser.g:372:9: (k= DECLARE k= BOUNDARY_SPACE ( (k= PRESERVE ) | (k= STRIP ) ) SEMICOLON )
            // xquery/XQueryParser.g:372:11: k= DECLARE k= BOUNDARY_SPACE ( (k= PRESERVE ) | (k= STRIP ) ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_BoundarySpaceDecl1459); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,BOUNDARY_SPACE,XQueryParser.FOLLOW_BOUNDARY_SPACE_in_pm_BoundarySpaceDecl1465); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:372:68: ( (k= PRESERVE ) | (k= STRIP ) )
            var alt10=2;
            var LA10_0 = this.input.LA(1);

            if ( (LA10_0==PRESERVE) ) {
                alt10=1;
            }
            else if ( (LA10_0==STRIP) ) {
                alt10=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 10, 0, this.input);

                throw nvae;
            }
            switch (alt10) {
                case 1 :
                    // xquery/XQueryParser.g:372:70: (k= PRESERVE )
                    // xquery/XQueryParser.g:372:70: (k= PRESERVE )
                    // xquery/XQueryParser.g:372:71: k= PRESERVE
                    k=this.match(this.input,PRESERVE,XQueryParser.FOLLOW_PRESERVE_in_pm_BoundarySpaceDecl1474); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }





                    break;
                case 2 :
                    // xquery/XQueryParser.g:372:100: (k= STRIP )
                    // xquery/XQueryParser.g:372:100: (k= STRIP )
                    // xquery/XQueryParser.g:372:101: k= STRIP
                    k=this.match(this.input,STRIP,XQueryParser.FOLLOW_STRIP_in_pm_BoundarySpaceDecl1484); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }





                    break;

            }

            SEMICOLON23=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_BoundarySpaceDecl1491); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON23_tree = this.adaptor.create(SEMICOLON23);
            this.adaptor.addChild(root_0, SEMICOLON23_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_DefaultCollationDecl_return: (function() {
        XQueryParser.pm_DefaultCollationDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_DefaultCollationDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:376:1: pm_DefaultCollationDecl : k= DECLARE k= DEFAULT k= COLLATION p_StringLiteral SEMICOLON ;
    // $ANTLR start "pm_DefaultCollationDecl"
    pm_DefaultCollationDecl: function() {
        var retval = new XQueryParser.pm_DefaultCollationDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON25 = null;
         var p_StringLiteral24 = null;

        var k_tree=null;
        var SEMICOLON25_tree=null;

        try {
            // xquery/XQueryParser.g:377:9: (k= DECLARE k= DEFAULT k= COLLATION p_StringLiteral SEMICOLON )
            // xquery/XQueryParser.g:377:11: k= DECLARE k= DEFAULT k= COLLATION p_StringLiteral SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_DefaultCollationDecl1519); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_pm_DefaultCollationDecl1525); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,COLLATION,XQueryParser.FOLLOW_COLLATION_in_pm_DefaultCollationDecl1531); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_DefaultCollationDecl1535);
            p_StringLiteral24=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral24.getTree());
            SEMICOLON25=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_DefaultCollationDecl1537); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON25_tree = this.adaptor.create(SEMICOLON25);
            this.adaptor.addChild(root_0, SEMICOLON25_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_BaseURIDecl_return: (function() {
        XQueryParser.pm_BaseURIDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_BaseURIDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:381:1: pm_BaseURIDecl : k= DECLARE k= BASE_URI sl= p_StringLiteral SEMICOLON -> ^( BaseURIDecl $sl) ;
    // $ANTLR start "pm_BaseURIDecl"
    pm_BaseURIDecl: function() {
        var retval = new XQueryParser.pm_BaseURIDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON26 = null;
         var sl = null;

        var k_tree=null;
        var SEMICOLON26_tree=null;
        var stream_DECLARE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token DECLARE");
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_BASE_URI=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token BASE_URI");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // xquery/XQueryParser.g:382:9: (k= DECLARE k= BASE_URI sl= p_StringLiteral SEMICOLON -> ^( BaseURIDecl $sl) )
            // xquery/XQueryParser.g:382:11: k= DECLARE k= BASE_URI sl= p_StringLiteral SEMICOLON
            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_BaseURIDecl1573); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_DECLARE.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,BASE_URI,XQueryParser.FOLLOW_BASE_URI_in_pm_BaseURIDecl1579); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_BASE_URI.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_BaseURIDecl1585);
            sl=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(sl.getTree());
            SEMICOLON26=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_BaseURIDecl1587); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON26);



            // AST REWRITE
            // elements: sl
            // token labels: 
            // rule labels: sl, retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_sl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token sl",sl!=null?sl.tree:null);
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 383:17: -> ^( BaseURIDecl $sl)
            {
                // xquery/XQueryParser.g:383:20: ^( BaseURIDecl $sl)
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(BaseURIDecl, "BaseURIDecl"), root_1);

                this.adaptor.addChild(root_1, stream_sl.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_ConstructionDecl_return: (function() {
        XQueryParser.pm_ConstructionDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_ConstructionDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:387:1: pm_ConstructionDecl : k= DECLARE k= CONSTRUCTION ( (k= STRIP | k= PRESERVE ) ) SEMICOLON ;
    // $ANTLR start "pm_ConstructionDecl"
    pm_ConstructionDecl: function() {
        var retval = new XQueryParser.pm_ConstructionDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON27 = null;

        var k_tree=null;
        var SEMICOLON27_tree=null;

        try {
            // xquery/XQueryParser.g:388:9: (k= DECLARE k= CONSTRUCTION ( (k= STRIP | k= PRESERVE ) ) SEMICOLON )
            // xquery/XQueryParser.g:388:11: k= DECLARE k= CONSTRUCTION ( (k= STRIP | k= PRESERVE ) ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_ConstructionDecl1640); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,CONSTRUCTION,XQueryParser.FOLLOW_CONSTRUCTION_in_pm_ConstructionDecl1646); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:388:66: ( (k= STRIP | k= PRESERVE ) )
            // xquery/XQueryParser.g:388:68: (k= STRIP | k= PRESERVE )
            // xquery/XQueryParser.g:388:68: (k= STRIP | k= PRESERVE )
            var alt11=2;
            var LA11_0 = this.input.LA(1);

            if ( (LA11_0==STRIP) ) {
                alt11=1;
            }
            else if ( (LA11_0==PRESERVE) ) {
                alt11=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 11, 0, this.input);

                throw nvae;
            }
            switch (alt11) {
                case 1 :
                    // xquery/XQueryParser.g:388:69: k= STRIP
                    k=this.match(this.input,STRIP,XQueryParser.FOLLOW_STRIP_in_pm_ConstructionDecl1655); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:388:79: k= PRESERVE
                    k=this.match(this.input,PRESERVE,XQueryParser.FOLLOW_PRESERVE_in_pm_ConstructionDecl1661); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            SEMICOLON27=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_ConstructionDecl1668); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON27_tree = this.adaptor.create(SEMICOLON27);
            this.adaptor.addChild(root_0, SEMICOLON27_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_OrderingModeDecl_return: (function() {
        XQueryParser.pm_OrderingModeDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_OrderingModeDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:392:1: pm_OrderingModeDecl : k= DECLARE k= ORDERING ( (k= ORDERED | k= UNORDERED ) ) SEMICOLON ;
    // $ANTLR start "pm_OrderingModeDecl"
    pm_OrderingModeDecl: function() {
        var retval = new XQueryParser.pm_OrderingModeDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON28 = null;

        var k_tree=null;
        var SEMICOLON28_tree=null;

        try {
            // xquery/XQueryParser.g:393:9: (k= DECLARE k= ORDERING ( (k= ORDERED | k= UNORDERED ) ) SEMICOLON )
            // xquery/XQueryParser.g:393:11: k= DECLARE k= ORDERING ( (k= ORDERED | k= UNORDERED ) ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_OrderingModeDecl1696); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,ORDERING,XQueryParser.FOLLOW_ORDERING_in_pm_OrderingModeDecl1702); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:393:62: ( (k= ORDERED | k= UNORDERED ) )
            // xquery/XQueryParser.g:393:64: (k= ORDERED | k= UNORDERED )
            // xquery/XQueryParser.g:393:64: (k= ORDERED | k= UNORDERED )
            var alt12=2;
            var LA12_0 = this.input.LA(1);

            if ( (LA12_0==ORDERED) ) {
                alt12=1;
            }
            else if ( (LA12_0==UNORDERED) ) {
                alt12=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 12, 0, this.input);

                throw nvae;
            }
            switch (alt12) {
                case 1 :
                    // xquery/XQueryParser.g:393:65: k= ORDERED
                    k=this.match(this.input,ORDERED,XQueryParser.FOLLOW_ORDERED_in_pm_OrderingModeDecl1711); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:393:77: k= UNORDERED
                    k=this.match(this.input,UNORDERED,XQueryParser.FOLLOW_UNORDERED_in_pm_OrderingModeDecl1717); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            SEMICOLON28=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_OrderingModeDecl1724); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON28_tree = this.adaptor.create(SEMICOLON28);
            this.adaptor.addChild(root_0, SEMICOLON28_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_EmptyOrderDecl_return: (function() {
        XQueryParser.pm_EmptyOrderDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_EmptyOrderDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:397:1: pm_EmptyOrderDecl : k= DECLARE k= DEFAULT k= ORDER k= EMPTY ( (k= GREATEST | k= LEAST ) ) SEMICOLON ;
    // $ANTLR start "pm_EmptyOrderDecl"
    pm_EmptyOrderDecl: function() {
        var retval = new XQueryParser.pm_EmptyOrderDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON29 = null;

        var k_tree=null;
        var SEMICOLON29_tree=null;

        try {
            // xquery/XQueryParser.g:398:9: (k= DECLARE k= DEFAULT k= ORDER k= EMPTY ( (k= GREATEST | k= LEAST ) ) SEMICOLON )
            // xquery/XQueryParser.g:398:11: k= DECLARE k= DEFAULT k= ORDER k= EMPTY ( (k= GREATEST | k= LEAST ) ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_EmptyOrderDecl1752); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_pm_EmptyOrderDecl1758); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,ORDER,XQueryParser.FOLLOW_ORDER_in_pm_EmptyOrderDecl1764); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,EMPTY,XQueryParser.FOLLOW_EMPTY_in_pm_EmptyOrderDecl1770); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:398:107: ( (k= GREATEST | k= LEAST ) )
            // xquery/XQueryParser.g:398:109: (k= GREATEST | k= LEAST )
            // xquery/XQueryParser.g:398:109: (k= GREATEST | k= LEAST )
            var alt13=2;
            var LA13_0 = this.input.LA(1);

            if ( (LA13_0==GREATEST) ) {
                alt13=1;
            }
            else if ( (LA13_0==LEAST) ) {
                alt13=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 13, 0, this.input);

                throw nvae;
            }
            switch (alt13) {
                case 1 :
                    // xquery/XQueryParser.g:398:110: k= GREATEST
                    k=this.match(this.input,GREATEST,XQueryParser.FOLLOW_GREATEST_in_pm_EmptyOrderDecl1779); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:398:123: k= LEAST
                    k=this.match(this.input,LEAST,XQueryParser.FOLLOW_LEAST_in_pm_EmptyOrderDecl1785); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            SEMICOLON29=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_EmptyOrderDecl1792); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON29_tree = this.adaptor.create(SEMICOLON29);
            this.adaptor.addChild(root_0, SEMICOLON29_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_CopyNamespacesDecl_return: (function() {
        XQueryParser.pm_CopyNamespacesDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_CopyNamespacesDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:402:1: pm_CopyNamespacesDecl : k= DECLARE k= COPY_NAMESPACES p_PreserveMode COMMA p_InheritMode SEMICOLON ;
    // $ANTLR start "pm_CopyNamespacesDecl"
    pm_CopyNamespacesDecl: function() {
        var retval = new XQueryParser.pm_CopyNamespacesDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var COMMA31 = null;
        var SEMICOLON33 = null;
         var p_PreserveMode30 = null;
         var p_InheritMode32 = null;

        var k_tree=null;
        var COMMA31_tree=null;
        var SEMICOLON33_tree=null;

        try {
            // xquery/XQueryParser.g:403:9: (k= DECLARE k= COPY_NAMESPACES p_PreserveMode COMMA p_InheritMode SEMICOLON )
            // xquery/XQueryParser.g:403:11: k= DECLARE k= COPY_NAMESPACES p_PreserveMode COMMA p_InheritMode SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_CopyNamespacesDecl1820); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,COPY_NAMESPACES,XQueryParser.FOLLOW_COPY_NAMESPACES_in_pm_CopyNamespacesDecl1826); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_PreserveMode_in_pm_CopyNamespacesDecl1830);
            p_PreserveMode30=this.p_PreserveMode();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PreserveMode30.getTree());
            COMMA31=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_pm_CopyNamespacesDecl1832); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            COMMA31_tree = this.adaptor.create(COMMA31);
            this.adaptor.addChild(root_0, COMMA31_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_InheritMode_in_pm_CopyNamespacesDecl1834);
            p_InheritMode32=this.p_InheritMode();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_InheritMode32.getTree());
            SEMICOLON33=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_CopyNamespacesDecl1836); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON33_tree = this.adaptor.create(SEMICOLON33);
            this.adaptor.addChild(root_0, SEMICOLON33_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PreserveMode_return: (function() {
        XQueryParser.p_PreserveMode_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PreserveMode_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:407:1: p_PreserveMode : (k+= PRESERVE | k+= NO_PRESERVE ) ;
    // $ANTLR start "p_PreserveMode"
    p_PreserveMode: function() {
        var retval = new XQueryParser.p_PreserveMode_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var list_k=null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:408:9: ( (k+= PRESERVE | k+= NO_PRESERVE ) )
            // xquery/XQueryParser.g:408:11: (k+= PRESERVE | k+= NO_PRESERVE )
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:408:11: (k+= PRESERVE | k+= NO_PRESERVE )
            var alt14=2;
            var LA14_0 = this.input.LA(1);

            if ( (LA14_0==PRESERVE) ) {
                alt14=1;
            }
            else if ( (LA14_0==NO_PRESERVE) ) {
                alt14=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 14, 0, this.input);

                throw nvae;
            }
            switch (alt14) {
                case 1 :
                    // xquery/XQueryParser.g:408:12: k+= PRESERVE
                    k=this.match(this.input,PRESERVE,XQueryParser.FOLLOW_PRESERVE_in_p_PreserveMode1865); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;
                case 2 :
                    // xquery/XQueryParser.g:408:26: k+= NO_PRESERVE
                    k=this.match(this.input,NO_PRESERVE,XQueryParser.FOLLOW_NO_PRESERVE_in_p_PreserveMode1871); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_InheritMode_return: (function() {
        XQueryParser.p_InheritMode_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_InheritMode_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:412:1: p_InheritMode : (k+= INHERIT | k+= NO_INHERIT ) ;
    // $ANTLR start "p_InheritMode"
    p_InheritMode: function() {
        var retval = new XQueryParser.p_InheritMode_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var list_k=null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:413:9: ( (k+= INHERIT | k+= NO_INHERIT ) )
            // xquery/XQueryParser.g:413:11: (k+= INHERIT | k+= NO_INHERIT )
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:413:11: (k+= INHERIT | k+= NO_INHERIT )
            var alt15=2;
            var LA15_0 = this.input.LA(1);

            if ( (LA15_0==INHERIT) ) {
                alt15=1;
            }
            else if ( (LA15_0==NO_INHERIT) ) {
                alt15=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 15, 0, this.input);

                throw nvae;
            }
            switch (alt15) {
                case 1 :
                    // xquery/XQueryParser.g:413:12: k+= INHERIT
                    k=this.match(this.input,INHERIT,XQueryParser.FOLLOW_INHERIT_in_p_InheritMode1903); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;
                case 2 :
                    // xquery/XQueryParser.g:413:25: k+= NO_INHERIT
                    k=this.match(this.input,NO_INHERIT,XQueryParser.FOLLOW_NO_INHERIT_in_p_InheritMode1909); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_DecimalFormatDecl_return: (function() {
        XQueryParser.pm_DecimalFormatDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_DecimalFormatDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:417:1: pm_DecimalFormatDecl : k= DECLARE ( (k= DECIMAL_FORMAT p_QName ) | (k= DEFAULT k= DECIMAL_FORMAT ) ) ( p_DFPropertyName EQUAL p_StringLiteral )* SEMICOLON ;
    // $ANTLR start "pm_DecimalFormatDecl"
    pm_DecimalFormatDecl: function() {
        var retval = new XQueryParser.pm_DecimalFormatDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var EQUAL36 = null;
        var SEMICOLON38 = null;
         var p_QName34 = null;
         var p_DFPropertyName35 = null;
         var p_StringLiteral37 = null;

        var k_tree=null;
        var EQUAL36_tree=null;
        var SEMICOLON38_tree=null;

        try {
            // xquery/XQueryParser.g:418:9: (k= DECLARE ( (k= DECIMAL_FORMAT p_QName ) | (k= DEFAULT k= DECIMAL_FORMAT ) ) ( p_DFPropertyName EQUAL p_StringLiteral )* SEMICOLON )
            // xquery/XQueryParser.g:418:11: k= DECLARE ( (k= DECIMAL_FORMAT p_QName ) | (k= DEFAULT k= DECIMAL_FORMAT ) ) ( p_DFPropertyName EQUAL p_StringLiteral )* SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_DecimalFormatDecl1948); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:418:36: ( (k= DECIMAL_FORMAT p_QName ) | (k= DEFAULT k= DECIMAL_FORMAT ) )
            var alt16=2;
            var LA16_0 = this.input.LA(1);

            if ( (LA16_0==DECIMAL_FORMAT) ) {
                alt16=1;
            }
            else if ( (LA16_0==DEFAULT) ) {
                alt16=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 16, 0, this.input);

                throw nvae;
            }
            switch (alt16) {
                case 1 :
                    // xquery/XQueryParser.g:418:37: (k= DECIMAL_FORMAT p_QName )
                    // xquery/XQueryParser.g:418:37: (k= DECIMAL_FORMAT p_QName )
                    // xquery/XQueryParser.g:418:38: k= DECIMAL_FORMAT p_QName
                    k=this.match(this.input,DECIMAL_FORMAT,XQueryParser.FOLLOW_DECIMAL_FORMAT_in_pm_DecimalFormatDecl1956); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_QName_in_pm_DecimalFormatDecl1960);
                    p_QName34=this.p_QName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName34.getTree());





                    break;
                case 2 :
                    // xquery/XQueryParser.g:418:81: (k= DEFAULT k= DECIMAL_FORMAT )
                    // xquery/XQueryParser.g:418:81: (k= DEFAULT k= DECIMAL_FORMAT )
                    // xquery/XQueryParser.g:418:82: k= DEFAULT k= DECIMAL_FORMAT
                    k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_pm_DecimalFormatDecl1968); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    k=this.match(this.input,DECIMAL_FORMAT,XQueryParser.FOLLOW_DECIMAL_FORMAT_in_pm_DecimalFormatDecl1974); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }





                    break;

            }

            // xquery/XQueryParser.g:418:141: ( p_DFPropertyName EQUAL p_StringLiteral )*
            loop17:
            do {
                var alt17=2;
                var LA17_0 = this.input.LA(1);

                if ( ((LA17_0>=DECIMAL_SEPARATOR && LA17_0<=DIGIT)||(LA17_0>=GROUPING_SEPARATOR && LA17_0<=MINUS_SIGN)||LA17_0==NAN||(LA17_0>=PATTERN_SEPARATOR && LA17_0<=PER_MILLE)||LA17_0==ZERO_DIGIT) ) {
                    alt17=1;
                }


                switch (alt17) {
                case 1 :
                    // xquery/XQueryParser.g:418:142: p_DFPropertyName EQUAL p_StringLiteral
                    this.pushFollow(XQueryParser.FOLLOW_p_DFPropertyName_in_pm_DecimalFormatDecl1981);
                    p_DFPropertyName35=this.p_DFPropertyName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_DFPropertyName35.getTree());
                    EQUAL36=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_pm_DecimalFormatDecl1983); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    EQUAL36_tree = this.adaptor.create(EQUAL36);
                    this.adaptor.addChild(root_0, EQUAL36_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_DecimalFormatDecl1985);
                    p_StringLiteral37=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral37.getTree());


                    break;

                default :
                    break loop17;
                }
            } while (true);

            SEMICOLON38=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_DecimalFormatDecl1989); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON38_tree = this.adaptor.create(SEMICOLON38);
            this.adaptor.addChild(root_0, SEMICOLON38_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_DFPropertyName_return: (function() {
        XQueryParser.p_DFPropertyName_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_DFPropertyName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:422:1: p_DFPropertyName : (k= DECIMAL_SEPARATOR | k= GROUPING_SEPARATOR | k= INFINITY | k= MINUS_SIGN | k= NAN | k= PERCENT | k= PER_MILLE | k= ZERO_DIGIT | k= DIGIT | k= PATTERN_SEPARATOR ) ;
    // $ANTLR start "p_DFPropertyName"
    p_DFPropertyName: function() {
        var retval = new XQueryParser.p_DFPropertyName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:423:9: ( (k= DECIMAL_SEPARATOR | k= GROUPING_SEPARATOR | k= INFINITY | k= MINUS_SIGN | k= NAN | k= PERCENT | k= PER_MILLE | k= ZERO_DIGIT | k= DIGIT | k= PATTERN_SEPARATOR ) )
            // xquery/XQueryParser.g:423:11: (k= DECIMAL_SEPARATOR | k= GROUPING_SEPARATOR | k= INFINITY | k= MINUS_SIGN | k= NAN | k= PERCENT | k= PER_MILLE | k= ZERO_DIGIT | k= DIGIT | k= PATTERN_SEPARATOR )
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:423:11: (k= DECIMAL_SEPARATOR | k= GROUPING_SEPARATOR | k= INFINITY | k= MINUS_SIGN | k= NAN | k= PERCENT | k= PER_MILLE | k= ZERO_DIGIT | k= DIGIT | k= PATTERN_SEPARATOR )
            var alt18=10;
            switch ( this.input.LA(1) ) {
            case DECIMAL_SEPARATOR:
                alt18=1;
                break;
            case GROUPING_SEPARATOR:
                alt18=2;
                break;
            case INFINITY:
                alt18=3;
                break;
            case MINUS_SIGN:
                alt18=4;
                break;
            case NAN:
                alt18=5;
                break;
            case PERCENT:
                alt18=6;
                break;
            case PER_MILLE:
                alt18=7;
                break;
            case ZERO_DIGIT:
                alt18=8;
                break;
            case DIGIT:
                alt18=9;
                break;
            case PATTERN_SEPARATOR:
                alt18=10;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 18, 0, this.input);

                throw nvae;
            }

            switch (alt18) {
                case 1 :
                    // xquery/XQueryParser.g:423:12: k= DECIMAL_SEPARATOR
                    k=this.match(this.input,DECIMAL_SEPARATOR,XQueryParser.FOLLOW_DECIMAL_SEPARATOR_in_p_DFPropertyName2018); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:423:34: k= GROUPING_SEPARATOR
                    k=this.match(this.input,GROUPING_SEPARATOR,XQueryParser.FOLLOW_GROUPING_SEPARATOR_in_p_DFPropertyName2024); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:423:57: k= INFINITY
                    k=this.match(this.input,INFINITY,XQueryParser.FOLLOW_INFINITY_in_p_DFPropertyName2030); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 4 :
                    // xquery/XQueryParser.g:423:70: k= MINUS_SIGN
                    k=this.match(this.input,MINUS_SIGN,XQueryParser.FOLLOW_MINUS_SIGN_in_p_DFPropertyName2036); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 5 :
                    // xquery/XQueryParser.g:423:85: k= NAN
                    k=this.match(this.input,NAN,XQueryParser.FOLLOW_NAN_in_p_DFPropertyName2042); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 6 :
                    // xquery/XQueryParser.g:423:93: k= PERCENT
                    k=this.match(this.input,PERCENT,XQueryParser.FOLLOW_PERCENT_in_p_DFPropertyName2048); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 7 :
                    // xquery/XQueryParser.g:423:105: k= PER_MILLE
                    k=this.match(this.input,PER_MILLE,XQueryParser.FOLLOW_PER_MILLE_in_p_DFPropertyName2054); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 8 :
                    // xquery/XQueryParser.g:423:119: k= ZERO_DIGIT
                    k=this.match(this.input,ZERO_DIGIT,XQueryParser.FOLLOW_ZERO_DIGIT_in_p_DFPropertyName2060); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 9 :
                    // xquery/XQueryParser.g:423:134: k= DIGIT
                    k=this.match(this.input,DIGIT,XQueryParser.FOLLOW_DIGIT_in_p_DFPropertyName2066); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 10 :
                    // xquery/XQueryParser.g:423:144: k= PATTERN_SEPARATOR
                    k=this.match(this.input,PATTERN_SEPARATOR,XQueryParser.FOLLOW_PATTERN_SEPARATOR_in_p_DFPropertyName2072); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Import_return: (function() {
        XQueryParser.p_Import_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Import_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:427:1: p_Import : ( pm_SchemaImport | pm_ModuleImport );
    // $ANTLR start "p_Import"
    p_Import: function() {
        var retval = new XQueryParser.p_Import_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pm_SchemaImport39 = null;
         var pm_ModuleImport40 = null;


        try {
            // xquery/XQueryParser.g:428:9: ( pm_SchemaImport | pm_ModuleImport )
            var alt19=2;
            var LA19_0 = this.input.LA(1);

            if ( (LA19_0==IMPORT) ) {
                var LA19_1 = this.input.LA(2);

                if ( (LA19_1==SCHEMA) ) {
                    alt19=1;
                }
                else if ( (LA19_1==MODULE) ) {
                    alt19=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 19, 1, this.input);

                    throw nvae;
                }
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 19, 0, this.input);

                throw nvae;
            }
            switch (alt19) {
                case 1 :
                    // xquery/XQueryParser.g:428:11: pm_SchemaImport
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_SchemaImport_in_p_Import2101);
                    pm_SchemaImport39=this.pm_SchemaImport();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_SchemaImport39.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:428:29: pm_ModuleImport
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_ModuleImport_in_p_Import2105);
                    pm_ModuleImport40=this.pm_ModuleImport();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_ModuleImport40.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_SchemaImport_return: (function() {
        XQueryParser.pm_SchemaImport_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_SchemaImport_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:432:1: pm_SchemaImport : k= IMPORT k= SCHEMA (sp= p_SchemaPrefix )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON -> ^( SchemaImport ^( SchemaPrefix ( $sp)? ) $us ^( AtHints ( $ah)* ) ) ;
    // $ANTLR start "pm_SchemaImport"
    pm_SchemaImport: function() {
        var retval = new XQueryParser.pm_SchemaImport_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var COMMA41 = null;
        var SEMICOLON42 = null;
        var list_ah=null;
         var sp = null;
         var us = null;
        var ah = null;
        var k_tree=null;
        var COMMA41_tree=null;
        var SEMICOLON42_tree=null;
        var stream_AT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token AT");
        var stream_IMPORT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token IMPORT");
        var stream_SCHEMA=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SCHEMA");
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_COMMA=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token COMMA");
        var stream_p_SchemaPrefix=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_SchemaPrefix");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // xquery/XQueryParser.g:433:9: (k= IMPORT k= SCHEMA (sp= p_SchemaPrefix )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON -> ^( SchemaImport ^( SchemaPrefix ( $sp)? ) $us ^( AtHints ( $ah)* ) ) )
            // xquery/XQueryParser.g:433:11: k= IMPORT k= SCHEMA (sp= p_SchemaPrefix )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON
            k=this.match(this.input,IMPORT,XQueryParser.FOLLOW_IMPORT_in_pm_SchemaImport2141); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_IMPORT.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,SCHEMA,XQueryParser.FOLLOW_SCHEMA_in_pm_SchemaImport2147); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SCHEMA.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:433:61: (sp= p_SchemaPrefix )?
            var alt20=2;
            var LA20_0 = this.input.LA(1);

            if ( (LA20_0==DEFAULT||LA20_0==NAMESPACE) ) {
                alt20=1;
            }
            switch (alt20) {
                case 1 :
                    // xquery/XQueryParser.g:433:61: sp= p_SchemaPrefix
                    this.pushFollow(XQueryParser.FOLLOW_p_SchemaPrefix_in_pm_SchemaImport2153);
                    sp=this.p_SchemaPrefix();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_SchemaPrefix.add(sp.getTree());


                    break;

            }

            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_SchemaImport2158);
            us=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(us.getTree());
            // xquery/XQueryParser.g:433:97: (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )?
            var alt22=2;
            var LA22_0 = this.input.LA(1);

            if ( (LA22_0==AT) ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // xquery/XQueryParser.g:433:98: k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )*
                    k=this.match(this.input,AT,XQueryParser.FOLLOW_AT_in_pm_SchemaImport2163); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_AT.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_SchemaImport2169);
                    ah=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(ah.getTree());
                    if (org.antlr.lang.isNull(list_ah)) list_ah = [];
                    list_ah.push(ah.getTree());

                    // xquery/XQueryParser.g:433:138: ( COMMA ah+= p_StringLiteral )*
                    loop21:
                    do {
                        var alt21=2;
                        var LA21_0 = this.input.LA(1);

                        if ( (LA21_0==COMMA) ) {
                            alt21=1;
                        }


                        switch (alt21) {
                        case 1 :
                            // xquery/XQueryParser.g:433:139: COMMA ah+= p_StringLiteral
                            COMMA41=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_pm_SchemaImport2172); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_COMMA.add(COMMA41);

                            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_SchemaImport2176);
                            ah=this.p_StringLiteral();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(ah.getTree());
                            if (org.antlr.lang.isNull(list_ah)) list_ah = [];
                            list_ah.push(ah.getTree());



                            break;

                        default :
                            break loop21;
                        }
                    } while (true);



                    break;

            }

            SEMICOLON42=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_SchemaImport2182); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON42);



            // AST REWRITE
            // elements: ah, sp, us
            // token labels: 
            // rule labels: retval, sp, us
            // token list labels: 
            // rule list labels: ah
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_sp=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token sp",sp!=null?sp.tree:null);
            var stream_us=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token us",us!=null?us.tree:null);
            var stream_ah=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token ah",list_ah);
            root_0 = this.adaptor.nil();
            // 434:17: -> ^( SchemaImport ^( SchemaPrefix ( $sp)? ) $us ^( AtHints ( $ah)* ) )
            {
                // xquery/XQueryParser.g:434:20: ^( SchemaImport ^( SchemaPrefix ( $sp)? ) $us ^( AtHints ( $ah)* ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(SchemaImport, "SchemaImport"), root_1);

                // xquery/XQueryParser.g:434:35: ^( SchemaPrefix ( $sp)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(SchemaPrefix, "SchemaPrefix"), root_2);

                // xquery/XQueryParser.g:434:50: ( $sp)?
                if ( stream_sp.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_sp.nextTree());

                }
                stream_sp.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                this.adaptor.addChild(root_1, stream_us.nextTree());
                // xquery/XQueryParser.g:434:60: ^( AtHints ( $ah)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(AtHints, "AtHints"), root_2);

                // xquery/XQueryParser.g:434:70: ( $ah)*
                while ( stream_ah.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_ah.nextTree());

                }
                stream_ah.reset();

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SchemaPrefix_return: (function() {
        XQueryParser.p_SchemaPrefix_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SchemaPrefix_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:438:1: p_SchemaPrefix : (k= NAMESPACE nn= p_NCName EQUAL -> ^( NamespaceName $nn) | k= DEFAULT k= ELEMENT k= NAMESPACE -> DefaultElementNamespace );
    // $ANTLR start "p_SchemaPrefix"
    p_SchemaPrefix: function() {
        var retval = new XQueryParser.p_SchemaPrefix_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var EQUAL43 = null;
         var nn = null;

        var k_tree=null;
        var EQUAL43_tree=null;
        var stream_ELEMENT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token ELEMENT");
        var stream_NAMESPACE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token NAMESPACE");
        var stream_EQUAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EQUAL");
        var stream_DEFAULT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token DEFAULT");
        var stream_p_NCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_NCName");
        try {
            // xquery/XQueryParser.g:439:9: (k= NAMESPACE nn= p_NCName EQUAL -> ^( NamespaceName $nn) | k= DEFAULT k= ELEMENT k= NAMESPACE -> DefaultElementNamespace )
            var alt23=2;
            var LA23_0 = this.input.LA(1);

            if ( (LA23_0==NAMESPACE) ) {
                alt23=1;
            }
            else if ( (LA23_0==DEFAULT) ) {
                alt23=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 23, 0, this.input);

                throw nvae;
            }
            switch (alt23) {
                case 1 :
                    // xquery/XQueryParser.g:439:11: k= NAMESPACE nn= p_NCName EQUAL
                    k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_p_SchemaPrefix2252); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_NAMESPACE.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_p_SchemaPrefix2258);
                    nn=this.p_NCName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_NCName.add(nn.getTree());
                    EQUAL43=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_p_SchemaPrefix2260); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_EQUAL.add(EQUAL43);



                    // AST REWRITE
                    // elements: nn
                    // token labels: 
                    // rule labels: retval, nn
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
                    var stream_nn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token nn",nn!=null?nn.tree:null);

                    root_0 = this.adaptor.nil();
                    // 440:17: -> ^( NamespaceName $nn)
                    {
                        // xquery/XQueryParser.g:440:20: ^( NamespaceName $nn)
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(NamespaceName, "NamespaceName"), root_1);

                        this.adaptor.addChild(root_1, stream_nn.nextTree());

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;
                case 2 :
                    // xquery/XQueryParser.g:441:11: k= DEFAULT k= ELEMENT k= NAMESPACE
                    k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_p_SchemaPrefix2299); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_DEFAULT.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    k=this.match(this.input,ELEMENT,XQueryParser.FOLLOW_ELEMENT_in_p_SchemaPrefix2305); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_ELEMENT.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_p_SchemaPrefix2311); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_NAMESPACE.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 442:17: -> DefaultElementNamespace
                    {
                        this.adaptor.addChild(root_0, this.adaptor.create(DefaultElementNamespace, "DefaultElementNamespace"));

                    }

                    retval.tree = root_0;}

                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_ModuleImport_return: (function() {
        XQueryParser.pm_ModuleImport_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_ModuleImport_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:446:1: pm_ModuleImport : k= IMPORT k= MODULE (k= NAMESPACE nn= p_NCName EQUAL )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON -> ^( ModuleImport ^( NamespaceName ( $nn)? ) $us ^( AtHints ( $ah)* ) ) ;
    // $ANTLR start "pm_ModuleImport"
    pm_ModuleImport: function() {
        var retval = new XQueryParser.pm_ModuleImport_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var EQUAL44 = null;
        var COMMA45 = null;
        var SEMICOLON46 = null;
        var list_ah=null;
         var nn = null;
         var us = null;
        var ah = null;
        var k_tree=null;
        var EQUAL44_tree=null;
        var COMMA45_tree=null;
        var SEMICOLON46_tree=null;
        var stream_AT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token AT");
        var stream_IMPORT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token IMPORT");
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_MODULE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token MODULE");
        var stream_COMMA=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token COMMA");
        var stream_NAMESPACE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token NAMESPACE");
        var stream_EQUAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EQUAL");
        var stream_p_NCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_NCName");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // xquery/XQueryParser.g:447:9: (k= IMPORT k= MODULE (k= NAMESPACE nn= p_NCName EQUAL )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON -> ^( ModuleImport ^( NamespaceName ( $nn)? ) $us ^( AtHints ( $ah)* ) ) )
            // xquery/XQueryParser.g:447:11: k= IMPORT k= MODULE (k= NAMESPACE nn= p_NCName EQUAL )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON
            k=this.match(this.input,IMPORT,XQueryParser.FOLLOW_IMPORT_in_pm_ModuleImport2361); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_IMPORT.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,MODULE,XQueryParser.FOLLOW_MODULE_in_pm_ModuleImport2367); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_MODULE.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:447:59: (k= NAMESPACE nn= p_NCName EQUAL )?
            var alt24=2;
            var LA24_0 = this.input.LA(1);

            if ( (LA24_0==NAMESPACE) ) {
                alt24=1;
            }
            switch (alt24) {
                case 1 :
                    // xquery/XQueryParser.g:447:60: k= NAMESPACE nn= p_NCName EQUAL
                    k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_pm_ModuleImport2374); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_NAMESPACE.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_pm_ModuleImport2380);
                    nn=this.p_NCName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_NCName.add(nn.getTree());
                    EQUAL44=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_pm_ModuleImport2382); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_EQUAL.add(EQUAL44);



                    break;

            }

            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_ModuleImport2388);
            us=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(us.getTree());
            // xquery/XQueryParser.g:447:126: (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )?
            var alt26=2;
            var LA26_0 = this.input.LA(1);

            if ( (LA26_0==AT) ) {
                alt26=1;
            }
            switch (alt26) {
                case 1 :
                    // xquery/XQueryParser.g:447:127: k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )*
                    k=this.match(this.input,AT,XQueryParser.FOLLOW_AT_in_pm_ModuleImport2393); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_AT.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_ModuleImport2399);
                    ah=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(ah.getTree());
                    if (org.antlr.lang.isNull(list_ah)) list_ah = [];
                    list_ah.push(ah.getTree());

                    // xquery/XQueryParser.g:447:167: ( COMMA ah+= p_StringLiteral )*
                    loop25:
                    do {
                        var alt25=2;
                        var LA25_0 = this.input.LA(1);

                        if ( (LA25_0==COMMA) ) {
                            alt25=1;
                        }


                        switch (alt25) {
                        case 1 :
                            // xquery/XQueryParser.g:447:168: COMMA ah+= p_StringLiteral
                            COMMA45=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_pm_ModuleImport2402); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_COMMA.add(COMMA45);

                            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_ModuleImport2406);
                            ah=this.p_StringLiteral();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(ah.getTree());
                            if (org.antlr.lang.isNull(list_ah)) list_ah = [];
                            list_ah.push(ah.getTree());



                            break;

                        default :
                            break loop25;
                        }
                    } while (true);



                    break;

            }

            SEMICOLON46=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_ModuleImport2412); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON46);



            // AST REWRITE
            // elements: us, nn, ah
            // token labels: 
            // rule labels: retval, nn, us
            // token list labels: 
            // rule list labels: ah
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_nn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token nn",nn!=null?nn.tree:null);
            var stream_us=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token us",us!=null?us.tree:null);
            var stream_ah=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token ah",list_ah);
            root_0 = this.adaptor.nil();
            // 448:17: -> ^( ModuleImport ^( NamespaceName ( $nn)? ) $us ^( AtHints ( $ah)* ) )
            {
                // xquery/XQueryParser.g:448:20: ^( ModuleImport ^( NamespaceName ( $nn)? ) $us ^( AtHints ( $ah)* ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(ModuleImport, "ModuleImport"), root_1);

                // xquery/XQueryParser.g:448:35: ^( NamespaceName ( $nn)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(NamespaceName, "NamespaceName"), root_2);

                // xquery/XQueryParser.g:448:51: ( $nn)?
                if ( stream_nn.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_nn.nextTree());

                }
                stream_nn.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                this.adaptor.addChild(root_1, stream_us.nextTree());
                // xquery/XQueryParser.g:448:61: ^( AtHints ( $ah)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(AtHints, "AtHints"), root_2);

                // xquery/XQueryParser.g:448:71: ( $ah)*
                while ( stream_ah.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_ah.nextTree());

                }
                stream_ah.reset();

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_NamespaceDecl_return: (function() {
        XQueryParser.pm_NamespaceDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_NamespaceDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:452:1: pm_NamespaceDecl : k= DECLARE k= NAMESPACE nn= p_NCName EQUAL us= p_StringLiteral SEMICOLON -> ^( NamespaceDecl $nn $us) ;
    // $ANTLR start "pm_NamespaceDecl"
    pm_NamespaceDecl: function() {
        var retval = new XQueryParser.pm_NamespaceDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var EQUAL47 = null;
        var SEMICOLON48 = null;
         var nn = null;
         var us = null;

        var k_tree=null;
        var EQUAL47_tree=null;
        var SEMICOLON48_tree=null;
        var stream_DECLARE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token DECLARE");
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_NAMESPACE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token NAMESPACE");
        var stream_EQUAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EQUAL");
        var stream_p_NCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_NCName");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // xquery/XQueryParser.g:453:9: (k= DECLARE k= NAMESPACE nn= p_NCName EQUAL us= p_StringLiteral SEMICOLON -> ^( NamespaceDecl $nn $us) )
            // xquery/XQueryParser.g:453:11: k= DECLARE k= NAMESPACE nn= p_NCName EQUAL us= p_StringLiteral SEMICOLON
            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_NamespaceDecl2481); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_DECLARE.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_pm_NamespaceDecl2487); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_NAMESPACE.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_pm_NamespaceDecl2493);
            nn=this.p_NCName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_NCName.add(nn.getTree());
            EQUAL47=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_pm_NamespaceDecl2495); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_EQUAL.add(EQUAL47);

            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_NamespaceDecl2499);
            us=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(us.getTree());
            SEMICOLON48=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_NamespaceDecl2501); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON48);



            // AST REWRITE
            // elements: nn, us
            // token labels: 
            // rule labels: retval, nn, us
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_nn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token nn",nn!=null?nn.tree:null);
            var stream_us=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token us",us!=null?us.tree:null);

            root_0 = this.adaptor.nil();
            // 454:17: -> ^( NamespaceDecl $nn $us)
            {
                // xquery/XQueryParser.g:454:20: ^( NamespaceDecl $nn $us)
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(NamespaceDecl, "NamespaceDecl"), root_1);

                this.adaptor.addChild(root_1, stream_nn.nextTree());
                this.adaptor.addChild(root_1, stream_us.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_DefaultNamespaceDecl_return: (function() {
        XQueryParser.pm_DefaultNamespaceDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_DefaultNamespaceDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:458:1: pm_DefaultNamespaceDecl : k= DECLARE k= DEFAULT (k= ELEMENT | k= FUNCTION ) k= NAMESPACE p_StringLiteral SEMICOLON ;
    // $ANTLR start "pm_DefaultNamespaceDecl"
    pm_DefaultNamespaceDecl: function() {
        var retval = new XQueryParser.pm_DefaultNamespaceDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON50 = null;
         var p_StringLiteral49 = null;

        var k_tree=null;
        var SEMICOLON50_tree=null;

        try {
            // xquery/XQueryParser.g:459:9: (k= DECLARE k= DEFAULT (k= ELEMENT | k= FUNCTION ) k= NAMESPACE p_StringLiteral SEMICOLON )
            // xquery/XQueryParser.g:459:11: k= DECLARE k= DEFAULT (k= ELEMENT | k= FUNCTION ) k= NAMESPACE p_StringLiteral SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_DefaultNamespaceDecl2558); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_pm_DefaultNamespaceDecl2564); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:459:61: (k= ELEMENT | k= FUNCTION )
            var alt27=2;
            var LA27_0 = this.input.LA(1);

            if ( (LA27_0==ELEMENT) ) {
                alt27=1;
            }
            else if ( (LA27_0==FUNCTION) ) {
                alt27=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 27, 0, this.input);

                throw nvae;
            }
            switch (alt27) {
                case 1 :
                    // xquery/XQueryParser.g:459:62: k= ELEMENT
                    k=this.match(this.input,ELEMENT,XQueryParser.FOLLOW_ELEMENT_in_pm_DefaultNamespaceDecl2571); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:459:74: k= FUNCTION
                    k=this.match(this.input,FUNCTION,XQueryParser.FOLLOW_FUNCTION_in_pm_DefaultNamespaceDecl2577); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_pm_DefaultNamespaceDecl2584); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_DefaultNamespaceDecl2588);
            p_StringLiteral49=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral49.getTree());
            SEMICOLON50=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_DefaultNamespaceDecl2590); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON50_tree = this.adaptor.create(SEMICOLON50);
            this.adaptor.addChild(root_0, SEMICOLON50_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_AnnotatedDecl_return: (function() {
        XQueryParser.pm_AnnotatedDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_AnnotatedDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:463:1: pm_AnnotatedDecl : k= DECLARE ( p_Annotation )* pg_AnnotatedDecl SEMICOLON ;
    // $ANTLR start "pm_AnnotatedDecl"
    pm_AnnotatedDecl: function() {
        var retval = new XQueryParser.pm_AnnotatedDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON53 = null;
         var p_Annotation51 = null;
         var pg_AnnotatedDecl52 = null;

        var k_tree=null;
        var SEMICOLON53_tree=null;

        try {
            // xquery/XQueryParser.g:464:9: (k= DECLARE ( p_Annotation )* pg_AnnotatedDecl SEMICOLON )
            // xquery/XQueryParser.g:464:11: k= DECLARE ( p_Annotation )* pg_AnnotatedDecl SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_AnnotatedDecl2618); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:464:36: ( p_Annotation )*
            loop28:
            do {
                var alt28=2;
                var LA28_0 = this.input.LA(1);

                if ( (LA28_0==ANN_PERCENT) ) {
                    alt28=1;
                }


                switch (alt28) {
                case 1 :
                    // xquery/XQueryParser.g:464:36: p_Annotation
                    this.pushFollow(XQueryParser.FOLLOW_p_Annotation_in_pm_AnnotatedDecl2622);
                    p_Annotation51=this.p_Annotation();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Annotation51.getTree());


                    break;

                default :
                    break loop28;
                }
            } while (true);

            this.pushFollow(XQueryParser.FOLLOW_pg_AnnotatedDecl_in_pm_AnnotatedDecl2625);
            pg_AnnotatedDecl52=this.pg_AnnotatedDecl();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pg_AnnotatedDecl52.getTree());
            SEMICOLON53=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_AnnotatedDecl2627); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON53_tree = this.adaptor.create(SEMICOLON53);
            this.adaptor.addChild(root_0, SEMICOLON53_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pg_AnnotatedDecl_return: (function() {
        XQueryParser.pg_AnnotatedDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pg_AnnotatedDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:466:1: pg_AnnotatedDecl : ( p_VarDecl | pm_FunctionDecl | {...}? => p_CollectionDecl | {...}? => p_IndexDecl | {...}? => p_ICDecl );
    // $ANTLR start "pg_AnnotatedDecl"
    pg_AnnotatedDecl: function() {
        var retval = new XQueryParser.pg_AnnotatedDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_VarDecl54 = null;
         var pm_FunctionDecl55 = null;
         var p_CollectionDecl56 = null;
         var p_IndexDecl57 = null;
         var p_ICDecl58 = null;


        try {
            // xquery/XQueryParser.g:467:9: ( p_VarDecl | pm_FunctionDecl | {...}? => p_CollectionDecl | {...}? => p_IndexDecl | {...}? => p_ICDecl )
            var alt29=5;
            var LA29_0 = this.input.LA(1);

            if ( (LA29_0==VARIABLE) ) {
                alt29=1;
            }
            else if ( (LA29_0==UPDATING) && ((this.lc(XQU)))) {
                alt29=2;
            }
            else if ( (LA29_0==FUNCTION) ) {
                alt29=2;
            }
            else if ( (LA29_0==COLLECTION) && ((this.lc(ZORBA)))) {
                alt29=3;
            }
            else if ( (LA29_0==INDEX) && ((this.lc(ZORBA)))) {
                alt29=4;
            }
            else if ( (LA29_0==INTEGRITY) && ((this.lc(ZORBA)))) {
                alt29=5;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 29, 0, this.input);

                throw nvae;
            }
            switch (alt29) {
                case 1 :
                    // xquery/XQueryParser.g:467:11: p_VarDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_VarDecl_in_pg_AnnotatedDecl2651);
                    p_VarDecl54=this.p_VarDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_VarDecl54.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:468:11: pm_FunctionDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_FunctionDecl_in_pg_AnnotatedDecl2663);
                    pm_FunctionDecl55=this.pm_FunctionDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_FunctionDecl55.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:469:11: {...}? => p_CollectionDecl
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(ZORBA))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "pg_AnnotatedDecl", "this.lc(ZORBA)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_CollectionDecl_in_pg_AnnotatedDecl2678);
                    p_CollectionDecl56=this.p_CollectionDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CollectionDecl56.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:470:11: {...}? => p_IndexDecl
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(ZORBA))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "pg_AnnotatedDecl", "this.lc(ZORBA)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_IndexDecl_in_pg_AnnotatedDecl2693);
                    p_IndexDecl57=this.p_IndexDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_IndexDecl57.getTree());


                    break;
                case 5 :
                    // xquery/XQueryParser.g:471:11: {...}? => p_ICDecl
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(ZORBA))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "pg_AnnotatedDecl", "this.lc(ZORBA)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_ICDecl_in_pg_AnnotatedDecl2708);
                    p_ICDecl58=this.p_ICDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ICDecl58.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Annotation_return: (function() {
        XQueryParser.p_Annotation_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Annotation_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:475:1: p_Annotation : ANN_PERCENT p_QName ( LPAREN p_Literal ( COMMA p_Literal )* RPAREN )? ;
    // $ANTLR start "p_Annotation"
    p_Annotation: function() {
        var retval = new XQueryParser.p_Annotation_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var ANN_PERCENT59 = null;
        var LPAREN61 = null;
        var COMMA63 = null;
        var RPAREN65 = null;
         var p_QName60 = null;
         var p_Literal62 = null;
         var p_Literal64 = null;

        var ANN_PERCENT59_tree=null;
        var LPAREN61_tree=null;
        var COMMA63_tree=null;
        var RPAREN65_tree=null;

        try {
            // xquery/XQueryParser.g:476:9: ( ANN_PERCENT p_QName ( LPAREN p_Literal ( COMMA p_Literal )* RPAREN )? )
            // xquery/XQueryParser.g:476:11: ANN_PERCENT p_QName ( LPAREN p_Literal ( COMMA p_Literal )* RPAREN )?
            root_0 = this.adaptor.nil();

            ANN_PERCENT59=this.match(this.input,ANN_PERCENT,XQueryParser.FOLLOW_ANN_PERCENT_in_p_Annotation2734); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            ANN_PERCENT59_tree = this.adaptor.create(ANN_PERCENT59);
            this.adaptor.addChild(root_0, ANN_PERCENT59_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_Annotation2736);
            p_QName60=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName60.getTree());
            // xquery/XQueryParser.g:476:31: ( LPAREN p_Literal ( COMMA p_Literal )* RPAREN )?
            var alt31=2;
            var LA31_0 = this.input.LA(1);

            if ( (LA31_0==LPAREN) ) {
                alt31=1;
            }
            switch (alt31) {
                case 1 :
                    // xquery/XQueryParser.g:476:32: LPAREN p_Literal ( COMMA p_Literal )* RPAREN
                    LPAREN61=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_Annotation2739); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    LPAREN61_tree = this.adaptor.create(LPAREN61);
                    this.adaptor.addChild(root_0, LPAREN61_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_Literal_in_p_Annotation2741);
                    p_Literal62=this.p_Literal();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Literal62.getTree());
                    // xquery/XQueryParser.g:476:49: ( COMMA p_Literal )*
                    loop30:
                    do {
                        var alt30=2;
                        var LA30_0 = this.input.LA(1);

                        if ( (LA30_0==COMMA) ) {
                            alt30=1;
                        }


                        switch (alt30) {
                        case 1 :
                            // xquery/XQueryParser.g:476:50: COMMA p_Literal
                            COMMA63=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_Annotation2744); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            COMMA63_tree = this.adaptor.create(COMMA63);
                            this.adaptor.addChild(root_0, COMMA63_tree);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_Literal_in_p_Annotation2746);
                            p_Literal64=this.p_Literal();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Literal64.getTree());


                            break;

                        default :
                            break loop30;
                        }
                    } while (true);

                    RPAREN65=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_Annotation2750); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    RPAREN65_tree = this.adaptor.create(RPAREN65);
                    this.adaptor.addChild(root_0, RPAREN65_tree);
                    }


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_VarDecl_return: (function() {
        XQueryParser.p_VarDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_VarDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:480:1: p_VarDecl : k= VARIABLE d= DOLLAR qn= p_QName (td= p_TypeDeclaration )? ( ( BIND vv= p_VarValue ) | (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? ) ) -> ^( VarDecl $qn ^( VarType ( $td)? ) ^( VarValue ( $vv)? ^( VarDefaultValue ( $vdv)? ) ) ) ;
    // $ANTLR start "p_VarDecl"
    p_VarDecl: function() {
        var retval = new XQueryParser.p_VarDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
        var BIND66 = null;
        var BIND67 = null;
         var qn = null;
         var td = null;
         var vv = null;
         var vdv = null;

        var k_tree=null;
        var d_tree=null;
        var BIND66_tree=null;
        var BIND67_tree=null;
        var stream_DOLLAR=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token DOLLAR");
        var stream_EXTERNAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EXTERNAL");
        var stream_VARIABLE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token VARIABLE");
        var stream_BIND=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token BIND");
        var stream_p_TypeDeclaration=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_TypeDeclaration");
        var stream_p_QName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_QName");
        var stream_p_VarDefaultValue=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_VarDefaultValue");
        var stream_p_VarValue=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_VarValue");
        try {
            // xquery/XQueryParser.g:481:9: (k= VARIABLE d= DOLLAR qn= p_QName (td= p_TypeDeclaration )? ( ( BIND vv= p_VarValue ) | (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? ) ) -> ^( VarDecl $qn ^( VarType ( $td)? ) ^( VarValue ( $vv)? ^( VarDefaultValue ( $vdv)? ) ) ) )
            // xquery/XQueryParser.g:481:11: k= VARIABLE d= DOLLAR qn= p_QName (td= p_TypeDeclaration )? ( ( BIND vv= p_VarValue ) | (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? ) )
            k=this.match(this.input,VARIABLE,XQueryParser.FOLLOW_VARIABLE_in_p_VarDecl2780); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_VARIABLE.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_VarDecl2786); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_DOLLAR.add(d);

            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_VarDecl2790);
            qn=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_QName.add(qn.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (qn?qn.stop:null)); 
            }
            // xquery/XQueryParser.g:481:86: (td= p_TypeDeclaration )?
            var alt32=2;
            var LA32_0 = this.input.LA(1);

            if ( (LA32_0==AS) ) {
                alt32=1;
            }
            switch (alt32) {
                case 1 :
                    // xquery/XQueryParser.g:481:86: td= p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_VarDecl2796);
                    td=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_TypeDeclaration.add(td.getTree());


                    break;

            }

            // xquery/XQueryParser.g:481:106: ( ( BIND vv= p_VarValue ) | (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? ) )
            var alt34=2;
            var LA34_0 = this.input.LA(1);

            if ( (LA34_0==BIND) ) {
                alt34=1;
            }
            else if ( (LA34_0==EXTERNAL) ) {
                alt34=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 34, 0, this.input);

                throw nvae;
            }
            switch (alt34) {
                case 1 :
                    // xquery/XQueryParser.g:481:107: ( BIND vv= p_VarValue )
                    // xquery/XQueryParser.g:481:107: ( BIND vv= p_VarValue )
                    // xquery/XQueryParser.g:481:108: BIND vv= p_VarValue
                    BIND66=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_p_VarDecl2801); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_BIND.add(BIND66);

                    this.pushFollow(XQueryParser.FOLLOW_p_VarValue_in_p_VarDecl2805);
                    vv=this.p_VarValue();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_VarValue.add(vv.getTree());





                    break;
                case 2 :
                    // xquery/XQueryParser.g:481:130: (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? )
                    // xquery/XQueryParser.g:481:130: (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? )
                    // xquery/XQueryParser.g:481:131: k= EXTERNAL ( BIND vdv= p_VarDefaultValue )?
                    k=this.match(this.input,EXTERNAL,XQueryParser.FOLLOW_EXTERNAL_in_p_VarDecl2813); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_EXTERNAL.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    // xquery/XQueryParser.g:481:157: ( BIND vdv= p_VarDefaultValue )?
                    var alt33=2;
                    var LA33_0 = this.input.LA(1);

                    if ( (LA33_0==BIND) ) {
                        alt33=1;
                    }
                    switch (alt33) {
                        case 1 :
                            // xquery/XQueryParser.g:481:158: BIND vdv= p_VarDefaultValue
                            BIND67=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_p_VarDecl2818); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_BIND.add(BIND67);

                            this.pushFollow(XQueryParser.FOLLOW_p_VarDefaultValue_in_p_VarDecl2822);
                            vdv=this.p_VarDefaultValue();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_VarDefaultValue.add(vdv.getTree());


                            break;

                    }






                    break;

            }



            // AST REWRITE
            // elements: vv, vdv, qn, td
            // token labels: 
            // rule labels: qn, vv, retval, vdv, td
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_qn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token qn",qn!=null?qn.tree:null);
            var stream_vv=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token vv",vv!=null?vv.tree:null);
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_vdv=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token vdv",vdv!=null?vdv.tree:null);
            var stream_td=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token td",td!=null?td.tree:null);

            root_0 = this.adaptor.nil();
            // 482:17: -> ^( VarDecl $qn ^( VarType ( $td)? ) ^( VarValue ( $vv)? ^( VarDefaultValue ( $vdv)? ) ) )
            {
                // xquery/XQueryParser.g:482:20: ^( VarDecl $qn ^( VarType ( $td)? ) ^( VarValue ( $vv)? ^( VarDefaultValue ( $vdv)? ) ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(VarDecl, "VarDecl"), root_1);

                this.adaptor.addChild(root_1, stream_qn.nextTree());
                // xquery/XQueryParser.g:482:34: ^( VarType ( $td)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(VarType, "VarType"), root_2);

                // xquery/XQueryParser.g:482:44: ( $td)?
                if ( stream_td.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_td.nextTree());

                }
                stream_td.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // xquery/XQueryParser.g:482:50: ^( VarValue ( $vv)? ^( VarDefaultValue ( $vdv)? ) )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(VarValue, "VarValue"), root_2);

                // xquery/XQueryParser.g:482:61: ( $vv)?
                if ( stream_vv.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_vv.nextTree());

                }
                stream_vv.reset();
                // xquery/XQueryParser.g:482:66: ^( VarDefaultValue ( $vdv)? )
                {
                var root_3 = this.adaptor.nil();
                root_3 = this.adaptor.becomeRoot(this.adaptor.create(VarDefaultValue, "VarDefaultValue"), root_3);

                // xquery/XQueryParser.g:482:84: ( $vdv)?
                if ( stream_vdv.hasNext() ) {
                    this.adaptor.addChild(root_3, stream_vdv.nextTree());

                }
                stream_vdv.reset();

                this.adaptor.addChild(root_2, root_3);
                }

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_VarValue_return: (function() {
        XQueryParser.p_VarValue_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_VarValue_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:486:1: p_VarValue : p_ExprSingle[true] ;
    // $ANTLR start "p_VarValue"
    p_VarValue: function() {
        var retval = new XQueryParser.p_VarValue_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ExprSingle68 = null;


        try {
            // xquery/XQueryParser.g:487:9: ( p_ExprSingle[true] )
            // xquery/XQueryParser.g:487:11: p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_VarValue2901);
            p_ExprSingle68=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle68.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_VarDefaultValue_return: (function() {
        XQueryParser.p_VarDefaultValue_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_VarDefaultValue_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:491:1: p_VarDefaultValue : p_ExprSingle[true] ;
    // $ANTLR start "p_VarDefaultValue"
    p_VarDefaultValue: function() {
        var retval = new XQueryParser.p_VarDefaultValue_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ExprSingle69 = null;


        try {
            // xquery/XQueryParser.g:492:9: ( p_ExprSingle[true] )
            // xquery/XQueryParser.g:492:11: p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_VarDefaultValue2928);
            p_ExprSingle69=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle69.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_ContextItemDecl_return: (function() {
        XQueryParser.pm_ContextItemDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_ContextItemDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:496:1: pm_ContextItemDecl : k= DECLARE k= CONTEXT k= ITEM (k= AS p_ItemType )? ( ( BIND p_VarValue ) | (k= EXTERNAL ( BIND p_VarDefaultValue )? ) ) SEMICOLON ;
    // $ANTLR start "pm_ContextItemDecl"
    pm_ContextItemDecl: function() {
        var retval = new XQueryParser.pm_ContextItemDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var BIND71 = null;
        var BIND73 = null;
        var SEMICOLON75 = null;
         var p_ItemType70 = null;
         var p_VarValue72 = null;
         var p_VarDefaultValue74 = null;

        var k_tree=null;
        var BIND71_tree=null;
        var BIND73_tree=null;
        var SEMICOLON75_tree=null;

        try {
            // xquery/XQueryParser.g:497:9: (k= DECLARE k= CONTEXT k= ITEM (k= AS p_ItemType )? ( ( BIND p_VarValue ) | (k= EXTERNAL ( BIND p_VarDefaultValue )? ) ) SEMICOLON )
            // xquery/XQueryParser.g:497:11: k= DECLARE k= CONTEXT k= ITEM (k= AS p_ItemType )? ( ( BIND p_VarValue ) | (k= EXTERNAL ( BIND p_VarDefaultValue )? ) ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_ContextItemDecl2957); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,CONTEXT,XQueryParser.FOLLOW_CONTEXT_in_pm_ContextItemDecl2963); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,ITEM,XQueryParser.FOLLOW_ITEM_in_pm_ContextItemDecl2969); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:497:83: (k= AS p_ItemType )?
            var alt35=2;
            var LA35_0 = this.input.LA(1);

            if ( (LA35_0==AS) ) {
                alt35=1;
            }
            switch (alt35) {
                case 1 :
                    // xquery/XQueryParser.g:497:84: k= AS p_ItemType
                    k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_pm_ContextItemDecl2976); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_ItemType_in_pm_ContextItemDecl2980);
                    p_ItemType70=this.p_ItemType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ItemType70.getTree());


                    break;

            }

            // xquery/XQueryParser.g:497:117: ( ( BIND p_VarValue ) | (k= EXTERNAL ( BIND p_VarDefaultValue )? ) )
            var alt37=2;
            var LA37_0 = this.input.LA(1);

            if ( (LA37_0==BIND) ) {
                alt37=1;
            }
            else if ( (LA37_0==EXTERNAL) ) {
                alt37=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 37, 0, this.input);

                throw nvae;
            }
            switch (alt37) {
                case 1 :
                    // xquery/XQueryParser.g:497:118: ( BIND p_VarValue )
                    // xquery/XQueryParser.g:497:118: ( BIND p_VarValue )
                    // xquery/XQueryParser.g:497:119: BIND p_VarValue
                    BIND71=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_pm_ContextItemDecl2986); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    BIND71_tree = this.adaptor.create(BIND71);
                    this.adaptor.addChild(root_0, BIND71_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_VarValue_in_pm_ContextItemDecl2988);
                    p_VarValue72=this.p_VarValue();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_VarValue72.getTree());





                    break;
                case 2 :
                    // xquery/XQueryParser.g:497:138: (k= EXTERNAL ( BIND p_VarDefaultValue )? )
                    // xquery/XQueryParser.g:497:138: (k= EXTERNAL ( BIND p_VarDefaultValue )? )
                    // xquery/XQueryParser.g:497:139: k= EXTERNAL ( BIND p_VarDefaultValue )?
                    k=this.match(this.input,EXTERNAL,XQueryParser.FOLLOW_EXTERNAL_in_pm_ContextItemDecl2996); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    // xquery/XQueryParser.g:497:165: ( BIND p_VarDefaultValue )?
                    var alt36=2;
                    var LA36_0 = this.input.LA(1);

                    if ( (LA36_0==BIND) ) {
                        alt36=1;
                    }
                    switch (alt36) {
                        case 1 :
                            // xquery/XQueryParser.g:497:166: BIND p_VarDefaultValue
                            BIND73=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_pm_ContextItemDecl3001); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            BIND73_tree = this.adaptor.create(BIND73);
                            this.adaptor.addChild(root_0, BIND73_tree);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_VarDefaultValue_in_pm_ContextItemDecl3003);
                            p_VarDefaultValue74=this.p_VarDefaultValue();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_VarDefaultValue74.getTree());


                            break;

                    }






                    break;

            }

            SEMICOLON75=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_ContextItemDecl3009); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON75_tree = this.adaptor.create(SEMICOLON75);
            this.adaptor.addChild(root_0, SEMICOLON75_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_FunctionDecl_return: (function() {
        XQueryParser.pm_FunctionDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_FunctionDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:502:1: pm_FunctionDecl : ({...}? =>k= UPDATING )? k= FUNCTION qn= pg_FQName LPAREN (pl= p_ParamList )? RPAREN (k= AS st= p_SequenceType )? ( LBRACKET soe= p_StatementsAndOptionalExpr RBRACKET | k= EXTERNAL ) -> ^( FunctionDecl $qn ^( ParamList ( $pl)? ) ^( ReturnType ( $st)? ) ( $soe)? ) ;
    // $ANTLR start "pm_FunctionDecl"
    pm_FunctionDecl: function() {
        var retval = new XQueryParser.pm_FunctionDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LPAREN76 = null;
        var RPAREN77 = null;
        var LBRACKET78 = null;
        var RBRACKET79 = null;
         var qn = null;
         var pl = null;
         var st = null;
         var soe = null;

        var k_tree=null;
        var LPAREN76_tree=null;
        var RPAREN77_tree=null;
        var LBRACKET78_tree=null;
        var RBRACKET79_tree=null;
        var stream_FUNCTION=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token FUNCTION");
        var stream_LBRACKET=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token LBRACKET");
        var stream_AS=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token AS");
        var stream_RPAREN=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token RPAREN");
        var stream_EXTERNAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EXTERNAL");
        var stream_RBRACKET=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token RBRACKET");
        var stream_LPAREN=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token LPAREN");
        var stream_UPDATING=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token UPDATING");
        var stream_p_StatementsAndOptionalExpr=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StatementsAndOptionalExpr");
        var stream_p_ParamList=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_ParamList");
        var stream_pg_FQName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pg_FQName");
        var stream_p_SequenceType=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_SequenceType");
        try {
            // xquery/XQueryParser.g:503:9: ( ({...}? =>k= UPDATING )? k= FUNCTION qn= pg_FQName LPAREN (pl= p_ParamList )? RPAREN (k= AS st= p_SequenceType )? ( LBRACKET soe= p_StatementsAndOptionalExpr RBRACKET | k= EXTERNAL ) -> ^( FunctionDecl $qn ^( ParamList ( $pl)? ) ^( ReturnType ( $st)? ) ( $soe)? ) )
            // xquery/XQueryParser.g:503:11: ({...}? =>k= UPDATING )? k= FUNCTION qn= pg_FQName LPAREN (pl= p_ParamList )? RPAREN (k= AS st= p_SequenceType )? ( LBRACKET soe= p_StatementsAndOptionalExpr RBRACKET | k= EXTERNAL )
            // xquery/XQueryParser.g:503:11: ({...}? =>k= UPDATING )?
            var alt38=2;
            var LA38_0 = this.input.LA(1);

            if ( (LA38_0==UPDATING) && ((this.lc(XQU)))) {
                alt38=1;
            }
            switch (alt38) {
                case 1 :
                    // xquery/XQueryParser.g:503:12: {...}? =>k= UPDATING
                    if ( !((this.lc(XQU))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "pm_FunctionDecl", "this.lc(XQU)");
                    }
                    k=this.match(this.input,UPDATING,XQueryParser.FOLLOW_UPDATING_in_pm_FunctionDecl3042); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_UPDATING.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }


                    break;

            }

            k=this.match(this.input,FUNCTION,XQueryParser.FOLLOW_FUNCTION_in_pm_FunctionDecl3050); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_FUNCTION.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_pg_FQName_in_pm_FunctionDecl3056);
            qn=this.pg_FQName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_pg_FQName.add(qn.getTree());
            LPAREN76=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_pm_FunctionDecl3058); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_LPAREN.add(LPAREN76);

            // xquery/XQueryParser.g:503:106: (pl= p_ParamList )?
            var alt39=2;
            var LA39_0 = this.input.LA(1);

            if ( (LA39_0==DOLLAR) ) {
                alt39=1;
            }
            switch (alt39) {
                case 1 :
                    // xquery/XQueryParser.g:503:106: pl= p_ParamList
                    this.pushFollow(XQueryParser.FOLLOW_p_ParamList_in_pm_FunctionDecl3062);
                    pl=this.p_ParamList();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_ParamList.add(pl.getTree());


                    break;

            }

            RPAREN77=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_pm_FunctionDecl3065); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_RPAREN.add(RPAREN77);

            // xquery/XQueryParser.g:503:127: (k= AS st= p_SequenceType )?
            var alt40=2;
            var LA40_0 = this.input.LA(1);

            if ( (LA40_0==AS) ) {
                alt40=1;
            }
            switch (alt40) {
                case 1 :
                    // xquery/XQueryParser.g:503:128: k= AS st= p_SequenceType
                    k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_pm_FunctionDecl3070); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_AS.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_SequenceType_in_pm_FunctionDecl3076);
                    st=this.p_SequenceType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_SequenceType.add(st.getTree());


                    break;

            }

            // xquery/XQueryParser.g:503:168: ( LBRACKET soe= p_StatementsAndOptionalExpr RBRACKET | k= EXTERNAL )
            var alt41=2;
            var LA41_0 = this.input.LA(1);

            if ( (LA41_0==LBRACKET) ) {
                alt41=1;
            }
            else if ( (LA41_0==EXTERNAL) ) {
                alt41=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 41, 0, this.input);

                throw nvae;
            }
            switch (alt41) {
                case 1 :
                    // xquery/XQueryParser.g:503:169: LBRACKET soe= p_StatementsAndOptionalExpr RBRACKET
                    LBRACKET78=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pm_FunctionDecl3081); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_LBRACKET.add(LBRACKET78);

                    this.pushFollow(XQueryParser.FOLLOW_p_StatementsAndOptionalExpr_in_pm_FunctionDecl3085);
                    soe=this.p_StatementsAndOptionalExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_StatementsAndOptionalExpr.add(soe.getTree());
                    RBRACKET79=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pm_FunctionDecl3087); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_RBRACKET.add(RBRACKET79);



                    break;
                case 2 :
                    // xquery/XQueryParser.g:503:221: k= EXTERNAL
                    k=this.match(this.input,EXTERNAL,XQueryParser.FOLLOW_EXTERNAL_in_pm_FunctionDecl3093); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_EXTERNAL.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }


                    break;

            }



            // AST REWRITE
            // elements: st, pl, qn, soe
            // token labels: 
            // rule labels: soe, qn, retval, pl, st
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_soe=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token soe",soe!=null?soe.tree:null);
            var stream_qn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token qn",qn!=null?qn.tree:null);
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_pl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token pl",pl!=null?pl.tree:null);
            var stream_st=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token st",st!=null?st.tree:null);

            root_0 = this.adaptor.nil();
            // 504:17: -> ^( FunctionDecl $qn ^( ParamList ( $pl)? ) ^( ReturnType ( $st)? ) ( $soe)? )
            {
                // xquery/XQueryParser.g:504:20: ^( FunctionDecl $qn ^( ParamList ( $pl)? ) ^( ReturnType ( $st)? ) ( $soe)? )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(FunctionDecl, "FunctionDecl"), root_1);

                this.adaptor.addChild(root_1, stream_qn.nextTree());
                // xquery/XQueryParser.g:504:39: ^( ParamList ( $pl)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(ParamList, "ParamList"), root_2);

                // xquery/XQueryParser.g:504:51: ( $pl)?
                if ( stream_pl.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_pl.nextTree());

                }
                stream_pl.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // xquery/XQueryParser.g:504:57: ^( ReturnType ( $st)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(ReturnType, "ReturnType"), root_2);

                // xquery/XQueryParser.g:504:70: ( $st)?
                if ( stream_st.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_st.nextTree());

                }
                stream_st.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // xquery/XQueryParser.g:504:76: ( $soe)?
                if ( stream_soe.hasNext() ) {
                    this.adaptor.addChild(root_1, stream_soe.nextTree());

                }
                stream_soe.reset();

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ParamList_return: (function() {
        XQueryParser.p_ParamList_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ParamList_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:508:1: p_ParamList : p+= p_Param ( COMMA p+= p_Param )* -> ( $p)+ ;
    // $ANTLR start "p_ParamList"
    p_ParamList: function() {
        var retval = new XQueryParser.p_ParamList_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var COMMA80 = null;
        var list_p=null;
        var p = null;
        var COMMA80_tree=null;
        var stream_COMMA=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token COMMA");
        var stream_p_Param=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_Param");
        try {
            // xquery/XQueryParser.g:509:9: (p+= p_Param ( COMMA p+= p_Param )* -> ( $p)+ )
            // xquery/XQueryParser.g:509:11: p+= p_Param ( COMMA p+= p_Param )*
            this.pushFollow(XQueryParser.FOLLOW_p_Param_in_p_ParamList3170);
            p=this.p_Param();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_Param.add(p.getTree());
            if (org.antlr.lang.isNull(list_p)) list_p = [];
            list_p.push(p.getTree());

            // xquery/XQueryParser.g:509:22: ( COMMA p+= p_Param )*
            loop42:
            do {
                var alt42=2;
                var LA42_0 = this.input.LA(1);

                if ( (LA42_0==COMMA) ) {
                    alt42=1;
                }


                switch (alt42) {
                case 1 :
                    // xquery/XQueryParser.g:509:23: COMMA p+= p_Param
                    COMMA80=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_ParamList3173); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_COMMA.add(COMMA80);

                    this.pushFollow(XQueryParser.FOLLOW_p_Param_in_p_ParamList3177);
                    p=this.p_Param();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_Param.add(p.getTree());
                    if (org.antlr.lang.isNull(list_p)) list_p = [];
                    list_p.push(p.getTree());



                    break;

                default :
                    break loop42;
                }
            } while (true);



            // AST REWRITE
            // elements: p
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: p
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_p=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token p",list_p);
            root_0 = this.adaptor.nil();
            // 510:17: -> ( $p)+
            {
                if ( !(stream_p.hasNext()) ) {
                    throw new org.antlr.runtime.tree.RewriteEarlyExitException();
                }
                while ( stream_p.hasNext() ) {
                    this.adaptor.addChild(root_0, stream_p.nextTree());

                }
                stream_p.reset();

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Param_return: (function() {
        XQueryParser.p_Param_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Param_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:514:1: p_Param : d= DOLLAR qn= p_QName (td= p_TypeDeclaration )? -> ^( Param $qn ( $td)? ) ;
    // $ANTLR start "p_Param"
    p_Param: function() {
        var retval = new XQueryParser.p_Param_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var d = null;
         var qn = null;
         var td = null;

        var d_tree=null;
        var stream_DOLLAR=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token DOLLAR");
        var stream_p_TypeDeclaration=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_TypeDeclaration");
        var stream_p_QName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_QName");
        try {
            // xquery/XQueryParser.g:515:9: (d= DOLLAR qn= p_QName (td= p_TypeDeclaration )? -> ^( Param $qn ( $td)? ) )
            // xquery/XQueryParser.g:515:11: d= DOLLAR qn= p_QName (td= p_TypeDeclaration )?
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_Param3237); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_DOLLAR.add(d);

            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_Param3241);
            qn=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_QName.add(qn.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (qn?qn.stop:null)); 
            }
            // xquery/XQueryParser.g:515:60: (td= p_TypeDeclaration )?
            var alt43=2;
            var LA43_0 = this.input.LA(1);

            if ( (LA43_0==AS) ) {
                alt43=1;
            }
            switch (alt43) {
                case 1 :
                    // xquery/XQueryParser.g:515:60: td= p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_Param3247);
                    td=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_TypeDeclaration.add(td.getTree());


                    break;

            }



            // AST REWRITE
            // elements: qn, td
            // token labels: 
            // rule labels: qn, retval, td
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_qn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token qn",qn!=null?qn.tree:null);
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_td=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token td",td!=null?td.tree:null);

            root_0 = this.adaptor.nil();
            // 516:17: -> ^( Param $qn ( $td)? )
            {
                // xquery/XQueryParser.g:516:20: ^( Param $qn ( $td)? )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(Param, "Param"), root_1);

                this.adaptor.addChild(root_1, stream_qn.nextTree());
                // xquery/XQueryParser.g:516:32: ( $td)?
                if ( stream_td.hasNext() ) {
                    this.adaptor.addChild(root_1, stream_td.nextTree());

                }
                stream_td.reset();

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_FunctionBody_return: (function() {
        XQueryParser.pm_FunctionBody_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_FunctionBody_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:520:1: pm_FunctionBody : p_EnclosedExpr ;
    // $ANTLR start "pm_FunctionBody"
    pm_FunctionBody: function() {
        var retval = new XQueryParser.pm_FunctionBody_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_EnclosedExpr81 = null;


        try {
            // xquery/XQueryParser.g:521:9: ( p_EnclosedExpr )
            // xquery/XQueryParser.g:521:11: p_EnclosedExpr
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_EnclosedExpr_in_pm_FunctionBody3303);
            p_EnclosedExpr81=this.p_EnclosedExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_EnclosedExpr81.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_EnclosedExpr_return: (function() {
        XQueryParser.p_EnclosedExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_EnclosedExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:526:1: p_EnclosedExpr : LBRACKET p_Expr[true,true] RBRACKET -> ^( EnclosedExpr p_Expr ) ;
    // $ANTLR start "p_EnclosedExpr"
    p_EnclosedExpr: function() {
        var retval = new XQueryParser.p_EnclosedExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var LBRACKET82 = null;
        var RBRACKET84 = null;
         var p_Expr83 = null;

        var LBRACKET82_tree=null;
        var RBRACKET84_tree=null;
        var stream_LBRACKET=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token LBRACKET");
        var stream_RBRACKET=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token RBRACKET");
        var stream_p_Expr=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_Expr");
        try {
            // xquery/XQueryParser.g:527:9: ( LBRACKET p_Expr[true,true] RBRACKET -> ^( EnclosedExpr p_Expr ) )
            // xquery/XQueryParser.g:527:11: LBRACKET p_Expr[true,true] RBRACKET
            LBRACKET82=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_EnclosedExpr3330); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_LBRACKET.add(LBRACKET82);

            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_EnclosedExpr3332);
            p_Expr83=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_Expr.add(p_Expr83.getTree());
            RBRACKET84=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_EnclosedExpr3335); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_RBRACKET.add(RBRACKET84);



            // AST REWRITE
            // elements: p_Expr
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 528:17: -> ^( EnclosedExpr p_Expr )
            {
                // xquery/XQueryParser.g:528:20: ^( EnclosedExpr p_Expr )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(EnclosedExpr, "EnclosedExpr"), root_1);

                this.adaptor.addChild(root_1, stream_p_Expr.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_OptionDecl_return: (function() {
        XQueryParser.pm_OptionDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_OptionDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:532:1: pm_OptionDecl : k= DECLARE k= OPTION p_QName p_StringLiteral SEMICOLON ;
    // $ANTLR start "pm_OptionDecl"
    pm_OptionDecl: function() {
        var retval = new XQueryParser.pm_OptionDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON87 = null;
         var p_QName85 = null;
         var p_StringLiteral86 = null;

        var k_tree=null;
        var SEMICOLON87_tree=null;

        try {
            // xquery/XQueryParser.g:533:9: (k= DECLARE k= OPTION p_QName p_StringLiteral SEMICOLON )
            // xquery/XQueryParser.g:533:11: k= DECLARE k= OPTION p_QName p_StringLiteral SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_OptionDecl3387); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,OPTION,XQueryParser.FOLLOW_OPTION_in_pm_OptionDecl3393); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_pm_OptionDecl3397);
            p_QName85=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName85.getTree());
            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_OptionDecl3399);
            p_StringLiteral86=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral86.getTree());
            SEMICOLON87=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_OptionDecl3401); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON87_tree = this.adaptor.create(SEMICOLON87);
            this.adaptor.addChild(root_0, SEMICOLON87_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_QueryBody_return: (function() {
        XQueryParser.pm_QueryBody_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_QueryBody_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:537:1: pm_QueryBody : ({...}? => p_Program | p_Expr[true,true] );
    // $ANTLR start "pm_QueryBody"
    pm_QueryBody: function() {
        var retval = new XQueryParser.pm_QueryBody_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_Program88 = null;
         var p_Expr89 = null;


        try {
            // xquery/XQueryParser.g:538:9: ({...}? => p_Program | p_Expr[true,true] )
            var alt44=2;
            alt44 = this.dfa44.predict(this.input);
            switch (alt44) {
                case 1 :
                    // xquery/XQueryParser.g:538:11: {...}? => p_Program
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(XQS))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "pm_QueryBody", "this.lc(XQS)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_Program_in_pm_QueryBody3430);
                    p_Program88=this.p_Program();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Program88.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:539:11: p_Expr[true,true]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_pm_QueryBody3442);
                    p_Expr89=this.p_Expr(true, true);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr89.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Expr_return: (function() {
        XQueryParser.p_Expr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Expr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:549:1: p_Expr[strict, allowConcat] : es= p_ExprSingle[$strict] ( COMMA p_ExprSingle[$strict] )* ;
    // $ANTLR start "p_Expr"
    p_Expr: function(strict, allowConcat) {
        var retval = new XQueryParser.p_Expr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var COMMA90 = null;
         var es = null;
         var p_ExprSingle91 = null;

        var COMMA90_tree=null;

        try {
            // xquery/XQueryParser.g:550:9: (es= p_ExprSingle[$strict] ( COMMA p_ExprSingle[$strict] )* )
            // xquery/XQueryParser.g:550:11: es= p_ExprSingle[$strict] ( COMMA p_ExprSingle[$strict] )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_Expr3478);
            es=this.p_ExprSingle(strict);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, es.getTree());
            if ( this.state.backtracking===0 ) {
               if (!allowConcat) throw new Exception(); 
            }
            // xquery/XQueryParser.g:551:11: ( COMMA p_ExprSingle[$strict] )*
            loop45:
            do {
                var alt45=2;
                var LA45_0 = this.input.LA(1);

                if ( (LA45_0==COMMA) ) {
                    alt45=1;
                }


                switch (alt45) {
                case 1 :
                    // xquery/XQueryParser.g:551:12: COMMA p_ExprSingle[$strict]
                    COMMA90=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_Expr3494); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA90_tree = this.adaptor.create(COMMA90);
                    this.adaptor.addChild(root_0, COMMA90_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_Expr3496);
                    p_ExprSingle91=this.p_ExprSingle(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle91.getTree());


                    break;

                default :
                    break loop45;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (e) {

              if(e instanceof org.antlr.runtime.RecognitionException) {
                //console.log("catch1");
                reportError(e);
                recover(this.input, e);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), e);
              } else if(e instanceof Exception) {
                //console.log("catch2");
                root_0 = this.adaptor.nil();
                this.adaptor.addChild(root_0, es.getTree());
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
              } else {
                throw e;
              }

        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ExprSingle_return: (function() {
        XQueryParser.p_ExprSingle_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ExprSingle_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:573:1: p_ExprSingle[strict] : ( ( ( ( FOR | LET ) DOLLAR ) | ( FOR ( TUMBLING | SLIDING ) ) )=> p_FLWORHybrid[$strict] | ( IF LPAREN )=> p_IfHybrid[$strict] | ( SWITCH LPAREN )=> p_SwitchHybrid[$strict] | ( TYPESWITCH LPAREN )=> p_TypeswitchHybrid[$strict] | ( TRY LBRACKET )=> p_TryCatchHybrid[$strict] | p_ExprSimple );
    // $ANTLR start "p_ExprSingle"
    p_ExprSingle: function(strict) {
        var retval = new XQueryParser.p_ExprSingle_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_FLWORHybrid92 = null;
         var p_IfHybrid93 = null;
         var p_SwitchHybrid94 = null;
         var p_TypeswitchHybrid95 = null;
         var p_TryCatchHybrid96 = null;
         var p_ExprSimple97 = null;


        try {
            // xquery/XQueryParser.g:574:9: ( ( ( ( FOR | LET ) DOLLAR ) | ( FOR ( TUMBLING | SLIDING ) ) )=> p_FLWORHybrid[$strict] | ( IF LPAREN )=> p_IfHybrid[$strict] | ( SWITCH LPAREN )=> p_SwitchHybrid[$strict] | ( TYPESWITCH LPAREN )=> p_TypeswitchHybrid[$strict] | ( TRY LBRACKET )=> p_TryCatchHybrid[$strict] | p_ExprSimple )
            var alt46=6;
            alt46 = this.dfa46.predict(this.input);
            switch (alt46) {
                case 1 :
                    // xquery/XQueryParser.g:574:11: ( ( ( FOR | LET ) DOLLAR ) | ( FOR ( TUMBLING | SLIDING ) ) )=> p_FLWORHybrid[$strict]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_FLWORHybrid_in_p_ExprSingle3563);
                    p_FLWORHybrid92=this.p_FLWORHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_FLWORHybrid92.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:575:11: ( IF LPAREN )=> p_IfHybrid[$strict]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_IfHybrid_in_p_ExprSingle3593);
                    p_IfHybrid93=this.p_IfHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_IfHybrid93.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:576:11: ( SWITCH LPAREN )=> p_SwitchHybrid[$strict]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_SwitchHybrid_in_p_ExprSingle3619);
                    p_SwitchHybrid94=this.p_SwitchHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SwitchHybrid94.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:577:11: ( TYPESWITCH LPAREN )=> p_TypeswitchHybrid[$strict]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_TypeswitchHybrid_in_p_ExprSingle3641);
                    p_TypeswitchHybrid95=this.p_TypeswitchHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeswitchHybrid95.getTree());


                    break;
                case 5 :
                    // xquery/XQueryParser.g:578:11: ( TRY LBRACKET )=> p_TryCatchHybrid[$strict]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_TryCatchHybrid_in_p_ExprSingle3668);
                    p_TryCatchHybrid96=this.p_TryCatchHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TryCatchHybrid96.getTree());


                    break;
                case 6 :
                    // xquery/XQueryParser.g:579:11: p_ExprSimple
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ExprSimple_in_p_ExprSingle3681);
                    p_ExprSimple97=this.p_ExprSimple();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSimple97.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_FLWORHybrid_return: (function() {
        XQueryParser.p_FLWORHybrid_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_FLWORHybrid_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:583:1: p_FLWORHybrid[strict] : p_InitialClause ( p_IntermediateClause )* p_ReturnHybrid[$strict] ;
    // $ANTLR start "p_FLWORHybrid"
    p_FLWORHybrid: function(strict) {
        var retval = new XQueryParser.p_FLWORHybrid_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_InitialClause98 = null;
         var p_IntermediateClause99 = null;
         var p_ReturnHybrid100 = null;


        try {
            // xquery/XQueryParser.g:584:9: ( p_InitialClause ( p_IntermediateClause )* p_ReturnHybrid[$strict] )
            // xquery/XQueryParser.g:584:11: p_InitialClause ( p_IntermediateClause )* p_ReturnHybrid[$strict]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_InitialClause_in_p_FLWORHybrid3708);
            p_InitialClause98=this.p_InitialClause();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_InitialClause98.getTree());
            // xquery/XQueryParser.g:584:27: ( p_IntermediateClause )*
            loop47:
            do {
                var alt47=2;
                var LA47_0 = this.input.LA(1);

                if ( (LA47_0==FOR||LA47_0==LET||LA47_0==ORDER||LA47_0==STABLE||LA47_0==WHERE||LA47_0==COUNT||LA47_0==GROUP) ) {
                    alt47=1;
                }


                switch (alt47) {
                case 1 :
                    // xquery/XQueryParser.g:584:27: p_IntermediateClause
                    this.pushFollow(XQueryParser.FOLLOW_p_IntermediateClause_in_p_FLWORHybrid3710);
                    p_IntermediateClause99=this.p_IntermediateClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_IntermediateClause99.getTree());


                    break;

                default :
                    break loop47;
                }
            } while (true);

            this.pushFollow(XQueryParser.FOLLOW_p_ReturnHybrid_in_p_FLWORHybrid3713);
            p_ReturnHybrid100=this.p_ReturnHybrid(strict);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ReturnHybrid100.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_InitialClause_return: (function() {
        XQueryParser.p_InitialClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_InitialClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:588:1: p_InitialClause : ( p_ForClause | p_LetClause | p_WindowClause );
    // $ANTLR start "p_InitialClause"
    p_InitialClause: function() {
        var retval = new XQueryParser.p_InitialClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ForClause101 = null;
         var p_LetClause102 = null;
         var p_WindowClause103 = null;


        try {
            // xquery/XQueryParser.g:589:9: ( p_ForClause | p_LetClause | p_WindowClause )
            var alt48=3;
            var LA48_0 = this.input.LA(1);

            if ( (LA48_0==FOR) ) {
                var LA48_1 = this.input.LA(2);

                if ( (LA48_1==DOLLAR) ) {
                    alt48=1;
                }
                else if ( (LA48_1==SLIDING||LA48_1==TUMBLING) ) {
                    alt48=3;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 48, 1, this.input);

                    throw nvae;
                }
            }
            else if ( (LA48_0==LET) ) {
                alt48=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 48, 0, this.input);

                throw nvae;
            }
            switch (alt48) {
                case 1 :
                    // xquery/XQueryParser.g:589:11: p_ForClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ForClause_in_p_InitialClause3740);
                    p_ForClause101=this.p_ForClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ForClause101.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:589:25: p_LetClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_LetClause_in_p_InitialClause3744);
                    p_LetClause102=this.p_LetClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_LetClause102.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:589:39: p_WindowClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_WindowClause_in_p_InitialClause3748);
                    p_WindowClause103=this.p_WindowClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowClause103.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_IntermediateClause_return: (function() {
        XQueryParser.p_IntermediateClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_IntermediateClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:593:1: p_IntermediateClause : ( p_InitialClause | p_WhereClause | p_GroupByClause | p_OrderByClause | p_CountClause );
    // $ANTLR start "p_IntermediateClause"
    p_IntermediateClause: function() {
        var retval = new XQueryParser.p_IntermediateClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_InitialClause104 = null;
         var p_WhereClause105 = null;
         var p_GroupByClause106 = null;
         var p_OrderByClause107 = null;
         var p_CountClause108 = null;


        try {
            // xquery/XQueryParser.g:594:9: ( p_InitialClause | p_WhereClause | p_GroupByClause | p_OrderByClause | p_CountClause )
            var alt49=5;
            switch ( this.input.LA(1) ) {
            case FOR:
            case LET:
                alt49=1;
                break;
            case WHERE:
                alt49=2;
                break;
            case GROUP:
                alt49=3;
                break;
            case ORDER:
            case STABLE:
                alt49=4;
                break;
            case COUNT:
                alt49=5;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 49, 0, this.input);

                throw nvae;
            }

            switch (alt49) {
                case 1 :
                    // xquery/XQueryParser.g:594:11: p_InitialClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_InitialClause_in_p_IntermediateClause3774);
                    p_InitialClause104=this.p_InitialClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_InitialClause104.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:594:29: p_WhereClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_WhereClause_in_p_IntermediateClause3778);
                    p_WhereClause105=this.p_WhereClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WhereClause105.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:594:45: p_GroupByClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_GroupByClause_in_p_IntermediateClause3782);
                    p_GroupByClause106=this.p_GroupByClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_GroupByClause106.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:594:63: p_OrderByClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_OrderByClause_in_p_IntermediateClause3786);
                    p_OrderByClause107=this.p_OrderByClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_OrderByClause107.getTree());


                    break;
                case 5 :
                    // xquery/XQueryParser.g:594:81: p_CountClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_CountClause_in_p_IntermediateClause3790);
                    p_CountClause108=this.p_CountClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CountClause108.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_StringConcatExpr_return: (function() {
        XQueryParser.p_StringConcatExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_StringConcatExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:598:1: p_StringConcatExpr : p_RangeExpr (o= CONCAT p_RangeExpr )* ;
    // $ANTLR start "p_StringConcatExpr"
    p_StringConcatExpr: function() {
        var retval = new XQueryParser.p_StringConcatExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var o = null;
         var p_RangeExpr109 = null;
         var p_RangeExpr110 = null;

        var o_tree=null;

        try {
            // xquery/XQueryParser.g:599:4: ( p_RangeExpr (o= CONCAT p_RangeExpr )* )
            // xquery/XQueryParser.g:599:6: p_RangeExpr (o= CONCAT p_RangeExpr )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_RangeExpr_in_p_StringConcatExpr3811);
            p_RangeExpr109=this.p_RangeExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_RangeExpr109.getTree());
            // xquery/XQueryParser.g:599:18: (o= CONCAT p_RangeExpr )*
            loop50:
            do {
                var alt50=2;
                var LA50_0 = this.input.LA(1);

                if ( (LA50_0==CONCAT) ) {
                    alt50=1;
                }


                switch (alt50) {
                case 1 :
                    // xquery/XQueryParser.g:599:20: o= CONCAT p_RangeExpr
                    o=this.match(this.input,CONCAT,XQueryParser.FOLLOW_CONCAT_in_p_StringConcatExpr3817); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    o_tree = this.adaptor.create(o);
                    this.adaptor.addChild(root_0, o_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                       this.ao(o); 
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_RangeExpr_in_p_StringConcatExpr3821);
                    p_RangeExpr110=this.p_RangeExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_RangeExpr110.getTree());


                    break;

                default :
                    break loop50;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ForClause_return: (function() {
        XQueryParser.p_ForClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ForClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:604:1: p_ForClause : k= FOR p_ForBinding ( COMMA p_ForBinding )* ;
    // $ANTLR start "p_ForClause"
    p_ForClause: function() {
        var retval = new XQueryParser.p_ForClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var COMMA112 = null;
         var p_ForBinding111 = null;
         var p_ForBinding113 = null;

        var k_tree=null;
        var COMMA112_tree=null;

        try {
            // xquery/XQueryParser.g:605:9: (k= FOR p_ForBinding ( COMMA p_ForBinding )* )
            // xquery/XQueryParser.g:605:11: k= FOR p_ForBinding ( COMMA p_ForBinding )*
            root_0 = this.adaptor.nil();

            k=this.match(this.input,FOR,XQueryParser.FOLLOW_FOR_in_p_ForClause3848); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ForBinding_in_p_ForClause3852);
            p_ForBinding111=this.p_ForBinding();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ForBinding111.getTree());
            // xquery/XQueryParser.g:605:45: ( COMMA p_ForBinding )*
            loop51:
            do {
                var alt51=2;
                var LA51_0 = this.input.LA(1);

                if ( (LA51_0==COMMA) ) {
                    alt51=1;
                }


                switch (alt51) {
                case 1 :
                    // xquery/XQueryParser.g:605:46: COMMA p_ForBinding
                    COMMA112=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_ForClause3855); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA112_tree = this.adaptor.create(COMMA112);
                    this.adaptor.addChild(root_0, COMMA112_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_ForBinding_in_p_ForClause3857);
                    p_ForBinding113=this.p_ForBinding();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ForBinding113.getTree());


                    break;

                default :
                    break loop51;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ForBinding_return: (function() {
        XQueryParser.p_ForBinding_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ForBinding_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:609:1: p_ForBinding : s= DOLLAR v= p_VarName ( p_TypeDeclaration )? ( p_AllowingEmpty )? ( p_PositionalVar )? ( p_FTScoreVar )? k= IN p_ExprSingle[true] ;
    // $ANTLR start "p_ForBinding"
    p_ForBinding: function() {
        var retval = new XQueryParser.p_ForBinding_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var s = null;
        var k = null;
         var v = null;
         var p_TypeDeclaration114 = null;
         var p_AllowingEmpty115 = null;
         var p_PositionalVar116 = null;
         var p_FTScoreVar117 = null;
         var p_ExprSingle118 = null;

        var s_tree=null;
        var k_tree=null;

        try {
            // xquery/XQueryParser.g:610:9: (s= DOLLAR v= p_VarName ( p_TypeDeclaration )? ( p_AllowingEmpty )? ( p_PositionalVar )? ( p_FTScoreVar )? k= IN p_ExprSingle[true] )
            // xquery/XQueryParser.g:610:11: s= DOLLAR v= p_VarName ( p_TypeDeclaration )? ( p_AllowingEmpty )? ( p_PositionalVar )? ( p_FTScoreVar )? k= IN p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            s=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_ForBinding3887); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            s_tree = this.adaptor.create(s);
            this.adaptor.addChild(root_0, s_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_ForBinding3891);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(s, (v?v.stop:null)); 
            }
            // xquery/XQueryParser.g:610:58: ( p_TypeDeclaration )?
            var alt52=2;
            var LA52_0 = this.input.LA(1);

            if ( (LA52_0==AS) ) {
                alt52=1;
            }
            switch (alt52) {
                case 1 :
                    // xquery/XQueryParser.g:610:58: p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_ForBinding3895);
                    p_TypeDeclaration114=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeDeclaration114.getTree());


                    break;

            }

            // xquery/XQueryParser.g:610:77: ( p_AllowingEmpty )?
            var alt53=2;
            var LA53_0 = this.input.LA(1);

            if ( (LA53_0==ALLOWING) ) {
                alt53=1;
            }
            switch (alt53) {
                case 1 :
                    // xquery/XQueryParser.g:610:77: p_AllowingEmpty
                    this.pushFollow(XQueryParser.FOLLOW_p_AllowingEmpty_in_p_ForBinding3898);
                    p_AllowingEmpty115=this.p_AllowingEmpty();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AllowingEmpty115.getTree());


                    break;

            }

            // xquery/XQueryParser.g:610:94: ( p_PositionalVar )?
            var alt54=2;
            var LA54_0 = this.input.LA(1);

            if ( (LA54_0==AT) ) {
                alt54=1;
            }
            switch (alt54) {
                case 1 :
                    // xquery/XQueryParser.g:610:94: p_PositionalVar
                    this.pushFollow(XQueryParser.FOLLOW_p_PositionalVar_in_p_ForBinding3901);
                    p_PositionalVar116=this.p_PositionalVar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PositionalVar116.getTree());


                    break;

            }

            // xquery/XQueryParser.g:610:111: ( p_FTScoreVar )?
            var alt55=2;
            var LA55_0 = this.input.LA(1);

            if ( (LA55_0==SCORE) ) {
                alt55=1;
            }
            switch (alt55) {
                case 1 :
                    // xquery/XQueryParser.g:610:111: p_FTScoreVar
                    this.pushFollow(XQueryParser.FOLLOW_p_FTScoreVar_in_p_ForBinding3904);
                    p_FTScoreVar117=this.p_FTScoreVar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_FTScoreVar117.getTree());


                    break;

            }

            k=this.match(this.input,IN,XQueryParser.FOLLOW_IN_in_p_ForBinding3909); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_ForBinding3913);
            p_ExprSingle118=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle118.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AllowingEmpty_return: (function() {
        XQueryParser.p_AllowingEmpty_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AllowingEmpty_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:614:1: p_AllowingEmpty : k= ALLOWING k= EMPTY ;
    // $ANTLR start "p_AllowingEmpty"
    p_AllowingEmpty: function() {
        var retval = new XQueryParser.p_AllowingEmpty_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:615:9: (k= ALLOWING k= EMPTY )
            // xquery/XQueryParser.g:615:11: k= ALLOWING k= EMPTY
            root_0 = this.adaptor.nil();

            k=this.match(this.input,ALLOWING,XQueryParser.FOLLOW_ALLOWING_in_p_AllowingEmpty3942); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,EMPTY,XQueryParser.FOLLOW_EMPTY_in_p_AllowingEmpty3948); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PositionalVar_return: (function() {
        XQueryParser.p_PositionalVar_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PositionalVar_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:619:1: p_PositionalVar : k= AT d= DOLLAR v= p_VarName ;
    // $ANTLR start "p_PositionalVar"
    p_PositionalVar: function() {
        var retval = new XQueryParser.p_PositionalVar_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
         var v = null;

        var k_tree=null;
        var d_tree=null;

        try {
            // xquery/XQueryParser.g:620:9: (k= AT d= DOLLAR v= p_VarName )
            // xquery/XQueryParser.g:620:11: k= AT d= DOLLAR v= p_VarName
            root_0 = this.adaptor.nil();

            k=this.match(this.input,AT,XQueryParser.FOLLOW_AT_in_p_PositionalVar3978); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_PositionalVar3984); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_PositionalVar3988);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (v?v.stop:null)); 
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_LetClause_return: (function() {
        XQueryParser.p_LetClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_LetClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:624:1: p_LetClause : k= LET p_LetBinding ( COMMA p_LetBinding )* ;
    // $ANTLR start "p_LetClause"
    p_LetClause: function() {
        var retval = new XQueryParser.p_LetClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var COMMA120 = null;
         var p_LetBinding119 = null;
         var p_LetBinding121 = null;

        var k_tree=null;
        var COMMA120_tree=null;

        try {
            // xquery/XQueryParser.g:625:9: (k= LET p_LetBinding ( COMMA p_LetBinding )* )
            // xquery/XQueryParser.g:625:11: k= LET p_LetBinding ( COMMA p_LetBinding )*
            root_0 = this.adaptor.nil();

            k=this.match(this.input,LET,XQueryParser.FOLLOW_LET_in_p_LetClause4018); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_LetBinding_in_p_LetClause4022);
            p_LetBinding119=this.p_LetBinding();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_LetBinding119.getTree());
            // xquery/XQueryParser.g:625:45: ( COMMA p_LetBinding )*
            loop56:
            do {
                var alt56=2;
                var LA56_0 = this.input.LA(1);

                if ( (LA56_0==COMMA) ) {
                    alt56=1;
                }


                switch (alt56) {
                case 1 :
                    // xquery/XQueryParser.g:625:46: COMMA p_LetBinding
                    COMMA120=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_LetClause4025); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA120_tree = this.adaptor.create(COMMA120);
                    this.adaptor.addChild(root_0, COMMA120_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_LetBinding_in_p_LetClause4027);
                    p_LetBinding121=this.p_LetBinding();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_LetBinding121.getTree());


                    break;

                default :
                    break loop56;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_LetBinding_return: (function() {
        XQueryParser.p_LetBinding_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_LetBinding_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:630:1: p_LetBinding : ( (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? ) | p_FTScoreVar ) BIND p_ExprSingle[true] ;
    // $ANTLR start "p_LetBinding"
    p_LetBinding: function() {
        var retval = new XQueryParser.p_LetBinding_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var d = null;
        var BIND124 = null;
         var v = null;
         var p_TypeDeclaration122 = null;
         var p_FTScoreVar123 = null;
         var p_ExprSingle125 = null;

        var d_tree=null;
        var BIND124_tree=null;

        try {
            // xquery/XQueryParser.g:631:9: ( ( (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? ) | p_FTScoreVar ) BIND p_ExprSingle[true] )
            // xquery/XQueryParser.g:631:11: ( (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? ) | p_FTScoreVar ) BIND p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:631:11: ( (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? ) | p_FTScoreVar )
            var alt58=2;
            var LA58_0 = this.input.LA(1);

            if ( (LA58_0==DOLLAR) ) {
                alt58=1;
            }
            else if ( (LA58_0==SCORE) ) {
                alt58=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 58, 0, this.input);

                throw nvae;
            }
            switch (alt58) {
                case 1 :
                    // xquery/XQueryParser.g:631:13: (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? )
                    // xquery/XQueryParser.g:631:13: (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? )
                    // xquery/XQueryParser.g:631:14: d= DOLLAR v= p_VarName ( p_TypeDeclaration )?
                    d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_LetBinding4061); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    d_tree = this.adaptor.create(d);
                    this.adaptor.addChild(root_0, d_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_LetBinding4065);
                    v=this.p_VarName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
                    if ( this.state.backtracking===0 ) {
                      this.av(d, (v?v.stop:null));
                    }
                    // xquery/XQueryParser.g:631:59: ( p_TypeDeclaration )?
                    var alt57=2;
                    var LA57_0 = this.input.LA(1);

                    if ( (LA57_0==AS) ) {
                        alt57=1;
                    }
                    switch (alt57) {
                        case 1 :
                            // xquery/XQueryParser.g:631:59: p_TypeDeclaration
                            this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_LetBinding4069);
                            p_TypeDeclaration122=this.p_TypeDeclaration();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeDeclaration122.getTree());


                            break;

                    }






                    break;
                case 2 :
                    // xquery/XQueryParser.g:631:81: p_FTScoreVar
                    this.pushFollow(XQueryParser.FOLLOW_p_FTScoreVar_in_p_LetBinding4075);
                    p_FTScoreVar123=this.p_FTScoreVar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_FTScoreVar123.getTree());


                    break;

            }

            BIND124=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_p_LetBinding4079); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            BIND124_tree = this.adaptor.create(BIND124);
            this.adaptor.addChild(root_0, BIND124_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_LetBinding4081);
            p_ExprSingle125=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle125.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_WindowClause_return: (function() {
        XQueryParser.p_WindowClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_WindowClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:635:1: p_WindowClause : k= FOR ( p_TumblingWindowClause | p_SlidingWindowClause ) ;
    // $ANTLR start "p_WindowClause"
    p_WindowClause: function() {
        var retval = new XQueryParser.p_WindowClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_TumblingWindowClause126 = null;
         var p_SlidingWindowClause127 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:636:9: (k= FOR ( p_TumblingWindowClause | p_SlidingWindowClause ) )
            // xquery/XQueryParser.g:636:11: k= FOR ( p_TumblingWindowClause | p_SlidingWindowClause )
            root_0 = this.adaptor.nil();

            k=this.match(this.input,FOR,XQueryParser.FOLLOW_FOR_in_p_WindowClause4110); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:636:32: ( p_TumblingWindowClause | p_SlidingWindowClause )
            var alt59=2;
            var LA59_0 = this.input.LA(1);

            if ( (LA59_0==TUMBLING) ) {
                alt59=1;
            }
            else if ( (LA59_0==SLIDING) ) {
                alt59=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 59, 0, this.input);

                throw nvae;
            }
            switch (alt59) {
                case 1 :
                    // xquery/XQueryParser.g:636:33: p_TumblingWindowClause
                    this.pushFollow(XQueryParser.FOLLOW_p_TumblingWindowClause_in_p_WindowClause4115);
                    p_TumblingWindowClause126=this.p_TumblingWindowClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TumblingWindowClause126.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:636:58: p_SlidingWindowClause
                    this.pushFollow(XQueryParser.FOLLOW_p_SlidingWindowClause_in_p_WindowClause4119);
                    p_SlidingWindowClause127=this.p_SlidingWindowClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SlidingWindowClause127.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TumblingWindowClause_return: (function() {
        XQueryParser.p_TumblingWindowClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TumblingWindowClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:640:1: p_TumblingWindowClause : k= TUMBLING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )? ;
    // $ANTLR start "p_TumblingWindowClause"
    p_TumblingWindowClause: function() {
        var retval = new XQueryParser.p_TumblingWindowClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
         var v = null;
         var p_TypeDeclaration128 = null;
         var p_ExprSingle129 = null;
         var p_WindowStartCondition130 = null;
         var p_WindowEndCondition131 = null;

        var k_tree=null;
        var d_tree=null;

        try {
            // xquery/XQueryParser.g:641:9: (k= TUMBLING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )? )
            // xquery/XQueryParser.g:641:11: k= TUMBLING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )?
            root_0 = this.adaptor.nil();

            k=this.match(this.input,TUMBLING,XQueryParser.FOLLOW_TUMBLING_in_p_TumblingWindowClause4156); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,WINDOW,XQueryParser.FOLLOW_WINDOW_in_p_TumblingWindowClause4162); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_TumblingWindowClause4168); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_TumblingWindowClause4172);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
              this.av(d, (v?v.stop:null));
            }
            // xquery/XQueryParser.g:641:106: ( p_TypeDeclaration )?
            var alt60=2;
            var LA60_0 = this.input.LA(1);

            if ( (LA60_0==AS) ) {
                alt60=1;
            }
            switch (alt60) {
                case 1 :
                    // xquery/XQueryParser.g:641:106: p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_TumblingWindowClause4176);
                    p_TypeDeclaration128=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeDeclaration128.getTree());


                    break;

            }

            k=this.match(this.input,IN,XQueryParser.FOLLOW_IN_in_p_TumblingWindowClause4181); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_TumblingWindowClause4185);
            p_ExprSingle129=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle129.getTree());
            this.pushFollow(XQueryParser.FOLLOW_p_WindowStartCondition_in_p_TumblingWindowClause4188);
            p_WindowStartCondition130=this.p_WindowStartCondition();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowStartCondition130.getTree());
            // xquery/XQueryParser.g:641:187: ( p_WindowEndCondition )?
            var alt61=2;
            var LA61_0 = this.input.LA(1);

            if ( (LA61_0==END||LA61_0==ONLY) ) {
                alt61=1;
            }
            switch (alt61) {
                case 1 :
                    // xquery/XQueryParser.g:641:187: p_WindowEndCondition
                    this.pushFollow(XQueryParser.FOLLOW_p_WindowEndCondition_in_p_TumblingWindowClause4190);
                    p_WindowEndCondition131=this.p_WindowEndCondition();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowEndCondition131.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SlidingWindowClause_return: (function() {
        XQueryParser.p_SlidingWindowClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SlidingWindowClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:645:1: p_SlidingWindowClause : k= SLIDING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )? ;
    // $ANTLR start "p_SlidingWindowClause"
    p_SlidingWindowClause: function() {
        var retval = new XQueryParser.p_SlidingWindowClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
         var v = null;
         var p_TypeDeclaration132 = null;
         var p_ExprSingle133 = null;
         var p_WindowStartCondition134 = null;
         var p_WindowEndCondition135 = null;

        var k_tree=null;
        var d_tree=null;

        try {
            // xquery/XQueryParser.g:646:9: (k= SLIDING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )? )
            // xquery/XQueryParser.g:646:11: k= SLIDING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )?
            root_0 = this.adaptor.nil();

            k=this.match(this.input,SLIDING,XQueryParser.FOLLOW_SLIDING_in_p_SlidingWindowClause4219); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,WINDOW,XQueryParser.FOLLOW_WINDOW_in_p_SlidingWindowClause4225); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_SlidingWindowClause4231); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_SlidingWindowClause4235);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (v?v.stop:null)); 
            }
            // xquery/XQueryParser.g:646:107: ( p_TypeDeclaration )?
            var alt62=2;
            var LA62_0 = this.input.LA(1);

            if ( (LA62_0==AS) ) {
                alt62=1;
            }
            switch (alt62) {
                case 1 :
                    // xquery/XQueryParser.g:646:107: p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_SlidingWindowClause4239);
                    p_TypeDeclaration132=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeDeclaration132.getTree());


                    break;

            }

            k=this.match(this.input,IN,XQueryParser.FOLLOW_IN_in_p_SlidingWindowClause4244); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_SlidingWindowClause4248);
            p_ExprSingle133=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle133.getTree());
            this.pushFollow(XQueryParser.FOLLOW_p_WindowStartCondition_in_p_SlidingWindowClause4251);
            p_WindowStartCondition134=this.p_WindowStartCondition();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowStartCondition134.getTree());
            // xquery/XQueryParser.g:646:188: ( p_WindowEndCondition )?
            var alt63=2;
            var LA63_0 = this.input.LA(1);

            if ( (LA63_0==END||LA63_0==ONLY) ) {
                alt63=1;
            }
            switch (alt63) {
                case 1 :
                    // xquery/XQueryParser.g:646:188: p_WindowEndCondition
                    this.pushFollow(XQueryParser.FOLLOW_p_WindowEndCondition_in_p_SlidingWindowClause4253);
                    p_WindowEndCondition135=this.p_WindowEndCondition();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowEndCondition135.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_WindowStartCondition_return: (function() {
        XQueryParser.p_WindowStartCondition_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_WindowStartCondition_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:650:1: p_WindowStartCondition : k= START p_WindowVars k= WHEN p_ExprSingle[true] ;
    // $ANTLR start "p_WindowStartCondition"
    p_WindowStartCondition: function() {
        var retval = new XQueryParser.p_WindowStartCondition_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_WindowVars136 = null;
         var p_ExprSingle137 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:651:9: (k= START p_WindowVars k= WHEN p_ExprSingle[true] )
            // xquery/XQueryParser.g:651:11: k= START p_WindowVars k= WHEN p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,START,XQueryParser.FOLLOW_START_in_p_WindowStartCondition4282); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_WindowVars_in_p_WindowStartCondition4286);
            p_WindowVars136=this.p_WindowVars();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowVars136.getTree());
            k=this.match(this.input,WHEN,XQueryParser.FOLLOW_WHEN_in_p_WindowStartCondition4290); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_WindowStartCondition4294);
            p_ExprSingle137=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle137.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_WindowEndCondition_return: (function() {
        XQueryParser.p_WindowEndCondition_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_WindowEndCondition_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:655:1: p_WindowEndCondition : (k= ONLY )? k= END p_WindowVars k= WHEN p_ExprSingle[true] ;
    // $ANTLR start "p_WindowEndCondition"
    p_WindowEndCondition: function() {
        var retval = new XQueryParser.p_WindowEndCondition_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_WindowVars138 = null;
         var p_ExprSingle139 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:656:9: ( (k= ONLY )? k= END p_WindowVars k= WHEN p_ExprSingle[true] )
            // xquery/XQueryParser.g:656:11: (k= ONLY )? k= END p_WindowVars k= WHEN p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:656:11: (k= ONLY )?
            var alt64=2;
            var LA64_0 = this.input.LA(1);

            if ( (LA64_0==ONLY) ) {
                alt64=1;
            }
            switch (alt64) {
                case 1 :
                    // xquery/XQueryParser.g:656:12: k= ONLY
                    k=this.match(this.input,ONLY,XQueryParser.FOLLOW_ONLY_in_p_WindowEndCondition4324); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }


                    break;

            }

            k=this.match(this.input,END,XQueryParser.FOLLOW_END_in_p_WindowEndCondition4332); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_WindowVars_in_p_WindowEndCondition4336);
            p_WindowVars138=this.p_WindowVars();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowVars138.getTree());
            k=this.match(this.input,WHEN,XQueryParser.FOLLOW_WHEN_in_p_WindowEndCondition4340); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_WindowEndCondition4344);
            p_ExprSingle139=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle139.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_WindowVars_return: (function() {
        XQueryParser.p_WindowVars_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_WindowVars_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:660:1: p_WindowVars : (d= DOLLAR v= p_CurrentItem )? ( p_PositionalVar )? (k= PREVIOUS DOLLAR p_PreviousItem )? (k= NEXT DOLLAR p_NextItem )? ;
    // $ANTLR start "p_WindowVars"
    p_WindowVars: function() {
        var retval = new XQueryParser.p_WindowVars_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var d = null;
        var k = null;
        var DOLLAR141 = null;
        var DOLLAR143 = null;
         var v = null;
         var p_PositionalVar140 = null;
         var p_PreviousItem142 = null;
         var p_NextItem144 = null;

        var d_tree=null;
        var k_tree=null;
        var DOLLAR141_tree=null;
        var DOLLAR143_tree=null;

        try {
            // xquery/XQueryParser.g:661:9: ( (d= DOLLAR v= p_CurrentItem )? ( p_PositionalVar )? (k= PREVIOUS DOLLAR p_PreviousItem )? (k= NEXT DOLLAR p_NextItem )? )
            // xquery/XQueryParser.g:661:11: (d= DOLLAR v= p_CurrentItem )? ( p_PositionalVar )? (k= PREVIOUS DOLLAR p_PreviousItem )? (k= NEXT DOLLAR p_NextItem )?
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:661:11: (d= DOLLAR v= p_CurrentItem )?
            var alt65=2;
            var LA65_0 = this.input.LA(1);

            if ( (LA65_0==DOLLAR) ) {
                alt65=1;
            }
            switch (alt65) {
                case 1 :
                    // xquery/XQueryParser.g:661:12: d= DOLLAR v= p_CurrentItem
                    d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_WindowVars4374); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    d_tree = this.adaptor.create(d);
                    this.adaptor.addChild(root_0, d_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_CurrentItem_in_p_WindowVars4378);
                    v=this.p_CurrentItem();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
                    if ( this.state.backtracking===0 ) {
                       this.av(d, (v?v.stop:null)); 
                    }


                    break;

            }

            // xquery/XQueryParser.g:661:65: ( p_PositionalVar )?
            var alt66=2;
            var LA66_0 = this.input.LA(1);

            if ( (LA66_0==AT) ) {
                alt66=1;
            }
            switch (alt66) {
                case 1 :
                    // xquery/XQueryParser.g:661:65: p_PositionalVar
                    this.pushFollow(XQueryParser.FOLLOW_p_PositionalVar_in_p_WindowVars4384);
                    p_PositionalVar140=this.p_PositionalVar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PositionalVar140.getTree());


                    break;

            }

            // xquery/XQueryParser.g:661:82: (k= PREVIOUS DOLLAR p_PreviousItem )?
            var alt67=2;
            var LA67_0 = this.input.LA(1);

            if ( (LA67_0==PREVIOUS) ) {
                alt67=1;
            }
            switch (alt67) {
                case 1 :
                    // xquery/XQueryParser.g:661:83: k= PREVIOUS DOLLAR p_PreviousItem
                    k=this.match(this.input,PREVIOUS,XQueryParser.FOLLOW_PREVIOUS_in_p_WindowVars4390); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    DOLLAR141=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_WindowVars4394); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    DOLLAR141_tree = this.adaptor.create(DOLLAR141);
                    this.adaptor.addChild(root_0, DOLLAR141_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_PreviousItem_in_p_WindowVars4396);
                    p_PreviousItem142=this.p_PreviousItem();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PreviousItem142.getTree());


                    break;

            }

            // xquery/XQueryParser.g:661:133: (k= NEXT DOLLAR p_NextItem )?
            var alt68=2;
            var LA68_0 = this.input.LA(1);

            if ( (LA68_0==NEXT) ) {
                alt68=1;
            }
            switch (alt68) {
                case 1 :
                    // xquery/XQueryParser.g:661:134: k= NEXT DOLLAR p_NextItem
                    k=this.match(this.input,NEXT,XQueryParser.FOLLOW_NEXT_in_p_WindowVars4403); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    DOLLAR143=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_WindowVars4407); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    DOLLAR143_tree = this.adaptor.create(DOLLAR143);
                    this.adaptor.addChild(root_0, DOLLAR143_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_NextItem_in_p_WindowVars4409);
                    p_NextItem144=this.p_NextItem();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NextItem144.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CurrentItem_return: (function() {
        XQueryParser.p_CurrentItem_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CurrentItem_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:665:1: p_CurrentItem : p_QName ;
    // $ANTLR start "p_CurrentItem"
    p_CurrentItem: function() {
        var retval = new XQueryParser.p_CurrentItem_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_QName145 = null;


        try {
            // xquery/XQueryParser.g:666:9: ( p_QName )
            // xquery/XQueryParser.g:666:11: p_QName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_CurrentItem4437);
            p_QName145=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName145.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PreviousItem_return: (function() {
        XQueryParser.p_PreviousItem_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PreviousItem_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:670:1: p_PreviousItem : p_QName ;
    // $ANTLR start "p_PreviousItem"
    p_PreviousItem: function() {
        var retval = new XQueryParser.p_PreviousItem_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_QName146 = null;


        try {
            // xquery/XQueryParser.g:671:9: ( p_QName )
            // xquery/XQueryParser.g:671:11: p_QName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_PreviousItem4463);
            p_QName146=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName146.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_NextItem_return: (function() {
        XQueryParser.p_NextItem_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_NextItem_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:675:1: p_NextItem : p_QName ;
    // $ANTLR start "p_NextItem"
    p_NextItem: function() {
        var retval = new XQueryParser.p_NextItem_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_QName147 = null;


        try {
            // xquery/XQueryParser.g:676:9: ( p_QName )
            // xquery/XQueryParser.g:676:11: p_QName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_NextItem4489);
            p_QName147=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName147.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CountClause_return: (function() {
        XQueryParser.p_CountClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CountClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:680:1: p_CountClause : k= COUNT d= DOLLAR v= p_VarName ;
    // $ANTLR start "p_CountClause"
    p_CountClause: function() {
        var retval = new XQueryParser.p_CountClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
         var v = null;

        var k_tree=null;
        var d_tree=null;

        try {
            // xquery/XQueryParser.g:681:9: (k= COUNT d= DOLLAR v= p_VarName )
            // xquery/XQueryParser.g:681:11: k= COUNT d= DOLLAR v= p_VarName
            root_0 = this.adaptor.nil();

            k=this.match(this.input,COUNT,XQueryParser.FOLLOW_COUNT_in_p_CountClause4517); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_CountClause4523); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_CountClause4527);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (v?v.stop:null)); 
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_WhereClause_return: (function() {
        XQueryParser.p_WhereClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_WhereClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:685:1: p_WhereClause : k= WHERE p_ExprSingle[true] ;
    // $ANTLR start "p_WhereClause"
    p_WhereClause: function() {
        var retval = new XQueryParser.p_WhereClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_ExprSingle148 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:686:9: (k= WHERE p_ExprSingle[true] )
            // xquery/XQueryParser.g:686:11: k= WHERE p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,WHERE,XQueryParser.FOLLOW_WHERE_in_p_WhereClause4565); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_WhereClause4569);
            p_ExprSingle148=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle148.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_GroupByClause_return: (function() {
        XQueryParser.p_GroupByClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_GroupByClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:690:1: p_GroupByClause : k= GROUP k= BY p_GroupingSpecList ;
    // $ANTLR start "p_GroupByClause"
    p_GroupByClause: function() {
        var retval = new XQueryParser.p_GroupByClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_GroupingSpecList149 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:691:9: (k= GROUP k= BY p_GroupingSpecList )
            // xquery/XQueryParser.g:691:11: k= GROUP k= BY p_GroupingSpecList
            root_0 = this.adaptor.nil();

            k=this.match(this.input,GROUP,XQueryParser.FOLLOW_GROUP_in_p_GroupByClause4598); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,BY,XQueryParser.FOLLOW_BY_in_p_GroupByClause4604); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_GroupingSpecList_in_p_GroupByClause4608);
            p_GroupingSpecList149=this.p_GroupingSpecList();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_GroupingSpecList149.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_GroupingSpecList_return: (function() {
        XQueryParser.p_GroupingSpecList_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_GroupingSpecList_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:695:1: p_GroupingSpecList : p_GroupingSpec ( COMMA p_GroupingSpec )* ;
    // $ANTLR start "p_GroupingSpecList"
    p_GroupingSpecList: function() {
        var retval = new XQueryParser.p_GroupingSpecList_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var COMMA151 = null;
         var p_GroupingSpec150 = null;
         var p_GroupingSpec152 = null;

        var COMMA151_tree=null;

        try {
            // xquery/XQueryParser.g:696:9: ( p_GroupingSpec ( COMMA p_GroupingSpec )* )
            // xquery/XQueryParser.g:696:11: p_GroupingSpec ( COMMA p_GroupingSpec )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_GroupingSpec_in_p_GroupingSpecList4634);
            p_GroupingSpec150=this.p_GroupingSpec();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_GroupingSpec150.getTree());
            // xquery/XQueryParser.g:696:26: ( COMMA p_GroupingSpec )*
            loop69:
            do {
                var alt69=2;
                var LA69_0 = this.input.LA(1);

                if ( (LA69_0==COMMA) ) {
                    alt69=1;
                }


                switch (alt69) {
                case 1 :
                    // xquery/XQueryParser.g:696:27: COMMA p_GroupingSpec
                    COMMA151=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_GroupingSpecList4637); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA151_tree = this.adaptor.create(COMMA151);
                    this.adaptor.addChild(root_0, COMMA151_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_GroupingSpec_in_p_GroupingSpecList4639);
                    p_GroupingSpec152=this.p_GroupingSpec();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_GroupingSpec152.getTree());


                    break;

                default :
                    break loop69;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_GroupingSpec_return: (function() {
        XQueryParser.p_GroupingSpec_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_GroupingSpec_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:700:1: p_GroupingSpec : d= DOLLAR v= p_VarName (k= COLLATION p_StringLiteral )? ;
    // $ANTLR start "p_GroupingSpec"
    p_GroupingSpec: function() {
        var retval = new XQueryParser.p_GroupingSpec_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var d = null;
        var k = null;
         var v = null;
         var p_StringLiteral153 = null;

        var d_tree=null;
        var k_tree=null;

        try {
            // xquery/XQueryParser.g:701:9: (d= DOLLAR v= p_VarName (k= COLLATION p_StringLiteral )? )
            // xquery/XQueryParser.g:701:11: d= DOLLAR v= p_VarName (k= COLLATION p_StringLiteral )?
            root_0 = this.adaptor.nil();

            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_GroupingSpec4669); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_GroupingSpec4673);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (v?v.stop:null)); 
            }
            // xquery/XQueryParser.g:701:58: (k= COLLATION p_StringLiteral )?
            var alt70=2;
            var LA70_0 = this.input.LA(1);

            if ( (LA70_0==COLLATION) ) {
                alt70=1;
            }
            switch (alt70) {
                case 1 :
                    // xquery/XQueryParser.g:701:59: k= COLLATION p_StringLiteral
                    k=this.match(this.input,COLLATION,XQueryParser.FOLLOW_COLLATION_in_p_GroupingSpec4680); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_GroupingSpec4684);
                    p_StringLiteral153=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral153.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_OrderByClause_return: (function() {
        XQueryParser.p_OrderByClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_OrderByClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:705:1: p_OrderByClause : ( (k+= ORDER k+= BY ) | (k+= STABLE k+= ORDER k+= BY ) ) p_OrderSpecList ;
    // $ANTLR start "p_OrderByClause"
    p_OrderByClause: function() {
        var retval = new XQueryParser.p_OrderByClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var list_k=null;
         var p_OrderSpecList154 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:706:9: ( ( (k+= ORDER k+= BY ) | (k+= STABLE k+= ORDER k+= BY ) ) p_OrderSpecList )
            // xquery/XQueryParser.g:706:11: ( (k+= ORDER k+= BY ) | (k+= STABLE k+= ORDER k+= BY ) ) p_OrderSpecList
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:706:11: ( (k+= ORDER k+= BY ) | (k+= STABLE k+= ORDER k+= BY ) )
            var alt71=2;
            var LA71_0 = this.input.LA(1);

            if ( (LA71_0==ORDER) ) {
                alt71=1;
            }
            else if ( (LA71_0==STABLE) ) {
                alt71=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 71, 0, this.input);

                throw nvae;
            }
            switch (alt71) {
                case 1 :
                    // xquery/XQueryParser.g:706:12: (k+= ORDER k+= BY )
                    // xquery/XQueryParser.g:706:12: (k+= ORDER k+= BY )
                    // xquery/XQueryParser.g:706:13: k+= ORDER k+= BY
                    k=this.match(this.input,ORDER,XQueryParser.FOLLOW_ORDER_in_p_OrderByClause4716); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);

                    k=this.match(this.input,BY,XQueryParser.FOLLOW_BY_in_p_OrderByClause4720); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);






                    break;
                case 2 :
                    // xquery/XQueryParser.g:706:31: (k+= STABLE k+= ORDER k+= BY )
                    // xquery/XQueryParser.g:706:31: (k+= STABLE k+= ORDER k+= BY )
                    // xquery/XQueryParser.g:706:32: k+= STABLE k+= ORDER k+= BY
                    k=this.match(this.input,STABLE,XQueryParser.FOLLOW_STABLE_in_p_OrderByClause4728); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);

                    k=this.match(this.input,ORDER,XQueryParser.FOLLOW_ORDER_in_p_OrderByClause4732); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);

                    k=this.match(this.input,BY,XQueryParser.FOLLOW_BY_in_p_OrderByClause4736); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);






                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_OrderSpecList_in_p_OrderByClause4742);
            p_OrderSpecList154=this.p_OrderSpecList();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_OrderSpecList154.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_OrderSpecList_return: (function() {
        XQueryParser.p_OrderSpecList_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_OrderSpecList_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:710:1: p_OrderSpecList : p_OrderSpec ( COMMA p_OrderSpec )* ;
    // $ANTLR start "p_OrderSpecList"
    p_OrderSpecList: function() {
        var retval = new XQueryParser.p_OrderSpecList_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var COMMA156 = null;
         var p_OrderSpec155 = null;
         var p_OrderSpec157 = null;

        var COMMA156_tree=null;

        try {
            // xquery/XQueryParser.g:711:9: ( p_OrderSpec ( COMMA p_OrderSpec )* )
            // xquery/XQueryParser.g:711:11: p_OrderSpec ( COMMA p_OrderSpec )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_OrderSpec_in_p_OrderSpecList4768);
            p_OrderSpec155=this.p_OrderSpec();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_OrderSpec155.getTree());
            // xquery/XQueryParser.g:711:23: ( COMMA p_OrderSpec )*
            loop72:
            do {
                var alt72=2;
                var LA72_0 = this.input.LA(1);

                if ( (LA72_0==COMMA) ) {
                    alt72=1;
                }


                switch (alt72) {
                case 1 :
                    // xquery/XQueryParser.g:711:24: COMMA p_OrderSpec
                    COMMA156=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_OrderSpecList4771); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA156_tree = this.adaptor.create(COMMA156);
                    this.adaptor.addChild(root_0, COMMA156_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_OrderSpec_in_p_OrderSpecList4773);
                    p_OrderSpec157=this.p_OrderSpec();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_OrderSpec157.getTree());


                    break;

                default :
                    break loop72;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_OrderSpec_return: (function() {
        XQueryParser.p_OrderSpec_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_OrderSpec_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:715:1: p_OrderSpec : p_ExprSingle[true] p_OrderModifier ;
    // $ANTLR start "p_OrderSpec"
    p_OrderSpec: function() {
        var retval = new XQueryParser.p_OrderSpec_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ExprSingle158 = null;
         var p_OrderModifier159 = null;


        try {
            // xquery/XQueryParser.g:716:9: ( p_ExprSingle[true] p_OrderModifier )
            // xquery/XQueryParser.g:716:11: p_ExprSingle[true] p_OrderModifier
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_OrderSpec4801);
            p_ExprSingle158=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle158.getTree());
            this.pushFollow(XQueryParser.FOLLOW_p_OrderModifier_in_p_OrderSpec4804);
            p_OrderModifier159=this.p_OrderModifier();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_OrderModifier159.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_OrderModifier_return: (function() {
        XQueryParser.p_OrderModifier_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_OrderModifier_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:720:1: p_OrderModifier : (k+= ASCENDING | k+= DESCENDING )? (k+= EMPTY (k+= GREATEST | k+= LEAST ) )? (k+= COLLATION p_StringLiteral )? ;
    // $ANTLR start "p_OrderModifier"
    p_OrderModifier: function() {
        var retval = new XQueryParser.p_OrderModifier_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var list_k=null;
         var p_StringLiteral160 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:721:9: ( (k+= ASCENDING | k+= DESCENDING )? (k+= EMPTY (k+= GREATEST | k+= LEAST ) )? (k+= COLLATION p_StringLiteral )? )
            // xquery/XQueryParser.g:721:11: (k+= ASCENDING | k+= DESCENDING )? (k+= EMPTY (k+= GREATEST | k+= LEAST ) )? (k+= COLLATION p_StringLiteral )?
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:721:11: (k+= ASCENDING | k+= DESCENDING )?
            var alt73=3;
            var LA73_0 = this.input.LA(1);

            if ( (LA73_0==ASCENDING) ) {
                alt73=1;
            }
            else if ( (LA73_0==DESCENDING) ) {
                alt73=2;
            }
            switch (alt73) {
                case 1 :
                    // xquery/XQueryParser.g:721:12: k+= ASCENDING
                    k=this.match(this.input,ASCENDING,XQueryParser.FOLLOW_ASCENDING_in_p_OrderModifier4833); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;
                case 2 :
                    // xquery/XQueryParser.g:721:27: k+= DESCENDING
                    k=this.match(this.input,DESCENDING,XQueryParser.FOLLOW_DESCENDING_in_p_OrderModifier4839); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;

            }

            // xquery/XQueryParser.g:721:43: (k+= EMPTY (k+= GREATEST | k+= LEAST ) )?
            var alt75=2;
            var LA75_0 = this.input.LA(1);

            if ( (LA75_0==EMPTY) ) {
                alt75=1;
            }
            switch (alt75) {
                case 1 :
                    // xquery/XQueryParser.g:721:44: k+= EMPTY (k+= GREATEST | k+= LEAST )
                    k=this.match(this.input,EMPTY,XQueryParser.FOLLOW_EMPTY_in_p_OrderModifier4846); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);

                    // xquery/XQueryParser.g:721:53: (k+= GREATEST | k+= LEAST )
                    var alt74=2;
                    var LA74_0 = this.input.LA(1);

                    if ( (LA74_0==GREATEST) ) {
                        alt74=1;
                    }
                    else if ( (LA74_0==LEAST) ) {
                        alt74=2;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var nvae =
                            new org.antlr.runtime.NoViableAltException("", 74, 0, this.input);

                        throw nvae;
                    }
                    switch (alt74) {
                        case 1 :
                            // xquery/XQueryParser.g:721:54: k+= GREATEST
                            k=this.match(this.input,GREATEST,XQueryParser.FOLLOW_GREATEST_in_p_OrderModifier4851); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            k_tree = this.adaptor.create(k);
                            this.adaptor.addChild(root_0, k_tree);
                            }
                            if (org.antlr.lang.isNull(list_k)) list_k = [];
                            list_k.push(k);



                            break;
                        case 2 :
                            // xquery/XQueryParser.g:721:68: k+= LEAST
                            k=this.match(this.input,LEAST,XQueryParser.FOLLOW_LEAST_in_p_OrderModifier4857); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            k_tree = this.adaptor.create(k);
                            this.adaptor.addChild(root_0, k_tree);
                            }
                            if (org.antlr.lang.isNull(list_k)) list_k = [];
                            list_k.push(k);



                            break;

                    }



                    break;

            }

            // xquery/XQueryParser.g:721:80: (k+= COLLATION p_StringLiteral )?
            var alt76=2;
            var LA76_0 = this.input.LA(1);

            if ( (LA76_0==COLLATION) ) {
                alt76=1;
            }
            switch (alt76) {
                case 1 :
                    // xquery/XQueryParser.g:721:81: k+= COLLATION p_StringLiteral
                    k=this.match(this.input,COLLATION,XQueryParser.FOLLOW_COLLATION_in_p_OrderModifier4865); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);

                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_OrderModifier4867);
                    p_StringLiteral160=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral160.getTree());


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ReturnHybrid_return: (function() {
        XQueryParser.p_ReturnHybrid_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ReturnHybrid_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:725:1: p_ReturnHybrid[strict] : k= RETURN p_Hybrid[$strict,false] ;
    // $ANTLR start "p_ReturnHybrid"
    p_ReturnHybrid: function(strict) {
        var retval = new XQueryParser.p_ReturnHybrid_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_Hybrid161 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:726:9: (k= RETURN p_Hybrid[$strict,false] )
            // xquery/XQueryParser.g:726:11: k= RETURN p_Hybrid[$strict,false]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,RETURN,XQueryParser.FOLLOW_RETURN_in_p_ReturnHybrid4900); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Hybrid_in_p_ReturnHybrid4904);
            p_Hybrid161=this.p_Hybrid(strict, false);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Hybrid161.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_QuantifiedExpr_return: (function() {
        XQueryParser.p_QuantifiedExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_QuantifiedExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:730:1: p_QuantifiedExpr : (k= SOME | k= EVERY ) d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] ( COMMA e= DOLLAR w= p_QName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] )* k= SATISFIES p_ExprSingle[true] ;
    // $ANTLR start "p_QuantifiedExpr"
    p_QuantifiedExpr: function() {
        var retval = new XQueryParser.p_QuantifiedExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
        var e = null;
        var COMMA164 = null;
         var v = null;
         var w = null;
         var p_TypeDeclaration162 = null;
         var p_ExprSingle163 = null;
         var p_TypeDeclaration165 = null;
         var p_ExprSingle166 = null;
         var p_ExprSingle167 = null;

        var k_tree=null;
        var d_tree=null;
        var e_tree=null;
        var COMMA164_tree=null;

        try {
            // xquery/XQueryParser.g:731:9: ( (k= SOME | k= EVERY ) d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] ( COMMA e= DOLLAR w= p_QName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] )* k= SATISFIES p_ExprSingle[true] )
            // xquery/XQueryParser.g:731:11: (k= SOME | k= EVERY ) d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] ( COMMA e= DOLLAR w= p_QName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] )* k= SATISFIES p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:731:11: (k= SOME | k= EVERY )
            var alt77=2;
            var LA77_0 = this.input.LA(1);

            if ( (LA77_0==SOME) ) {
                alt77=1;
            }
            else if ( (LA77_0==EVERY) ) {
                alt77=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 77, 0, this.input);

                throw nvae;
            }
            switch (alt77) {
                case 1 :
                    // xquery/XQueryParser.g:731:12: k= SOME
                    k=this.match(this.input,SOME,XQueryParser.FOLLOW_SOME_in_p_QuantifiedExpr4934); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:731:21: k= EVERY
                    k=this.match(this.input,EVERY,XQueryParser.FOLLOW_EVERY_in_p_QuantifiedExpr4940); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_QuantifiedExpr4947); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_QuantifiedExpr4951);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (v?v.stop:null)); 
            }
            // xquery/XQueryParser.g:731:92: ( p_TypeDeclaration )?
            var alt78=2;
            var LA78_0 = this.input.LA(1);

            if ( (LA78_0==AS) ) {
                alt78=1;
            }
            switch (alt78) {
                case 1 :
                    // xquery/XQueryParser.g:731:92: p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_QuantifiedExpr4955);
                    p_TypeDeclaration162=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeDeclaration162.getTree());


                    break;

            }

            k=this.match(this.input,IN,XQueryParser.FOLLOW_IN_in_p_QuantifiedExpr4960); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_QuantifiedExpr4964);
            p_ExprSingle163=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle163.getTree());
            // xquery/XQueryParser.g:731:150: ( COMMA e= DOLLAR w= p_QName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] )*
            loop80:
            do {
                var alt80=2;
                var LA80_0 = this.input.LA(1);

                if ( (LA80_0==COMMA) ) {
                    alt80=1;
                }


                switch (alt80) {
                case 1 :
                    // xquery/XQueryParser.g:731:151: COMMA e= DOLLAR w= p_QName ( p_TypeDeclaration )? k= IN p_ExprSingle[true]
                    COMMA164=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_QuantifiedExpr4968); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA164_tree = this.adaptor.create(COMMA164);
                    this.adaptor.addChild(root_0, COMMA164_tree);
                    }
                    e=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_QuantifiedExpr4972); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    e_tree = this.adaptor.create(e);
                    this.adaptor.addChild(root_0, e_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_QuantifiedExpr4976);
                    w=this.p_QName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, w.getTree());
                    if ( this.state.backtracking===0 ) {
                      this.av(e, (w?w.stop:null));
                    }
                    // xquery/XQueryParser.g:731:200: ( p_TypeDeclaration )?
                    var alt79=2;
                    var LA79_0 = this.input.LA(1);

                    if ( (LA79_0==AS) ) {
                        alt79=1;
                    }
                    switch (alt79) {
                        case 1 :
                            // xquery/XQueryParser.g:731:200: p_TypeDeclaration
                            this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_QuantifiedExpr4980);
                            p_TypeDeclaration165=this.p_TypeDeclaration();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeDeclaration165.getTree());


                            break;

                    }

                    k=this.match(this.input,IN,XQueryParser.FOLLOW_IN_in_p_QuantifiedExpr4985); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_QuantifiedExpr4989);
                    p_ExprSingle166=this.p_ExprSingle(true);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle166.getTree());


                    break;

                default :
                    break loop80;
                }
            } while (true);

            k=this.match(this.input,SATISFIES,XQueryParser.FOLLOW_SATISFIES_in_p_QuantifiedExpr4996); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_QuantifiedExpr5000);
            p_ExprSingle167=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle167.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SwitchHybrid_return: (function() {
        XQueryParser.p_SwitchHybrid_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SwitchHybrid_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:735:1: p_SwitchHybrid[strict] : k= SWITCH LPAREN p_Expr[true,true] RPAREN ( p_SwitchCaseHybrid[$strict] )+ k= DEFAULT k= RETURN p_Hybrid[$strict,false] ;
    // $ANTLR start "p_SwitchHybrid"
    p_SwitchHybrid: function(strict) {
        var retval = new XQueryParser.p_SwitchHybrid_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LPAREN168 = null;
        var RPAREN170 = null;
         var p_Expr169 = null;
         var p_SwitchCaseHybrid171 = null;
         var p_Hybrid172 = null;

        var k_tree=null;
        var LPAREN168_tree=null;
        var RPAREN170_tree=null;

        try {
            // xquery/XQueryParser.g:736:9: (k= SWITCH LPAREN p_Expr[true,true] RPAREN ( p_SwitchCaseHybrid[$strict] )+ k= DEFAULT k= RETURN p_Hybrid[$strict,false] )
            // xquery/XQueryParser.g:736:11: k= SWITCH LPAREN p_Expr[true,true] RPAREN ( p_SwitchCaseHybrid[$strict] )+ k= DEFAULT k= RETURN p_Hybrid[$strict,false]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,SWITCH,XQueryParser.FOLLOW_SWITCH_in_p_SwitchHybrid5030); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            LPAREN168=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_SwitchHybrid5034); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN168_tree = this.adaptor.create(LPAREN168);
            this.adaptor.addChild(root_0, LPAREN168_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_SwitchHybrid5036);
            p_Expr169=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr169.getTree());
            RPAREN170=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_SwitchHybrid5039); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN170_tree = this.adaptor.create(RPAREN170);
            this.adaptor.addChild(root_0, RPAREN170_tree);
            }
            // xquery/XQueryParser.g:736:67: ( p_SwitchCaseHybrid[$strict] )+
            var cnt81=0;
            loop81:
            do {
                var alt81=2;
                var LA81_0 = this.input.LA(1);

                if ( (LA81_0==CASE) ) {
                    alt81=1;
                }


                switch (alt81) {
                case 1 :
                    // xquery/XQueryParser.g:736:67: p_SwitchCaseHybrid[$strict]
                    this.pushFollow(XQueryParser.FOLLOW_p_SwitchCaseHybrid_in_p_SwitchHybrid5041);
                    p_SwitchCaseHybrid171=this.p_SwitchCaseHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SwitchCaseHybrid171.getTree());


                    break;

                default :
                    if ( cnt81 >= 1 ) {
                        break loop81;
                    }
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var eee = new org.antlr.runtime.EarlyExitException(81, this.input);
                        throw eee;
                }
                cnt81++;
            } while (true);

            k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_p_SwitchHybrid5047); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,RETURN,XQueryParser.FOLLOW_RETURN_in_p_SwitchHybrid5053); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Hybrid_in_p_SwitchHybrid5057);
            p_Hybrid172=this.p_Hybrid(strict, false);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Hybrid172.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SwitchCaseHybrid_return: (function() {
        XQueryParser.p_SwitchCaseHybrid_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SwitchCaseHybrid_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:740:1: p_SwitchCaseHybrid[strict] : (k= CASE p_SwitchCaseOperand )+ k= RETURN p_Hybrid[$strict,false] ;
    // $ANTLR start "p_SwitchCaseHybrid"
    p_SwitchCaseHybrid: function(strict) {
        var retval = new XQueryParser.p_SwitchCaseHybrid_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_SwitchCaseOperand173 = null;
         var p_Hybrid174 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:741:9: ( (k= CASE p_SwitchCaseOperand )+ k= RETURN p_Hybrid[$strict,false] )
            // xquery/XQueryParser.g:741:11: (k= CASE p_SwitchCaseOperand )+ k= RETURN p_Hybrid[$strict,false]
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:741:11: (k= CASE p_SwitchCaseOperand )+
            var cnt82=0;
            loop82:
            do {
                var alt82=2;
                var LA82_0 = this.input.LA(1);

                if ( (LA82_0==CASE) ) {
                    alt82=1;
                }


                switch (alt82) {
                case 1 :
                    // xquery/XQueryParser.g:741:12: k= CASE p_SwitchCaseOperand
                    k=this.match(this.input,CASE,XQueryParser.FOLLOW_CASE_in_p_SwitchCaseHybrid5088); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_SwitchCaseOperand_in_p_SwitchCaseHybrid5092);
                    p_SwitchCaseOperand173=this.p_SwitchCaseOperand();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SwitchCaseOperand173.getTree());


                    break;

                default :
                    if ( cnt82 >= 1 ) {
                        break loop82;
                    }
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var eee = new org.antlr.runtime.EarlyExitException(82, this.input);
                        throw eee;
                }
                cnt82++;
            } while (true);

            k=this.match(this.input,RETURN,XQueryParser.FOLLOW_RETURN_in_p_SwitchCaseHybrid5098); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Hybrid_in_p_SwitchCaseHybrid5102);
            p_Hybrid174=this.p_Hybrid(strict, false);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Hybrid174.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SwitchCaseOperand_return: (function() {
        XQueryParser.p_SwitchCaseOperand_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SwitchCaseOperand_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:745:1: p_SwitchCaseOperand : p_ExprSingle[true] ;
    // $ANTLR start "p_SwitchCaseOperand"
    p_SwitchCaseOperand: function() {
        var retval = new XQueryParser.p_SwitchCaseOperand_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ExprSingle175 = null;


        try {
            // xquery/XQueryParser.g:746:9: ( p_ExprSingle[true] )
            // xquery/XQueryParser.g:746:11: p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_SwitchCaseOperand5129);
            p_ExprSingle175=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle175.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TypeswitchHybrid_return: (function() {
        XQueryParser.p_TypeswitchHybrid_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TypeswitchHybrid_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:750:1: p_TypeswitchHybrid[strict] : k= TYPESWITCH LPAREN p_Expr[true,true] RPAREN ( p_CaseHybrid[$strict] )+ k= DEFAULT (d= DOLLAR v= p_VarName )? k= RETURN p_Hybrid[$strict,false] ;
    // $ANTLR start "p_TypeswitchHybrid"
    p_TypeswitchHybrid: function(strict) {
        var retval = new XQueryParser.p_TypeswitchHybrid_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
        var LPAREN176 = null;
        var RPAREN178 = null;
         var v = null;
         var p_Expr177 = null;
         var p_CaseHybrid179 = null;
         var p_Hybrid180 = null;

        var k_tree=null;
        var d_tree=null;
        var LPAREN176_tree=null;
        var RPAREN178_tree=null;

        try {
            // xquery/XQueryParser.g:751:9: (k= TYPESWITCH LPAREN p_Expr[true,true] RPAREN ( p_CaseHybrid[$strict] )+ k= DEFAULT (d= DOLLAR v= p_VarName )? k= RETURN p_Hybrid[$strict,false] )
            // xquery/XQueryParser.g:751:11: k= TYPESWITCH LPAREN p_Expr[true,true] RPAREN ( p_CaseHybrid[$strict] )+ k= DEFAULT (d= DOLLAR v= p_VarName )? k= RETURN p_Hybrid[$strict,false]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,TYPESWITCH,XQueryParser.FOLLOW_TYPESWITCH_in_p_TypeswitchHybrid5159); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            LPAREN176=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_TypeswitchHybrid5163); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN176_tree = this.adaptor.create(LPAREN176);
            this.adaptor.addChild(root_0, LPAREN176_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_TypeswitchHybrid5165);
            p_Expr177=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr177.getTree());
            RPAREN178=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_TypeswitchHybrid5168); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN178_tree = this.adaptor.create(RPAREN178);
            this.adaptor.addChild(root_0, RPAREN178_tree);
            }
            // xquery/XQueryParser.g:751:71: ( p_CaseHybrid[$strict] )+
            var cnt83=0;
            loop83:
            do {
                var alt83=2;
                var LA83_0 = this.input.LA(1);

                if ( (LA83_0==CASE) ) {
                    alt83=1;
                }


                switch (alt83) {
                case 1 :
                    // xquery/XQueryParser.g:751:71: p_CaseHybrid[$strict]
                    this.pushFollow(XQueryParser.FOLLOW_p_CaseHybrid_in_p_TypeswitchHybrid5170);
                    p_CaseHybrid179=this.p_CaseHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CaseHybrid179.getTree());


                    break;

                default :
                    if ( cnt83 >= 1 ) {
                        break loop83;
                    }
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var eee = new org.antlr.runtime.EarlyExitException(83, this.input);
                        throw eee;
                }
                cnt83++;
            } while (true);

            k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_p_TypeswitchHybrid5176); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:751:119: (d= DOLLAR v= p_VarName )?
            var alt84=2;
            var LA84_0 = this.input.LA(1);

            if ( (LA84_0==DOLLAR) ) {
                alt84=1;
            }
            switch (alt84) {
                case 1 :
                    // xquery/XQueryParser.g:751:120: d= DOLLAR v= p_VarName
                    d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_TypeswitchHybrid5183); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    d_tree = this.adaptor.create(d);
                    this.adaptor.addChild(root_0, d_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_TypeswitchHybrid5187);
                    v=this.p_VarName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
                    if ( this.state.backtracking===0 ) {
                       this.av(d, (v?v.stop:null)); 
                    }


                    break;

            }

            k=this.match(this.input,RETURN,XQueryParser.FOLLOW_RETURN_in_p_TypeswitchHybrid5195); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Hybrid_in_p_TypeswitchHybrid5199);
            p_Hybrid180=this.p_Hybrid(strict, false);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Hybrid180.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CaseHybrid_return: (function() {
        XQueryParser.p_CaseHybrid_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CaseHybrid_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:755:1: p_CaseHybrid[strict] : k= CASE (d= DOLLAR v= p_VarName k= AS )? p_SequenceTypeUnion k= RETURN p_ExprSingle[false] ;
    // $ANTLR start "p_CaseHybrid"
    p_CaseHybrid: function(strict) {
        var retval = new XQueryParser.p_CaseHybrid_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
         var v = null;
         var p_SequenceTypeUnion181 = null;
         var p_ExprSingle182 = null;

        var k_tree=null;
        var d_tree=null;

        try {
            // xquery/XQueryParser.g:756:9: (k= CASE (d= DOLLAR v= p_VarName k= AS )? p_SequenceTypeUnion k= RETURN p_ExprSingle[false] )
            // xquery/XQueryParser.g:756:11: k= CASE (d= DOLLAR v= p_VarName k= AS )? p_SequenceTypeUnion k= RETURN p_ExprSingle[false]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,CASE,XQueryParser.FOLLOW_CASE_in_p_CaseHybrid5229); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:756:33: (d= DOLLAR v= p_VarName k= AS )?
            var alt85=2;
            var LA85_0 = this.input.LA(1);

            if ( (LA85_0==DOLLAR) ) {
                alt85=1;
            }
            switch (alt85) {
                case 1 :
                    // xquery/XQueryParser.g:756:34: d= DOLLAR v= p_VarName k= AS
                    d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_CaseHybrid5236); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    d_tree = this.adaptor.create(d);
                    this.adaptor.addChild(root_0, d_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_CaseHybrid5240);
                    v=this.p_VarName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
                    if ( this.state.backtracking===0 ) {
                       this.av(d, (v?v.stop:null)); 
                    }
                    k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_p_CaseHybrid5246); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }


                    break;

            }

            this.pushFollow(XQueryParser.FOLLOW_p_SequenceTypeUnion_in_p_CaseHybrid5252);
            p_SequenceTypeUnion181=this.p_SequenceTypeUnion();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SequenceTypeUnion181.getTree());
            k=this.match(this.input,RETURN,XQueryParser.FOLLOW_RETURN_in_p_CaseHybrid5256); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_CaseHybrid5260);
            p_ExprSingle182=this.p_ExprSingle(false);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle182.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SequenceTypeUnion_return: (function() {
        XQueryParser.p_SequenceTypeUnion_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SequenceTypeUnion_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:760:1: p_SequenceTypeUnion : p_SequenceType ( VBAR p_SequenceType )* ;
    // $ANTLR start "p_SequenceTypeUnion"
    p_SequenceTypeUnion: function() {
        var retval = new XQueryParser.p_SequenceTypeUnion_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var VBAR184 = null;
         var p_SequenceType183 = null;
         var p_SequenceType185 = null;

        var VBAR184_tree=null;

        try {
            // xquery/XQueryParser.g:761:9: ( p_SequenceType ( VBAR p_SequenceType )* )
            // xquery/XQueryParser.g:761:11: p_SequenceType ( VBAR p_SequenceType )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_SequenceType_in_p_SequenceTypeUnion5287);
            p_SequenceType183=this.p_SequenceType();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SequenceType183.getTree());
            // xquery/XQueryParser.g:761:26: ( VBAR p_SequenceType )*
            loop86:
            do {
                var alt86=2;
                var LA86_0 = this.input.LA(1);

                if ( (LA86_0==VBAR) ) {
                    alt86=1;
                }


                switch (alt86) {
                case 1 :
                    // xquery/XQueryParser.g:761:27: VBAR p_SequenceType
                    VBAR184=this.match(this.input,VBAR,XQueryParser.FOLLOW_VBAR_in_p_SequenceTypeUnion5290); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    VBAR184_tree = this.adaptor.create(VBAR184);
                    this.adaptor.addChild(root_0, VBAR184_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_SequenceType_in_p_SequenceTypeUnion5292);
                    p_SequenceType185=this.p_SequenceType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SequenceType185.getTree());


                    break;

                default :
                    break loop86;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_IfHybrid_return: (function() {
        XQueryParser.p_IfHybrid_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_IfHybrid_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:765:1: p_IfHybrid[strict] : k= IF LPAREN p_Expr[true,true] RPAREN k= THEN p_Hybrid[$strict,false] k= ELSE p_Hybrid[$strict,false] ;
    // $ANTLR start "p_IfHybrid"
    p_IfHybrid: function(strict) {
        var retval = new XQueryParser.p_IfHybrid_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LPAREN186 = null;
        var RPAREN188 = null;
         var p_Expr187 = null;
         var p_Hybrid189 = null;
         var p_Hybrid190 = null;

        var k_tree=null;
        var LPAREN186_tree=null;
        var RPAREN188_tree=null;

        try {
            // xquery/XQueryParser.g:766:9: (k= IF LPAREN p_Expr[true,true] RPAREN k= THEN p_Hybrid[$strict,false] k= ELSE p_Hybrid[$strict,false] )
            // xquery/XQueryParser.g:766:11: k= IF LPAREN p_Expr[true,true] RPAREN k= THEN p_Hybrid[$strict,false] k= ELSE p_Hybrid[$strict,false]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,IF,XQueryParser.FOLLOW_IF_in_p_IfHybrid5323); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            LPAREN186=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_IfHybrid5327); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN186_tree = this.adaptor.create(LPAREN186);
            this.adaptor.addChild(root_0, LPAREN186_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_IfHybrid5329);
            p_Expr187=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr187.getTree());
            RPAREN188=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_IfHybrid5332); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN188_tree = this.adaptor.create(RPAREN188);
            this.adaptor.addChild(root_0, RPAREN188_tree);
            }
            k=this.match(this.input,THEN,XQueryParser.FOLLOW_THEN_in_p_IfHybrid5336); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Hybrid_in_p_IfHybrid5340);
            p_Hybrid189=this.p_Hybrid(strict, false);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Hybrid189.getTree());
            k=this.match(this.input,ELSE,XQueryParser.FOLLOW_ELSE_in_p_IfHybrid5345); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Hybrid_in_p_IfHybrid5349);
            p_Hybrid190=this.p_Hybrid(strict, false);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Hybrid190.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TryCatchExpr_return: (function() {
        XQueryParser.p_TryCatchExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TryCatchExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:770:1: p_TryCatchExpr : p_TryClause ( p_CatchClause )+ ;
    // $ANTLR start "p_TryCatchExpr"
    p_TryCatchExpr: function() {
        var retval = new XQueryParser.p_TryCatchExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_TryClause191 = null;
         var p_CatchClause192 = null;


        try {
            // xquery/XQueryParser.g:771:9: ( p_TryClause ( p_CatchClause )+ )
            // xquery/XQueryParser.g:771:11: p_TryClause ( p_CatchClause )+
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_TryClause_in_p_TryCatchExpr5376);
            p_TryClause191=this.p_TryClause();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TryClause191.getTree());
            // xquery/XQueryParser.g:771:23: ( p_CatchClause )+
            var cnt87=0;
            loop87:
            do {
                var alt87=2;
                var LA87_0 = this.input.LA(1);

                if ( (LA87_0==CATCH) ) {
                    alt87=1;
                }


                switch (alt87) {
                case 1 :
                    // xquery/XQueryParser.g:771:23: p_CatchClause
                    this.pushFollow(XQueryParser.FOLLOW_p_CatchClause_in_p_TryCatchExpr5378);
                    p_CatchClause192=this.p_CatchClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CatchClause192.getTree());


                    break;

                default :
                    if ( cnt87 >= 1 ) {
                        break loop87;
                    }
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var eee = new org.antlr.runtime.EarlyExitException(87, this.input);
                        throw eee;
                }
                cnt87++;
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TryClause_return: (function() {
        XQueryParser.p_TryClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TryClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:775:1: p_TryClause : k= TRY LBRACKET p_TryTargetExpr RBRACKET ;
    // $ANTLR start "p_TryClause"
    p_TryClause: function() {
        var retval = new XQueryParser.p_TryClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET193 = null;
        var RBRACKET195 = null;
         var p_TryTargetExpr194 = null;

        var k_tree=null;
        var LBRACKET193_tree=null;
        var RBRACKET195_tree=null;

        try {
            // xquery/XQueryParser.g:776:9: (k= TRY LBRACKET p_TryTargetExpr RBRACKET )
            // xquery/XQueryParser.g:776:11: k= TRY LBRACKET p_TryTargetExpr RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,TRY,XQueryParser.FOLLOW_TRY_in_p_TryClause5407); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            LBRACKET193=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_TryClause5411); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET193_tree = this.adaptor.create(LBRACKET193);
            this.adaptor.addChild(root_0, LBRACKET193_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_TryTargetExpr_in_p_TryClause5413);
            p_TryTargetExpr194=this.p_TryTargetExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TryTargetExpr194.getTree());
            RBRACKET195=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_TryClause5415); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET195_tree = this.adaptor.create(RBRACKET195);
            this.adaptor.addChild(root_0, RBRACKET195_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TryTargetExpr_return: (function() {
        XQueryParser.p_TryTargetExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TryTargetExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:780:1: p_TryTargetExpr : p_Expr[false,false] ;
    // $ANTLR start "p_TryTargetExpr"
    p_TryTargetExpr: function() {
        var retval = new XQueryParser.p_TryTargetExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_Expr196 = null;


        try {
            // xquery/XQueryParser.g:781:9: ( p_Expr[false,false] )
            // xquery/XQueryParser.g:781:11: p_Expr[false,false]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_TryTargetExpr5441);
            p_Expr196=this.p_Expr(false, false);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr196.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CatchClause_return: (function() {
        XQueryParser.p_CatchClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CatchClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:785:1: p_CatchClause : k= CATCH p_CatchErrorList LBRACKET p_Expr[false,false] RBRACKET ;
    // $ANTLR start "p_CatchClause"
    p_CatchClause: function() {
        var retval = new XQueryParser.p_CatchClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET198 = null;
        var RBRACKET200 = null;
         var p_CatchErrorList197 = null;
         var p_Expr199 = null;

        var k_tree=null;
        var LBRACKET198_tree=null;
        var RBRACKET200_tree=null;

        try {
            // xquery/XQueryParser.g:786:9: (k= CATCH p_CatchErrorList LBRACKET p_Expr[false,false] RBRACKET )
            // xquery/XQueryParser.g:786:11: k= CATCH p_CatchErrorList LBRACKET p_Expr[false,false] RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,CATCH,XQueryParser.FOLLOW_CATCH_in_p_CatchClause5470); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_CatchErrorList_in_p_CatchClause5474);
            p_CatchErrorList197=this.p_CatchErrorList();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CatchErrorList197.getTree());
            LBRACKET198=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_CatchClause5476); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET198_tree = this.adaptor.create(LBRACKET198);
            this.adaptor.addChild(root_0, LBRACKET198_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_CatchClause5478);
            p_Expr199=this.p_Expr(false, false);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr199.getTree());
            RBRACKET200=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_CatchClause5481); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET200_tree = this.adaptor.create(RBRACKET200);
            this.adaptor.addChild(root_0, RBRACKET200_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CatchErrorList_return: (function() {
        XQueryParser.p_CatchErrorList_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CatchErrorList_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:790:1: p_CatchErrorList : ( p_NameTest ( VBAR p_NameTest )* | {...}? => () );
    // $ANTLR start "p_CatchErrorList"
    p_CatchErrorList: function() {
        var retval = new XQueryParser.p_CatchErrorList_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var VBAR202 = null;
         var p_NameTest201 = null;
         var p_NameTest203 = null;

        var VBAR202_tree=null;

        try {
            // xquery/XQueryParser.g:791:9: ( p_NameTest ( VBAR p_NameTest )* | {...}? => () )
            var alt89=2;
            var LA89_0 = this.input.LA(1);

            if ( ((LA89_0>=ANCESTOR && LA89_0<=SKIP)||(LA89_0>=VALUE && LA89_0<=QUOT_ER)||LA89_0==STAR||(LA89_0>=APOS && LA89_0<=QUOT)||LA89_0==L_NCName||LA89_0==EXPLICITLY) ) {
                alt89=1;
            }
            else if ( (LA89_0==LBRACKET) && ((this.lc(MLS)))) {
                alt89=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 89, 0, this.input);

                throw nvae;
            }
            switch (alt89) {
                case 1 :
                    // xquery/XQueryParser.g:791:11: p_NameTest ( VBAR p_NameTest )*
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_NameTest_in_p_CatchErrorList5507);
                    p_NameTest201=this.p_NameTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NameTest201.getTree());
                    // xquery/XQueryParser.g:791:22: ( VBAR p_NameTest )*
                    loop88:
                    do {
                        var alt88=2;
                        var LA88_0 = this.input.LA(1);

                        if ( (LA88_0==VBAR) ) {
                            alt88=1;
                        }


                        switch (alt88) {
                        case 1 :
                            // xquery/XQueryParser.g:791:23: VBAR p_NameTest
                            VBAR202=this.match(this.input,VBAR,XQueryParser.FOLLOW_VBAR_in_p_CatchErrorList5510); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            VBAR202_tree = this.adaptor.create(VBAR202);
                            this.adaptor.addChild(root_0, VBAR202_tree);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_NameTest_in_p_CatchErrorList5512);
                            p_NameTest203=this.p_NameTest();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NameTest203.getTree());


                            break;

                        default :
                            break loop88;
                        }
                    } while (true);



                    break;
                case 2 :
                    // xquery/XQueryParser.g:792:11: {...}? => ()
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(MLS))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "p_CatchErrorList", "this.lc(MLS)");
                    }
                    // xquery/XQueryParser.g:792:29: ()
                    // xquery/XQueryParser.g:792:43: 




                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_OrExpr_return: (function() {
        XQueryParser.p_OrExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_OrExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:796:1: p_OrExpr : p_AndExpr (k= OR p_AndExpr )* ;
    // $ANTLR start "p_OrExpr"
    p_OrExpr: function() {
        var retval = new XQueryParser.p_OrExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_AndExpr204 = null;
         var p_AndExpr205 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:797:9: ( p_AndExpr (k= OR p_AndExpr )* )
            // xquery/XQueryParser.g:797:11: p_AndExpr (k= OR p_AndExpr )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_AndExpr_in_p_OrExpr5557);
            p_AndExpr204=this.p_AndExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AndExpr204.getTree());
            // xquery/XQueryParser.g:797:21: (k= OR p_AndExpr )*
            loop90:
            do {
                var alt90=2;
                var LA90_0 = this.input.LA(1);

                if ( (LA90_0==OR) ) {
                    alt90=1;
                }


                switch (alt90) {
                case 1 :
                    // xquery/XQueryParser.g:797:23: k= OR p_AndExpr
                    k=this.match(this.input,OR,XQueryParser.FOLLOW_OR_in_p_OrExpr5563); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_AndExpr_in_p_OrExpr5567);
                    p_AndExpr205=this.p_AndExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AndExpr205.getTree());


                    break;

                default :
                    break loop90;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AndExpr_return: (function() {
        XQueryParser.p_AndExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AndExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:801:1: p_AndExpr : p_ComparisonExpr (k= AND p_ComparisonExpr )* ;
    // $ANTLR start "p_AndExpr"
    p_AndExpr: function() {
        var retval = new XQueryParser.p_AndExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_ComparisonExpr206 = null;
         var p_ComparisonExpr207 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:802:9: ( p_ComparisonExpr (k= AND p_ComparisonExpr )* )
            // xquery/XQueryParser.g:802:11: p_ComparisonExpr (k= AND p_ComparisonExpr )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ComparisonExpr_in_p_AndExpr5596);
            p_ComparisonExpr206=this.p_ComparisonExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ComparisonExpr206.getTree());
            // xquery/XQueryParser.g:802:28: (k= AND p_ComparisonExpr )*
            loop91:
            do {
                var alt91=2;
                var LA91_0 = this.input.LA(1);

                if ( (LA91_0==AND) ) {
                    alt91=1;
                }


                switch (alt91) {
                case 1 :
                    // xquery/XQueryParser.g:802:30: k= AND p_ComparisonExpr
                    k=this.match(this.input,AND,XQueryParser.FOLLOW_AND_in_p_AndExpr5602); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_ComparisonExpr_in_p_AndExpr5606);
                    p_ComparisonExpr207=this.p_ComparisonExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ComparisonExpr207.getTree());


                    break;

                default :
                    break loop91;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ComparisonExpr_return: (function() {
        XQueryParser.p_ComparisonExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ComparisonExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:807:1: p_ComparisonExpr : p_FTContainsExpr ( ( p_ValueComp | p_GeneralComp | p_NodeComp ) p_FTContainsExpr )? ;
    // $ANTLR start "p_ComparisonExpr"
    p_ComparisonExpr: function() {
        var retval = new XQueryParser.p_ComparisonExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_FTContainsExpr208 = null;
         var p_ValueComp209 = null;
         var p_GeneralComp210 = null;
         var p_NodeComp211 = null;
         var p_FTContainsExpr212 = null;


        try {
            // xquery/XQueryParser.g:808:9: ( p_FTContainsExpr ( ( p_ValueComp | p_GeneralComp | p_NodeComp ) p_FTContainsExpr )? )
            // xquery/XQueryParser.g:808:11: p_FTContainsExpr ( ( p_ValueComp | p_GeneralComp | p_NodeComp ) p_FTContainsExpr )?
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_FTContainsExpr_in_p_ComparisonExpr5636);
            p_FTContainsExpr208=this.p_FTContainsExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_FTContainsExpr208.getTree());
            // xquery/XQueryParser.g:808:28: ( ( p_ValueComp | p_GeneralComp | p_NodeComp ) p_FTContainsExpr )?
            var alt93=2;
            var LA93_0 = this.input.LA(1);

            if ( (LA93_0==EQ||LA93_0==GE||LA93_0==GT||LA93_0==IS||LA93_0==LE||LA93_0==LT||LA93_0==NE||LA93_0==EQUAL||LA93_0==NOTEQUAL||(LA93_0>=SMALLER && LA93_0<=GREATER_GREATER)) ) {
                alt93=1;
            }
            switch (alt93) {
                case 1 :
                    // xquery/XQueryParser.g:808:30: ( p_ValueComp | p_GeneralComp | p_NodeComp ) p_FTContainsExpr
                    // xquery/XQueryParser.g:808:30: ( p_ValueComp | p_GeneralComp | p_NodeComp )
                    var alt92=3;
                    switch ( this.input.LA(1) ) {
                    case EQ:
                    case GE:
                    case GT:
                    case LE:
                    case LT:
                    case NE:
                        alt92=1;
                        break;
                    case EQUAL:
                    case NOTEQUAL:
                    case SMALLER:
                    case GREATER:
                    case SMALLEREQ:
                    case GREATEREQ:
                        alt92=2;
                        break;
                    case IS:
                    case SMALLER_SMALLER:
                    case GREATER_GREATER:
                        alt92=3;
                        break;
                    default:
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var nvae =
                            new org.antlr.runtime.NoViableAltException("", 92, 0, this.input);

                        throw nvae;
                    }

                    switch (alt92) {
                        case 1 :
                            // xquery/XQueryParser.g:808:31: p_ValueComp
                            this.pushFollow(XQueryParser.FOLLOW_p_ValueComp_in_p_ComparisonExpr5641);
                            p_ValueComp209=this.p_ValueComp();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ValueComp209.getTree());


                            break;
                        case 2 :
                            // xquery/XQueryParser.g:808:45: p_GeneralComp
                            this.pushFollow(XQueryParser.FOLLOW_p_GeneralComp_in_p_ComparisonExpr5645);
                            p_GeneralComp210=this.p_GeneralComp();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_GeneralComp210.getTree());


                            break;
                        case 3 :
                            // xquery/XQueryParser.g:808:61: p_NodeComp
                            this.pushFollow(XQueryParser.FOLLOW_p_NodeComp_in_p_ComparisonExpr5649);
                            p_NodeComp211=this.p_NodeComp();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NodeComp211.getTree());


                            break;

                    }

                    this.pushFollow(XQueryParser.FOLLOW_p_FTContainsExpr_in_p_ComparisonExpr5652);
                    p_FTContainsExpr212=this.p_FTContainsExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_FTContainsExpr212.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_RangeExpr_return: (function() {
        XQueryParser.p_RangeExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_RangeExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:812:1: p_RangeExpr : p_AdditiveExpr (k= TO p_AdditiveExpr )? ;
    // $ANTLR start "p_RangeExpr"
    p_RangeExpr: function() {
        var retval = new XQueryParser.p_RangeExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_AdditiveExpr213 = null;
         var p_AdditiveExpr214 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:813:9: ( p_AdditiveExpr (k= TO p_AdditiveExpr )? )
            // xquery/XQueryParser.g:813:11: p_AdditiveExpr (k= TO p_AdditiveExpr )?
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_AdditiveExpr_in_p_RangeExpr5681);
            p_AdditiveExpr213=this.p_AdditiveExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AdditiveExpr213.getTree());
            // xquery/XQueryParser.g:813:26: (k= TO p_AdditiveExpr )?
            var alt94=2;
            var LA94_0 = this.input.LA(1);

            if ( (LA94_0==TO) ) {
                alt94=1;
            }
            switch (alt94) {
                case 1 :
                    // xquery/XQueryParser.g:813:28: k= TO p_AdditiveExpr
                    k=this.match(this.input,TO,XQueryParser.FOLLOW_TO_in_p_RangeExpr5687); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_AdditiveExpr_in_p_RangeExpr5691);
                    p_AdditiveExpr214=this.p_AdditiveExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AdditiveExpr214.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AdditiveExpr_return: (function() {
        XQueryParser.p_AdditiveExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AdditiveExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:817:1: p_AdditiveExpr : p_MultiplicativeExpr ( (o= PLUS | o= MINUS ) p_MultiplicativeExpr )* ;
    // $ANTLR start "p_AdditiveExpr"
    p_AdditiveExpr: function() {
        var retval = new XQueryParser.p_AdditiveExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var o = null;
         var p_MultiplicativeExpr215 = null;
         var p_MultiplicativeExpr216 = null;

        var o_tree=null;

        try {
            // xquery/XQueryParser.g:818:9: ( p_MultiplicativeExpr ( (o= PLUS | o= MINUS ) p_MultiplicativeExpr )* )
            // xquery/XQueryParser.g:818:11: p_MultiplicativeExpr ( (o= PLUS | o= MINUS ) p_MultiplicativeExpr )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_MultiplicativeExpr_in_p_AdditiveExpr5720);
            p_MultiplicativeExpr215=this.p_MultiplicativeExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_MultiplicativeExpr215.getTree());
            // xquery/XQueryParser.g:818:32: ( (o= PLUS | o= MINUS ) p_MultiplicativeExpr )*
            loop96:
            do {
                var alt96=2;
                var LA96_0 = this.input.LA(1);

                if ( ((LA96_0>=PLUS && LA96_0<=MINUS)) ) {
                    alt96=1;
                }


                switch (alt96) {
                case 1 :
                    // xquery/XQueryParser.g:818:34: (o= PLUS | o= MINUS ) p_MultiplicativeExpr
                    // xquery/XQueryParser.g:818:34: (o= PLUS | o= MINUS )
                    var alt95=2;
                    var LA95_0 = this.input.LA(1);

                    if ( (LA95_0==PLUS) ) {
                        alt95=1;
                    }
                    else if ( (LA95_0==MINUS) ) {
                        alt95=2;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var nvae =
                            new org.antlr.runtime.NoViableAltException("", 95, 0, this.input);

                        throw nvae;
                    }
                    switch (alt95) {
                        case 1 :
                            // xquery/XQueryParser.g:818:35: o= PLUS
                            o=this.match(this.input,PLUS,XQueryParser.FOLLOW_PLUS_in_p_AdditiveExpr5727); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            o_tree = this.adaptor.create(o);
                            this.adaptor.addChild(root_0, o_tree);
                            }
                            if ( this.state.backtracking===0 ) {
                              this.ao(o);
                            }


                            break;
                        case 2 :
                            // xquery/XQueryParser.g:818:59: o= MINUS
                            o=this.match(this.input,MINUS,XQueryParser.FOLLOW_MINUS_in_p_AdditiveExpr5735); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            o_tree = this.adaptor.create(o);
                            this.adaptor.addChild(root_0, o_tree);
                            }
                            if ( this.state.backtracking===0 ) {
                              this.ao(o);
                            }


                            break;

                    }

                    this.pushFollow(XQueryParser.FOLLOW_p_MultiplicativeExpr_in_p_AdditiveExpr5740);
                    p_MultiplicativeExpr216=this.p_MultiplicativeExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_MultiplicativeExpr216.getTree());


                    break;

                default :
                    break loop96;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_MultiplicativeExpr_return: (function() {
        XQueryParser.p_MultiplicativeExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_MultiplicativeExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:822:1: p_MultiplicativeExpr : p_UnionExpr ( (o= STAR | (k= DIV | k= IDIV | k= MOD ) ) p_UnionExpr )* ;
    // $ANTLR start "p_MultiplicativeExpr"
    p_MultiplicativeExpr: function() {
        var retval = new XQueryParser.p_MultiplicativeExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var o = null;
        var k = null;
         var p_UnionExpr217 = null;
         var p_UnionExpr218 = null;

        var o_tree=null;
        var k_tree=null;

        try {
            // xquery/XQueryParser.g:823:9: ( p_UnionExpr ( (o= STAR | (k= DIV | k= IDIV | k= MOD ) ) p_UnionExpr )* )
            // xquery/XQueryParser.g:823:11: p_UnionExpr ( (o= STAR | (k= DIV | k= IDIV | k= MOD ) ) p_UnionExpr )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_UnionExpr_in_p_MultiplicativeExpr5769);
            p_UnionExpr217=this.p_UnionExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_UnionExpr217.getTree());
            // xquery/XQueryParser.g:823:23: ( (o= STAR | (k= DIV | k= IDIV | k= MOD ) ) p_UnionExpr )*
            loop99:
            do {
                var alt99=2;
                var LA99_0 = this.input.LA(1);

                if ( (LA99_0==DIV||LA99_0==IDIV||LA99_0==MOD||LA99_0==STAR) ) {
                    alt99=1;
                }


                switch (alt99) {
                case 1 :
                    // xquery/XQueryParser.g:823:25: (o= STAR | (k= DIV | k= IDIV | k= MOD ) ) p_UnionExpr
                    // xquery/XQueryParser.g:823:25: (o= STAR | (k= DIV | k= IDIV | k= MOD ) )
                    var alt98=2;
                    var LA98_0 = this.input.LA(1);

                    if ( (LA98_0==STAR) ) {
                        alt98=1;
                    }
                    else if ( (LA98_0==DIV||LA98_0==IDIV||LA98_0==MOD) ) {
                        alt98=2;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var nvae =
                            new org.antlr.runtime.NoViableAltException("", 98, 0, this.input);

                        throw nvae;
                    }
                    switch (alt98) {
                        case 1 :
                            // xquery/XQueryParser.g:823:26: o= STAR
                            o=this.match(this.input,STAR,XQueryParser.FOLLOW_STAR_in_p_MultiplicativeExpr5776); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            o_tree = this.adaptor.create(o);
                            this.adaptor.addChild(root_0, o_tree);
                            }
                            if ( this.state.backtracking===0 ) {
                              this.ao(o);
                            }


                            break;
                        case 2 :
                            // xquery/XQueryParser.g:823:50: (k= DIV | k= IDIV | k= MOD )
                            // xquery/XQueryParser.g:823:50: (k= DIV | k= IDIV | k= MOD )
                            var alt97=3;
                            switch ( this.input.LA(1) ) {
                            case DIV:
                                alt97=1;
                                break;
                            case IDIV:
                                alt97=2;
                                break;
                            case MOD:
                                alt97=3;
                                break;
                            default:
                                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                                var nvae =
                                    new org.antlr.runtime.NoViableAltException("", 97, 0, this.input);

                                throw nvae;
                            }

                            switch (alt97) {
                                case 1 :
                                    // xquery/XQueryParser.g:823:51: k= DIV
                                    k=this.match(this.input,DIV,XQueryParser.FOLLOW_DIV_in_p_MultiplicativeExpr5785); if (this.state.failed) return retval;
                                    if ( this.state.backtracking===0 ) {
                                    k_tree = this.adaptor.create(k);
                                    this.adaptor.addChild(root_0, k_tree);
                                    }


                                    break;
                                case 2 :
                                    // xquery/XQueryParser.g:823:59: k= IDIV
                                    k=this.match(this.input,IDIV,XQueryParser.FOLLOW_IDIV_in_p_MultiplicativeExpr5791); if (this.state.failed) return retval;
                                    if ( this.state.backtracking===0 ) {
                                    k_tree = this.adaptor.create(k);
                                    this.adaptor.addChild(root_0, k_tree);
                                    }


                                    break;
                                case 3 :
                                    // xquery/XQueryParser.g:823:68: k= MOD
                                    k=this.match(this.input,MOD,XQueryParser.FOLLOW_MOD_in_p_MultiplicativeExpr5797); if (this.state.failed) return retval;
                                    if ( this.state.backtracking===0 ) {
                                    k_tree = this.adaptor.create(k);
                                    this.adaptor.addChild(root_0, k_tree);
                                    }


                                    break;

                            }

                            if ( this.state.backtracking===0 ) {
                              this.ak(k);
                            }


                            break;

                    }

                    this.pushFollow(XQueryParser.FOLLOW_p_UnionExpr_in_p_MultiplicativeExpr5803);
                    p_UnionExpr218=this.p_UnionExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_UnionExpr218.getTree());


                    break;

                default :
                    break loop99;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_UnionExpr_return: (function() {
        XQueryParser.p_UnionExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_UnionExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:827:1: p_UnionExpr : p_IntersectExceptExpr ( (k= UNION | VBAR ) p_IntersectExceptExpr )* ;
    // $ANTLR start "p_UnionExpr"
    p_UnionExpr: function() {
        var retval = new XQueryParser.p_UnionExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var VBAR220 = null;
         var p_IntersectExceptExpr219 = null;
         var p_IntersectExceptExpr221 = null;

        var k_tree=null;
        var VBAR220_tree=null;

        try {
            // xquery/XQueryParser.g:828:9: ( p_IntersectExceptExpr ( (k= UNION | VBAR ) p_IntersectExceptExpr )* )
            // xquery/XQueryParser.g:828:11: p_IntersectExceptExpr ( (k= UNION | VBAR ) p_IntersectExceptExpr )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_IntersectExceptExpr_in_p_UnionExpr5832);
            p_IntersectExceptExpr219=this.p_IntersectExceptExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_IntersectExceptExpr219.getTree());
            // xquery/XQueryParser.g:828:33: ( (k= UNION | VBAR ) p_IntersectExceptExpr )*
            loop101:
            do {
                var alt101=2;
                var LA101_0 = this.input.LA(1);

                if ( (LA101_0==UNION||LA101_0==VBAR) ) {
                    alt101=1;
                }


                switch (alt101) {
                case 1 :
                    // xquery/XQueryParser.g:828:35: (k= UNION | VBAR ) p_IntersectExceptExpr
                    // xquery/XQueryParser.g:828:35: (k= UNION | VBAR )
                    var alt100=2;
                    var LA100_0 = this.input.LA(1);

                    if ( (LA100_0==UNION) ) {
                        alt100=1;
                    }
                    else if ( (LA100_0==VBAR) ) {
                        alt100=2;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var nvae =
                            new org.antlr.runtime.NoViableAltException("", 100, 0, this.input);

                        throw nvae;
                    }
                    switch (alt100) {
                        case 1 :
                            // xquery/XQueryParser.g:828:36: k= UNION
                            k=this.match(this.input,UNION,XQueryParser.FOLLOW_UNION_in_p_UnionExpr5839); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            k_tree = this.adaptor.create(k);
                            this.adaptor.addChild(root_0, k_tree);
                            }
                            if ( this.state.backtracking===0 ) {
                              this.ak(k);
                            }


                            break;
                        case 2 :
                            // xquery/XQueryParser.g:828:61: VBAR
                            VBAR220=this.match(this.input,VBAR,XQueryParser.FOLLOW_VBAR_in_p_UnionExpr5845); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            VBAR220_tree = this.adaptor.create(VBAR220);
                            this.adaptor.addChild(root_0, VBAR220_tree);
                            }


                            break;

                    }

                    this.pushFollow(XQueryParser.FOLLOW_p_IntersectExceptExpr_in_p_UnionExpr5848);
                    p_IntersectExceptExpr221=this.p_IntersectExceptExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_IntersectExceptExpr221.getTree());


                    break;

                default :
                    break loop101;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_IntersectExceptExpr_return: (function() {
        XQueryParser.p_IntersectExceptExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_IntersectExceptExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:832:1: p_IntersectExceptExpr : p_InstanceofExpr ( (k= INTERSECT | k= EXCEPT ) p_InstanceofExpr )* ;
    // $ANTLR start "p_IntersectExceptExpr"
    p_IntersectExceptExpr: function() {
        var retval = new XQueryParser.p_IntersectExceptExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_InstanceofExpr222 = null;
         var p_InstanceofExpr223 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:833:9: ( p_InstanceofExpr ( (k= INTERSECT | k= EXCEPT ) p_InstanceofExpr )* )
            // xquery/XQueryParser.g:833:11: p_InstanceofExpr ( (k= INTERSECT | k= EXCEPT ) p_InstanceofExpr )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_InstanceofExpr_in_p_IntersectExceptExpr5877);
            p_InstanceofExpr222=this.p_InstanceofExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_InstanceofExpr222.getTree());
            // xquery/XQueryParser.g:833:28: ( (k= INTERSECT | k= EXCEPT ) p_InstanceofExpr )*
            loop103:
            do {
                var alt103=2;
                var LA103_0 = this.input.LA(1);

                if ( (LA103_0==EXCEPT||LA103_0==INTERSECT) ) {
                    alt103=1;
                }


                switch (alt103) {
                case 1 :
                    // xquery/XQueryParser.g:833:30: (k= INTERSECT | k= EXCEPT ) p_InstanceofExpr
                    // xquery/XQueryParser.g:833:30: (k= INTERSECT | k= EXCEPT )
                    var alt102=2;
                    var LA102_0 = this.input.LA(1);

                    if ( (LA102_0==INTERSECT) ) {
                        alt102=1;
                    }
                    else if ( (LA102_0==EXCEPT) ) {
                        alt102=2;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var nvae =
                            new org.antlr.runtime.NoViableAltException("", 102, 0, this.input);

                        throw nvae;
                    }
                    switch (alt102) {
                        case 1 :
                            // xquery/XQueryParser.g:833:31: k= INTERSECT
                            k=this.match(this.input,INTERSECT,XQueryParser.FOLLOW_INTERSECT_in_p_IntersectExceptExpr5884); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            k_tree = this.adaptor.create(k);
                            this.adaptor.addChild(root_0, k_tree);
                            }


                            break;
                        case 2 :
                            // xquery/XQueryParser.g:833:45: k= EXCEPT
                            k=this.match(this.input,EXCEPT,XQueryParser.FOLLOW_EXCEPT_in_p_IntersectExceptExpr5890); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            k_tree = this.adaptor.create(k);
                            this.adaptor.addChild(root_0, k_tree);
                            }


                            break;

                    }

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_InstanceofExpr_in_p_IntersectExceptExpr5895);
                    p_InstanceofExpr223=this.p_InstanceofExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_InstanceofExpr223.getTree());


                    break;

                default :
                    break loop103;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_InstanceofExpr_return: (function() {
        XQueryParser.p_InstanceofExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_InstanceofExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:837:1: p_InstanceofExpr : p_TreatExpr (k= INSTANCE k= OF p_SequenceType )? ;
    // $ANTLR start "p_InstanceofExpr"
    p_InstanceofExpr: function() {
        var retval = new XQueryParser.p_InstanceofExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_TreatExpr224 = null;
         var p_SequenceType225 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:838:9: ( p_TreatExpr (k= INSTANCE k= OF p_SequenceType )? )
            // xquery/XQueryParser.g:838:11: p_TreatExpr (k= INSTANCE k= OF p_SequenceType )?
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_TreatExpr_in_p_InstanceofExpr5924);
            p_TreatExpr224=this.p_TreatExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TreatExpr224.getTree());
            // xquery/XQueryParser.g:838:23: (k= INSTANCE k= OF p_SequenceType )?
            var alt104=2;
            var LA104_0 = this.input.LA(1);

            if ( (LA104_0==INSTANCE) ) {
                alt104=1;
            }
            switch (alt104) {
                case 1 :
                    // xquery/XQueryParser.g:838:25: k= INSTANCE k= OF p_SequenceType
                    k=this.match(this.input,INSTANCE,XQueryParser.FOLLOW_INSTANCE_in_p_InstanceofExpr5930); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    k=this.match(this.input,OF,XQueryParser.FOLLOW_OF_in_p_InstanceofExpr5936); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_SequenceType_in_p_InstanceofExpr5940);
                    p_SequenceType225=this.p_SequenceType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SequenceType225.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TreatExpr_return: (function() {
        XQueryParser.p_TreatExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TreatExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:842:1: p_TreatExpr : p_CastableExpr (k= TREAT k= AS p_SequenceType )? ;
    // $ANTLR start "p_TreatExpr"
    p_TreatExpr: function() {
        var retval = new XQueryParser.p_TreatExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_CastableExpr226 = null;
         var p_SequenceType227 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:843:9: ( p_CastableExpr (k= TREAT k= AS p_SequenceType )? )
            // xquery/XQueryParser.g:843:11: p_CastableExpr (k= TREAT k= AS p_SequenceType )?
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_CastableExpr_in_p_TreatExpr5968);
            p_CastableExpr226=this.p_CastableExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CastableExpr226.getTree());
            // xquery/XQueryParser.g:843:26: (k= TREAT k= AS p_SequenceType )?
            var alt105=2;
            var LA105_0 = this.input.LA(1);

            if ( (LA105_0==TREAT) ) {
                alt105=1;
            }
            switch (alt105) {
                case 1 :
                    // xquery/XQueryParser.g:843:28: k= TREAT k= AS p_SequenceType
                    k=this.match(this.input,TREAT,XQueryParser.FOLLOW_TREAT_in_p_TreatExpr5974); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_p_TreatExpr5980); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_SequenceType_in_p_TreatExpr5984);
                    p_SequenceType227=this.p_SequenceType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SequenceType227.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CastableExpr_return: (function() {
        XQueryParser.p_CastableExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CastableExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:847:1: p_CastableExpr : p_CastExpr (k= CASTABLE k= AS p_SingleType )? ;
    // $ANTLR start "p_CastableExpr"
    p_CastableExpr: function() {
        var retval = new XQueryParser.p_CastableExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_CastExpr228 = null;
         var p_SingleType229 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:848:9: ( p_CastExpr (k= CASTABLE k= AS p_SingleType )? )
            // xquery/XQueryParser.g:848:11: p_CastExpr (k= CASTABLE k= AS p_SingleType )?
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_CastExpr_in_p_CastableExpr6021);
            p_CastExpr228=this.p_CastExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CastExpr228.getTree());
            // xquery/XQueryParser.g:848:22: (k= CASTABLE k= AS p_SingleType )?
            var alt106=2;
            var LA106_0 = this.input.LA(1);

            if ( (LA106_0==CASTABLE) ) {
                alt106=1;
            }
            switch (alt106) {
                case 1 :
                    // xquery/XQueryParser.g:848:24: k= CASTABLE k= AS p_SingleType
                    k=this.match(this.input,CASTABLE,XQueryParser.FOLLOW_CASTABLE_in_p_CastableExpr6027); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_p_CastableExpr6033); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_SingleType_in_p_CastableExpr6037);
                    p_SingleType229=this.p_SingleType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SingleType229.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CastExpr_return: (function() {
        XQueryParser.p_CastExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CastExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:852:1: p_CastExpr : p_UnaryExpr (k= CAST k= AS p_SingleType )? ;
    // $ANTLR start "p_CastExpr"
    p_CastExpr: function() {
        var retval = new XQueryParser.p_CastExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_UnaryExpr230 = null;
         var p_SingleType231 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:853:9: ( p_UnaryExpr (k= CAST k= AS p_SingleType )? )
            // xquery/XQueryParser.g:853:11: p_UnaryExpr (k= CAST k= AS p_SingleType )?
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_UnaryExpr_in_p_CastExpr6074);
            p_UnaryExpr230=this.p_UnaryExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_UnaryExpr230.getTree());
            // xquery/XQueryParser.g:853:23: (k= CAST k= AS p_SingleType )?
            var alt107=2;
            var LA107_0 = this.input.LA(1);

            if ( (LA107_0==CAST) ) {
                alt107=1;
            }
            switch (alt107) {
                case 1 :
                    // xquery/XQueryParser.g:853:25: k= CAST k= AS p_SingleType
                    k=this.match(this.input,CAST,XQueryParser.FOLLOW_CAST_in_p_CastExpr6080); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_p_CastExpr6086); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_SingleType_in_p_CastExpr6090);
                    p_SingleType231=this.p_SingleType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SingleType231.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_UnaryExpr_return: (function() {
        XQueryParser.p_UnaryExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_UnaryExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:857:1: p_UnaryExpr : (o= PLUS | o= MINUS )* p_ValueExpr -> ^( UnaryExpr ( PLUS )* p_ValueExpr ) ;
    // $ANTLR start "p_UnaryExpr"
    p_UnaryExpr: function() {
        var retval = new XQueryParser.p_UnaryExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var o = null;
         var p_ValueExpr232 = null;

        var o_tree=null;
        var stream_PLUS=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token PLUS");
        var stream_MINUS=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token MINUS");
        var stream_p_ValueExpr=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_ValueExpr");
        try {
            // xquery/XQueryParser.g:858:9: ( (o= PLUS | o= MINUS )* p_ValueExpr -> ^( UnaryExpr ( PLUS )* p_ValueExpr ) )
            // xquery/XQueryParser.g:858:11: (o= PLUS | o= MINUS )* p_ValueExpr
            // xquery/XQueryParser.g:858:11: (o= PLUS | o= MINUS )*
            loop108:
            do {
                var alt108=3;
                var LA108_0 = this.input.LA(1);

                if ( (LA108_0==PLUS) ) {
                    alt108=1;
                }
                else if ( (LA108_0==MINUS) ) {
                    alt108=2;
                }


                switch (alt108) {
                case 1 :
                    // xquery/XQueryParser.g:858:12: o= PLUS
                    o=this.match(this.input,PLUS,XQueryParser.FOLLOW_PLUS_in_p_UnaryExpr6122); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_PLUS.add(o);

                    if ( this.state.backtracking===0 ) {
                      this.ao(o);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:858:36: o= MINUS
                    o=this.match(this.input,MINUS,XQueryParser.FOLLOW_MINUS_in_p_UnaryExpr6130); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_MINUS.add(o);

                    if ( this.state.backtracking===0 ) {
                      this.ao(o);
                    }


                    break;

                default :
                    break loop108;
                }
            } while (true);

            this.pushFollow(XQueryParser.FOLLOW_p_ValueExpr_in_p_UnaryExpr6135);
            p_ValueExpr232=this.p_ValueExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_ValueExpr.add(p_ValueExpr232.getTree());


            // AST REWRITE
            // elements: p_ValueExpr, PLUS
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 859:17: -> ^( UnaryExpr ( PLUS )* p_ValueExpr )
            {
                // xquery/XQueryParser.g:859:20: ^( UnaryExpr ( PLUS )* p_ValueExpr )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(UnaryExpr, "UnaryExpr"), root_1);

                // xquery/XQueryParser.g:859:32: ( PLUS )*
                while ( stream_PLUS.hasNext() ) {
                    this.adaptor.addChild(root_1, stream_PLUS.nextNode());

                }
                stream_PLUS.reset();
                this.adaptor.addChild(root_1, stream_p_ValueExpr.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ValueExpr_return: (function() {
        XQueryParser.p_ValueExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ValueExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:863:1: p_ValueExpr : ( ( VALIDATE ( p_ValidationMode | TYPE )? )=> p_ValidateExpr | p_PathExpr | p_ExtensionExpr );
    // $ANTLR start "p_ValueExpr"
    p_ValueExpr: function() {
        var retval = new XQueryParser.p_ValueExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ValidateExpr233 = null;
         var p_PathExpr234 = null;
         var p_ExtensionExpr235 = null;


        try {
            // xquery/XQueryParser.g:864:9: ( ( VALIDATE ( p_ValidationMode | TYPE )? )=> p_ValidateExpr | p_PathExpr | p_ExtensionExpr )
            var alt109=3;
            switch ( this.input.LA(1) ) {
            case VALIDATE:
                var LA109_1 = this.input.LA(2);

                if ( (LA109_1==LAX) && (this.synpred6_XQueryParser())) {
                    alt109=1;
                }
                else if ( (LA109_1==STRICT) && (this.synpred6_XQueryParser())) {
                    alt109=1;
                }
                else if ( (LA109_1==TYPE) && (this.synpred6_XQueryParser())) {
                    alt109=1;
                }
                else if ( (LA109_1==LBRACKET) && (this.synpred6_XQueryParser())) {
                    alt109=1;
                }
                else if ( (LA109_1==EOF||(LA109_1>=AND && LA109_1<=ASCENDING)||(LA109_1>=CASE && LA109_1<=CASTABLE)||LA109_1==COLLATION||LA109_1==DEFAULT||(LA109_1>=DESCENDING && LA109_1<=DIV)||LA109_1==EMPTY||LA109_1==EQ||LA109_1==EXCEPT||LA109_1==FOR||LA109_1==GE||(LA109_1>=GT && LA109_1<=IDIV)||(LA109_1>=INSTANCE && LA109_1<=IS)||LA109_1==LE||(LA109_1>=LET && LA109_1<=MOD)||LA109_1==NE||(LA109_1>=OR && LA109_1<=ORDER)||(LA109_1>=RETURN && LA109_1<=SATISFIES)||LA109_1==STABLE||(LA109_1>=TO && LA109_1<=TREAT)||LA109_1==UNION||LA109_1==WHERE||LA109_1==COUNT||(LA109_1>=END && LA109_1<=GROUP)||LA109_1==ONLY||LA109_1==START||(LA109_1>=AFTER && LA109_1<=BEFORE)||LA109_1==INTO||LA109_1==MODIFY||LA109_1==WITH||LA109_1==CONTAINS||LA109_1==PARAGRAPHS||LA109_1==SENTENCES||LA109_1==TIMES||LA109_1==WORDS||(LA109_1>=CONCAT && LA109_1<=RPAREN)||(LA109_1>=RBRACKET && LA109_1<=EQUAL)||LA109_1==NOTEQUAL||LA109_1==COMMA||(LA109_1>=STAR && LA109_1<=SLASH_SLASH)||LA109_1==COLON||(LA109_1>=SEMICOLON && LA109_1<=VBAR)) ) {
                    alt109=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 109, 1, this.input);

                    throw nvae;
                }
                break;
            case ANCESTOR:
            case ANCESTOR_OR_SELF:
            case AND:
            case AS:
            case ASCENDING:
            case AT:
            case ATTRIBUTE:
            case BASE_URI:
            case BOUNDARY_SPACE:
            case BY:
            case CASE:
            case CAST:
            case CASTABLE:
            case CHILD:
            case COLLATION:
            case COMMENT:
            case CONSTRUCTION:
            case COPY_NAMESPACES:
            case DECLARE:
            case DEFAULT:
            case DESCENDANT:
            case DESCENDANT_OR_SELF:
            case DESCENDING:
            case DIV:
            case DOCUMENT:
            case DOCUMENT_NODE:
            case ELEMENT:
            case ELSE:
            case EMPTY:
            case EMPTY_SEQUENCE:
            case ENCODING:
            case EQ:
            case EVERY:
            case EXCEPT:
            case EXTERNAL:
            case FOLLOWING:
            case FOLLOWING_SIBLING:
            case FOR:
            case FUNCTION:
            case GE:
            case GREATEST:
            case GT:
            case IDIV:
            case IF:
            case IMPORT:
            case IN:
            case INHERIT:
            case INSTANCE:
            case INTERSECT:
            case IS:
            case ITEM:
            case LAX:
            case LE:
            case LEAST:
            case LET:
            case LT:
            case MOD:
            case MODULE:
            case NAMESPACE:
            case NE:
            case NO_INHERIT:
            case NO_PRESERVE:
            case NODE:
            case OF:
            case OPTION:
            case OR:
            case ORDER:
            case ORDERED:
            case ORDERING:
            case PARENT:
            case PRECEDING:
            case PRECEDING_SIBLING:
            case PRESERVE:
            case PROCESSING_INSTRUCTION:
            case RETURN:
            case SATISFIES:
            case SCHEMA:
            case SCHEMA_ATTRIBUTE:
            case SCHEMA_ELEMENT:
            case SELF:
            case SOME:
            case STABLE:
            case STRICT:
            case STRIP:
            case TEXT:
            case THEN:
            case TO:
            case TREAT:
            case TYPESWITCH:
            case UNION:
            case UNORDERED:
            case VARIABLE:
            case VERSION:
            case WHERE:
            case XQUERY:
            case ALLOWING:
            case CATCH:
            case CONTEXT:
            case COUNT:
            case DECIMAL_FORMAT:
            case DECIMAL_SEPARATOR:
            case DIGIT:
            case END:
            case GROUP:
            case GROUPING_SEPARATOR:
            case INFINITY:
            case MINUS_SIGN:
            case NAMESPACE_NODE:
            case NAN:
            case NEXT:
            case ONLY:
            case PATTERN_SEPARATOR:
            case PERCENT:
            case PER_MILLE:
            case PREVIOUS:
            case SLIDING:
            case START:
            case SWITCH:
            case TRY:
            case TUMBLING:
            case TYPE:
            case WHEN:
            case WINDOW:
            case ZERO_DIGIT:
            case AFTER:
            case BEFORE:
            case COPY:
            case DELETE:
            case FIRST:
            case INSERT:
            case INTO:
            case LAST:
            case MODIFY:
            case NODES:
            case RENAME:
            case REPLACE:
            case REVALIDATION:
            case SKIP:
            case UPDATING:
            case VALUE:
            case WITH:
            case ALL:
            case ANY:
            case CONTAINS:
            case CONTENT:
            case DIACRITICS:
            case DIFFERENT:
            case DISTANCE:
            case ENTIRE:
            case EXACTLY:
            case FROM:
            case FT_OPTION:
            case FTAND:
            case FTNOT:
            case FTOR:
            case INSENSITIVE:
            case LANGUAGE:
            case LEVELS:
            case LOWERCASE:
            case MOST:
            case NO:
            case NOT:
            case OCCURS:
            case PARAGRAPH:
            case PARAGRAPHS:
            case PHRASE:
            case RELATIONSHIP:
            case SAME:
            case SCORE:
            case SENSITIVE:
            case SENTENCE:
            case SENTENCES:
            case STEMMING:
            case STOP:
            case THESAURUS:
            case TIMES:
            case UPPERCASE:
            case USING:
            case WEIGHT:
            case WILDCARDS:
            case WITHOUT:
            case WORD:
            case WORDS:
            case BREAK:
            case CONTINUE:
            case EXIT:
            case LOOP:
            case RETURNING:
            case WHILE:
            case CHECK:
            case COLLECTION:
            case CONSTRAINT:
            case FOREACH:
            case FOREIGN:
            case INDEX:
            case INTEGRITY:
            case KEY:
            case ON:
            case UNIQUE:
            case BINARY:
            case AMP_ER:
            case APOS_ER:
            case QUOT_ER:
            case LPAREN:
            case DOLLAR:
            case LBRACKET:
            case STAR:
            case SMALLER:
            case SLASH:
            case SLASH_SLASH:
            case DOT:
            case DOT_DOT:
            case ATTR_SIGN:
            case APOS:
            case QUOT:
            case L_NCName:
            case L_DirCommentConstructor:
            case L_DirPIConstructor:
            case L_IntegerLiteral:
            case L_DecimalLiteral:
            case L_DoubleLiteral:
            case EXPLICITLY:
                alt109=2;
                break;
            case L_Pragma:
                alt109=3;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 109, 0, this.input);

                throw nvae;
            }

            switch (alt109) {
                case 1 :
                    // xquery/XQueryParser.g:864:11: ( VALIDATE ( p_ValidationMode | TYPE )? )=> p_ValidateExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ValidateExpr_in_p_ValueExpr6205);
                    p_ValidateExpr233=this.p_ValidateExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ValidateExpr233.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:865:11: p_PathExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_PathExpr_in_p_ValueExpr6217);
                    p_PathExpr234=this.p_PathExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PathExpr234.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:866:11: p_ExtensionExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ExtensionExpr_in_p_ValueExpr6229);
                    p_ExtensionExpr235=this.p_ExtensionExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExtensionExpr235.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_GeneralComp_return: (function() {
        XQueryParser.p_GeneralComp_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_GeneralComp_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:870:1: p_GeneralComp : (o= EQUAL | o= NOTEQUAL | o= SMALLER | o= SMALLEREQ | o= GREATER | o= GREATEREQ ) ;
    // $ANTLR start "p_GeneralComp"
    p_GeneralComp: function() {
        var retval = new XQueryParser.p_GeneralComp_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var o = null;

        var o_tree=null;

        try {
            // xquery/XQueryParser.g:871:9: ( (o= EQUAL | o= NOTEQUAL | o= SMALLER | o= SMALLEREQ | o= GREATER | o= GREATEREQ ) )
            // xquery/XQueryParser.g:871:11: (o= EQUAL | o= NOTEQUAL | o= SMALLER | o= SMALLEREQ | o= GREATER | o= GREATEREQ )
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:871:11: (o= EQUAL | o= NOTEQUAL | o= SMALLER | o= SMALLEREQ | o= GREATER | o= GREATEREQ )
            var alt110=6;
            switch ( this.input.LA(1) ) {
            case EQUAL:
                alt110=1;
                break;
            case NOTEQUAL:
                alt110=2;
                break;
            case SMALLER:
                alt110=3;
                break;
            case SMALLEREQ:
                alt110=4;
                break;
            case GREATER:
                alt110=5;
                break;
            case GREATEREQ:
                alt110=6;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 110, 0, this.input);

                throw nvae;
            }

            switch (alt110) {
                case 1 :
                    // xquery/XQueryParser.g:871:12: o= EQUAL
                    o=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_p_GeneralComp6258); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    o_tree = this.adaptor.create(o);
                    this.adaptor.addChild(root_0, o_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:871:22: o= NOTEQUAL
                    o=this.match(this.input,NOTEQUAL,XQueryParser.FOLLOW_NOTEQUAL_in_p_GeneralComp6264); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    o_tree = this.adaptor.create(o);
                    this.adaptor.addChild(root_0, o_tree);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:871:35: o= SMALLER
                    o=this.match(this.input,SMALLER,XQueryParser.FOLLOW_SMALLER_in_p_GeneralComp6270); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    o_tree = this.adaptor.create(o);
                    this.adaptor.addChild(root_0, o_tree);
                    }


                    break;
                case 4 :
                    // xquery/XQueryParser.g:871:47: o= SMALLEREQ
                    o=this.match(this.input,SMALLEREQ,XQueryParser.FOLLOW_SMALLEREQ_in_p_GeneralComp6276); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    o_tree = this.adaptor.create(o);
                    this.adaptor.addChild(root_0, o_tree);
                    }


                    break;
                case 5 :
                    // xquery/XQueryParser.g:871:61: o= GREATER
                    o=this.match(this.input,GREATER,XQueryParser.FOLLOW_GREATER_in_p_GeneralComp6282); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    o_tree = this.adaptor.create(o);
                    this.adaptor.addChild(root_0, o_tree);
                    }


                    break;
                case 6 :
                    // xquery/XQueryParser.g:871:73: o= GREATEREQ
                    o=this.match(this.input,GREATEREQ,XQueryParser.FOLLOW_GREATEREQ_in_p_GeneralComp6288); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    o_tree = this.adaptor.create(o);
                    this.adaptor.addChild(root_0, o_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
               this.ao(o); 
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ValueComp_return: (function() {
        XQueryParser.p_ValueComp_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ValueComp_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:875:1: p_ValueComp : (k= EQ | k= NE | k= LT | k= LE | k= GT | k= GE ) ;
    // $ANTLR start "p_ValueComp"
    p_ValueComp: function() {
        var retval = new XQueryParser.p_ValueComp_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:876:9: ( (k= EQ | k= NE | k= LT | k= LE | k= GT | k= GE ) )
            // xquery/XQueryParser.g:876:11: (k= EQ | k= NE | k= LT | k= LE | k= GT | k= GE )
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:876:11: (k= EQ | k= NE | k= LT | k= LE | k= GT | k= GE )
            var alt111=6;
            switch ( this.input.LA(1) ) {
            case EQ:
                alt111=1;
                break;
            case NE:
                alt111=2;
                break;
            case LT:
                alt111=3;
                break;
            case LE:
                alt111=4;
                break;
            case GT:
                alt111=5;
                break;
            case GE:
                alt111=6;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 111, 0, this.input);

                throw nvae;
            }

            switch (alt111) {
                case 1 :
                    // xquery/XQueryParser.g:876:12: k= EQ
                    k=this.match(this.input,EQ,XQueryParser.FOLLOW_EQ_in_p_ValueComp6320); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:876:19: k= NE
                    k=this.match(this.input,NE,XQueryParser.FOLLOW_NE_in_p_ValueComp6326); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:876:26: k= LT
                    k=this.match(this.input,LT,XQueryParser.FOLLOW_LT_in_p_ValueComp6332); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 4 :
                    // xquery/XQueryParser.g:876:33: k= LE
                    k=this.match(this.input,LE,XQueryParser.FOLLOW_LE_in_p_ValueComp6338); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 5 :
                    // xquery/XQueryParser.g:876:40: k= GT
                    k=this.match(this.input,GT,XQueryParser.FOLLOW_GT_in_p_ValueComp6344); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 6 :
                    // xquery/XQueryParser.g:876:47: k= GE
                    k=this.match(this.input,GE,XQueryParser.FOLLOW_GE_in_p_ValueComp6350); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_NodeComp_return: (function() {
        XQueryParser.p_NodeComp_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_NodeComp_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:880:1: p_NodeComp : (k= IS | SMALLER_SMALLER | GREATER_GREATER );
    // $ANTLR start "p_NodeComp"
    p_NodeComp: function() {
        var retval = new XQueryParser.p_NodeComp_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SMALLER_SMALLER236 = null;
        var GREATER_GREATER237 = null;

        var k_tree=null;
        var SMALLER_SMALLER236_tree=null;
        var GREATER_GREATER237_tree=null;

        try {
            // xquery/XQueryParser.g:881:9: (k= IS | SMALLER_SMALLER | GREATER_GREATER )
            var alt112=3;
            switch ( this.input.LA(1) ) {
            case IS:
                alt112=1;
                break;
            case SMALLER_SMALLER:
                alt112=2;
                break;
            case GREATER_GREATER:
                alt112=3;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 112, 0, this.input);

                throw nvae;
            }

            switch (alt112) {
                case 1 :
                    // xquery/XQueryParser.g:881:11: k= IS
                    root_0 = this.adaptor.nil();

                    k=this.match(this.input,IS,XQueryParser.FOLLOW_IS_in_p_NodeComp6381); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:881:33: SMALLER_SMALLER
                    root_0 = this.adaptor.nil();

                    SMALLER_SMALLER236=this.match(this.input,SMALLER_SMALLER,XQueryParser.FOLLOW_SMALLER_SMALLER_in_p_NodeComp6387); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    SMALLER_SMALLER236_tree = this.adaptor.create(SMALLER_SMALLER236);
                    this.adaptor.addChild(root_0, SMALLER_SMALLER236_tree);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:881:51: GREATER_GREATER
                    root_0 = this.adaptor.nil();

                    GREATER_GREATER237=this.match(this.input,GREATER_GREATER,XQueryParser.FOLLOW_GREATER_GREATER_in_p_NodeComp6391); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    GREATER_GREATER237_tree = this.adaptor.create(GREATER_GREATER237);
                    this.adaptor.addChild(root_0, GREATER_GREATER237_tree);
                    }


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ValidateExpr_return: (function() {
        XQueryParser.p_ValidateExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ValidateExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:885:1: p_ValidateExpr : k= VALIDATE ( p_ValidationMode | k= TYPE p_TypeName )? LBRACKET p_Expr[true,true] RBRACKET ;
    // $ANTLR start "p_ValidateExpr"
    p_ValidateExpr: function() {
        var retval = new XQueryParser.p_ValidateExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET240 = null;
        var RBRACKET242 = null;
         var p_ValidationMode238 = null;
         var p_TypeName239 = null;
         var p_Expr241 = null;

        var k_tree=null;
        var LBRACKET240_tree=null;
        var RBRACKET242_tree=null;

        try {
            // xquery/XQueryParser.g:886:9: (k= VALIDATE ( p_ValidationMode | k= TYPE p_TypeName )? LBRACKET p_Expr[true,true] RBRACKET )
            // xquery/XQueryParser.g:886:11: k= VALIDATE ( p_ValidationMode | k= TYPE p_TypeName )? LBRACKET p_Expr[true,true] RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,VALIDATE,XQueryParser.FOLLOW_VALIDATE_in_p_ValidateExpr6419); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:886:37: ( p_ValidationMode | k= TYPE p_TypeName )?
            var alt113=3;
            var LA113_0 = this.input.LA(1);

            if ( (LA113_0==LAX||LA113_0==STRICT) ) {
                alt113=1;
            }
            else if ( (LA113_0==TYPE) ) {
                alt113=2;
            }
            switch (alt113) {
                case 1 :
                    // xquery/XQueryParser.g:886:39: p_ValidationMode
                    this.pushFollow(XQueryParser.FOLLOW_p_ValidationMode_in_p_ValidateExpr6425);
                    p_ValidationMode238=this.p_ValidationMode();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ValidationMode238.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:886:58: k= TYPE p_TypeName
                    k=this.match(this.input,TYPE,XQueryParser.FOLLOW_TYPE_in_p_ValidateExpr6431); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeName_in_p_ValidateExpr6435);
                    p_TypeName239=this.p_TypeName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeName239.getTree());


                    break;

            }

            LBRACKET240=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_ValidateExpr6440); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET240_tree = this.adaptor.create(LBRACKET240);
            this.adaptor.addChild(root_0, LBRACKET240_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_ValidateExpr6442);
            p_Expr241=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr241.getTree());
            RBRACKET242=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_ValidateExpr6445); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET242_tree = this.adaptor.create(RBRACKET242);
            this.adaptor.addChild(root_0, RBRACKET242_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ValidationMode_return: (function() {
        XQueryParser.p_ValidationMode_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ValidationMode_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:890:1: p_ValidationMode : (k= LAX | k= STRICT ) ;
    // $ANTLR start "p_ValidationMode"
    p_ValidationMode: function() {
        var retval = new XQueryParser.p_ValidationMode_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:891:9: ( (k= LAX | k= STRICT ) )
            // xquery/XQueryParser.g:891:11: (k= LAX | k= STRICT )
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:891:11: (k= LAX | k= STRICT )
            var alt114=2;
            var LA114_0 = this.input.LA(1);

            if ( (LA114_0==LAX) ) {
                alt114=1;
            }
            else if ( (LA114_0==STRICT) ) {
                alt114=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 114, 0, this.input);

                throw nvae;
            }
            switch (alt114) {
                case 1 :
                    // xquery/XQueryParser.g:891:12: k= LAX
                    k=this.match(this.input,LAX,XQueryParser.FOLLOW_LAX_in_p_ValidationMode6474); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:891:20: k= STRICT
                    k=this.match(this.input,STRICT,XQueryParser.FOLLOW_STRICT_in_p_ValidationMode6480); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ExtensionExpr_return: (function() {
        XQueryParser.p_ExtensionExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ExtensionExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:895:1: p_ExtensionExpr : ( L_Pragma )+ LBRACKET ( p_Expr[true,true] )? RBRACKET ;
    // $ANTLR start "p_ExtensionExpr"
    p_ExtensionExpr: function() {
        var retval = new XQueryParser.p_ExtensionExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var L_Pragma243 = null;
        var LBRACKET244 = null;
        var RBRACKET246 = null;
         var p_Expr245 = null;

        var L_Pragma243_tree=null;
        var LBRACKET244_tree=null;
        var RBRACKET246_tree=null;

        try {
            // xquery/XQueryParser.g:896:9: ( ( L_Pragma )+ LBRACKET ( p_Expr[true,true] )? RBRACKET )
            // xquery/XQueryParser.g:896:11: ( L_Pragma )+ LBRACKET ( p_Expr[true,true] )? RBRACKET
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:896:11: ( L_Pragma )+
            var cnt115=0;
            loop115:
            do {
                var alt115=2;
                var LA115_0 = this.input.LA(1);

                if ( (LA115_0==L_Pragma) ) {
                    alt115=1;
                }


                switch (alt115) {
                case 1 :
                    // xquery/XQueryParser.g:896:11: L_Pragma
                    L_Pragma243=this.match(this.input,L_Pragma,XQueryParser.FOLLOW_L_Pragma_in_p_ExtensionExpr6509); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    L_Pragma243_tree = this.adaptor.create(L_Pragma243);
                    this.adaptor.addChild(root_0, L_Pragma243_tree);
                    }


                    break;

                default :
                    if ( cnt115 >= 1 ) {
                        break loop115;
                    }
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var eee = new org.antlr.runtime.EarlyExitException(115, this.input);
                        throw eee;
                }
                cnt115++;
            } while (true);

            LBRACKET244=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_ExtensionExpr6512); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET244_tree = this.adaptor.create(LBRACKET244);
            this.adaptor.addChild(root_0, LBRACKET244_tree);
            }
            // xquery/XQueryParser.g:896:30: ( p_Expr[true,true] )?
            var alt116=2;
            var LA116_0 = this.input.LA(1);

            if ( ((LA116_0>=ANCESTOR && LA116_0<=QUOT_ER)||LA116_0==LPAREN||(LA116_0>=DOLLAR && LA116_0<=LBRACKET)||(LA116_0>=STAR && LA116_0<=SMALLER)||(LA116_0>=SLASH && LA116_0<=DOT_DOT)||LA116_0==ATTR_SIGN||(LA116_0>=APOS && LA116_0<=QUOT)||LA116_0==L_NCName||(LA116_0>=L_Pragma && LA116_0<=L_DoubleLiteral)||LA116_0==EXPLICITLY) ) {
                alt116=1;
            }
            switch (alt116) {
                case 1 :
                    // xquery/XQueryParser.g:896:30: p_Expr[true,true]
                    this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_ExtensionExpr6514);
                    p_Expr245=this.p_Expr(true, true);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr245.getTree());


                    break;

            }

            RBRACKET246=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_ExtensionExpr6518); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET246_tree = this.adaptor.create(RBRACKET246);
            this.adaptor.addChild(root_0, RBRACKET246_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PathExpr_return: (function() {
        XQueryParser.p_PathExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PathExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:908:1: p_PathExpr : ( ( SLASH p_RelativePathExpr )=> ( SLASH p_RelativePathExpr ) | SLASH | SLASH_SLASH p_RelativePathExpr | p_RelativePathExpr );
    // $ANTLR start "p_PathExpr"
    p_PathExpr: function() {
        var retval = new XQueryParser.p_PathExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var SLASH247 = null;
        var SLASH249 = null;
        var SLASH_SLASH250 = null;
         var p_RelativePathExpr248 = null;
         var p_RelativePathExpr251 = null;
         var p_RelativePathExpr252 = null;

        var SLASH247_tree=null;
        var SLASH249_tree=null;
        var SLASH_SLASH250_tree=null;

        try {
            // xquery/XQueryParser.g:909:9: ( ( SLASH p_RelativePathExpr )=> ( SLASH p_RelativePathExpr ) | SLASH | SLASH_SLASH p_RelativePathExpr | p_RelativePathExpr )
            var alt117=4;
            alt117 = this.dfa117.predict(this.input);
            switch (alt117) {
                case 1 :
                    // xquery/XQueryParser.g:909:11: ( SLASH p_RelativePathExpr )=> ( SLASH p_RelativePathExpr )
                    root_0 = this.adaptor.nil();

                    // xquery/XQueryParser.g:909:41: ( SLASH p_RelativePathExpr )
                    // xquery/XQueryParser.g:909:42: SLASH p_RelativePathExpr
                    SLASH247=this.match(this.input,SLASH,XQueryParser.FOLLOW_SLASH_in_p_PathExpr6561); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    SLASH247_tree = this.adaptor.create(SLASH247);
                    this.adaptor.addChild(root_0, SLASH247_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_RelativePathExpr_in_p_PathExpr6563);
                    p_RelativePathExpr248=this.p_RelativePathExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_RelativePathExpr248.getTree());





                    break;
                case 2 :
                    // xquery/XQueryParser.g:910:11: SLASH
                    root_0 = this.adaptor.nil();

                    SLASH249=this.match(this.input,SLASH,XQueryParser.FOLLOW_SLASH_in_p_PathExpr6576); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    SLASH249_tree = this.adaptor.create(SLASH249);
                    this.adaptor.addChild(root_0, SLASH249_tree);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:911:11: SLASH_SLASH p_RelativePathExpr
                    root_0 = this.adaptor.nil();

                    SLASH_SLASH250=this.match(this.input,SLASH_SLASH,XQueryParser.FOLLOW_SLASH_SLASH_in_p_PathExpr6588); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    SLASH_SLASH250_tree = this.adaptor.create(SLASH_SLASH250);
                    this.adaptor.addChild(root_0, SLASH_SLASH250_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_RelativePathExpr_in_p_PathExpr6590);
                    p_RelativePathExpr251=this.p_RelativePathExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_RelativePathExpr251.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:912:11: p_RelativePathExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_RelativePathExpr_in_p_PathExpr6602);
                    p_RelativePathExpr252=this.p_RelativePathExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_RelativePathExpr252.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_RelativePathExpr_return: (function() {
        XQueryParser.p_RelativePathExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_RelativePathExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:916:1: p_RelativePathExpr : p_StepExpr ( ( SLASH | SLASH_SLASH ) p_StepExpr )* ;
    // $ANTLR start "p_RelativePathExpr"
    p_RelativePathExpr: function() {
        var retval = new XQueryParser.p_RelativePathExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var set254 = null;
         var p_StepExpr253 = null;
         var p_StepExpr255 = null;

        var set254_tree=null;

        try {
            // xquery/XQueryParser.g:917:9: ( p_StepExpr ( ( SLASH | SLASH_SLASH ) p_StepExpr )* )
            // xquery/XQueryParser.g:917:11: p_StepExpr ( ( SLASH | SLASH_SLASH ) p_StepExpr )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_StepExpr_in_p_RelativePathExpr6630);
            p_StepExpr253=this.p_StepExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StepExpr253.getTree());
            // xquery/XQueryParser.g:917:22: ( ( SLASH | SLASH_SLASH ) p_StepExpr )*
            loop118:
            do {
                var alt118=2;
                var LA118_0 = this.input.LA(1);

                if ( ((LA118_0>=SLASH && LA118_0<=SLASH_SLASH)) ) {
                    alt118=1;
                }


                switch (alt118) {
                case 1 :
                    // xquery/XQueryParser.g:917:23: ( SLASH | SLASH_SLASH ) p_StepExpr
                    set254=this.input.LT(1);
                    if ( (this.input.LA(1)>=SLASH && this.input.LA(1)<=SLASH_SLASH) ) {
                        this.input.consume();
                        if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, this.adaptor.create(set254));
                        this.state.errorRecovery=false;this.state.failed=false;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                        throw mse;
                    }

                    this.pushFollow(XQueryParser.FOLLOW_p_StepExpr_in_p_RelativePathExpr6641);
                    p_StepExpr255=this.p_StepExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StepExpr255.getTree());


                    break;

                default :
                    break loop118;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_StepExpr_return: (function() {
        XQueryParser.p_StepExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_StepExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:921:1: p_StepExpr : ( ( LBRACKET | LPAREN | SMALLER | QUOT | APOS | DOLLAR )=> p_PostfixExpr | ( ( ( ELEMENT | ATTRIBUTE ) ( p_QName )? LBRACKET ) | ( ( NAMESPACE | PROCESSING_INSTRUCTION ) ( p_NCName )? LBRACKET ) | ( ( DOCUMENT | TEXT | COMMENT ) LBRACKET ) )=> p_PostfixExpr | ( p_KindTest )=> p_AxisStep | ( p_QName LPAREN )=> p_PostfixExpr | ( p_PrimaryExpr )=> p_PostfixExpr | p_AxisStep );
    // $ANTLR start "p_StepExpr"
    p_StepExpr: function() {
        var retval = new XQueryParser.p_StepExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_PostfixExpr256 = null;
         var p_PostfixExpr257 = null;
         var p_AxisStep258 = null;
         var p_PostfixExpr259 = null;
         var p_PostfixExpr260 = null;
         var p_AxisStep261 = null;


        try {
            // xquery/XQueryParser.g:922:9: ( ( LBRACKET | LPAREN | SMALLER | QUOT | APOS | DOLLAR )=> p_PostfixExpr | ( ( ( ELEMENT | ATTRIBUTE ) ( p_QName )? LBRACKET ) | ( ( NAMESPACE | PROCESSING_INSTRUCTION ) ( p_NCName )? LBRACKET ) | ( ( DOCUMENT | TEXT | COMMENT ) LBRACKET ) )=> p_PostfixExpr | ( p_KindTest )=> p_AxisStep | ( p_QName LPAREN )=> p_PostfixExpr | ( p_PrimaryExpr )=> p_PostfixExpr | p_AxisStep )
            var alt119=6;
            alt119 = this.dfa119.predict(this.input);
            switch (alt119) {
                case 1 :
                    // xquery/XQueryParser.g:922:11: ( LBRACKET | LPAREN | SMALLER | QUOT | APOS | DOLLAR )=> p_PostfixExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_PostfixExpr_in_p_StepExpr6695);
                    p_PostfixExpr256=this.p_PostfixExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PostfixExpr256.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:923:11: ( ( ( ELEMENT | ATTRIBUTE ) ( p_QName )? LBRACKET ) | ( ( NAMESPACE | PROCESSING_INSTRUCTION ) ( p_NCName )? LBRACKET ) | ( ( DOCUMENT | TEXT | COMMENT ) LBRACKET ) )=> p_PostfixExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_PostfixExpr_in_p_StepExpr6809);
                    p_PostfixExpr257=this.p_PostfixExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PostfixExpr257.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:928:11: ( p_KindTest )=> p_AxisStep
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_AxisStep_in_p_StepExpr6827);
                    p_AxisStep258=this.p_AxisStep();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AxisStep258.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:929:11: ( p_QName LPAREN )=> p_PostfixExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_PostfixExpr_in_p_StepExpr6848);
                    p_PostfixExpr259=this.p_PostfixExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PostfixExpr259.getTree());


                    break;
                case 5 :
                    // xquery/XQueryParser.g:930:11: ( p_PrimaryExpr )=> p_PostfixExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_PostfixExpr_in_p_StepExpr6866);
                    p_PostfixExpr260=this.p_PostfixExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PostfixExpr260.getTree());


                    break;
                case 6 :
                    // xquery/XQueryParser.g:931:11: p_AxisStep
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_AxisStep_in_p_StepExpr6878);
                    p_AxisStep261=this.p_AxisStep();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AxisStep261.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AxisStep_return: (function() {
        XQueryParser.p_AxisStep_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AxisStep_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:935:1: p_AxisStep : ( p_ReverseStep | p_ForwardStep ) p_PredicateList ;
    // $ANTLR start "p_AxisStep"
    p_AxisStep: function() {
        var retval = new XQueryParser.p_AxisStep_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ReverseStep262 = null;
         var p_ForwardStep263 = null;
         var p_PredicateList264 = null;


        try {
            // xquery/XQueryParser.g:936:9: ( ( p_ReverseStep | p_ForwardStep ) p_PredicateList )
            // xquery/XQueryParser.g:936:11: ( p_ReverseStep | p_ForwardStep ) p_PredicateList
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:936:11: ( p_ReverseStep | p_ForwardStep )
            var alt120=2;
            switch ( this.input.LA(1) ) {
            case PARENT:
                var LA120_1 = this.input.LA(2);

                if ( (LA120_1==COLON_COLON) ) {
                    alt120=1;
                }
                else if ( (LA120_1==EOF||(LA120_1>=AND && LA120_1<=ASCENDING)||(LA120_1>=BY && LA120_1<=CASTABLE)||LA120_1==COLLATION||LA120_1==DEFAULT||(LA120_1>=DESCENDING && LA120_1<=DIV)||LA120_1==EMPTY||LA120_1==EQ||LA120_1==EXCEPT||LA120_1==FOR||LA120_1==GE||(LA120_1>=GT && LA120_1<=IDIV)||(LA120_1>=INSTANCE && LA120_1<=IS)||LA120_1==LE||(LA120_1>=LET && LA120_1<=MOD)||LA120_1==NE||(LA120_1>=OR && LA120_1<=ORDER)||(LA120_1>=RETURN && LA120_1<=SATISFIES)||LA120_1==STABLE||(LA120_1>=TO && LA120_1<=TREAT)||LA120_1==UNION||LA120_1==WHERE||LA120_1==COUNT||(LA120_1>=END && LA120_1<=GROUP)||LA120_1==ONLY||LA120_1==START||(LA120_1>=AFTER && LA120_1<=BEFORE)||LA120_1==INTO||LA120_1==MODIFY||LA120_1==WITH||LA120_1==CONTAINS||LA120_1==PARAGRAPHS||LA120_1==SENTENCES||LA120_1==TIMES||LA120_1==WORDS||LA120_1==CONCAT||LA120_1==RPAREN||(LA120_1>=RBRACKET && LA120_1<=EQUAL)||LA120_1==NOTEQUAL||LA120_1==COMMA||(LA120_1>=STAR && LA120_1<=SLASH_SLASH)||LA120_1==COLON||(LA120_1>=SEMICOLON && LA120_1<=VBAR)) ) {
                    alt120=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 120, 1, this.input);

                    throw nvae;
                }
                break;
            case ANCESTOR:
                var LA120_2 = this.input.LA(2);

                if ( (LA120_2==COLON_COLON) ) {
                    alt120=1;
                }
                else if ( (LA120_2==EOF||(LA120_2>=AND && LA120_2<=ASCENDING)||(LA120_2>=BY && LA120_2<=CASTABLE)||LA120_2==COLLATION||LA120_2==DEFAULT||(LA120_2>=DESCENDING && LA120_2<=DIV)||LA120_2==EMPTY||LA120_2==EQ||LA120_2==EXCEPT||LA120_2==FOR||LA120_2==GE||(LA120_2>=GT && LA120_2<=IDIV)||(LA120_2>=INSTANCE && LA120_2<=IS)||LA120_2==LE||(LA120_2>=LET && LA120_2<=MOD)||LA120_2==NE||(LA120_2>=OR && LA120_2<=ORDER)||(LA120_2>=RETURN && LA120_2<=SATISFIES)||LA120_2==STABLE||(LA120_2>=TO && LA120_2<=TREAT)||LA120_2==UNION||LA120_2==WHERE||LA120_2==COUNT||(LA120_2>=END && LA120_2<=GROUP)||LA120_2==ONLY||LA120_2==START||(LA120_2>=AFTER && LA120_2<=BEFORE)||LA120_2==INTO||LA120_2==MODIFY||LA120_2==WITH||LA120_2==CONTAINS||LA120_2==PARAGRAPHS||LA120_2==SENTENCES||LA120_2==TIMES||LA120_2==WORDS||LA120_2==CONCAT||LA120_2==RPAREN||(LA120_2>=RBRACKET && LA120_2<=EQUAL)||LA120_2==NOTEQUAL||LA120_2==COMMA||(LA120_2>=STAR && LA120_2<=SLASH_SLASH)||LA120_2==COLON||(LA120_2>=SEMICOLON && LA120_2<=VBAR)) ) {
                    alt120=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 120, 2, this.input);

                    throw nvae;
                }
                break;
            case PRECEDING_SIBLING:
                var LA120_3 = this.input.LA(2);

                if ( (LA120_3==COLON_COLON) ) {
                    alt120=1;
                }
                else if ( (LA120_3==EOF||(LA120_3>=AND && LA120_3<=ASCENDING)||(LA120_3>=BY && LA120_3<=CASTABLE)||LA120_3==COLLATION||LA120_3==DEFAULT||(LA120_3>=DESCENDING && LA120_3<=DIV)||LA120_3==EMPTY||LA120_3==EQ||LA120_3==EXCEPT||LA120_3==FOR||LA120_3==GE||(LA120_3>=GT && LA120_3<=IDIV)||(LA120_3>=INSTANCE && LA120_3<=IS)||LA120_3==LE||(LA120_3>=LET && LA120_3<=MOD)||LA120_3==NE||(LA120_3>=OR && LA120_3<=ORDER)||(LA120_3>=RETURN && LA120_3<=SATISFIES)||LA120_3==STABLE||(LA120_3>=TO && LA120_3<=TREAT)||LA120_3==UNION||LA120_3==WHERE||LA120_3==COUNT||(LA120_3>=END && LA120_3<=GROUP)||LA120_3==ONLY||LA120_3==START||(LA120_3>=AFTER && LA120_3<=BEFORE)||LA120_3==INTO||LA120_3==MODIFY||LA120_3==WITH||LA120_3==CONTAINS||LA120_3==PARAGRAPHS||LA120_3==SENTENCES||LA120_3==TIMES||LA120_3==WORDS||LA120_3==CONCAT||LA120_3==RPAREN||(LA120_3>=RBRACKET && LA120_3<=EQUAL)||LA120_3==NOTEQUAL||LA120_3==COMMA||(LA120_3>=STAR && LA120_3<=SLASH_SLASH)||LA120_3==COLON||(LA120_3>=SEMICOLON && LA120_3<=VBAR)) ) {
                    alt120=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 120, 3, this.input);

                    throw nvae;
                }
                break;
            case PRECEDING:
                var LA120_4 = this.input.LA(2);

                if ( (LA120_4==COLON_COLON) ) {
                    alt120=1;
                }
                else if ( (LA120_4==EOF||(LA120_4>=AND && LA120_4<=ASCENDING)||(LA120_4>=BY && LA120_4<=CASTABLE)||LA120_4==COLLATION||LA120_4==DEFAULT||(LA120_4>=DESCENDING && LA120_4<=DIV)||LA120_4==EMPTY||LA120_4==EQ||LA120_4==EXCEPT||LA120_4==FOR||LA120_4==GE||(LA120_4>=GT && LA120_4<=IDIV)||(LA120_4>=INSTANCE && LA120_4<=IS)||LA120_4==LE||(LA120_4>=LET && LA120_4<=MOD)||LA120_4==NE||(LA120_4>=OR && LA120_4<=ORDER)||(LA120_4>=RETURN && LA120_4<=SATISFIES)||LA120_4==STABLE||(LA120_4>=TO && LA120_4<=TREAT)||LA120_4==UNION||LA120_4==WHERE||LA120_4==COUNT||(LA120_4>=END && LA120_4<=GROUP)||LA120_4==ONLY||LA120_4==START||(LA120_4>=AFTER && LA120_4<=BEFORE)||LA120_4==INTO||LA120_4==MODIFY||LA120_4==WITH||LA120_4==CONTAINS||LA120_4==PARAGRAPHS||LA120_4==SENTENCES||LA120_4==TIMES||LA120_4==WORDS||LA120_4==CONCAT||LA120_4==RPAREN||(LA120_4>=RBRACKET && LA120_4<=EQUAL)||LA120_4==NOTEQUAL||LA120_4==COMMA||(LA120_4>=STAR && LA120_4<=SLASH_SLASH)||LA120_4==COLON||(LA120_4>=SEMICOLON && LA120_4<=VBAR)) ) {
                    alt120=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 120, 4, this.input);

                    throw nvae;
                }
                break;
            case ANCESTOR_OR_SELF:
                var LA120_5 = this.input.LA(2);

                if ( (LA120_5==COLON_COLON) ) {
                    alt120=1;
                }
                else if ( (LA120_5==EOF||(LA120_5>=AND && LA120_5<=ASCENDING)||(LA120_5>=BY && LA120_5<=CASTABLE)||LA120_5==COLLATION||LA120_5==DEFAULT||(LA120_5>=DESCENDING && LA120_5<=DIV)||LA120_5==EMPTY||LA120_5==EQ||LA120_5==EXCEPT||LA120_5==FOR||LA120_5==GE||(LA120_5>=GT && LA120_5<=IDIV)||(LA120_5>=INSTANCE && LA120_5<=IS)||LA120_5==LE||(LA120_5>=LET && LA120_5<=MOD)||LA120_5==NE||(LA120_5>=OR && LA120_5<=ORDER)||(LA120_5>=RETURN && LA120_5<=SATISFIES)||LA120_5==STABLE||(LA120_5>=TO && LA120_5<=TREAT)||LA120_5==UNION||LA120_5==WHERE||LA120_5==COUNT||(LA120_5>=END && LA120_5<=GROUP)||LA120_5==ONLY||LA120_5==START||(LA120_5>=AFTER && LA120_5<=BEFORE)||LA120_5==INTO||LA120_5==MODIFY||LA120_5==WITH||LA120_5==CONTAINS||LA120_5==PARAGRAPHS||LA120_5==SENTENCES||LA120_5==TIMES||LA120_5==WORDS||LA120_5==CONCAT||LA120_5==RPAREN||(LA120_5>=RBRACKET && LA120_5<=EQUAL)||LA120_5==NOTEQUAL||LA120_5==COMMA||(LA120_5>=STAR && LA120_5<=SLASH_SLASH)||LA120_5==COLON||(LA120_5>=SEMICOLON && LA120_5<=VBAR)) ) {
                    alt120=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 120, 5, this.input);

                    throw nvae;
                }
                break;
            case DOT_DOT:
                alt120=1;
                break;
            case AND:
            case AS:
            case ASCENDING:
            case AT:
            case ATTRIBUTE:
            case BASE_URI:
            case BOUNDARY_SPACE:
            case BY:
            case CASE:
            case CAST:
            case CASTABLE:
            case CHILD:
            case COLLATION:
            case COMMENT:
            case CONSTRUCTION:
            case COPY_NAMESPACES:
            case DECLARE:
            case DEFAULT:
            case DESCENDANT:
            case DESCENDANT_OR_SELF:
            case DESCENDING:
            case DIV:
            case DOCUMENT:
            case DOCUMENT_NODE:
            case ELEMENT:
            case ELSE:
            case EMPTY:
            case EMPTY_SEQUENCE:
            case ENCODING:
            case EQ:
            case EVERY:
            case EXCEPT:
            case EXTERNAL:
            case FOLLOWING:
            case FOLLOWING_SIBLING:
            case FOR:
            case FUNCTION:
            case GE:
            case GREATEST:
            case GT:
            case IDIV:
            case IF:
            case IMPORT:
            case IN:
            case INHERIT:
            case INSTANCE:
            case INTERSECT:
            case IS:
            case ITEM:
            case LAX:
            case LE:
            case LEAST:
            case LET:
            case LT:
            case MOD:
            case MODULE:
            case NAMESPACE:
            case NE:
            case NO_INHERIT:
            case NO_PRESERVE:
            case NODE:
            case OF:
            case OPTION:
            case OR:
            case ORDER:
            case ORDERED:
            case ORDERING:
            case PRESERVE:
            case PROCESSING_INSTRUCTION:
            case RETURN:
            case SATISFIES:
            case SCHEMA:
            case SCHEMA_ATTRIBUTE:
            case SCHEMA_ELEMENT:
            case SELF:
            case SOME:
            case STABLE:
            case STRICT:
            case STRIP:
            case TEXT:
            case THEN:
            case TO:
            case TREAT:
            case TYPESWITCH:
            case UNION:
            case UNORDERED:
            case VALIDATE:
            case VARIABLE:
            case VERSION:
            case WHERE:
            case XQUERY:
            case ALLOWING:
            case CATCH:
            case CONTEXT:
            case COUNT:
            case DECIMAL_FORMAT:
            case DECIMAL_SEPARATOR:
            case DIGIT:
            case END:
            case GROUP:
            case GROUPING_SEPARATOR:
            case INFINITY:
            case MINUS_SIGN:
            case NAMESPACE_NODE:
            case NAN:
            case NEXT:
            case ONLY:
            case PATTERN_SEPARATOR:
            case PERCENT:
            case PER_MILLE:
            case PREVIOUS:
            case SLIDING:
            case START:
            case SWITCH:
            case TRY:
            case TUMBLING:
            case TYPE:
            case WHEN:
            case WINDOW:
            case ZERO_DIGIT:
            case AFTER:
            case BEFORE:
            case COPY:
            case DELETE:
            case FIRST:
            case INSERT:
            case INTO:
            case LAST:
            case MODIFY:
            case NODES:
            case RENAME:
            case REPLACE:
            case REVALIDATION:
            case SKIP:
            case VALUE:
            case WITH:
            case ALL:
            case ANY:
            case CONTAINS:
            case CONTENT:
            case DIACRITICS:
            case DIFFERENT:
            case DISTANCE:
            case ENTIRE:
            case EXACTLY:
            case FROM:
            case FT_OPTION:
            case FTAND:
            case FTNOT:
            case FTOR:
            case INSENSITIVE:
            case LANGUAGE:
            case LEVELS:
            case LOWERCASE:
            case MOST:
            case NO:
            case NOT:
            case OCCURS:
            case PARAGRAPH:
            case PARAGRAPHS:
            case PHRASE:
            case RELATIONSHIP:
            case SAME:
            case SCORE:
            case SENSITIVE:
            case SENTENCE:
            case SENTENCES:
            case STEMMING:
            case STOP:
            case THESAURUS:
            case TIMES:
            case UPPERCASE:
            case USING:
            case WEIGHT:
            case WILDCARDS:
            case WITHOUT:
            case WORD:
            case WORDS:
            case BREAK:
            case CONTINUE:
            case EXIT:
            case LOOP:
            case RETURNING:
            case WHILE:
            case CHECK:
            case COLLECTION:
            case CONSTRAINT:
            case FOREACH:
            case FOREIGN:
            case INDEX:
            case INTEGRITY:
            case KEY:
            case ON:
            case UNIQUE:
            case BINARY:
            case AMP_ER:
            case APOS_ER:
            case QUOT_ER:
            case STAR:
            case ATTR_SIGN:
            case APOS:
            case QUOT:
            case L_NCName:
            case EXPLICITLY:
                alt120=2;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 120, 0, this.input);

                throw nvae;
            }

            switch (alt120) {
                case 1 :
                    // xquery/XQueryParser.g:936:12: p_ReverseStep
                    this.pushFollow(XQueryParser.FOLLOW_p_ReverseStep_in_p_AxisStep6905);
                    p_ReverseStep262=this.p_ReverseStep();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ReverseStep262.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:936:28: p_ForwardStep
                    this.pushFollow(XQueryParser.FOLLOW_p_ForwardStep_in_p_AxisStep6909);
                    p_ForwardStep263=this.p_ForwardStep();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ForwardStep263.getTree());


                    break;

            }

            this.pushFollow(XQueryParser.FOLLOW_p_PredicateList_in_p_AxisStep6912);
            p_PredicateList264=this.p_PredicateList();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PredicateList264.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ForwardStep_return: (function() {
        XQueryParser.p_ForwardStep_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ForwardStep_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:940:1: p_ForwardStep : ( p_ForwardAxis p_NodeTest | p_AbbrevForwardStep );
    // $ANTLR start "p_ForwardStep"
    p_ForwardStep: function() {
        var retval = new XQueryParser.p_ForwardStep_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ForwardAxis265 = null;
         var p_NodeTest266 = null;
         var p_AbbrevForwardStep267 = null;


        try {
            // xquery/XQueryParser.g:941:9: ( p_ForwardAxis p_NodeTest | p_AbbrevForwardStep )
            var alt121=2;
            alt121 = this.dfa121.predict(this.input);
            switch (alt121) {
                case 1 :
                    // xquery/XQueryParser.g:941:11: p_ForwardAxis p_NodeTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ForwardAxis_in_p_ForwardStep6938);
                    p_ForwardAxis265=this.p_ForwardAxis();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ForwardAxis265.getTree());
                    this.pushFollow(XQueryParser.FOLLOW_p_NodeTest_in_p_ForwardStep6940);
                    p_NodeTest266=this.p_NodeTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NodeTest266.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:942:11: p_AbbrevForwardStep
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_AbbrevForwardStep_in_p_ForwardStep6952);
                    p_AbbrevForwardStep267=this.p_AbbrevForwardStep();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AbbrevForwardStep267.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ForwardAxis_return: (function() {
        XQueryParser.p_ForwardAxis_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ForwardAxis_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:946:1: p_ForwardAxis : ( CHILD COLON_COLON | DESCENDANT COLON_COLON | ATTRIBUTE COLON_COLON | SELF COLON_COLON | DESCENDANT_OR_SELF COLON_COLON | FOLLOWING_SIBLING COLON_COLON | FOLLOWING COLON_COLON );
    // $ANTLR start "p_ForwardAxis"
    p_ForwardAxis: function() {
        var retval = new XQueryParser.p_ForwardAxis_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var CHILD268 = null;
        var COLON_COLON269 = null;
        var DESCENDANT270 = null;
        var COLON_COLON271 = null;
        var ATTRIBUTE272 = null;
        var COLON_COLON273 = null;
        var SELF274 = null;
        var COLON_COLON275 = null;
        var DESCENDANT_OR_SELF276 = null;
        var COLON_COLON277 = null;
        var FOLLOWING_SIBLING278 = null;
        var COLON_COLON279 = null;
        var FOLLOWING280 = null;
        var COLON_COLON281 = null;

        var CHILD268_tree=null;
        var COLON_COLON269_tree=null;
        var DESCENDANT270_tree=null;
        var COLON_COLON271_tree=null;
        var ATTRIBUTE272_tree=null;
        var COLON_COLON273_tree=null;
        var SELF274_tree=null;
        var COLON_COLON275_tree=null;
        var DESCENDANT_OR_SELF276_tree=null;
        var COLON_COLON277_tree=null;
        var FOLLOWING_SIBLING278_tree=null;
        var COLON_COLON279_tree=null;
        var FOLLOWING280_tree=null;
        var COLON_COLON281_tree=null;

        try {
            // xquery/XQueryParser.g:947:9: ( CHILD COLON_COLON | DESCENDANT COLON_COLON | ATTRIBUTE COLON_COLON | SELF COLON_COLON | DESCENDANT_OR_SELF COLON_COLON | FOLLOWING_SIBLING COLON_COLON | FOLLOWING COLON_COLON )
            var alt122=7;
            switch ( this.input.LA(1) ) {
            case CHILD:
                alt122=1;
                break;
            case DESCENDANT:
                alt122=2;
                break;
            case ATTRIBUTE:
                alt122=3;
                break;
            case SELF:
                alt122=4;
                break;
            case DESCENDANT_OR_SELF:
                alt122=5;
                break;
            case FOLLOWING_SIBLING:
                alt122=6;
                break;
            case FOLLOWING:
                alt122=7;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 122, 0, this.input);

                throw nvae;
            }

            switch (alt122) {
                case 1 :
                    // xquery/XQueryParser.g:947:11: CHILD COLON_COLON
                    root_0 = this.adaptor.nil();

                    CHILD268=this.match(this.input,CHILD,XQueryParser.FOLLOW_CHILD_in_p_ForwardAxis6978); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    CHILD268_tree = this.adaptor.create(CHILD268);
                    this.adaptor.addChild(root_0, CHILD268_tree);
                    }
                    COLON_COLON269=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ForwardAxis6980); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON269_tree = this.adaptor.create(COLON_COLON269);
                    this.adaptor.addChild(root_0, COLON_COLON269_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:948:11: DESCENDANT COLON_COLON
                    root_0 = this.adaptor.nil();

                    DESCENDANT270=this.match(this.input,DESCENDANT,XQueryParser.FOLLOW_DESCENDANT_in_p_ForwardAxis6992); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    DESCENDANT270_tree = this.adaptor.create(DESCENDANT270);
                    this.adaptor.addChild(root_0, DESCENDANT270_tree);
                    }
                    COLON_COLON271=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ForwardAxis6994); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON271_tree = this.adaptor.create(COLON_COLON271);
                    this.adaptor.addChild(root_0, COLON_COLON271_tree);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:949:11: ATTRIBUTE COLON_COLON
                    root_0 = this.adaptor.nil();

                    ATTRIBUTE272=this.match(this.input,ATTRIBUTE,XQueryParser.FOLLOW_ATTRIBUTE_in_p_ForwardAxis7006); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    ATTRIBUTE272_tree = this.adaptor.create(ATTRIBUTE272);
                    this.adaptor.addChild(root_0, ATTRIBUTE272_tree);
                    }
                    COLON_COLON273=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ForwardAxis7008); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON273_tree = this.adaptor.create(COLON_COLON273);
                    this.adaptor.addChild(root_0, COLON_COLON273_tree);
                    }


                    break;
                case 4 :
                    // xquery/XQueryParser.g:950:11: SELF COLON_COLON
                    root_0 = this.adaptor.nil();

                    SELF274=this.match(this.input,SELF,XQueryParser.FOLLOW_SELF_in_p_ForwardAxis7020); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    SELF274_tree = this.adaptor.create(SELF274);
                    this.adaptor.addChild(root_0, SELF274_tree);
                    }
                    COLON_COLON275=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ForwardAxis7022); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON275_tree = this.adaptor.create(COLON_COLON275);
                    this.adaptor.addChild(root_0, COLON_COLON275_tree);
                    }


                    break;
                case 5 :
                    // xquery/XQueryParser.g:951:11: DESCENDANT_OR_SELF COLON_COLON
                    root_0 = this.adaptor.nil();

                    DESCENDANT_OR_SELF276=this.match(this.input,DESCENDANT_OR_SELF,XQueryParser.FOLLOW_DESCENDANT_OR_SELF_in_p_ForwardAxis7034); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    DESCENDANT_OR_SELF276_tree = this.adaptor.create(DESCENDANT_OR_SELF276);
                    this.adaptor.addChild(root_0, DESCENDANT_OR_SELF276_tree);
                    }
                    COLON_COLON277=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ForwardAxis7036); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON277_tree = this.adaptor.create(COLON_COLON277);
                    this.adaptor.addChild(root_0, COLON_COLON277_tree);
                    }


                    break;
                case 6 :
                    // xquery/XQueryParser.g:952:11: FOLLOWING_SIBLING COLON_COLON
                    root_0 = this.adaptor.nil();

                    FOLLOWING_SIBLING278=this.match(this.input,FOLLOWING_SIBLING,XQueryParser.FOLLOW_FOLLOWING_SIBLING_in_p_ForwardAxis7048); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    FOLLOWING_SIBLING278_tree = this.adaptor.create(FOLLOWING_SIBLING278);
                    this.adaptor.addChild(root_0, FOLLOWING_SIBLING278_tree);
                    }
                    COLON_COLON279=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ForwardAxis7050); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON279_tree = this.adaptor.create(COLON_COLON279);
                    this.adaptor.addChild(root_0, COLON_COLON279_tree);
                    }


                    break;
                case 7 :
                    // xquery/XQueryParser.g:953:11: FOLLOWING COLON_COLON
                    root_0 = this.adaptor.nil();

                    FOLLOWING280=this.match(this.input,FOLLOWING,XQueryParser.FOLLOW_FOLLOWING_in_p_ForwardAxis7062); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    FOLLOWING280_tree = this.adaptor.create(FOLLOWING280);
                    this.adaptor.addChild(root_0, FOLLOWING280_tree);
                    }
                    COLON_COLON281=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ForwardAxis7064); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON281_tree = this.adaptor.create(COLON_COLON281);
                    this.adaptor.addChild(root_0, COLON_COLON281_tree);
                    }


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AbbrevForwardStep_return: (function() {
        XQueryParser.p_AbbrevForwardStep_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AbbrevForwardStep_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:957:1: p_AbbrevForwardStep : ( ATTR_SIGN )? p_NodeTest ;
    // $ANTLR start "p_AbbrevForwardStep"
    p_AbbrevForwardStep: function() {
        var retval = new XQueryParser.p_AbbrevForwardStep_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var ATTR_SIGN282 = null;
         var p_NodeTest283 = null;

        var ATTR_SIGN282_tree=null;

        try {
            // xquery/XQueryParser.g:958:9: ( ( ATTR_SIGN )? p_NodeTest )
            // xquery/XQueryParser.g:958:11: ( ATTR_SIGN )? p_NodeTest
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:958:11: ( ATTR_SIGN )?
            var alt123=2;
            var LA123_0 = this.input.LA(1);

            if ( (LA123_0==ATTR_SIGN) ) {
                alt123=1;
            }
            switch (alt123) {
                case 1 :
                    // xquery/XQueryParser.g:958:11: ATTR_SIGN
                    ATTR_SIGN282=this.match(this.input,ATTR_SIGN,XQueryParser.FOLLOW_ATTR_SIGN_in_p_AbbrevForwardStep7090); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    ATTR_SIGN282_tree = this.adaptor.create(ATTR_SIGN282);
                    this.adaptor.addChild(root_0, ATTR_SIGN282_tree);
                    }


                    break;

            }

            this.pushFollow(XQueryParser.FOLLOW_p_NodeTest_in_p_AbbrevForwardStep7093);
            p_NodeTest283=this.p_NodeTest();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NodeTest283.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ReverseStep_return: (function() {
        XQueryParser.p_ReverseStep_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ReverseStep_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:962:1: p_ReverseStep : ( p_ReverseAxis p_NodeTest | p_AbbrevReverseStep );
    // $ANTLR start "p_ReverseStep"
    p_ReverseStep: function() {
        var retval = new XQueryParser.p_ReverseStep_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ReverseAxis284 = null;
         var p_NodeTest285 = null;
         var p_AbbrevReverseStep286 = null;


        try {
            // xquery/XQueryParser.g:963:9: ( p_ReverseAxis p_NodeTest | p_AbbrevReverseStep )
            var alt124=2;
            var LA124_0 = this.input.LA(1);

            if ( ((LA124_0>=ANCESTOR && LA124_0<=ANCESTOR_OR_SELF)||(LA124_0>=PARENT && LA124_0<=PRECEDING_SIBLING)) ) {
                alt124=1;
            }
            else if ( (LA124_0==DOT_DOT) ) {
                alt124=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 124, 0, this.input);

                throw nvae;
            }
            switch (alt124) {
                case 1 :
                    // xquery/XQueryParser.g:963:11: p_ReverseAxis p_NodeTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ReverseAxis_in_p_ReverseStep7119);
                    p_ReverseAxis284=this.p_ReverseAxis();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ReverseAxis284.getTree());
                    this.pushFollow(XQueryParser.FOLLOW_p_NodeTest_in_p_ReverseStep7121);
                    p_NodeTest285=this.p_NodeTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NodeTest285.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:964:11: p_AbbrevReverseStep
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_AbbrevReverseStep_in_p_ReverseStep7133);
                    p_AbbrevReverseStep286=this.p_AbbrevReverseStep();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AbbrevReverseStep286.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ReverseAxis_return: (function() {
        XQueryParser.p_ReverseAxis_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ReverseAxis_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:968:1: p_ReverseAxis : ( PARENT COLON_COLON | ANCESTOR COLON_COLON | PRECEDING_SIBLING COLON_COLON | PRECEDING COLON_COLON | ANCESTOR_OR_SELF COLON_COLON );
    // $ANTLR start "p_ReverseAxis"
    p_ReverseAxis: function() {
        var retval = new XQueryParser.p_ReverseAxis_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var PARENT287 = null;
        var COLON_COLON288 = null;
        var ANCESTOR289 = null;
        var COLON_COLON290 = null;
        var PRECEDING_SIBLING291 = null;
        var COLON_COLON292 = null;
        var PRECEDING293 = null;
        var COLON_COLON294 = null;
        var ANCESTOR_OR_SELF295 = null;
        var COLON_COLON296 = null;

        var PARENT287_tree=null;
        var COLON_COLON288_tree=null;
        var ANCESTOR289_tree=null;
        var COLON_COLON290_tree=null;
        var PRECEDING_SIBLING291_tree=null;
        var COLON_COLON292_tree=null;
        var PRECEDING293_tree=null;
        var COLON_COLON294_tree=null;
        var ANCESTOR_OR_SELF295_tree=null;
        var COLON_COLON296_tree=null;

        try {
            // xquery/XQueryParser.g:969:9: ( PARENT COLON_COLON | ANCESTOR COLON_COLON | PRECEDING_SIBLING COLON_COLON | PRECEDING COLON_COLON | ANCESTOR_OR_SELF COLON_COLON )
            var alt125=5;
            switch ( this.input.LA(1) ) {
            case PARENT:
                alt125=1;
                break;
            case ANCESTOR:
                alt125=2;
                break;
            case PRECEDING_SIBLING:
                alt125=3;
                break;
            case PRECEDING:
                alt125=4;
                break;
            case ANCESTOR_OR_SELF:
                alt125=5;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 125, 0, this.input);

                throw nvae;
            }

            switch (alt125) {
                case 1 :
                    // xquery/XQueryParser.g:969:11: PARENT COLON_COLON
                    root_0 = this.adaptor.nil();

                    PARENT287=this.match(this.input,PARENT,XQueryParser.FOLLOW_PARENT_in_p_ReverseAxis7159); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    PARENT287_tree = this.adaptor.create(PARENT287);
                    this.adaptor.addChild(root_0, PARENT287_tree);
                    }
                    COLON_COLON288=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ReverseAxis7161); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON288_tree = this.adaptor.create(COLON_COLON288);
                    this.adaptor.addChild(root_0, COLON_COLON288_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:970:11: ANCESTOR COLON_COLON
                    root_0 = this.adaptor.nil();

                    ANCESTOR289=this.match(this.input,ANCESTOR,XQueryParser.FOLLOW_ANCESTOR_in_p_ReverseAxis7173); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    ANCESTOR289_tree = this.adaptor.create(ANCESTOR289);
                    this.adaptor.addChild(root_0, ANCESTOR289_tree);
                    }
                    COLON_COLON290=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ReverseAxis7175); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON290_tree = this.adaptor.create(COLON_COLON290);
                    this.adaptor.addChild(root_0, COLON_COLON290_tree);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:971:11: PRECEDING_SIBLING COLON_COLON
                    root_0 = this.adaptor.nil();

                    PRECEDING_SIBLING291=this.match(this.input,PRECEDING_SIBLING,XQueryParser.FOLLOW_PRECEDING_SIBLING_in_p_ReverseAxis7187); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    PRECEDING_SIBLING291_tree = this.adaptor.create(PRECEDING_SIBLING291);
                    this.adaptor.addChild(root_0, PRECEDING_SIBLING291_tree);
                    }
                    COLON_COLON292=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ReverseAxis7189); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON292_tree = this.adaptor.create(COLON_COLON292);
                    this.adaptor.addChild(root_0, COLON_COLON292_tree);
                    }


                    break;
                case 4 :
                    // xquery/XQueryParser.g:972:11: PRECEDING COLON_COLON
                    root_0 = this.adaptor.nil();

                    PRECEDING293=this.match(this.input,PRECEDING,XQueryParser.FOLLOW_PRECEDING_in_p_ReverseAxis7201); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    PRECEDING293_tree = this.adaptor.create(PRECEDING293);
                    this.adaptor.addChild(root_0, PRECEDING293_tree);
                    }
                    COLON_COLON294=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ReverseAxis7203); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON294_tree = this.adaptor.create(COLON_COLON294);
                    this.adaptor.addChild(root_0, COLON_COLON294_tree);
                    }


                    break;
                case 5 :
                    // xquery/XQueryParser.g:973:11: ANCESTOR_OR_SELF COLON_COLON
                    root_0 = this.adaptor.nil();

                    ANCESTOR_OR_SELF295=this.match(this.input,ANCESTOR_OR_SELF,XQueryParser.FOLLOW_ANCESTOR_OR_SELF_in_p_ReverseAxis7215); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    ANCESTOR_OR_SELF295_tree = this.adaptor.create(ANCESTOR_OR_SELF295);
                    this.adaptor.addChild(root_0, ANCESTOR_OR_SELF295_tree);
                    }
                    COLON_COLON296=this.match(this.input,COLON_COLON,XQueryParser.FOLLOW_COLON_COLON_in_p_ReverseAxis7217); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON_COLON296_tree = this.adaptor.create(COLON_COLON296);
                    this.adaptor.addChild(root_0, COLON_COLON296_tree);
                    }


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AbbrevReverseStep_return: (function() {
        XQueryParser.p_AbbrevReverseStep_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AbbrevReverseStep_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:977:1: p_AbbrevReverseStep : DOT_DOT ;
    // $ANTLR start "p_AbbrevReverseStep"
    p_AbbrevReverseStep: function() {
        var retval = new XQueryParser.p_AbbrevReverseStep_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var DOT_DOT297 = null;

        var DOT_DOT297_tree=null;

        try {
            // xquery/XQueryParser.g:978:9: ( DOT_DOT )
            // xquery/XQueryParser.g:978:11: DOT_DOT
            root_0 = this.adaptor.nil();

            DOT_DOT297=this.match(this.input,DOT_DOT,XQueryParser.FOLLOW_DOT_DOT_in_p_AbbrevReverseStep7243); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            DOT_DOT297_tree = this.adaptor.create(DOT_DOT297);
            this.adaptor.addChild(root_0, DOT_DOT297_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_NodeTest_return: (function() {
        XQueryParser.p_NodeTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_NodeTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:982:1: p_NodeTest : ( p_KindTest | p_NameTest );
    // $ANTLR start "p_NodeTest"
    p_NodeTest: function() {
        var retval = new XQueryParser.p_NodeTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_KindTest298 = null;
         var p_NameTest299 = null;


        try {
            // xquery/XQueryParser.g:983:9: ( p_KindTest | p_NameTest )
            var alt126=2;
            alt126 = this.dfa126.predict(this.input);
            switch (alt126) {
                case 1 :
                    // xquery/XQueryParser.g:983:11: p_KindTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_KindTest_in_p_NodeTest7269);
                    p_KindTest298=this.p_KindTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_KindTest298.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:983:24: p_NameTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_NameTest_in_p_NodeTest7273);
                    p_NameTest299=this.p_NameTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NameTest299.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_NameTest_return: (function() {
        XQueryParser.p_NameTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_NameTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:987:1: p_NameTest : ( ( p_Wildcard )=> p_Wildcard | ( p_NCName COLON )=> p_QName | ( p_NCName )=> p_QName );
    // $ANTLR start "p_NameTest"
    p_NameTest: function() {
        var retval = new XQueryParser.p_NameTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_Wildcard300 = null;
         var p_QName301 = null;
         var p_QName302 = null;


        try {
            // xquery/XQueryParser.g:988:9: ( ( p_Wildcard )=> p_Wildcard | ( p_NCName COLON )=> p_QName | ( p_NCName )=> p_QName )
            var alt127=3;
            var LA127_0 = this.input.LA(1);

            if ( (LA127_0==STAR) && (this.synpred13_XQueryParser())) {
                alt127=1;
            }
            else if ( ((LA127_0>=ANCESTOR && LA127_0<=SKIP)||(LA127_0>=VALUE && LA127_0<=QUOT_ER)||LA127_0==L_NCName||LA127_0==EXPLICITLY) ) {
                var LA127_2 = this.input.LA(2);

                if ( (LA127_2==COLON) && (this.synpred13_XQueryParser())) {
                    alt127=1;
                }
                else if ( (this.synpred14_XQueryParser()) ) {
                    alt127=2;
                }
                else if ( (this.synpred15_XQueryParser()) ) {
                    alt127=3;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 127, 2, this.input);

                    throw nvae;
                }
            }
            else if ( (LA127_0==QUOT) && (this.synpred13_XQueryParser())) {
                alt127=1;
            }
            else if ( (LA127_0==APOS) && (this.synpred13_XQueryParser())) {
                alt127=1;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 127, 0, this.input);

                throw nvae;
            }
            switch (alt127) {
                case 1 :
                    // xquery/XQueryParser.g:988:11: ( p_Wildcard )=> p_Wildcard
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_Wildcard_in_p_NameTest7305);
                    p_Wildcard300=this.p_Wildcard();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Wildcard300.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:989:11: ( p_NCName COLON )=> p_QName
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_NameTest7326);
                    p_QName301=this.p_QName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName301.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:990:11: ( p_NCName )=> p_QName
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_NameTest7344);
                    p_QName302=this.p_QName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName302.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Wildcard_return: (function() {
        XQueryParser.p_Wildcard_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Wildcard_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:994:1: p_Wildcard : ( STAR ( COLON p_NCName )? | p_NCName COLON STAR | p_StringLiteral COLON STAR );
    // $ANTLR start "p_Wildcard"
    p_Wildcard: function() {
        var retval = new XQueryParser.p_Wildcard_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var STAR303 = null;
        var COLON304 = null;
        var COLON307 = null;
        var STAR308 = null;
        var COLON310 = null;
        var STAR311 = null;
         var p_NCName305 = null;
         var p_NCName306 = null;
         var p_StringLiteral309 = null;

        var STAR303_tree=null;
        var COLON304_tree=null;
        var COLON307_tree=null;
        var STAR308_tree=null;
        var COLON310_tree=null;
        var STAR311_tree=null;

        this.setWsExplicit(true);
        try {
            // xquery/XQueryParser.g:995:9: ( STAR ( COLON p_NCName )? | p_NCName COLON STAR | p_StringLiteral COLON STAR )
            var alt129=3;
            switch ( this.input.LA(1) ) {
            case STAR:
                alt129=1;
                break;
            case ANCESTOR:
            case ANCESTOR_OR_SELF:
            case AND:
            case AS:
            case ASCENDING:
            case AT:
            case ATTRIBUTE:
            case BASE_URI:
            case BOUNDARY_SPACE:
            case BY:
            case CASE:
            case CAST:
            case CASTABLE:
            case CHILD:
            case COLLATION:
            case COMMENT:
            case CONSTRUCTION:
            case COPY_NAMESPACES:
            case DECLARE:
            case DEFAULT:
            case DESCENDANT:
            case DESCENDANT_OR_SELF:
            case DESCENDING:
            case DIV:
            case DOCUMENT:
            case DOCUMENT_NODE:
            case ELEMENT:
            case ELSE:
            case EMPTY:
            case EMPTY_SEQUENCE:
            case ENCODING:
            case EQ:
            case EVERY:
            case EXCEPT:
            case EXTERNAL:
            case FOLLOWING:
            case FOLLOWING_SIBLING:
            case FOR:
            case FUNCTION:
            case GE:
            case GREATEST:
            case GT:
            case IDIV:
            case IF:
            case IMPORT:
            case IN:
            case INHERIT:
            case INSTANCE:
            case INTERSECT:
            case IS:
            case ITEM:
            case LAX:
            case LE:
            case LEAST:
            case LET:
            case LT:
            case MOD:
            case MODULE:
            case NAMESPACE:
            case NE:
            case NO_INHERIT:
            case NO_PRESERVE:
            case NODE:
            case OF:
            case OPTION:
            case OR:
            case ORDER:
            case ORDERED:
            case ORDERING:
            case PARENT:
            case PRECEDING:
            case PRECEDING_SIBLING:
            case PRESERVE:
            case PROCESSING_INSTRUCTION:
            case RETURN:
            case SATISFIES:
            case SCHEMA:
            case SCHEMA_ATTRIBUTE:
            case SCHEMA_ELEMENT:
            case SELF:
            case SOME:
            case STABLE:
            case STRICT:
            case STRIP:
            case TEXT:
            case THEN:
            case TO:
            case TREAT:
            case TYPESWITCH:
            case UNION:
            case UNORDERED:
            case VALIDATE:
            case VARIABLE:
            case VERSION:
            case WHERE:
            case XQUERY:
            case ALLOWING:
            case CATCH:
            case CONTEXT:
            case COUNT:
            case DECIMAL_FORMAT:
            case DECIMAL_SEPARATOR:
            case DIGIT:
            case END:
            case GROUP:
            case GROUPING_SEPARATOR:
            case INFINITY:
            case MINUS_SIGN:
            case NAMESPACE_NODE:
            case NAN:
            case NEXT:
            case ONLY:
            case PATTERN_SEPARATOR:
            case PERCENT:
            case PER_MILLE:
            case PREVIOUS:
            case SLIDING:
            case START:
            case SWITCH:
            case TRY:
            case TUMBLING:
            case TYPE:
            case WHEN:
            case WINDOW:
            case ZERO_DIGIT:
            case AFTER:
            case BEFORE:
            case COPY:
            case DELETE:
            case FIRST:
            case INSERT:
            case INTO:
            case LAST:
            case MODIFY:
            case NODES:
            case RENAME:
            case REPLACE:
            case REVALIDATION:
            case SKIP:
            case VALUE:
            case WITH:
            case ALL:
            case ANY:
            case CONTAINS:
            case CONTENT:
            case DIACRITICS:
            case DIFFERENT:
            case DISTANCE:
            case ENTIRE:
            case EXACTLY:
            case FROM:
            case FT_OPTION:
            case FTAND:
            case FTNOT:
            case FTOR:
            case INSENSITIVE:
            case LANGUAGE:
            case LEVELS:
            case LOWERCASE:
            case MOST:
            case NO:
            case NOT:
            case OCCURS:
            case PARAGRAPH:
            case PARAGRAPHS:
            case PHRASE:
            case RELATIONSHIP:
            case SAME:
            case SCORE:
            case SENSITIVE:
            case SENTENCE:
            case SENTENCES:
            case STEMMING:
            case STOP:
            case THESAURUS:
            case TIMES:
            case UPPERCASE:
            case USING:
            case WEIGHT:
            case WILDCARDS:
            case WITHOUT:
            case WORD:
            case WORDS:
            case BREAK:
            case CONTINUE:
            case EXIT:
            case LOOP:
            case RETURNING:
            case WHILE:
            case CHECK:
            case COLLECTION:
            case CONSTRAINT:
            case FOREACH:
            case FOREIGN:
            case INDEX:
            case INTEGRITY:
            case KEY:
            case ON:
            case UNIQUE:
            case BINARY:
            case AMP_ER:
            case APOS_ER:
            case QUOT_ER:
            case L_NCName:
            case EXPLICITLY:
                alt129=2;
                break;
            case APOS:
            case QUOT:
                alt129=3;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 129, 0, this.input);

                throw nvae;
            }

            switch (alt129) {
                case 1 :
                    // xquery/XQueryParser.g:995:11: STAR ( COLON p_NCName )?
                    root_0 = this.adaptor.nil();

                    STAR303=this.match(this.input,STAR,XQueryParser.FOLLOW_STAR_in_p_Wildcard7374); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    STAR303_tree = this.adaptor.create(STAR303);
                    this.adaptor.addChild(root_0, STAR303_tree);
                    }
                    // xquery/XQueryParser.g:995:16: ( COLON p_NCName )?
                    var alt128=2;
                    var LA128_0 = this.input.LA(1);

                    if ( (LA128_0==COLON) ) {
                        alt128=1;
                    }
                    switch (alt128) {
                        case 1 :
                            // xquery/XQueryParser.g:995:17: COLON p_NCName
                            COLON304=this.match(this.input,COLON,XQueryParser.FOLLOW_COLON_in_p_Wildcard7377); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            COLON304_tree = this.adaptor.create(COLON304);
                            this.adaptor.addChild(root_0, COLON304_tree);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_p_Wildcard7379);
                            p_NCName305=this.p_NCName();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NCName305.getTree());


                            break;

                    }



                    break;
                case 2 :
                    // xquery/XQueryParser.g:996:11: p_NCName COLON STAR
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_p_Wildcard7393);
                    p_NCName306=this.p_NCName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NCName306.getTree());
                    COLON307=this.match(this.input,COLON,XQueryParser.FOLLOW_COLON_in_p_Wildcard7395); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON307_tree = this.adaptor.create(COLON307);
                    this.adaptor.addChild(root_0, COLON307_tree);
                    }
                    STAR308=this.match(this.input,STAR,XQueryParser.FOLLOW_STAR_in_p_Wildcard7397); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    STAR308_tree = this.adaptor.create(STAR308);
                    this.adaptor.addChild(root_0, STAR308_tree);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:997:11: p_StringLiteral COLON STAR
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_Wildcard7409);
                    p_StringLiteral309=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral309.getTree());
                    COLON310=this.match(this.input,COLON,XQueryParser.FOLLOW_COLON_in_p_Wildcard7411); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COLON310_tree = this.adaptor.create(COLON310);
                    this.adaptor.addChild(root_0, COLON310_tree);
                    }
                    STAR311=this.match(this.input,STAR,XQueryParser.FOLLOW_STAR_in_p_Wildcard7413); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    STAR311_tree = this.adaptor.create(STAR311);
                    this.adaptor.addChild(root_0, STAR311_tree);
                    }


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
            this.setWsExplicit(false);
        }
        return retval;
    },

    // inline static return class
    p_PostfixExpr_return: (function() {
        XQueryParser.p_PostfixExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PostfixExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1002:1: p_PostfixExpr : p_PrimaryExpr ( p_Predicate )* ;
    // $ANTLR start "p_PostfixExpr"
    p_PostfixExpr: function() {
        var retval = new XQueryParser.p_PostfixExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_PrimaryExpr312 = null;
         var p_Predicate313 = null;


        try {
            // xquery/XQueryParser.g:1003:9: ( p_PrimaryExpr ( p_Predicate )* )
            // xquery/XQueryParser.g:1003:11: p_PrimaryExpr ( p_Predicate )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_PrimaryExpr_in_p_PostfixExpr7451);
            p_PrimaryExpr312=this.p_PrimaryExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PrimaryExpr312.getTree());
            // xquery/XQueryParser.g:1003:25: ( p_Predicate )*
            loop130:
            do {
                var alt130=2;
                var LA130_0 = this.input.LA(1);

                if ( (LA130_0==LSQUARE) ) {
                    alt130=1;
                }


                switch (alt130) {
                case 1 :
                    // xquery/XQueryParser.g:1003:26: p_Predicate
                    this.pushFollow(XQueryParser.FOLLOW_p_Predicate_in_p_PostfixExpr7454);
                    p_Predicate313=this.p_Predicate();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Predicate313.getTree());


                    break;

                default :
                    break loop130;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ArgumentList_return: (function() {
        XQueryParser.p_ArgumentList_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ArgumentList_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1010:1: p_ArgumentList : LPAREN ( p_Argument ( COMMA p_Argument )* )? RPAREN ;
    // $ANTLR start "p_ArgumentList"
    p_ArgumentList: function() {
        var retval = new XQueryParser.p_ArgumentList_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var LPAREN314 = null;
        var COMMA316 = null;
        var RPAREN318 = null;
         var p_Argument315 = null;
         var p_Argument317 = null;

        var LPAREN314_tree=null;
        var COMMA316_tree=null;
        var RPAREN318_tree=null;

        try {
            // xquery/XQueryParser.g:1011:9: ( LPAREN ( p_Argument ( COMMA p_Argument )* )? RPAREN )
            // xquery/XQueryParser.g:1011:11: LPAREN ( p_Argument ( COMMA p_Argument )* )? RPAREN
            root_0 = this.adaptor.nil();

            LPAREN314=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_ArgumentList7495); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN314_tree = this.adaptor.create(LPAREN314);
            this.adaptor.addChild(root_0, LPAREN314_tree);
            }
            // xquery/XQueryParser.g:1011:18: ( p_Argument ( COMMA p_Argument )* )?
            var alt132=2;
            var LA132_0 = this.input.LA(1);

            if ( ((LA132_0>=ANCESTOR && LA132_0<=QUOT_ER)||LA132_0==LPAREN||(LA132_0>=DOLLAR && LA132_0<=LBRACKET)||(LA132_0>=QUESTION && LA132_0<=SMALLER)||(LA132_0>=SLASH && LA132_0<=DOT_DOT)||LA132_0==ATTR_SIGN||(LA132_0>=APOS && LA132_0<=QUOT)||LA132_0==L_NCName||(LA132_0>=L_Pragma && LA132_0<=L_DoubleLiteral)||LA132_0==EXPLICITLY) ) {
                alt132=1;
            }
            switch (alt132) {
                case 1 :
                    // xquery/XQueryParser.g:1011:19: p_Argument ( COMMA p_Argument )*
                    this.pushFollow(XQueryParser.FOLLOW_p_Argument_in_p_ArgumentList7498);
                    p_Argument315=this.p_Argument();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Argument315.getTree());
                    // xquery/XQueryParser.g:1011:30: ( COMMA p_Argument )*
                    loop131:
                    do {
                        var alt131=2;
                        var LA131_0 = this.input.LA(1);

                        if ( (LA131_0==COMMA) ) {
                            alt131=1;
                        }


                        switch (alt131) {
                        case 1 :
                            // xquery/XQueryParser.g:1011:31: COMMA p_Argument
                            COMMA316=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_ArgumentList7501); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            COMMA316_tree = this.adaptor.create(COMMA316);
                            this.adaptor.addChild(root_0, COMMA316_tree);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_Argument_in_p_ArgumentList7503);
                            p_Argument317=this.p_Argument();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Argument317.getTree());


                            break;

                        default :
                            break loop131;
                        }
                    } while (true);



                    break;

            }

            RPAREN318=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_ArgumentList7509); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN318_tree = this.adaptor.create(RPAREN318);
            this.adaptor.addChild(root_0, RPAREN318_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PredicateList_return: (function() {
        XQueryParser.p_PredicateList_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PredicateList_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1015:1: p_PredicateList : ( p_Predicate )* ;
    // $ANTLR start "p_PredicateList"
    p_PredicateList: function() {
        var retval = new XQueryParser.p_PredicateList_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_Predicate319 = null;


        try {
            // xquery/XQueryParser.g:1016:9: ( ( p_Predicate )* )
            // xquery/XQueryParser.g:1016:11: ( p_Predicate )*
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:1016:11: ( p_Predicate )*
            loop133:
            do {
                var alt133=2;
                var LA133_0 = this.input.LA(1);

                if ( (LA133_0==LSQUARE) ) {
                    alt133=1;
                }


                switch (alt133) {
                case 1 :
                    // xquery/XQueryParser.g:1016:11: p_Predicate
                    this.pushFollow(XQueryParser.FOLLOW_p_Predicate_in_p_PredicateList7535);
                    p_Predicate319=this.p_Predicate();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Predicate319.getTree());


                    break;

                default :
                    break loop133;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Predicate_return: (function() {
        XQueryParser.p_Predicate_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Predicate_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1020:1: p_Predicate : LSQUARE p_Expr[true,true] RSQUARE ;
    // $ANTLR start "p_Predicate"
    p_Predicate: function() {
        var retval = new XQueryParser.p_Predicate_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var LSQUARE320 = null;
        var RSQUARE322 = null;
         var p_Expr321 = null;

        var LSQUARE320_tree=null;
        var RSQUARE322_tree=null;

        try {
            // xquery/XQueryParser.g:1021:9: ( LSQUARE p_Expr[true,true] RSQUARE )
            // xquery/XQueryParser.g:1021:11: LSQUARE p_Expr[true,true] RSQUARE
            root_0 = this.adaptor.nil();

            LSQUARE320=this.match(this.input,LSQUARE,XQueryParser.FOLLOW_LSQUARE_in_p_Predicate7562); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LSQUARE320_tree = this.adaptor.create(LSQUARE320);
            this.adaptor.addChild(root_0, LSQUARE320_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_Predicate7564);
            p_Expr321=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr321.getTree());
            RSQUARE322=this.match(this.input,RSQUARE,XQueryParser.FOLLOW_RSQUARE_in_p_Predicate7567); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RSQUARE322_tree = this.adaptor.create(RSQUARE322);
            this.adaptor.addChild(root_0, RSQUARE322_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PrimaryExpr_return: (function() {
        XQueryParser.p_PrimaryExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PrimaryExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1026:1: p_PrimaryExpr : ( ( LPAREN )=> p_ParenthesizedExpr | p_Literal | p_VarRef | p_ContextItemExpr | p_FunctionCall | p_OrderedExpr | p_UnorderedExpr | p_Constructor | p_BlockExpr );
    // $ANTLR start "p_PrimaryExpr"
    p_PrimaryExpr: function() {
        var retval = new XQueryParser.p_PrimaryExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ParenthesizedExpr323 = null;
         var p_Literal324 = null;
         var p_VarRef325 = null;
         var p_ContextItemExpr326 = null;
         var p_FunctionCall327 = null;
         var p_OrderedExpr328 = null;
         var p_UnorderedExpr329 = null;
         var p_Constructor330 = null;
         var p_BlockExpr331 = null;


        try {
            // xquery/XQueryParser.g:1027:9: ( ( LPAREN )=> p_ParenthesizedExpr | p_Literal | p_VarRef | p_ContextItemExpr | p_FunctionCall | p_OrderedExpr | p_UnorderedExpr | p_Constructor | p_BlockExpr )
            var alt134=9;
            alt134 = this.dfa134.predict(this.input);
            switch (alt134) {
                case 1 :
                    // xquery/XQueryParser.g:1027:11: ( LPAREN )=> p_ParenthesizedExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ParenthesizedExpr_in_p_PrimaryExpr7600);
                    p_ParenthesizedExpr323=this.p_ParenthesizedExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ParenthesizedExpr323.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1028:11: p_Literal
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_Literal_in_p_PrimaryExpr7612);
                    p_Literal324=this.p_Literal();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Literal324.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:1029:11: p_VarRef
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_VarRef_in_p_PrimaryExpr7624);
                    p_VarRef325=this.p_VarRef();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_VarRef325.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:1030:11: p_ContextItemExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ContextItemExpr_in_p_PrimaryExpr7636);
                    p_ContextItemExpr326=this.p_ContextItemExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ContextItemExpr326.getTree());


                    break;
                case 5 :
                    // xquery/XQueryParser.g:1031:11: p_FunctionCall
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_FunctionCall_in_p_PrimaryExpr7648);
                    p_FunctionCall327=this.p_FunctionCall();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_FunctionCall327.getTree());


                    break;
                case 6 :
                    // xquery/XQueryParser.g:1032:11: p_OrderedExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_OrderedExpr_in_p_PrimaryExpr7660);
                    p_OrderedExpr328=this.p_OrderedExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_OrderedExpr328.getTree());


                    break;
                case 7 :
                    // xquery/XQueryParser.g:1033:11: p_UnorderedExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_UnorderedExpr_in_p_PrimaryExpr7672);
                    p_UnorderedExpr329=this.p_UnorderedExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_UnorderedExpr329.getTree());


                    break;
                case 8 :
                    // xquery/XQueryParser.g:1034:11: p_Constructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_Constructor_in_p_PrimaryExpr7684);
                    p_Constructor330=this.p_Constructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Constructor330.getTree());


                    break;
                case 9 :
                    // xquery/XQueryParser.g:1037:11: p_BlockExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_BlockExpr_in_p_PrimaryExpr7698);
                    p_BlockExpr331=this.p_BlockExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_BlockExpr331.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Literal_return: (function() {
        XQueryParser.p_Literal_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Literal_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1041:1: p_Literal : ( p_NumericLiteral | p_StringLiteral );
    // $ANTLR start "p_Literal"
    p_Literal: function() {
        var retval = new XQueryParser.p_Literal_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_NumericLiteral332 = null;
         var p_StringLiteral333 = null;


        try {
            // xquery/XQueryParser.g:1042:9: ( p_NumericLiteral | p_StringLiteral )
            var alt135=2;
            var LA135_0 = this.input.LA(1);

            if ( ((LA135_0>=L_IntegerLiteral && LA135_0<=L_DoubleLiteral)) ) {
                alt135=1;
            }
            else if ( ((LA135_0>=APOS && LA135_0<=QUOT)) ) {
                alt135=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 135, 0, this.input);

                throw nvae;
            }
            switch (alt135) {
                case 1 :
                    // xquery/XQueryParser.g:1042:11: p_NumericLiteral
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_NumericLiteral_in_p_Literal7724);
                    p_NumericLiteral332=this.p_NumericLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NumericLiteral332.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1042:30: p_StringLiteral
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_Literal7728);
                    p_StringLiteral333=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral333.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_NumericLiteral_return: (function() {
        XQueryParser.p_NumericLiteral_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_NumericLiteral_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1046:1: p_NumericLiteral : (d+= L_IntegerLiteral | d+= L_DecimalLiteral | d+= L_DoubleLiteral );
    // $ANTLR start "p_NumericLiteral"
    p_NumericLiteral: function() {
        var retval = new XQueryParser.p_NumericLiteral_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var d = null;
        var list_d=null;

        var d_tree=null;

        try {
            // xquery/XQueryParser.g:1047:9: (d+= L_IntegerLiteral | d+= L_DecimalLiteral | d+= L_DoubleLiteral )
            var alt136=3;
            switch ( this.input.LA(1) ) {
            case L_IntegerLiteral:
                alt136=1;
                break;
            case L_DecimalLiteral:
                alt136=2;
                break;
            case L_DoubleLiteral:
                alt136=3;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 136, 0, this.input);

                throw nvae;
            }

            switch (alt136) {
                case 1 :
                    // xquery/XQueryParser.g:1047:11: d+= L_IntegerLiteral
                    root_0 = this.adaptor.nil();

                    d=this.match(this.input,L_IntegerLiteral,XQueryParser.FOLLOW_L_IntegerLiteral_in_p_NumericLiteral7756); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    d_tree = this.adaptor.create(d);
                    this.adaptor.addChild(root_0, d_tree);
                    }
                    if (org.antlr.lang.isNull(list_d)) list_d = [];
                    list_d.push(d);

                    if ( this.state.backtracking===0 ) {
                      this.ad(list_d);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1047:48: d+= L_DecimalLiteral
                    root_0 = this.adaptor.nil();

                    d=this.match(this.input,L_DecimalLiteral,XQueryParser.FOLLOW_L_DecimalLiteral_in_p_NumericLiteral7764); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    d_tree = this.adaptor.create(d);
                    this.adaptor.addChild(root_0, d_tree);
                    }
                    if (org.antlr.lang.isNull(list_d)) list_d = [];
                    list_d.push(d);

                    if ( this.state.backtracking===0 ) {
                      this.ad(list_d);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:1047:85: d+= L_DoubleLiteral
                    root_0 = this.adaptor.nil();

                    d=this.match(this.input,L_DoubleLiteral,XQueryParser.FOLLOW_L_DoubleLiteral_in_p_NumericLiteral7772); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    d_tree = this.adaptor.create(d);
                    this.adaptor.addChild(root_0, d_tree);
                    }
                    if (org.antlr.lang.isNull(list_d)) list_d = [];
                    list_d.push(d);

                    if ( this.state.backtracking===0 ) {
                      this.ad(list_d);
                    }


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_VarRef_return: (function() {
        XQueryParser.p_VarRef_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_VarRef_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1051:1: p_VarRef : d= DOLLAR v= p_VarName ;
    // $ANTLR start "p_VarRef"
    p_VarRef: function() {
        var retval = new XQueryParser.p_VarRef_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var d = null;
         var v = null;

        var d_tree=null;

        try {
            // xquery/XQueryParser.g:1052:9: (d= DOLLAR v= p_VarName )
            // xquery/XQueryParser.g:1052:11: d= DOLLAR v= p_VarName
            root_0 = this.adaptor.nil();

            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_VarRef7810); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_VarRef7814);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (v?v.stop:null)); 
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_VarName_return: (function() {
        XQueryParser.p_VarName_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_VarName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1056:1: p_VarName : p_QName ;
    // $ANTLR start "p_VarName"
    p_VarName: function() {
        var retval = new XQueryParser.p_VarName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_QName334 = null;


        try {
            // xquery/XQueryParser.g:1057:9: ( p_QName )
            // xquery/XQueryParser.g:1057:11: p_QName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_VarName7842);
            p_QName334=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName334.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ParenthesizedExpr_return: (function() {
        XQueryParser.p_ParenthesizedExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ParenthesizedExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1061:1: p_ParenthesizedExpr : LPAREN ( p_Expr[true,true] )? RPAREN ;
    // $ANTLR start "p_ParenthesizedExpr"
    p_ParenthesizedExpr: function() {
        var retval = new XQueryParser.p_ParenthesizedExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var LPAREN335 = null;
        var RPAREN337 = null;
         var p_Expr336 = null;

        var LPAREN335_tree=null;
        var RPAREN337_tree=null;

        try {
            // xquery/XQueryParser.g:1062:9: ( LPAREN ( p_Expr[true,true] )? RPAREN )
            // xquery/XQueryParser.g:1062:11: LPAREN ( p_Expr[true,true] )? RPAREN
            root_0 = this.adaptor.nil();

            LPAREN335=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_ParenthesizedExpr7868); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN335_tree = this.adaptor.create(LPAREN335);
            this.adaptor.addChild(root_0, LPAREN335_tree);
            }
            // xquery/XQueryParser.g:1062:18: ( p_Expr[true,true] )?
            var alt137=2;
            var LA137_0 = this.input.LA(1);

            if ( ((LA137_0>=ANCESTOR && LA137_0<=QUOT_ER)||LA137_0==LPAREN||(LA137_0>=DOLLAR && LA137_0<=LBRACKET)||(LA137_0>=STAR && LA137_0<=SMALLER)||(LA137_0>=SLASH && LA137_0<=DOT_DOT)||LA137_0==ATTR_SIGN||(LA137_0>=APOS && LA137_0<=QUOT)||LA137_0==L_NCName||(LA137_0>=L_Pragma && LA137_0<=L_DoubleLiteral)||LA137_0==EXPLICITLY) ) {
                alt137=1;
            }
            switch (alt137) {
                case 1 :
                    // xquery/XQueryParser.g:1062:18: p_Expr[true,true]
                    this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_ParenthesizedExpr7870);
                    p_Expr336=this.p_Expr(true, true);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr336.getTree());


                    break;

            }

            RPAREN337=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_ParenthesizedExpr7874); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN337_tree = this.adaptor.create(RPAREN337);
            this.adaptor.addChild(root_0, RPAREN337_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ContextItemExpr_return: (function() {
        XQueryParser.p_ContextItemExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ContextItemExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1066:1: p_ContextItemExpr : DOT ;
    // $ANTLR start "p_ContextItemExpr"
    p_ContextItemExpr: function() {
        var retval = new XQueryParser.p_ContextItemExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var DOT338 = null;

        var DOT338_tree=null;

        try {
            // xquery/XQueryParser.g:1067:9: ( DOT )
            // xquery/XQueryParser.g:1067:11: DOT
            root_0 = this.adaptor.nil();

            DOT338=this.match(this.input,DOT,XQueryParser.FOLLOW_DOT_in_p_ContextItemExpr7900); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            DOT338_tree = this.adaptor.create(DOT338);
            this.adaptor.addChild(root_0, DOT338_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_OrderedExpr_return: (function() {
        XQueryParser.p_OrderedExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_OrderedExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1071:1: p_OrderedExpr : k= ORDERED LBRACKET p_Expr[true,true] RBRACKET ;
    // $ANTLR start "p_OrderedExpr"
    p_OrderedExpr: function() {
        var retval = new XQueryParser.p_OrderedExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET339 = null;
        var RBRACKET341 = null;
         var p_Expr340 = null;

        var k_tree=null;
        var LBRACKET339_tree=null;
        var RBRACKET341_tree=null;

        try {
            // xquery/XQueryParser.g:1072:9: (k= ORDERED LBRACKET p_Expr[true,true] RBRACKET )
            // xquery/XQueryParser.g:1072:11: k= ORDERED LBRACKET p_Expr[true,true] RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,ORDERED,XQueryParser.FOLLOW_ORDERED_in_p_OrderedExpr7928); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            LBRACKET339=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_OrderedExpr7932); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET339_tree = this.adaptor.create(LBRACKET339);
            this.adaptor.addChild(root_0, LBRACKET339_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_OrderedExpr7934);
            p_Expr340=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr340.getTree());
            RBRACKET341=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_OrderedExpr7937); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET341_tree = this.adaptor.create(RBRACKET341);
            this.adaptor.addChild(root_0, RBRACKET341_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_UnorderedExpr_return: (function() {
        XQueryParser.p_UnorderedExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_UnorderedExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1076:1: p_UnorderedExpr : k= UNORDERED LBRACKET p_Expr[true,true] RBRACKET ;
    // $ANTLR start "p_UnorderedExpr"
    p_UnorderedExpr: function() {
        var retval = new XQueryParser.p_UnorderedExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET342 = null;
        var RBRACKET344 = null;
         var p_Expr343 = null;

        var k_tree=null;
        var LBRACKET342_tree=null;
        var RBRACKET344_tree=null;

        try {
            // xquery/XQueryParser.g:1077:9: (k= UNORDERED LBRACKET p_Expr[true,true] RBRACKET )
            // xquery/XQueryParser.g:1077:11: k= UNORDERED LBRACKET p_Expr[true,true] RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,UNORDERED,XQueryParser.FOLLOW_UNORDERED_in_p_UnorderedExpr7965); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            LBRACKET342=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_UnorderedExpr7969); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET342_tree = this.adaptor.create(LBRACKET342);
            this.adaptor.addChild(root_0, LBRACKET342_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_UnorderedExpr7971);
            p_Expr343=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr343.getTree());
            RBRACKET344=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_UnorderedExpr7974); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET344_tree = this.adaptor.create(RBRACKET344);
            this.adaptor.addChild(root_0, RBRACKET344_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_FunctionCall_return: (function() {
        XQueryParser.p_FunctionCall_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_FunctionCall_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1082:1: p_FunctionCall : f= pg_FQName p_ArgumentList ;
    // $ANTLR start "p_FunctionCall"
    p_FunctionCall: function() {
        var retval = new XQueryParser.p_FunctionCall_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var f = null;
         var p_ArgumentList345 = null;


        try {
            // xquery/XQueryParser.g:1083:9: (f= pg_FQName p_ArgumentList )
            // xquery/XQueryParser.g:1083:11: f= pg_FQName p_ArgumentList
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_pg_FQName_in_p_FunctionCall8003);
            f=this.pg_FQName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, f.getTree());
            if ( this.state.backtracking===0 ) {
              this.af((f?f.start:null), (f?f.stop:null));
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ArgumentList_in_p_FunctionCall8008);
            p_ArgumentList345=this.p_ArgumentList();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ArgumentList345.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Argument_return: (function() {
        XQueryParser.p_Argument_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Argument_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1087:1: p_Argument : ( p_ExprSingle[true] | p_ArgumentPlaceholder );
    // $ANTLR start "p_Argument"
    p_Argument: function() {
        var retval = new XQueryParser.p_Argument_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ExprSingle346 = null;
         var p_ArgumentPlaceholder347 = null;


        try {
            // xquery/XQueryParser.g:1088:9: ( p_ExprSingle[true] | p_ArgumentPlaceholder )
            var alt138=2;
            var LA138_0 = this.input.LA(1);

            if ( ((LA138_0>=ANCESTOR && LA138_0<=QUOT_ER)||LA138_0==LPAREN||(LA138_0>=DOLLAR && LA138_0<=LBRACKET)||(LA138_0>=STAR && LA138_0<=SMALLER)||(LA138_0>=SLASH && LA138_0<=DOT_DOT)||LA138_0==ATTR_SIGN||(LA138_0>=APOS && LA138_0<=QUOT)||LA138_0==L_NCName||(LA138_0>=L_Pragma && LA138_0<=L_DoubleLiteral)||LA138_0==EXPLICITLY) ) {
                alt138=1;
            }
            else if ( (LA138_0==QUESTION) ) {
                alt138=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 138, 0, this.input);

                throw nvae;
            }
            switch (alt138) {
                case 1 :
                    // xquery/XQueryParser.g:1088:11: p_ExprSingle[true]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_Argument8034);
                    p_ExprSingle346=this.p_ExprSingle(true);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle346.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1088:32: p_ArgumentPlaceholder
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ArgumentPlaceholder_in_p_Argument8039);
                    p_ArgumentPlaceholder347=this.p_ArgumentPlaceholder();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ArgumentPlaceholder347.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ArgumentPlaceholder_return: (function() {
        XQueryParser.p_ArgumentPlaceholder_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ArgumentPlaceholder_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1092:1: p_ArgumentPlaceholder : QUESTION ;
    // $ANTLR start "p_ArgumentPlaceholder"
    p_ArgumentPlaceholder: function() {
        var retval = new XQueryParser.p_ArgumentPlaceholder_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var QUESTION348 = null;

        var QUESTION348_tree=null;

        try {
            // xquery/XQueryParser.g:1093:9: ( QUESTION )
            // xquery/XQueryParser.g:1093:11: QUESTION
            root_0 = this.adaptor.nil();

            QUESTION348=this.match(this.input,QUESTION,XQueryParser.FOLLOW_QUESTION_in_p_ArgumentPlaceholder8065); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            QUESTION348_tree = this.adaptor.create(QUESTION348);
            this.adaptor.addChild(root_0, QUESTION348_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Constructor_return: (function() {
        XQueryParser.p_Constructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Constructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1097:1: p_Constructor : ( p_DirectConstructor | p_ComputedConstructor );
    // $ANTLR start "p_Constructor"
    p_Constructor: function() {
        var retval = new XQueryParser.p_Constructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_DirectConstructor349 = null;
         var p_ComputedConstructor350 = null;


        try {
            // xquery/XQueryParser.g:1098:9: ( p_DirectConstructor | p_ComputedConstructor )
            var alt139=2;
            var LA139_0 = this.input.LA(1);

            if ( (LA139_0==SMALLER||(LA139_0>=L_DirCommentConstructor && LA139_0<=L_DirPIConstructor)) ) {
                alt139=1;
            }
            else if ( (LA139_0==ATTRIBUTE||LA139_0==COMMENT||LA139_0==DOCUMENT||LA139_0==ELEMENT||LA139_0==NAMESPACE||LA139_0==PROCESSING_INSTRUCTION||LA139_0==TEXT) ) {
                alt139=2;
            }
            else if ( (LA139_0==BINARY) && ((this.lc(MLS)))) {
                alt139=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 139, 0, this.input);

                throw nvae;
            }
            switch (alt139) {
                case 1 :
                    // xquery/XQueryParser.g:1098:11: p_DirectConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_DirectConstructor_in_p_Constructor8091);
                    p_DirectConstructor349=this.p_DirectConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_DirectConstructor349.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1099:11: p_ComputedConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ComputedConstructor_in_p_Constructor8103);
                    p_ComputedConstructor350=this.p_ComputedConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ComputedConstructor350.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_DirectConstructor_return: (function() {
        XQueryParser.p_DirectConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_DirectConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1103:1: p_DirectConstructor : ( p_DirElemConstructor | p_DirCommentConstructor | p_DirPIConstructor );
    // $ANTLR start "p_DirectConstructor"
    p_DirectConstructor: function() {
        var retval = new XQueryParser.p_DirectConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_DirElemConstructor351 = null;
         var p_DirCommentConstructor352 = null;
         var p_DirPIConstructor353 = null;


        try {
            // xquery/XQueryParser.g:1104:9: ( p_DirElemConstructor | p_DirCommentConstructor | p_DirPIConstructor )
            var alt140=3;
            switch ( this.input.LA(1) ) {
            case SMALLER:
                alt140=1;
                break;
            case L_DirCommentConstructor:
                alt140=2;
                break;
            case L_DirPIConstructor:
                alt140=3;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 140, 0, this.input);

                throw nvae;
            }

            switch (alt140) {
                case 1 :
                    // xquery/XQueryParser.g:1104:11: p_DirElemConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_DirElemConstructor_in_p_DirectConstructor8129);
                    p_DirElemConstructor351=this.p_DirElemConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_DirElemConstructor351.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1105:11: p_DirCommentConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_DirCommentConstructor_in_p_DirectConstructor8141);
                    p_DirCommentConstructor352=this.p_DirCommentConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_DirCommentConstructor352.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:1106:11: p_DirPIConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_DirPIConstructor_in_p_DirectConstructor8153);
                    p_DirPIConstructor353=this.p_DirPIConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_DirPIConstructor353.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_DirElemConstructor_return: (function() {
        XQueryParser.p_DirElemConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_DirElemConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1110:1: p_DirElemConstructor : SMALLER ts= p_QName p_DirAttributeList ( EMPTY_CLOSE_TAG | ( GREATER ( pm_DirElemContent )* CLOSE_TAG te= p_QName ( S )? GREATER ) ) -> ^( DirElemConstructor ^( DirAttributeList ( p_DirAttributeList )* ) ^( DirElemContent ( pm_DirElemContent )* ) ) ;
    // $ANTLR start "p_DirElemConstructor"
    p_DirElemConstructor: function() {
        var retval = new XQueryParser.p_DirElemConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var SMALLER354 = null;
        var EMPTY_CLOSE_TAG356 = null;
        var GREATER357 = null;
        var CLOSE_TAG359 = null;
        var S360 = null;
        var GREATER361 = null;
         var ts = null;
         var te = null;
         var p_DirAttributeList355 = null;
         var pm_DirElemContent358 = null;

        var SMALLER354_tree=null;
        var EMPTY_CLOSE_TAG356_tree=null;
        var GREATER357_tree=null;
        var CLOSE_TAG359_tree=null;
        var S360_tree=null;
        var GREATER361_tree=null;
        var stream_CLOSE_TAG=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token CLOSE_TAG");
        var stream_GREATER=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token GREATER");
        var stream_S=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token S");
        var stream_EMPTY_CLOSE_TAG=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EMPTY_CLOSE_TAG");
        var stream_SMALLER=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SMALLER");
        var stream_p_DirAttributeList=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_DirAttributeList");
        var stream_pm_DirElemContent=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_DirElemContent");
        var stream_p_QName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_QName");
        try {
            // xquery/XQueryParser.g:1111:9: ( SMALLER ts= p_QName p_DirAttributeList ( EMPTY_CLOSE_TAG | ( GREATER ( pm_DirElemContent )* CLOSE_TAG te= p_QName ( S )? GREATER ) ) -> ^( DirElemConstructor ^( DirAttributeList ( p_DirAttributeList )* ) ^( DirElemContent ( pm_DirElemContent )* ) ) )
            // xquery/XQueryParser.g:1111:11: SMALLER ts= p_QName p_DirAttributeList ( EMPTY_CLOSE_TAG | ( GREATER ( pm_DirElemContent )* CLOSE_TAG te= p_QName ( S )? GREATER ) )
            SMALLER354=this.match(this.input,SMALLER,XQueryParser.FOLLOW_SMALLER_in_p_DirElemConstructor8180); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SMALLER.add(SMALLER354);

            if ( this.state.backtracking===0 ) {
              this.pushXMLLexer();
            }
            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_DirElemConstructor8196);
            ts=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_QName.add(ts.getTree());
            if ( this.state.backtracking===0 ) {
              this.at((ts?ts.start:null), (ts?ts.stop:null));
            }
            this.pushFollow(XQueryParser.FOLLOW_p_DirAttributeList_in_p_DirElemConstructor8201);
            p_DirAttributeList355=this.p_DirAttributeList();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_DirAttributeList.add(p_DirAttributeList355.getTree());
            // xquery/XQueryParser.g:1113:11: ( EMPTY_CLOSE_TAG | ( GREATER ( pm_DirElemContent )* CLOSE_TAG te= p_QName ( S )? GREATER ) )
            var alt143=2;
            var LA143_0 = this.input.LA(1);

            if ( (LA143_0==EMPTY_CLOSE_TAG) ) {
                alt143=1;
            }
            else if ( (LA143_0==GREATER) ) {
                alt143=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 143, 0, this.input);

                throw nvae;
            }
            switch (alt143) {
                case 1 :
                    // xquery/XQueryParser.g:1113:12: EMPTY_CLOSE_TAG
                    EMPTY_CLOSE_TAG356=this.match(this.input,EMPTY_CLOSE_TAG,XQueryParser.FOLLOW_EMPTY_CLOSE_TAG_in_p_DirElemConstructor8215); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_EMPTY_CLOSE_TAG.add(EMPTY_CLOSE_TAG356);



                    break;
                case 2 :
                    // xquery/XQueryParser.g:1113:30: ( GREATER ( pm_DirElemContent )* CLOSE_TAG te= p_QName ( S )? GREATER )
                    // xquery/XQueryParser.g:1113:30: ( GREATER ( pm_DirElemContent )* CLOSE_TAG te= p_QName ( S )? GREATER )
                    // xquery/XQueryParser.g:1113:31: GREATER ( pm_DirElemContent )* CLOSE_TAG te= p_QName ( S )? GREATER
                    GREATER357=this.match(this.input,GREATER,XQueryParser.FOLLOW_GREATER_in_p_DirElemConstructor8220); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_GREATER.add(GREATER357);

                    // xquery/XQueryParser.g:1113:39: ( pm_DirElemContent )*
                    loop141:
                    do {
                        var alt141=2;
                        var LA141_0 = this.input.LA(1);

                        if ( ((LA141_0>=L_ElementContentChar && LA141_0<=ESCAPE_RBRACKET)||LA141_0==LBRACKET||LA141_0==SMALLER||(LA141_0>=L_DirCommentConstructor && LA141_0<=L_DirPIConstructor)) ) {
                            alt141=1;
                        }


                        switch (alt141) {
                        case 1 :
                            // xquery/XQueryParser.g:1113:39: pm_DirElemContent
                            this.pushFollow(XQueryParser.FOLLOW_pm_DirElemContent_in_p_DirElemConstructor8222);
                            pm_DirElemContent358=this.pm_DirElemContent();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_pm_DirElemContent.add(pm_DirElemContent358.getTree());


                            break;

                        default :
                            break loop141;
                        }
                    } while (true);

                    CLOSE_TAG359=this.match(this.input,CLOSE_TAG,XQueryParser.FOLLOW_CLOSE_TAG_in_p_DirElemConstructor8225); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_CLOSE_TAG.add(CLOSE_TAG359);

                    this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_DirElemConstructor8229);
                    te=this.p_QName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_QName.add(te.getTree());
                    if ( this.state.backtracking===0 ) {
                      this.at((te?te.start:null), (te?te.stop:null));
                    }
                    // xquery/XQueryParser.g:1113:111: ( S )?
                    var alt142=2;
                    var LA142_0 = this.input.LA(1);

                    if ( (LA142_0==S) ) {
                        alt142=1;
                    }
                    switch (alt142) {
                        case 1 :
                            // xquery/XQueryParser.g:1113:111: S
                            S360=this.match(this.input,S,XQueryParser.FOLLOW_S_in_p_DirElemConstructor8233); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_S.add(S360);



                            break;

                    }

                    GREATER361=this.match(this.input,GREATER,XQueryParser.FOLLOW_GREATER_in_p_DirElemConstructor8236); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_GREATER.add(GREATER361);






                    break;

            }



            // AST REWRITE
            // elements: p_DirAttributeList, pm_DirElemContent
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 1114:17: -> ^( DirElemConstructor ^( DirAttributeList ( p_DirAttributeList )* ) ^( DirElemContent ( pm_DirElemContent )* ) )
            {
                // xquery/XQueryParser.g:1114:20: ^( DirElemConstructor ^( DirAttributeList ( p_DirAttributeList )* ) ^( DirElemContent ( pm_DirElemContent )* ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(DirElemConstructor, "DirElemConstructor"), root_1);

                // xquery/XQueryParser.g:1114:41: ^( DirAttributeList ( p_DirAttributeList )* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(DirAttributeList, "DirAttributeList"), root_2);

                // xquery/XQueryParser.g:1114:60: ( p_DirAttributeList )*
                while ( stream_p_DirAttributeList.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_p_DirAttributeList.nextTree());

                }
                stream_p_DirAttributeList.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // xquery/XQueryParser.g:1114:81: ^( DirElemContent ( pm_DirElemContent )* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(DirElemContent, "DirElemContent"), root_2);

                // xquery/XQueryParser.g:1114:98: ( pm_DirElemContent )*
                while ( stream_pm_DirElemContent.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_pm_DirElemContent.nextTree());

                }
                stream_pm_DirElemContent.reset();

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
            this.popLexer(); 
        }
        return retval;
    },

    // inline static return class
    p_DirAttributeList_return: (function() {
        XQueryParser.p_DirAttributeList_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_DirAttributeList_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1119:1: p_DirAttributeList : ( S (t= p_QName ( S )? EQUAL ( S )? v= p_DirAttributeValue )? )* ;
    // $ANTLR start "p_DirAttributeList"
    p_DirAttributeList: function() {
        var retval = new XQueryParser.p_DirAttributeList_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var S362 = null;
        var S363 = null;
        var EQUAL364 = null;
        var S365 = null;
         var t = null;
         var v = null;

        var S362_tree=null;
        var S363_tree=null;
        var EQUAL364_tree=null;
        var S365_tree=null;

        try {
            // xquery/XQueryParser.g:1120:9: ( ( S (t= p_QName ( S )? EQUAL ( S )? v= p_DirAttributeValue )? )* )
            // xquery/XQueryParser.g:1120:11: ( S (t= p_QName ( S )? EQUAL ( S )? v= p_DirAttributeValue )? )*
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:1120:11: ( S (t= p_QName ( S )? EQUAL ( S )? v= p_DirAttributeValue )? )*
            loop147:
            do {
                var alt147=2;
                var LA147_0 = this.input.LA(1);

                if ( (LA147_0==S) ) {
                    alt147=1;
                }


                switch (alt147) {
                case 1 :
                    // xquery/XQueryParser.g:1120:12: S (t= p_QName ( S )? EQUAL ( S )? v= p_DirAttributeValue )?
                    S362=this.match(this.input,S,XQueryParser.FOLLOW_S_in_p_DirAttributeList8313); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    S362_tree = this.adaptor.create(S362);
                    this.adaptor.addChild(root_0, S362_tree);
                    }
                    // xquery/XQueryParser.g:1120:14: (t= p_QName ( S )? EQUAL ( S )? v= p_DirAttributeValue )?
                    var alt146=2;
                    var LA146_0 = this.input.LA(1);

                    if ( ((LA146_0>=ANCESTOR && LA146_0<=SKIP)||(LA146_0>=VALUE && LA146_0<=QUOT_ER)||LA146_0==L_NCName||LA146_0==EXPLICITLY) ) {
                        alt146=1;
                    }
                    switch (alt146) {
                        case 1 :
                            // xquery/XQueryParser.g:1120:15: t= p_QName ( S )? EQUAL ( S )? v= p_DirAttributeValue
                            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_DirAttributeList8318);
                            t=this.p_QName();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, t.getTree());
                            if ( this.state.backtracking===0 ) {
                              this.at((t?t.start:null), (t?t.stop:null));
                            }
                            // xquery/XQueryParser.g:1120:55: ( S )?
                            var alt144=2;
                            var LA144_0 = this.input.LA(1);

                            if ( (LA144_0==S) ) {
                                alt144=1;
                            }
                            switch (alt144) {
                                case 1 :
                                    // xquery/XQueryParser.g:1120:55: S
                                    S363=this.match(this.input,S,XQueryParser.FOLLOW_S_in_p_DirAttributeList8322); if (this.state.failed) return retval;
                                    if ( this.state.backtracking===0 ) {
                                    S363_tree = this.adaptor.create(S363);
                                    this.adaptor.addChild(root_0, S363_tree);
                                    }


                                    break;

                            }

                            EQUAL364=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_p_DirAttributeList8325); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            EQUAL364_tree = this.adaptor.create(EQUAL364);
                            this.adaptor.addChild(root_0, EQUAL364_tree);
                            }
                            // xquery/XQueryParser.g:1120:64: ( S )?
                            var alt145=2;
                            var LA145_0 = this.input.LA(1);

                            if ( (LA145_0==S) ) {
                                alt145=1;
                            }
                            switch (alt145) {
                                case 1 :
                                    // xquery/XQueryParser.g:1120:64: S
                                    S365=this.match(this.input,S,XQueryParser.FOLLOW_S_in_p_DirAttributeList8327); if (this.state.failed) return retval;
                                    if ( this.state.backtracking===0 ) {
                                    S365_tree = this.adaptor.create(S365);
                                    this.adaptor.addChild(root_0, S365_tree);
                                    }


                                    break;

                            }

                            this.pushFollow(XQueryParser.FOLLOW_p_DirAttributeValue_in_p_DirAttributeList8332);
                            v=this.p_DirAttributeValue();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());


                            break;

                    }



                    break;

                default :
                    break loop147;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_DirAttributeValue_return: (function() {
        XQueryParser.p_DirAttributeValue_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_DirAttributeValue_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1124:1: p_DirAttributeValue : ( (s+= QUOT (s+= ESCAPE_QUOT | s+= APOS | p_QuotAttrValueContent )* s+= QUOT ) -> ^( DirAttributeValue ( p_QuotAttrValueContent )* ) | (s+= APOS (s+= ESCAPE_APOS | s+= QUOT | p_AposAttrValueContent )* s+= APOS ) -> ^( DirAttributeValue ( p_AposAttrValueContent )* ) );
    // $ANTLR start "p_DirAttributeValue"
    p_DirAttributeValue: function() {
        var retval = new XQueryParser.p_DirAttributeValue_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var s = null;
        var list_s=null;
         var p_QuotAttrValueContent366 = null;
         var p_AposAttrValueContent367 = null;

        var s_tree=null;
        var stream_ESCAPE_QUOT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token ESCAPE_QUOT");
        var stream_APOS=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token APOS");
        var stream_ESCAPE_APOS=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token ESCAPE_APOS");
        var stream_QUOT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token QUOT");
        var stream_p_QuotAttrValueContent=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_QuotAttrValueContent");
        var stream_p_AposAttrValueContent=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_AposAttrValueContent");
        try {
            // xquery/XQueryParser.g:1125:9: ( (s+= QUOT (s+= ESCAPE_QUOT | s+= APOS | p_QuotAttrValueContent )* s+= QUOT ) -> ^( DirAttributeValue ( p_QuotAttrValueContent )* ) | (s+= APOS (s+= ESCAPE_APOS | s+= QUOT | p_AposAttrValueContent )* s+= APOS ) -> ^( DirAttributeValue ( p_AposAttrValueContent )* ) )
            var alt150=2;
            var LA150_0 = this.input.LA(1);

            if ( (LA150_0==QUOT) ) {
                alt150=1;
            }
            else if ( (LA150_0==APOS) ) {
                alt150=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 150, 0, this.input);

                throw nvae;
            }
            switch (alt150) {
                case 1 :
                    // xquery/XQueryParser.g:1125:11: (s+= QUOT (s+= ESCAPE_QUOT | s+= APOS | p_QuotAttrValueContent )* s+= QUOT )
                    // xquery/XQueryParser.g:1125:11: (s+= QUOT (s+= ESCAPE_QUOT | s+= APOS | p_QuotAttrValueContent )* s+= QUOT )
                    // xquery/XQueryParser.g:1125:12: s+= QUOT (s+= ESCAPE_QUOT | s+= APOS | p_QuotAttrValueContent )* s+= QUOT
                    s=this.match(this.input,QUOT,XQueryParser.FOLLOW_QUOT_in_p_DirAttributeValue8366); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_QUOT.add(s);

                    if (org.antlr.lang.isNull(list_s)) list_s = [];
                    list_s.push(s);

                    if ( this.state.backtracking===0 ) {
                      this.isInAttr = true; 
                    }
                    // xquery/XQueryParser.g:1125:45: (s+= ESCAPE_QUOT | s+= APOS | p_QuotAttrValueContent )*
                    loop148:
                    do {
                        var alt148=4;
                        switch ( this.input.LA(1) ) {
                        case ESCAPE_QUOT:
                            alt148=1;
                            break;
                        case APOS:
                            alt148=2;
                            break;
                        case L_QuotAttrContentChar:
                        case L_PredefinedEntityRef:
                        case L_CharRef:
                        case ESCAPE_LBRACKET:
                        case ESCAPE_RBRACKET:
                        case LBRACKET:
                            alt148=3;
                            break;

                        }

                        switch (alt148) {
                        case 1 :
                            // xquery/XQueryParser.g:1125:46: s+= ESCAPE_QUOT
                            s=this.match(this.input,ESCAPE_QUOT,XQueryParser.FOLLOW_ESCAPE_QUOT_in_p_DirAttributeValue8373); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_ESCAPE_QUOT.add(s);

                            if (org.antlr.lang.isNull(list_s)) list_s = [];
                            list_s.push(s);



                            break;
                        case 2 :
                            // xquery/XQueryParser.g:1125:63: s+= APOS
                            s=this.match(this.input,APOS,XQueryParser.FOLLOW_APOS_in_p_DirAttributeValue8379); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_APOS.add(s);

                            if (org.antlr.lang.isNull(list_s)) list_s = [];
                            list_s.push(s);



                            break;
                        case 3 :
                            // xquery/XQueryParser.g:1125:73: p_QuotAttrValueContent
                            this.pushFollow(XQueryParser.FOLLOW_p_QuotAttrValueContent_in_p_DirAttributeValue8383);
                            p_QuotAttrValueContent366=this.p_QuotAttrValueContent();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_QuotAttrValueContent.add(p_QuotAttrValueContent366.getTree());


                            break;

                        default :
                            break loop148;
                        }
                    } while (true);

                    s=this.match(this.input,QUOT,XQueryParser.FOLLOW_QUOT_in_p_DirAttributeValue8389); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_QUOT.add(s);

                    if (org.antlr.lang.isNull(list_s)) list_s = [];
                    list_s.push(s);

                    if ( this.state.backtracking===0 ) {
                       this.isInAttr = false; 
                    }



                    if ( this.state.backtracking===0 ) {
                       this.addToken(list_s, "string"); 
                    }


                    // AST REWRITE
                    // elements: p_QuotAttrValueContent
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1126:17: -> ^( DirAttributeValue ( p_QuotAttrValueContent )* )
                    {
                        // xquery/XQueryParser.g:1126:20: ^( DirAttributeValue ( p_QuotAttrValueContent )* )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(DirAttributeValue, "DirAttributeValue"), root_1);

                        // xquery/XQueryParser.g:1126:40: ( p_QuotAttrValueContent )*
                        while ( stream_p_QuotAttrValueContent.hasNext() ) {
                            this.adaptor.addChild(root_1, stream_p_QuotAttrValueContent.nextTree());

                        }
                        stream_p_QuotAttrValueContent.reset();

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;
                case 2 :
                    // xquery/XQueryParser.g:1127:11: (s+= APOS (s+= ESCAPE_APOS | s+= QUOT | p_AposAttrValueContent )* s+= APOS )
                    // xquery/XQueryParser.g:1127:11: (s+= APOS (s+= ESCAPE_APOS | s+= QUOT | p_AposAttrValueContent )* s+= APOS )
                    // xquery/XQueryParser.g:1127:12: s+= APOS (s+= ESCAPE_APOS | s+= QUOT | p_AposAttrValueContent )* s+= APOS
                    s=this.match(this.input,APOS,XQueryParser.FOLLOW_APOS_in_p_DirAttributeValue8434); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_APOS.add(s);

                    if (org.antlr.lang.isNull(list_s)) list_s = [];
                    list_s.push(s);

                    if ( this.state.backtracking===0 ) {
                       this.isInAttr = true; 
                    }
                    // xquery/XQueryParser.g:1127:46: (s+= ESCAPE_APOS | s+= QUOT | p_AposAttrValueContent )*
                    loop149:
                    do {
                        var alt149=4;
                        switch ( this.input.LA(1) ) {
                        case ESCAPE_APOS:
                            alt149=1;
                            break;
                        case QUOT:
                            alt149=2;
                            break;
                        case L_AposAttrContentChar:
                        case L_PredefinedEntityRef:
                        case L_CharRef:
                        case ESCAPE_LBRACKET:
                        case ESCAPE_RBRACKET:
                        case LBRACKET:
                            alt149=3;
                            break;

                        }

                        switch (alt149) {
                        case 1 :
                            // xquery/XQueryParser.g:1127:47: s+= ESCAPE_APOS
                            s=this.match(this.input,ESCAPE_APOS,XQueryParser.FOLLOW_ESCAPE_APOS_in_p_DirAttributeValue8441); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_ESCAPE_APOS.add(s);

                            if (org.antlr.lang.isNull(list_s)) list_s = [];
                            list_s.push(s);



                            break;
                        case 2 :
                            // xquery/XQueryParser.g:1127:64: s+= QUOT
                            s=this.match(this.input,QUOT,XQueryParser.FOLLOW_QUOT_in_p_DirAttributeValue8447); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_QUOT.add(s);

                            if (org.antlr.lang.isNull(list_s)) list_s = [];
                            list_s.push(s);



                            break;
                        case 3 :
                            // xquery/XQueryParser.g:1127:74: p_AposAttrValueContent
                            this.pushFollow(XQueryParser.FOLLOW_p_AposAttrValueContent_in_p_DirAttributeValue8451);
                            p_AposAttrValueContent367=this.p_AposAttrValueContent();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_AposAttrValueContent.add(p_AposAttrValueContent367.getTree());


                            break;

                        default :
                            break loop149;
                        }
                    } while (true);

                    s=this.match(this.input,APOS,XQueryParser.FOLLOW_APOS_in_p_DirAttributeValue8457); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_APOS.add(s);

                    if (org.antlr.lang.isNull(list_s)) list_s = [];
                    list_s.push(s);

                    if ( this.state.backtracking===0 ) {
                       this.isInAttr = false; 
                    }



                    if ( this.state.backtracking===0 ) {
                       this.addToken(list_s, "string"); 
                    }


                    // AST REWRITE
                    // elements: p_AposAttrValueContent
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1128:17: -> ^( DirAttributeValue ( p_AposAttrValueContent )* )
                    {
                        // xquery/XQueryParser.g:1128:20: ^( DirAttributeValue ( p_AposAttrValueContent )* )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(DirAttributeValue, "DirAttributeValue"), root_1);

                        // xquery/XQueryParser.g:1128:40: ( p_AposAttrValueContent )*
                        while ( stream_p_AposAttrValueContent.hasNext() ) {
                            this.adaptor.addChild(root_1, stream_p_AposAttrValueContent.nextTree());

                        }
                        stream_p_AposAttrValueContent.reset();

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_QuotAttrValueContent_return: (function() {
        XQueryParser.p_QuotAttrValueContent_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_QuotAttrValueContent_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1132:1: p_QuotAttrValueContent : (s= p_QuotAttrContentChar | pm_CommonContent );
    // $ANTLR start "p_QuotAttrValueContent"
    p_QuotAttrValueContent: function() {
        var retval = new XQueryParser.p_QuotAttrValueContent_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var s = null;
         var pm_CommonContent368 = null;


        try {
            // xquery/XQueryParser.g:1133:9: (s= p_QuotAttrContentChar | pm_CommonContent )
            var alt151=2;
            var LA151_0 = this.input.LA(1);

            if ( (LA151_0==L_QuotAttrContentChar) ) {
                alt151=1;
            }
            else if ( ((LA151_0>=L_PredefinedEntityRef && LA151_0<=ESCAPE_RBRACKET)||LA151_0==LBRACKET) ) {
                alt151=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 151, 0, this.input);

                throw nvae;
            }
            switch (alt151) {
                case 1 :
                    // xquery/XQueryParser.g:1133:11: s= p_QuotAttrContentChar
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_QuotAttrContentChar_in_p_QuotAttrValueContent8515);
                    s=this.p_QuotAttrContentChar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, s.getTree());
                    if ( this.state.backtracking===0 ) {
                       this.addString((s?s.start:null), (s?s.stop:null)); 
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1133:76: pm_CommonContent
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_CommonContent_in_p_QuotAttrValueContent8521);
                    pm_CommonContent368=this.pm_CommonContent();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_CommonContent368.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AposAttrValueContent_return: (function() {
        XQueryParser.p_AposAttrValueContent_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AposAttrValueContent_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1137:1: p_AposAttrValueContent : (s= p_AposAttrContentChar | pm_CommonContent );
    // $ANTLR start "p_AposAttrValueContent"
    p_AposAttrValueContent: function() {
        var retval = new XQueryParser.p_AposAttrValueContent_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var s = null;
         var pm_CommonContent369 = null;


        try {
            // xquery/XQueryParser.g:1138:9: (s= p_AposAttrContentChar | pm_CommonContent )
            var alt152=2;
            var LA152_0 = this.input.LA(1);

            if ( (LA152_0==L_AposAttrContentChar) ) {
                alt152=1;
            }
            else if ( ((LA152_0>=L_PredefinedEntityRef && LA152_0<=ESCAPE_RBRACKET)||LA152_0==LBRACKET) ) {
                alt152=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 152, 0, this.input);

                throw nvae;
            }
            switch (alt152) {
                case 1 :
                    // xquery/XQueryParser.g:1138:11: s= p_AposAttrContentChar
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_AposAttrContentChar_in_p_AposAttrValueContent8549);
                    s=this.p_AposAttrContentChar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, s.getTree());
                    if ( this.state.backtracking===0 ) {
                       this.addString((s?s.start:null), (s?s.stop:null)); 
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1138:76: pm_CommonContent
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_CommonContent_in_p_AposAttrValueContent8555);
                    pm_CommonContent369=this.pm_CommonContent();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_CommonContent369.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_DirElemContent_return: (function() {
        XQueryParser.pm_DirElemContent_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_DirElemContent_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1142:1: pm_DirElemContent : ( p_DirectConstructor | p_CDataSection | pm_CommonContent | p_ElementContentChar );
    // $ANTLR start "pm_DirElemContent"
    pm_DirElemContent: function() {
        var retval = new XQueryParser.pm_DirElemContent_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_DirectConstructor370 = null;
         var p_CDataSection371 = null;
         var pm_CommonContent372 = null;
         var p_ElementContentChar373 = null;


        try {
            // xquery/XQueryParser.g:1143:9: ( p_DirectConstructor | p_CDataSection | pm_CommonContent | p_ElementContentChar )
            var alt153=4;
            switch ( this.input.LA(1) ) {
            case SMALLER:
            case L_DirCommentConstructor:
            case L_DirPIConstructor:
                alt153=1;
                break;
            case L_CDataSection:
                alt153=2;
                break;
            case L_PredefinedEntityRef:
            case L_CharRef:
            case ESCAPE_LBRACKET:
            case ESCAPE_RBRACKET:
            case LBRACKET:
                alt153=3;
                break;
            case L_ElementContentChar:
                alt153=4;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 153, 0, this.input);

                throw nvae;
            }

            switch (alt153) {
                case 1 :
                    // xquery/XQueryParser.g:1143:11: p_DirectConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_DirectConstructor_in_pm_DirElemContent8581);
                    p_DirectConstructor370=this.p_DirectConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_DirectConstructor370.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1144:11: p_CDataSection
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_CDataSection_in_pm_DirElemContent8593);
                    p_CDataSection371=this.p_CDataSection();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CDataSection371.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:1145:11: pm_CommonContent
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_CommonContent_in_pm_DirElemContent8605);
                    pm_CommonContent372=this.pm_CommonContent();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_CommonContent372.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:1146:11: p_ElementContentChar
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ElementContentChar_in_pm_DirElemContent8617);
                    p_ElementContentChar373=this.p_ElementContentChar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ElementContentChar373.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_CommonContent_return: (function() {
        XQueryParser.pm_CommonContent_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_CommonContent_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1152:1: pm_CommonContent : ( L_PredefinedEntityRef | L_CharRef | s= ESCAPE_LBRACKET | s= ESCAPE_RBRACKET | pg_EnclosedExprXml );
    // $ANTLR start "pm_CommonContent"
    pm_CommonContent: function() {
        var retval = new XQueryParser.pm_CommonContent_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var s = null;
        var L_PredefinedEntityRef374 = null;
        var L_CharRef375 = null;
         var pg_EnclosedExprXml376 = null;

        var s_tree=null;
        var L_PredefinedEntityRef374_tree=null;
        var L_CharRef375_tree=null;

        try {
            // xquery/XQueryParser.g:1153:9: ( L_PredefinedEntityRef | L_CharRef | s= ESCAPE_LBRACKET | s= ESCAPE_RBRACKET | pg_EnclosedExprXml )
            var alt154=5;
            switch ( this.input.LA(1) ) {
            case L_PredefinedEntityRef:
                alt154=1;
                break;
            case L_CharRef:
                alt154=2;
                break;
            case ESCAPE_LBRACKET:
                alt154=3;
                break;
            case ESCAPE_RBRACKET:
                alt154=4;
                break;
            case LBRACKET:
                alt154=5;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 154, 0, this.input);

                throw nvae;
            }

            switch (alt154) {
                case 1 :
                    // xquery/XQueryParser.g:1153:11: L_PredefinedEntityRef
                    root_0 = this.adaptor.nil();

                    L_PredefinedEntityRef374=this.match(this.input,L_PredefinedEntityRef,XQueryParser.FOLLOW_L_PredefinedEntityRef_in_pm_CommonContent8645); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    L_PredefinedEntityRef374_tree = this.adaptor.create(L_PredefinedEntityRef374);
                    this.adaptor.addChild(root_0, L_PredefinedEntityRef374_tree);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1154:11: L_CharRef
                    root_0 = this.adaptor.nil();

                    L_CharRef375=this.match(this.input,L_CharRef,XQueryParser.FOLLOW_L_CharRef_in_pm_CommonContent8657); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    L_CharRef375_tree = this.adaptor.create(L_CharRef375);
                    this.adaptor.addChild(root_0, L_CharRef375_tree);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:1155:11: s= ESCAPE_LBRACKET
                    root_0 = this.adaptor.nil();

                    s=this.match(this.input,ESCAPE_LBRACKET,XQueryParser.FOLLOW_ESCAPE_LBRACKET_in_pm_CommonContent8671); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    s_tree = this.adaptor.create(s);
                    this.adaptor.addChild(root_0, s_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                       if(this.isInAttr) { this.addToken(s, "string");  } 
                    }


                    break;
                case 4 :
                    // xquery/XQueryParser.g:1156:11: s= ESCAPE_RBRACKET
                    root_0 = this.adaptor.nil();

                    s=this.match(this.input,ESCAPE_RBRACKET,XQueryParser.FOLLOW_ESCAPE_RBRACKET_in_pm_CommonContent8687); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    s_tree = this.adaptor.create(s);
                    this.adaptor.addChild(root_0, s_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                       if(this.isInAttr) { this.addToken(s, "string");  } 
                    }


                    break;
                case 5 :
                    // xquery/XQueryParser.g:1157:11: pg_EnclosedExprXml
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pg_EnclosedExprXml_in_pm_CommonContent8701);
                    pg_EnclosedExprXml376=this.pg_EnclosedExprXml();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pg_EnclosedExprXml376.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pg_EnclosedExprXml_return: (function() {
        XQueryParser.pg_EnclosedExprXml_return = function(){};
        org.antlr.lang.extend(XQueryParser.pg_EnclosedExprXml_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1165:1: pg_EnclosedExprXml : LBRACKET p_StatementsAndOptionalExpr RBRACKET ;
    // $ANTLR start "pg_EnclosedExprXml"
    pg_EnclosedExprXml: function() {
        var retval = new XQueryParser.pg_EnclosedExprXml_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var LBRACKET377 = null;
        var RBRACKET379 = null;
         var p_StatementsAndOptionalExpr378 = null;

        var LBRACKET377_tree=null;
        var RBRACKET379_tree=null;

        try {
            // xquery/XQueryParser.g:1166:9: ( LBRACKET p_StatementsAndOptionalExpr RBRACKET )
            // xquery/XQueryParser.g:1166:13: LBRACKET p_StatementsAndOptionalExpr RBRACKET
            root_0 = this.adaptor.nil();

            LBRACKET377=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pg_EnclosedExprXml8733); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET377_tree = this.adaptor.create(LBRACKET377);
            this.adaptor.addChild(root_0, LBRACKET377_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.pushXQueryLexer();
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StatementsAndOptionalExpr_in_pg_EnclosedExprXml8749);
            p_StatementsAndOptionalExpr378=this.p_StatementsAndOptionalExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StatementsAndOptionalExpr378.getTree());
            RBRACKET379=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pg_EnclosedExprXml8763); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET379_tree = this.adaptor.create(RBRACKET379);
            this.adaptor.addChild(root_0, RBRACKET379_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.popLexer();
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_DirCommentConstructor_return: (function() {
        XQueryParser.p_DirCommentConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_DirCommentConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1173:1: p_DirCommentConstructor : c= L_DirCommentConstructor ;
    // $ANTLR start "p_DirCommentConstructor"
    p_DirCommentConstructor: function() {
        var retval = new XQueryParser.p_DirCommentConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var c = null;

        var c_tree=null;

        try {
            // xquery/XQueryParser.g:1174:9: (c= L_DirCommentConstructor )
            // xquery/XQueryParser.g:1174:11: c= L_DirCommentConstructor
            root_0 = this.adaptor.nil();

            c=this.match(this.input,L_DirCommentConstructor,XQueryParser.FOLLOW_L_DirCommentConstructor_in_p_DirCommentConstructor8794); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            c_tree = this.adaptor.create(c);
            this.adaptor.addChild(root_0, c_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ac(c);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_DirPIConstructor_return: (function() {
        XQueryParser.p_DirPIConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_DirPIConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1181:1: p_DirPIConstructor : p= L_DirPIConstructor ;
    // $ANTLR start "p_DirPIConstructor"
    p_DirPIConstructor: function() {
        var retval = new XQueryParser.p_DirPIConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var p = null;

        var p_tree=null;

        try {
            // xquery/XQueryParser.g:1182:9: (p= L_DirPIConstructor )
            // xquery/XQueryParser.g:1182:11: p= L_DirPIConstructor
            root_0 = this.adaptor.nil();

            p=this.match(this.input,L_DirPIConstructor,XQueryParser.FOLLOW_L_DirPIConstructor_in_p_DirPIConstructor8830); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            p_tree = this.adaptor.create(p);
            this.adaptor.addChild(root_0, p_tree);
            }
            if ( this.state.backtracking===0 ) {
               this.ap(p);  
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CDataSection_return: (function() {
        XQueryParser.p_CDataSection_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CDataSection_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1189:1: p_CDataSection : c= L_CDataSection ;
    // $ANTLR start "p_CDataSection"
    p_CDataSection: function() {
        var retval = new XQueryParser.p_CDataSection_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var c = null;

        var c_tree=null;

        try {
            // xquery/XQueryParser.g:1190:9: (c= L_CDataSection )
            // xquery/XQueryParser.g:1190:11: c= L_CDataSection
            root_0 = this.adaptor.nil();

            c=this.match(this.input,L_CDataSection,XQueryParser.FOLLOW_L_CDataSection_in_p_CDataSection8867); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            c_tree = this.adaptor.create(c);
            this.adaptor.addChild(root_0, c_tree);
            }
            if ( this.state.backtracking===0 ) {
               this.ac(c); 
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ComputedConstructor_return: (function() {
        XQueryParser.p_ComputedConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ComputedConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1197:1: p_ComputedConstructor : ( pm_CompDocConstructor | pm_CompElemConstructor | pm_CompAttrConstructor | p_CompNamespaceConstructor | p_CompTextConstructor | pm_CompCommentConstructor | pm_CompPIConstructor | {...}? => p_CompBinaryConstructor );
    // $ANTLR start "p_ComputedConstructor"
    p_ComputedConstructor: function() {
        var retval = new XQueryParser.p_ComputedConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pm_CompDocConstructor380 = null;
         var pm_CompElemConstructor381 = null;
         var pm_CompAttrConstructor382 = null;
         var p_CompNamespaceConstructor383 = null;
         var p_CompTextConstructor384 = null;
         var pm_CompCommentConstructor385 = null;
         var pm_CompPIConstructor386 = null;
         var p_CompBinaryConstructor387 = null;


        try {
            // xquery/XQueryParser.g:1198:9: ( pm_CompDocConstructor | pm_CompElemConstructor | pm_CompAttrConstructor | p_CompNamespaceConstructor | p_CompTextConstructor | pm_CompCommentConstructor | pm_CompPIConstructor | {...}? => p_CompBinaryConstructor )
            var alt155=8;
            var LA155_0 = this.input.LA(1);

            if ( (LA155_0==DOCUMENT) ) {
                alt155=1;
            }
            else if ( (LA155_0==ELEMENT) ) {
                alt155=2;
            }
            else if ( (LA155_0==ATTRIBUTE) ) {
                alt155=3;
            }
            else if ( (LA155_0==NAMESPACE) ) {
                alt155=4;
            }
            else if ( (LA155_0==TEXT) ) {
                alt155=5;
            }
            else if ( (LA155_0==COMMENT) ) {
                alt155=6;
            }
            else if ( (LA155_0==PROCESSING_INSTRUCTION) ) {
                alt155=7;
            }
            else if ( (LA155_0==BINARY) && ((this.lc(MLS)))) {
                alt155=8;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 155, 0, this.input);

                throw nvae;
            }
            switch (alt155) {
                case 1 :
                    // xquery/XQueryParser.g:1198:11: pm_CompDocConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_CompDocConstructor_in_p_ComputedConstructor8901);
                    pm_CompDocConstructor380=this.pm_CompDocConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_CompDocConstructor380.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1199:11: pm_CompElemConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_CompElemConstructor_in_p_ComputedConstructor8913);
                    pm_CompElemConstructor381=this.pm_CompElemConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_CompElemConstructor381.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:1200:11: pm_CompAttrConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_CompAttrConstructor_in_p_ComputedConstructor8925);
                    pm_CompAttrConstructor382=this.pm_CompAttrConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_CompAttrConstructor382.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:1201:11: p_CompNamespaceConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_CompNamespaceConstructor_in_p_ComputedConstructor8937);
                    p_CompNamespaceConstructor383=this.p_CompNamespaceConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CompNamespaceConstructor383.getTree());


                    break;
                case 5 :
                    // xquery/XQueryParser.g:1202:11: p_CompTextConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_CompTextConstructor_in_p_ComputedConstructor8949);
                    p_CompTextConstructor384=this.p_CompTextConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CompTextConstructor384.getTree());


                    break;
                case 6 :
                    // xquery/XQueryParser.g:1203:11: pm_CompCommentConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_CompCommentConstructor_in_p_ComputedConstructor8961);
                    pm_CompCommentConstructor385=this.pm_CompCommentConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_CompCommentConstructor385.getTree());


                    break;
                case 7 :
                    // xquery/XQueryParser.g:1204:11: pm_CompPIConstructor
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_CompPIConstructor_in_p_ComputedConstructor8973);
                    pm_CompPIConstructor386=this.pm_CompPIConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_CompPIConstructor386.getTree());


                    break;
                case 8 :
                    // xquery/XQueryParser.g:1205:11: {...}? => p_CompBinaryConstructor
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(MLS))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "p_ComputedConstructor", "this.lc(MLS)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_CompBinaryConstructor_in_p_ComputedConstructor8988);
                    p_CompBinaryConstructor387=this.p_CompBinaryConstructor();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CompBinaryConstructor387.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_CompDocConstructor_return: (function() {
        XQueryParser.pm_CompDocConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_CompDocConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1210:1: pm_CompDocConstructor : k= DOCUMENT LBRACKET p_StatementsAndOptionalExpr RBRACKET ;
    // $ANTLR start "pm_CompDocConstructor"
    pm_CompDocConstructor: function() {
        var retval = new XQueryParser.pm_CompDocConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET388 = null;
        var RBRACKET390 = null;
         var p_StatementsAndOptionalExpr389 = null;

        var k_tree=null;
        var LBRACKET388_tree=null;
        var RBRACKET390_tree=null;

        try {
            // xquery/XQueryParser.g:1211:9: (k= DOCUMENT LBRACKET p_StatementsAndOptionalExpr RBRACKET )
            // xquery/XQueryParser.g:1211:11: k= DOCUMENT LBRACKET p_StatementsAndOptionalExpr RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DOCUMENT,XQueryParser.FOLLOW_DOCUMENT_in_pm_CompDocConstructor9017); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            LBRACKET388=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pm_CompDocConstructor9021); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET388_tree = this.adaptor.create(LBRACKET388);
            this.adaptor.addChild(root_0, LBRACKET388_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StatementsAndOptionalExpr_in_pm_CompDocConstructor9023);
            p_StatementsAndOptionalExpr389=this.p_StatementsAndOptionalExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StatementsAndOptionalExpr389.getTree());
            RBRACKET390=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pm_CompDocConstructor9025); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET390_tree = this.adaptor.create(RBRACKET390);
            this.adaptor.addChild(root_0, RBRACKET390_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_CompElemConstructor_return: (function() {
        XQueryParser.pm_CompElemConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_CompElemConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1215:1: pm_CompElemConstructor : k= ELEMENT ( p_QName | ( LBRACKET p_Expr[true,true] RBRACKET ) ) LBRACKET pm_ContentExpr RBRACKET ;
    // $ANTLR start "pm_CompElemConstructor"
    pm_CompElemConstructor: function() {
        var retval = new XQueryParser.pm_CompElemConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET392 = null;
        var RBRACKET394 = null;
        var LBRACKET395 = null;
        var RBRACKET397 = null;
         var p_QName391 = null;
         var p_Expr393 = null;
         var pm_ContentExpr396 = null;

        var k_tree=null;
        var LBRACKET392_tree=null;
        var RBRACKET394_tree=null;
        var LBRACKET395_tree=null;
        var RBRACKET397_tree=null;

        try {
            // xquery/XQueryParser.g:1216:9: (k= ELEMENT ( p_QName | ( LBRACKET p_Expr[true,true] RBRACKET ) ) LBRACKET pm_ContentExpr RBRACKET )
            // xquery/XQueryParser.g:1216:11: k= ELEMENT ( p_QName | ( LBRACKET p_Expr[true,true] RBRACKET ) ) LBRACKET pm_ContentExpr RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,ELEMENT,XQueryParser.FOLLOW_ELEMENT_in_pm_CompElemConstructor9061); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:1216:36: ( p_QName | ( LBRACKET p_Expr[true,true] RBRACKET ) )
            var alt156=2;
            var LA156_0 = this.input.LA(1);

            if ( ((LA156_0>=ANCESTOR && LA156_0<=SKIP)||(LA156_0>=VALUE && LA156_0<=QUOT_ER)||LA156_0==L_NCName||LA156_0==EXPLICITLY) ) {
                alt156=1;
            }
            else if ( (LA156_0==LBRACKET) ) {
                alt156=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 156, 0, this.input);

                throw nvae;
            }
            switch (alt156) {
                case 1 :
                    // xquery/XQueryParser.g:1216:37: p_QName
                    this.pushFollow(XQueryParser.FOLLOW_p_QName_in_pm_CompElemConstructor9066);
                    p_QName391=this.p_QName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName391.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1216:47: ( LBRACKET p_Expr[true,true] RBRACKET )
                    // xquery/XQueryParser.g:1216:47: ( LBRACKET p_Expr[true,true] RBRACKET )
                    // xquery/XQueryParser.g:1216:48: LBRACKET p_Expr[true,true] RBRACKET
                    LBRACKET392=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pm_CompElemConstructor9071); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    LBRACKET392_tree = this.adaptor.create(LBRACKET392);
                    this.adaptor.addChild(root_0, LBRACKET392_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_pm_CompElemConstructor9073);
                    p_Expr393=this.p_Expr(true, true);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr393.getTree());
                    RBRACKET394=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pm_CompElemConstructor9076); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    RBRACKET394_tree = this.adaptor.create(RBRACKET394);
                    this.adaptor.addChild(root_0, RBRACKET394_tree);
                    }





                    break;

            }

            LBRACKET395=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pm_CompElemConstructor9080); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET395_tree = this.adaptor.create(LBRACKET395);
            this.adaptor.addChild(root_0, LBRACKET395_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_pm_ContentExpr_in_pm_CompElemConstructor9082);
            pm_ContentExpr396=this.pm_ContentExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_ContentExpr396.getTree());
            RBRACKET397=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pm_CompElemConstructor9084); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET397_tree = this.adaptor.create(RBRACKET397);
            this.adaptor.addChild(root_0, RBRACKET397_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_ContentExpr_return: (function() {
        XQueryParser.pm_ContentExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_ContentExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1221:1: pm_ContentExpr : p_StatementsAndOptionalExpr ;
    // $ANTLR start "pm_ContentExpr"
    pm_ContentExpr: function() {
        var retval = new XQueryParser.pm_ContentExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_StatementsAndOptionalExpr398 = null;


        try {
            // xquery/XQueryParser.g:1222:9: ( p_StatementsAndOptionalExpr )
            // xquery/XQueryParser.g:1222:11: p_StatementsAndOptionalExpr
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_StatementsAndOptionalExpr_in_pm_ContentExpr9111);
            p_StatementsAndOptionalExpr398=this.p_StatementsAndOptionalExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StatementsAndOptionalExpr398.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_CompAttrConstructor_return: (function() {
        XQueryParser.pm_CompAttrConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_CompAttrConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1227:1: pm_CompAttrConstructor : k= ATTRIBUTE ( p_QName | ( LBRACKET p_Expr[true,true] RBRACKET ) ) LBRACKET p_StatementsAndOptionalExpr RBRACKET ;
    // $ANTLR start "pm_CompAttrConstructor"
    pm_CompAttrConstructor: function() {
        var retval = new XQueryParser.pm_CompAttrConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET400 = null;
        var RBRACKET402 = null;
        var LBRACKET403 = null;
        var RBRACKET405 = null;
         var p_QName399 = null;
         var p_Expr401 = null;
         var p_StatementsAndOptionalExpr404 = null;

        var k_tree=null;
        var LBRACKET400_tree=null;
        var RBRACKET402_tree=null;
        var LBRACKET403_tree=null;
        var RBRACKET405_tree=null;

        try {
            // xquery/XQueryParser.g:1228:9: (k= ATTRIBUTE ( p_QName | ( LBRACKET p_Expr[true,true] RBRACKET ) ) LBRACKET p_StatementsAndOptionalExpr RBRACKET )
            // xquery/XQueryParser.g:1228:11: k= ATTRIBUTE ( p_QName | ( LBRACKET p_Expr[true,true] RBRACKET ) ) LBRACKET p_StatementsAndOptionalExpr RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,ATTRIBUTE,XQueryParser.FOLLOW_ATTRIBUTE_in_pm_CompAttrConstructor9140); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:1228:38: ( p_QName | ( LBRACKET p_Expr[true,true] RBRACKET ) )
            var alt157=2;
            var LA157_0 = this.input.LA(1);

            if ( ((LA157_0>=ANCESTOR && LA157_0<=SKIP)||(LA157_0>=VALUE && LA157_0<=QUOT_ER)||LA157_0==L_NCName||LA157_0==EXPLICITLY) ) {
                alt157=1;
            }
            else if ( (LA157_0==LBRACKET) ) {
                alt157=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 157, 0, this.input);

                throw nvae;
            }
            switch (alt157) {
                case 1 :
                    // xquery/XQueryParser.g:1228:39: p_QName
                    this.pushFollow(XQueryParser.FOLLOW_p_QName_in_pm_CompAttrConstructor9145);
                    p_QName399=this.p_QName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName399.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1228:49: ( LBRACKET p_Expr[true,true] RBRACKET )
                    // xquery/XQueryParser.g:1228:49: ( LBRACKET p_Expr[true,true] RBRACKET )
                    // xquery/XQueryParser.g:1228:50: LBRACKET p_Expr[true,true] RBRACKET
                    LBRACKET400=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pm_CompAttrConstructor9150); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    LBRACKET400_tree = this.adaptor.create(LBRACKET400);
                    this.adaptor.addChild(root_0, LBRACKET400_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_pm_CompAttrConstructor9152);
                    p_Expr401=this.p_Expr(true, true);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr401.getTree());
                    RBRACKET402=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pm_CompAttrConstructor9155); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    RBRACKET402_tree = this.adaptor.create(RBRACKET402);
                    this.adaptor.addChild(root_0, RBRACKET402_tree);
                    }





                    break;

            }

            LBRACKET403=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pm_CompAttrConstructor9159); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET403_tree = this.adaptor.create(LBRACKET403);
            this.adaptor.addChild(root_0, LBRACKET403_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StatementsAndOptionalExpr_in_pm_CompAttrConstructor9161);
            p_StatementsAndOptionalExpr404=this.p_StatementsAndOptionalExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StatementsAndOptionalExpr404.getTree());
            RBRACKET405=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pm_CompAttrConstructor9163); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET405_tree = this.adaptor.create(RBRACKET405);
            this.adaptor.addChild(root_0, RBRACKET405_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CompNamespaceConstructor_return: (function() {
        XQueryParser.p_CompNamespaceConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CompNamespaceConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1232:1: p_CompNamespaceConstructor : k= NAMESPACE ( p_Prefix | ( LBRACKET p_PrefixExpr RBRACKET ) ) LBRACKET ( p_URIExpr )? RBRACKET ;
    // $ANTLR start "p_CompNamespaceConstructor"
    p_CompNamespaceConstructor: function() {
        var retval = new XQueryParser.p_CompNamespaceConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET407 = null;
        var RBRACKET409 = null;
        var LBRACKET410 = null;
        var RBRACKET412 = null;
         var p_Prefix406 = null;
         var p_PrefixExpr408 = null;
         var p_URIExpr411 = null;

        var k_tree=null;
        var LBRACKET407_tree=null;
        var RBRACKET409_tree=null;
        var LBRACKET410_tree=null;
        var RBRACKET412_tree=null;

        try {
            // xquery/XQueryParser.g:1233:9: (k= NAMESPACE ( p_Prefix | ( LBRACKET p_PrefixExpr RBRACKET ) ) LBRACKET ( p_URIExpr )? RBRACKET )
            // xquery/XQueryParser.g:1233:11: k= NAMESPACE ( p_Prefix | ( LBRACKET p_PrefixExpr RBRACKET ) ) LBRACKET ( p_URIExpr )? RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_p_CompNamespaceConstructor9191); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:1233:38: ( p_Prefix | ( LBRACKET p_PrefixExpr RBRACKET ) )
            var alt158=2;
            var LA158_0 = this.input.LA(1);

            if ( ((LA158_0>=ANCESTOR && LA158_0<=SKIP)||(LA158_0>=VALUE && LA158_0<=QUOT_ER)||LA158_0==L_NCName||LA158_0==EXPLICITLY) ) {
                alt158=1;
            }
            else if ( (LA158_0==LBRACKET) ) {
                alt158=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 158, 0, this.input);

                throw nvae;
            }
            switch (alt158) {
                case 1 :
                    // xquery/XQueryParser.g:1233:39: p_Prefix
                    this.pushFollow(XQueryParser.FOLLOW_p_Prefix_in_p_CompNamespaceConstructor9196);
                    p_Prefix406=this.p_Prefix();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Prefix406.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1233:50: ( LBRACKET p_PrefixExpr RBRACKET )
                    // xquery/XQueryParser.g:1233:50: ( LBRACKET p_PrefixExpr RBRACKET )
                    // xquery/XQueryParser.g:1233:51: LBRACKET p_PrefixExpr RBRACKET
                    LBRACKET407=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_CompNamespaceConstructor9201); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    LBRACKET407_tree = this.adaptor.create(LBRACKET407);
                    this.adaptor.addChild(root_0, LBRACKET407_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_PrefixExpr_in_p_CompNamespaceConstructor9203);
                    p_PrefixExpr408=this.p_PrefixExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PrefixExpr408.getTree());
                    RBRACKET409=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_CompNamespaceConstructor9205); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    RBRACKET409_tree = this.adaptor.create(RBRACKET409);
                    this.adaptor.addChild(root_0, RBRACKET409_tree);
                    }





                    break;

            }

            LBRACKET410=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_CompNamespaceConstructor9209); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET410_tree = this.adaptor.create(LBRACKET410);
            this.adaptor.addChild(root_0, LBRACKET410_tree);
            }
            // xquery/XQueryParser.g:1233:93: ( p_URIExpr )?
            var alt159=2;
            var LA159_0 = this.input.LA(1);

            if ( ((LA159_0>=ANCESTOR && LA159_0<=QUOT_ER)||LA159_0==LPAREN||(LA159_0>=DOLLAR && LA159_0<=LBRACKET)||(LA159_0>=STAR && LA159_0<=SMALLER)||(LA159_0>=SLASH && LA159_0<=DOT_DOT)||LA159_0==ATTR_SIGN||(LA159_0>=APOS && LA159_0<=QUOT)||LA159_0==L_NCName||(LA159_0>=L_Pragma && LA159_0<=L_DoubleLiteral)||LA159_0==EXPLICITLY) ) {
                alt159=1;
            }
            switch (alt159) {
                case 1 :
                    // xquery/XQueryParser.g:1233:93: p_URIExpr
                    this.pushFollow(XQueryParser.FOLLOW_p_URIExpr_in_p_CompNamespaceConstructor9211);
                    p_URIExpr411=this.p_URIExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_URIExpr411.getTree());


                    break;

            }

            RBRACKET412=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_CompNamespaceConstructor9214); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET412_tree = this.adaptor.create(RBRACKET412);
            this.adaptor.addChild(root_0, RBRACKET412_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Prefix_return: (function() {
        XQueryParser.p_Prefix_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Prefix_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1237:1: p_Prefix : p_NCName ;
    // $ANTLR start "p_Prefix"
    p_Prefix: function() {
        var retval = new XQueryParser.p_Prefix_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_NCName413 = null;


        try {
            // xquery/XQueryParser.g:1238:9: ( p_NCName )
            // xquery/XQueryParser.g:1238:11: p_NCName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_p_Prefix9240);
            p_NCName413=this.p_NCName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NCName413.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PrefixExpr_return: (function() {
        XQueryParser.p_PrefixExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PrefixExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1242:1: p_PrefixExpr : p_Expr[true,true] ;
    // $ANTLR start "p_PrefixExpr"
    p_PrefixExpr: function() {
        var retval = new XQueryParser.p_PrefixExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_Expr414 = null;


        try {
            // xquery/XQueryParser.g:1243:9: ( p_Expr[true,true] )
            // xquery/XQueryParser.g:1243:11: p_Expr[true,true]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_PrefixExpr9266);
            p_Expr414=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr414.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_URIExpr_return: (function() {
        XQueryParser.p_URIExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_URIExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1247:1: p_URIExpr : p_Expr[true,true] ;
    // $ANTLR start "p_URIExpr"
    p_URIExpr: function() {
        var retval = new XQueryParser.p_URIExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_Expr415 = null;


        try {
            // xquery/XQueryParser.g:1248:9: ( p_Expr[true,true] )
            // xquery/XQueryParser.g:1248:11: p_Expr[true,true]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_URIExpr9293);
            p_Expr415=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr415.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CompTextConstructor_return: (function() {
        XQueryParser.p_CompTextConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CompTextConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1252:1: p_CompTextConstructor : k= TEXT LBRACKET p_Expr[true,true] RBRACKET ;
    // $ANTLR start "p_CompTextConstructor"
    p_CompTextConstructor: function() {
        var retval = new XQueryParser.p_CompTextConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET416 = null;
        var RBRACKET418 = null;
         var p_Expr417 = null;

        var k_tree=null;
        var LBRACKET416_tree=null;
        var RBRACKET418_tree=null;

        try {
            // xquery/XQueryParser.g:1253:9: (k= TEXT LBRACKET p_Expr[true,true] RBRACKET )
            // xquery/XQueryParser.g:1253:11: k= TEXT LBRACKET p_Expr[true,true] RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,TEXT,XQueryParser.FOLLOW_TEXT_in_p_CompTextConstructor9322); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            LBRACKET416=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_CompTextConstructor9326); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET416_tree = this.adaptor.create(LBRACKET416);
            this.adaptor.addChild(root_0, LBRACKET416_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_CompTextConstructor9328);
            p_Expr417=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr417.getTree());
            RBRACKET418=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_CompTextConstructor9331); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET418_tree = this.adaptor.create(RBRACKET418);
            this.adaptor.addChild(root_0, RBRACKET418_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CompBinaryConstructor_return: (function() {
        XQueryParser.p_CompBinaryConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CompBinaryConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1257:1: p_CompBinaryConstructor : k= BINARY LBRACKET p_Expr[true,true] RBRACKET ;
    // $ANTLR start "p_CompBinaryConstructor"
    p_CompBinaryConstructor: function() {
        var retval = new XQueryParser.p_CompBinaryConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET419 = null;
        var RBRACKET421 = null;
         var p_Expr420 = null;

        var k_tree=null;
        var LBRACKET419_tree=null;
        var RBRACKET421_tree=null;

        try {
            // xquery/XQueryParser.g:1258:9: (k= BINARY LBRACKET p_Expr[true,true] RBRACKET )
            // xquery/XQueryParser.g:1258:11: k= BINARY LBRACKET p_Expr[true,true] RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,BINARY,XQueryParser.FOLLOW_BINARY_in_p_CompBinaryConstructor9359); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            LBRACKET419=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_CompBinaryConstructor9363); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET419_tree = this.adaptor.create(LBRACKET419);
            this.adaptor.addChild(root_0, LBRACKET419_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_CompBinaryConstructor9365);
            p_Expr420=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr420.getTree());
            RBRACKET421=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_CompBinaryConstructor9368); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET421_tree = this.adaptor.create(RBRACKET421);
            this.adaptor.addChild(root_0, RBRACKET421_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_CompCommentConstructor_return: (function() {
        XQueryParser.pm_CompCommentConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_CompCommentConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1263:1: pm_CompCommentConstructor : k= COMMENT LBRACKET p_StatementsAndOptionalExpr RBRACKET ;
    // $ANTLR start "pm_CompCommentConstructor"
    pm_CompCommentConstructor: function() {
        var retval = new XQueryParser.pm_CompCommentConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET422 = null;
        var RBRACKET424 = null;
         var p_StatementsAndOptionalExpr423 = null;

        var k_tree=null;
        var LBRACKET422_tree=null;
        var RBRACKET424_tree=null;

        try {
            // xquery/XQueryParser.g:1264:9: (k= COMMENT LBRACKET p_StatementsAndOptionalExpr RBRACKET )
            // xquery/XQueryParser.g:1264:11: k= COMMENT LBRACKET p_StatementsAndOptionalExpr RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,COMMENT,XQueryParser.FOLLOW_COMMENT_in_pm_CompCommentConstructor9397); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            LBRACKET422=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pm_CompCommentConstructor9401); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET422_tree = this.adaptor.create(LBRACKET422);
            this.adaptor.addChild(root_0, LBRACKET422_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StatementsAndOptionalExpr_in_pm_CompCommentConstructor9403);
            p_StatementsAndOptionalExpr423=this.p_StatementsAndOptionalExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StatementsAndOptionalExpr423.getTree());
            RBRACKET424=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pm_CompCommentConstructor9405); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET424_tree = this.adaptor.create(RBRACKET424);
            this.adaptor.addChild(root_0, RBRACKET424_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_CompPIConstructor_return: (function() {
        XQueryParser.pm_CompPIConstructor_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_CompPIConstructor_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1269:1: pm_CompPIConstructor : k= PROCESSING_INSTRUCTION ( p_NCName | ( LBRACKET p_Expr[true,true] RBRACKET ) ) LBRACKET p_StatementsAndOptionalExpr RBRACKET ;
    // $ANTLR start "pm_CompPIConstructor"
    pm_CompPIConstructor: function() {
        var retval = new XQueryParser.pm_CompPIConstructor_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LBRACKET426 = null;
        var RBRACKET428 = null;
        var LBRACKET429 = null;
        var RBRACKET431 = null;
         var p_NCName425 = null;
         var p_Expr427 = null;
         var p_StatementsAndOptionalExpr430 = null;

        var k_tree=null;
        var LBRACKET426_tree=null;
        var RBRACKET428_tree=null;
        var LBRACKET429_tree=null;
        var RBRACKET431_tree=null;

        try {
            // xquery/XQueryParser.g:1270:9: (k= PROCESSING_INSTRUCTION ( p_NCName | ( LBRACKET p_Expr[true,true] RBRACKET ) ) LBRACKET p_StatementsAndOptionalExpr RBRACKET )
            // xquery/XQueryParser.g:1270:11: k= PROCESSING_INSTRUCTION ( p_NCName | ( LBRACKET p_Expr[true,true] RBRACKET ) ) LBRACKET p_StatementsAndOptionalExpr RBRACKET
            root_0 = this.adaptor.nil();

            k=this.match(this.input,PROCESSING_INSTRUCTION,XQueryParser.FOLLOW_PROCESSING_INSTRUCTION_in_pm_CompPIConstructor9434); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // xquery/XQueryParser.g:1270:51: ( p_NCName | ( LBRACKET p_Expr[true,true] RBRACKET ) )
            var alt160=2;
            var LA160_0 = this.input.LA(1);

            if ( ((LA160_0>=ANCESTOR && LA160_0<=SKIP)||(LA160_0>=VALUE && LA160_0<=QUOT_ER)||LA160_0==L_NCName||LA160_0==EXPLICITLY) ) {
                alt160=1;
            }
            else if ( (LA160_0==LBRACKET) ) {
                alt160=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 160, 0, this.input);

                throw nvae;
            }
            switch (alt160) {
                case 1 :
                    // xquery/XQueryParser.g:1270:52: p_NCName
                    this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_pm_CompPIConstructor9439);
                    p_NCName425=this.p_NCName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NCName425.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1270:63: ( LBRACKET p_Expr[true,true] RBRACKET )
                    // xquery/XQueryParser.g:1270:63: ( LBRACKET p_Expr[true,true] RBRACKET )
                    // xquery/XQueryParser.g:1270:64: LBRACKET p_Expr[true,true] RBRACKET
                    LBRACKET426=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pm_CompPIConstructor9444); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    LBRACKET426_tree = this.adaptor.create(LBRACKET426);
                    this.adaptor.addChild(root_0, LBRACKET426_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_pm_CompPIConstructor9446);
                    p_Expr427=this.p_Expr(true, true);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr427.getTree());
                    RBRACKET428=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pm_CompPIConstructor9449); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    RBRACKET428_tree = this.adaptor.create(RBRACKET428);
                    this.adaptor.addChild(root_0, RBRACKET428_tree);
                    }





                    break;

            }

            LBRACKET429=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pm_CompPIConstructor9453); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LBRACKET429_tree = this.adaptor.create(LBRACKET429);
            this.adaptor.addChild(root_0, LBRACKET429_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StatementsAndOptionalExpr_in_pm_CompPIConstructor9455);
            p_StatementsAndOptionalExpr430=this.p_StatementsAndOptionalExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StatementsAndOptionalExpr430.getTree());
            RBRACKET431=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pm_CompPIConstructor9457); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RBRACKET431_tree = this.adaptor.create(RBRACKET431);
            this.adaptor.addChild(root_0, RBRACKET431_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SingleType_return: (function() {
        XQueryParser.p_SingleType_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SingleType_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1292:1: p_SingleType : p_AtomicOrUnionType ( QUESTION )? ;
    // $ANTLR start "p_SingleType"
    p_SingleType: function() {
        var retval = new XQueryParser.p_SingleType_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var QUESTION433 = null;
         var p_AtomicOrUnionType432 = null;

        var QUESTION433_tree=null;

        try {
            // xquery/XQueryParser.g:1293:9: ( p_AtomicOrUnionType ( QUESTION )? )
            // xquery/XQueryParser.g:1293:11: p_AtomicOrUnionType ( QUESTION )?
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_AtomicOrUnionType_in_p_SingleType9501);
            p_AtomicOrUnionType432=this.p_AtomicOrUnionType();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AtomicOrUnionType432.getTree());
            // xquery/XQueryParser.g:1293:31: ( QUESTION )?
            var alt161=2;
            var LA161_0 = this.input.LA(1);

            if ( (LA161_0==QUESTION) ) {
                alt161=1;
            }
            switch (alt161) {
                case 1 :
                    // xquery/XQueryParser.g:1293:31: QUESTION
                    QUESTION433=this.match(this.input,QUESTION,XQueryParser.FOLLOW_QUESTION_in_p_SingleType9503); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    QUESTION433_tree = this.adaptor.create(QUESTION433);
                    this.adaptor.addChild(root_0, QUESTION433_tree);
                    }


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TypeDeclaration_return: (function() {
        XQueryParser.p_TypeDeclaration_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TypeDeclaration_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1297:1: p_TypeDeclaration : k= AS st= p_SequenceType -> ^( TypeDeclaration $st) ;
    // $ANTLR start "p_TypeDeclaration"
    p_TypeDeclaration: function() {
        var retval = new XQueryParser.p_TypeDeclaration_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var st = null;

        var k_tree=null;
        var stream_AS=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token AS");
        var stream_p_SequenceType=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_SequenceType");
        try {
            // xquery/XQueryParser.g:1298:9: (k= AS st= p_SequenceType -> ^( TypeDeclaration $st) )
            // xquery/XQueryParser.g:1298:11: k= AS st= p_SequenceType
            k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_p_TypeDeclaration9532); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_AS.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_SequenceType_in_p_TypeDeclaration9538);
            st=this.p_SequenceType();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_SequenceType.add(st.getTree());


            // AST REWRITE
            // elements: st
            // token labels: 
            // rule labels: retval, st
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_st=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token st",st!=null?st.tree:null);

            root_0 = this.adaptor.nil();
            // 1299:17: -> ^( TypeDeclaration $st)
            {
                // xquery/XQueryParser.g:1299:20: ^( TypeDeclaration $st)
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(TypeDeclaration, "TypeDeclaration"), root_1);

                this.adaptor.addChild(root_1, stream_st.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SequenceType_return: (function() {
        XQueryParser.p_SequenceType_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SequenceType_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1303:1: p_SequenceType : (k= EMPTY_SEQUENCE l= LPAREN r= RPAREN -> ^( SequenceType ^( EmptySequenceTest $k $l $r) ) | it= p_ItemType ( ( p_OccurrenceIndicator )=>oi= p_OccurrenceIndicator )? -> ^( SequenceType $it ( $oi)? ) );
    // $ANTLR start "p_SequenceType"
    p_SequenceType: function() {
        var retval = new XQueryParser.p_SequenceType_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var l = null;
        var r = null;
         var it = null;
         var oi = null;

        var k_tree=null;
        var l_tree=null;
        var r_tree=null;
        var stream_EMPTY_SEQUENCE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EMPTY_SEQUENCE");
        var stream_RPAREN=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token RPAREN");
        var stream_LPAREN=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token LPAREN");
        var stream_p_ItemType=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_ItemType");
        var stream_p_OccurrenceIndicator=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_OccurrenceIndicator");
        try {
            // xquery/XQueryParser.g:1304:9: (k= EMPTY_SEQUENCE l= LPAREN r= RPAREN -> ^( SequenceType ^( EmptySequenceTest $k $l $r) ) | it= p_ItemType ( ( p_OccurrenceIndicator )=>oi= p_OccurrenceIndicator )? -> ^( SequenceType $it ( $oi)? ) )
            var alt163=2;
            var LA163_0 = this.input.LA(1);

            if ( (LA163_0==EMPTY_SEQUENCE) ) {
                var LA163_1 = this.input.LA(2);

                if ( (LA163_1==LPAREN) ) {
                    alt163=1;
                }
                else if ( (LA163_1==EOF||(LA163_1>=AND && LA163_1<=AT)||LA163_1==CASE||LA163_1==COLLATION||LA163_1==DEFAULT||(LA163_1>=DESCENDING && LA163_1<=DIV)||LA163_1==EMPTY||LA163_1==EQ||(LA163_1>=EXCEPT && LA163_1<=EXTERNAL)||LA163_1==FOR||LA163_1==GE||(LA163_1>=GT && LA163_1<=IDIV)||LA163_1==IN||(LA163_1>=INSTANCE && LA163_1<=IS)||LA163_1==LE||(LA163_1>=LET && LA163_1<=MOD)||LA163_1==NE||(LA163_1>=OR && LA163_1<=ORDER)||(LA163_1>=RETURN && LA163_1<=SATISFIES)||LA163_1==STABLE||LA163_1==TO||LA163_1==UNION||LA163_1==WHERE||LA163_1==ALLOWING||LA163_1==COUNT||(LA163_1>=END && LA163_1<=GROUP)||LA163_1==ONLY||LA163_1==START||(LA163_1>=AFTER && LA163_1<=BEFORE)||LA163_1==INTO||LA163_1==MODIFY||LA163_1==WITH||LA163_1==CONTAINS||LA163_1==PARAGRAPHS||LA163_1==SCORE||LA163_1==SENTENCES||LA163_1==TIMES||LA163_1==WORDS||LA163_1==CONCAT||LA163_1==RPAREN||(LA163_1>=LBRACKET && LA163_1<=RBRACKET)||(LA163_1>=RSQUARE && LA163_1<=NOTEQUAL)||(LA163_1>=COMMA && LA163_1<=GREATER_GREATER)||LA163_1==COLON||(LA163_1>=SEMICOLON && LA163_1<=VBAR)) ) {
                    alt163=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 163, 1, this.input);

                    throw nvae;
                }
            }
            else if ( ((LA163_0>=ANCESTOR && LA163_0<=EMPTY)||(LA163_0>=ENCODING && LA163_0<=SKIP)||(LA163_0>=VALUE && LA163_0<=QUOT_ER)||LA163_0==LPAREN||LA163_0==L_NCName||LA163_0==EXPLICITLY) ) {
                alt163=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 163, 0, this.input);

                throw nvae;
            }
            switch (alt163) {
                case 1 :
                    // xquery/XQueryParser.g:1304:11: k= EMPTY_SEQUENCE l= LPAREN r= RPAREN
                    k=this.match(this.input,EMPTY_SEQUENCE,XQueryParser.FOLLOW_EMPTY_SEQUENCE_in_p_SequenceType9591); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_EMPTY_SEQUENCE.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    l=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_SequenceType9597); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_LPAREN.add(l);

                    r=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_SequenceType9601); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_RPAREN.add(r);



                    // AST REWRITE
                    // elements: l, k, r
                    // token labels: r, l, k
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_r=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token r",r);
                    var stream_l=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token l",l);
                    var stream_k=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token k",k);
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1305:17: -> ^( SequenceType ^( EmptySequenceTest $k $l $r) )
                    {
                        // xquery/XQueryParser.g:1305:20: ^( SequenceType ^( EmptySequenceTest $k $l $r) )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(SequenceType, "SequenceType"), root_1);

                        // xquery/XQueryParser.g:1305:35: ^( EmptySequenceTest $k $l $r)
                        {
                        var root_2 = this.adaptor.nil();
                        root_2 = this.adaptor.becomeRoot(this.adaptor.create(EmptySequenceTest, "EmptySequenceTest"), root_2);

                        this.adaptor.addChild(root_2, stream_k.nextNode());
                        this.adaptor.addChild(root_2, stream_l.nextNode());
                        this.adaptor.addChild(root_2, stream_r.nextNode());

                        this.adaptor.addChild(root_1, root_2);
                        }

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;
                case 2 :
                    // xquery/XQueryParser.g:1306:11: it= p_ItemType ( ( p_OccurrenceIndicator )=>oi= p_OccurrenceIndicator )?
                    this.pushFollow(XQueryParser.FOLLOW_p_ItemType_in_p_SequenceType9650);
                    it=this.p_ItemType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_ItemType.add(it.getTree());
                    // xquery/XQueryParser.g:1306:25: ( ( p_OccurrenceIndicator )=>oi= p_OccurrenceIndicator )?
                    var alt162=2;
                    alt162 = this.dfa162.predict(this.input);
                    switch (alt162) {
                        case 1 :
                            // xquery/XQueryParser.g:1306:26: ( p_OccurrenceIndicator )=>oi= p_OccurrenceIndicator
                            this.pushFollow(XQueryParser.FOLLOW_p_OccurrenceIndicator_in_p_SequenceType9661);
                            oi=this.p_OccurrenceIndicator();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_OccurrenceIndicator.add(oi.getTree());


                            break;

                    }



                    // AST REWRITE
                    // elements: oi, it
                    // token labels: 
                    // rule labels: retval, it, oi
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
                    var stream_it=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token it",it!=null?it.tree:null);
                    var stream_oi=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token oi",oi!=null?oi.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1307:17: -> ^( SequenceType $it ( $oi)? )
                    {
                        // xquery/XQueryParser.g:1307:20: ^( SequenceType $it ( $oi)? )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(SequenceType, "SequenceType"), root_1);

                        this.adaptor.addChild(root_1, stream_it.nextTree());
                        // xquery/XQueryParser.g:1307:39: ( $oi)?
                        if ( stream_oi.hasNext() ) {
                            this.adaptor.addChild(root_1, stream_oi.nextTree());

                        }
                        stream_oi.reset();

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_OccurrenceIndicator_return: (function() {
        XQueryParser.p_OccurrenceIndicator_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_OccurrenceIndicator_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1311:1: p_OccurrenceIndicator : ( QUESTION | STAR | PLUS );
    // $ANTLR start "p_OccurrenceIndicator"
    p_OccurrenceIndicator: function() {
        var retval = new XQueryParser.p_OccurrenceIndicator_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var set434 = null;

        var set434_tree=null;

        try {
            // xquery/XQueryParser.g:1312:9: ( QUESTION | STAR | PLUS )
            // xquery/XQueryParser.g:
            root_0 = this.adaptor.nil();

            set434=this.input.LT(1);
            if ( (this.input.LA(1)>=QUESTION && this.input.LA(1)<=PLUS) ) {
                this.input.consume();
                if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, this.adaptor.create(set434));
                this.state.errorRecovery=false;this.state.failed=false;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                throw mse;
            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ItemType_return: (function() {
        XQueryParser.p_ItemType_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ItemType_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1316:1: p_ItemType : ( p_KindTest -> ^( KindTest p_KindTest ) | {...}? => ( BINARY LPAREN RPAREN ) -> ^( BinaryTest BINARY LPAREN RPAREN ) | ( ITEM LPAREN RPAREN ) -> ^( ItemTest ITEM LPAREN RPAREN ) | p_AtomicOrUnionType | p_ParenthesizedItemType );
    // $ANTLR start "p_ItemType"
    p_ItemType: function() {
        var retval = new XQueryParser.p_ItemType_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var BINARY436 = null;
        var LPAREN437 = null;
        var RPAREN438 = null;
        var ITEM439 = null;
        var LPAREN440 = null;
        var RPAREN441 = null;
         var p_KindTest435 = null;
         var p_AtomicOrUnionType442 = null;
         var p_ParenthesizedItemType443 = null;

        var BINARY436_tree=null;
        var LPAREN437_tree=null;
        var RPAREN438_tree=null;
        var ITEM439_tree=null;
        var LPAREN440_tree=null;
        var RPAREN441_tree=null;
        var stream_RPAREN=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token RPAREN");
        var stream_ITEM=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token ITEM");
        var stream_BINARY=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token BINARY");
        var stream_LPAREN=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token LPAREN");
        var stream_p_KindTest=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_KindTest");
        try {
            // xquery/XQueryParser.g:1317:9: ( p_KindTest -> ^( KindTest p_KindTest ) | {...}? => ( BINARY LPAREN RPAREN ) -> ^( BinaryTest BINARY LPAREN RPAREN ) | ( ITEM LPAREN RPAREN ) -> ^( ItemTest ITEM LPAREN RPAREN ) | p_AtomicOrUnionType | p_ParenthesizedItemType )
            var alt164=5;
            alt164 = this.dfa164.predict(this.input);
            switch (alt164) {
                case 1 :
                    // xquery/XQueryParser.g:1317:11: p_KindTest
                    this.pushFollow(XQueryParser.FOLLOW_p_KindTest_in_p_ItemType9763);
                    p_KindTest435=this.p_KindTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_KindTest.add(p_KindTest435.getTree());


                    // AST REWRITE
                    // elements: p_KindTest
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1318:17: -> ^( KindTest p_KindTest )
                    {
                        // xquery/XQueryParser.g:1318:20: ^( KindTest p_KindTest )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(KindTest, "KindTest"), root_1);

                        this.adaptor.addChild(root_1, stream_p_KindTest.nextTree());

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;
                case 2 :
                    // xquery/XQueryParser.g:1319:11: {...}? => ( BINARY LPAREN RPAREN )
                    if ( !((this.lc(MLS))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "p_ItemType", "this.lc(MLS)");
                    }
                    // xquery/XQueryParser.g:1319:29: ( BINARY LPAREN RPAREN )
                    // xquery/XQueryParser.g:1319:30: BINARY LPAREN RPAREN
                    BINARY436=this.match(this.input,BINARY,XQueryParser.FOLLOW_BINARY_in_p_ItemType9803); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_BINARY.add(BINARY436);

                    LPAREN437=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_ItemType9805); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_LPAREN.add(LPAREN437);

                    RPAREN438=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_ItemType9807); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_RPAREN.add(RPAREN438);






                    // AST REWRITE
                    // elements: LPAREN, RPAREN, BINARY
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1320:17: -> ^( BinaryTest BINARY LPAREN RPAREN )
                    {
                        // xquery/XQueryParser.g:1320:20: ^( BinaryTest BINARY LPAREN RPAREN )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(BinaryTest, "BinaryTest"), root_1);

                        this.adaptor.addChild(root_1, stream_BINARY.nextNode());
                        this.adaptor.addChild(root_1, stream_LPAREN.nextNode());
                        this.adaptor.addChild(root_1, stream_RPAREN.nextNode());

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;
                case 3 :
                    // xquery/XQueryParser.g:1321:11: ( ITEM LPAREN RPAREN )
                    // xquery/XQueryParser.g:1321:11: ( ITEM LPAREN RPAREN )
                    // xquery/XQueryParser.g:1321:12: ITEM LPAREN RPAREN
                    ITEM439=this.match(this.input,ITEM,XQueryParser.FOLLOW_ITEM_in_p_ItemType9849); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_ITEM.add(ITEM439);

                    LPAREN440=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_ItemType9851); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_LPAREN.add(LPAREN440);

                    RPAREN441=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_ItemType9853); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_RPAREN.add(RPAREN441);






                    // AST REWRITE
                    // elements: ITEM, RPAREN, LPAREN
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1322:17: -> ^( ItemTest ITEM LPAREN RPAREN )
                    {
                        // xquery/XQueryParser.g:1322:20: ^( ItemTest ITEM LPAREN RPAREN )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(ItemTest, "ItemTest"), root_1);

                        this.adaptor.addChild(root_1, stream_ITEM.nextNode());
                        this.adaptor.addChild(root_1, stream_LPAREN.nextNode());
                        this.adaptor.addChild(root_1, stream_RPAREN.nextNode());

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;
                case 4 :
                    // xquery/XQueryParser.g:1326:11: p_AtomicOrUnionType
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_AtomicOrUnionType_in_p_ItemType9897);
                    p_AtomicOrUnionType442=this.p_AtomicOrUnionType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AtomicOrUnionType442.getTree());


                    break;
                case 5 :
                    // xquery/XQueryParser.g:1327:11: p_ParenthesizedItemType
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ParenthesizedItemType_in_p_ItemType9909);
                    p_ParenthesizedItemType443=this.p_ParenthesizedItemType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ParenthesizedItemType443.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AtomicOrUnionType_return: (function() {
        XQueryParser.p_AtomicOrUnionType_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AtomicOrUnionType_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1331:1: p_AtomicOrUnionType : p_QName -> ^( AtomicOrUnionType p_QName ) ;
    // $ANTLR start "p_AtomicOrUnionType"
    p_AtomicOrUnionType: function() {
        var retval = new XQueryParser.p_AtomicOrUnionType_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_QName444 = null;

        var stream_p_QName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_QName");
        try {
            // xquery/XQueryParser.g:1332:9: ( p_QName -> ^( AtomicOrUnionType p_QName ) )
            // xquery/XQueryParser.g:1332:11: p_QName
            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_AtomicOrUnionType9935);
            p_QName444=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_QName.add(p_QName444.getTree());


            // AST REWRITE
            // elements: p_QName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 1333:17: -> ^( AtomicOrUnionType p_QName )
            {
                // xquery/XQueryParser.g:1333:20: ^( AtomicOrUnionType p_QName )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(AtomicOrUnionType, "AtomicOrUnionType"), root_1);

                this.adaptor.addChild(root_1, stream_p_QName.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_KindTest_return: (function() {
        XQueryParser.p_KindTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_KindTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1337:1: p_KindTest : ( p_DocumentTest | p_ElementTest | p_AttributeTest | p_SchemaElementTest | p_SchemaAttributeTest | p_PITest | p_CommentTest | p_TextTest | p_NamespaceNodeTest | p_AnyKindTest );
    // $ANTLR start "p_KindTest"
    p_KindTest: function() {
        var retval = new XQueryParser.p_KindTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_DocumentTest445 = null;
         var p_ElementTest446 = null;
         var p_AttributeTest447 = null;
         var p_SchemaElementTest448 = null;
         var p_SchemaAttributeTest449 = null;
         var p_PITest450 = null;
         var p_CommentTest451 = null;
         var p_TextTest452 = null;
         var p_NamespaceNodeTest453 = null;
         var p_AnyKindTest454 = null;


        try {
            // xquery/XQueryParser.g:1338:9: ( p_DocumentTest | p_ElementTest | p_AttributeTest | p_SchemaElementTest | p_SchemaAttributeTest | p_PITest | p_CommentTest | p_TextTest | p_NamespaceNodeTest | p_AnyKindTest )
            var alt165=10;
            switch ( this.input.LA(1) ) {
            case DOCUMENT_NODE:
                alt165=1;
                break;
            case ELEMENT:
                alt165=2;
                break;
            case ATTRIBUTE:
                alt165=3;
                break;
            case SCHEMA_ELEMENT:
                alt165=4;
                break;
            case SCHEMA_ATTRIBUTE:
                alt165=5;
                break;
            case PROCESSING_INSTRUCTION:
                alt165=6;
                break;
            case COMMENT:
                alt165=7;
                break;
            case TEXT:
                alt165=8;
                break;
            case NAMESPACE_NODE:
                alt165=9;
                break;
            case NODE:
                alt165=10;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 165, 0, this.input);

                throw nvae;
            }

            switch (alt165) {
                case 1 :
                    // xquery/XQueryParser.g:1338:11: p_DocumentTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_DocumentTest_in_p_KindTest9985);
                    p_DocumentTest445=this.p_DocumentTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_DocumentTest445.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1339:11: p_ElementTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ElementTest_in_p_KindTest9997);
                    p_ElementTest446=this.p_ElementTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ElementTest446.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:1340:11: p_AttributeTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_AttributeTest_in_p_KindTest10009);
                    p_AttributeTest447=this.p_AttributeTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AttributeTest447.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:1341:11: p_SchemaElementTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_SchemaElementTest_in_p_KindTest10021);
                    p_SchemaElementTest448=this.p_SchemaElementTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SchemaElementTest448.getTree());


                    break;
                case 5 :
                    // xquery/XQueryParser.g:1342:11: p_SchemaAttributeTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_SchemaAttributeTest_in_p_KindTest10033);
                    p_SchemaAttributeTest449=this.p_SchemaAttributeTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SchemaAttributeTest449.getTree());


                    break;
                case 6 :
                    // xquery/XQueryParser.g:1343:11: p_PITest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_PITest_in_p_KindTest10045);
                    p_PITest450=this.p_PITest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PITest450.getTree());


                    break;
                case 7 :
                    // xquery/XQueryParser.g:1344:11: p_CommentTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_CommentTest_in_p_KindTest10057);
                    p_CommentTest451=this.p_CommentTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CommentTest451.getTree());


                    break;
                case 8 :
                    // xquery/XQueryParser.g:1345:11: p_TextTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_TextTest_in_p_KindTest10069);
                    p_TextTest452=this.p_TextTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TextTest452.getTree());


                    break;
                case 9 :
                    // xquery/XQueryParser.g:1346:11: p_NamespaceNodeTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_NamespaceNodeTest_in_p_KindTest10081);
                    p_NamespaceNodeTest453=this.p_NamespaceNodeTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NamespaceNodeTest453.getTree());


                    break;
                case 10 :
                    // xquery/XQueryParser.g:1347:11: p_AnyKindTest
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_AnyKindTest_in_p_KindTest10093);
                    p_AnyKindTest454=this.p_AnyKindTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AnyKindTest454.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AnyKindTest_return: (function() {
        XQueryParser.p_AnyKindTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AnyKindTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1351:1: p_AnyKindTest : NODE LPAREN RPAREN ;
    // $ANTLR start "p_AnyKindTest"
    p_AnyKindTest: function() {
        var retval = new XQueryParser.p_AnyKindTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var NODE455 = null;
        var LPAREN456 = null;
        var RPAREN457 = null;

        var NODE455_tree=null;
        var LPAREN456_tree=null;
        var RPAREN457_tree=null;

        try {
            // xquery/XQueryParser.g:1352:9: ( NODE LPAREN RPAREN )
            // xquery/XQueryParser.g:1352:11: NODE LPAREN RPAREN
            root_0 = this.adaptor.nil();

            NODE455=this.match(this.input,NODE,XQueryParser.FOLLOW_NODE_in_p_AnyKindTest10119); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            NODE455_tree = this.adaptor.create(NODE455);
            this.adaptor.addChild(root_0, NODE455_tree);
            }
            LPAREN456=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_AnyKindTest10121); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN456_tree = this.adaptor.create(LPAREN456);
            this.adaptor.addChild(root_0, LPAREN456_tree);
            }
            RPAREN457=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_AnyKindTest10123); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN457_tree = this.adaptor.create(RPAREN457);
            this.adaptor.addChild(root_0, RPAREN457_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_DocumentTest_return: (function() {
        XQueryParser.p_DocumentTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_DocumentTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1356:1: p_DocumentTest : DOCUMENT_NODE LPAREN ( p_ElementTest | p_SchemaElementTest )? RPAREN ;
    // $ANTLR start "p_DocumentTest"
    p_DocumentTest: function() {
        var retval = new XQueryParser.p_DocumentTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var DOCUMENT_NODE458 = null;
        var LPAREN459 = null;
        var RPAREN462 = null;
         var p_ElementTest460 = null;
         var p_SchemaElementTest461 = null;

        var DOCUMENT_NODE458_tree=null;
        var LPAREN459_tree=null;
        var RPAREN462_tree=null;

        try {
            // xquery/XQueryParser.g:1357:9: ( DOCUMENT_NODE LPAREN ( p_ElementTest | p_SchemaElementTest )? RPAREN )
            // xquery/XQueryParser.g:1357:11: DOCUMENT_NODE LPAREN ( p_ElementTest | p_SchemaElementTest )? RPAREN
            root_0 = this.adaptor.nil();

            DOCUMENT_NODE458=this.match(this.input,DOCUMENT_NODE,XQueryParser.FOLLOW_DOCUMENT_NODE_in_p_DocumentTest10149); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            DOCUMENT_NODE458_tree = this.adaptor.create(DOCUMENT_NODE458);
            this.adaptor.addChild(root_0, DOCUMENT_NODE458_tree);
            }
            LPAREN459=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_DocumentTest10151); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN459_tree = this.adaptor.create(LPAREN459);
            this.adaptor.addChild(root_0, LPAREN459_tree);
            }
            // xquery/XQueryParser.g:1357:32: ( p_ElementTest | p_SchemaElementTest )?
            var alt166=3;
            var LA166_0 = this.input.LA(1);

            if ( (LA166_0==ELEMENT) ) {
                alt166=1;
            }
            else if ( (LA166_0==SCHEMA_ELEMENT) ) {
                alt166=2;
            }
            switch (alt166) {
                case 1 :
                    // xquery/XQueryParser.g:1357:33: p_ElementTest
                    this.pushFollow(XQueryParser.FOLLOW_p_ElementTest_in_p_DocumentTest10154);
                    p_ElementTest460=this.p_ElementTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ElementTest460.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1357:49: p_SchemaElementTest
                    this.pushFollow(XQueryParser.FOLLOW_p_SchemaElementTest_in_p_DocumentTest10158);
                    p_SchemaElementTest461=this.p_SchemaElementTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SchemaElementTest461.getTree());


                    break;

            }

            RPAREN462=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_DocumentTest10162); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN462_tree = this.adaptor.create(RPAREN462);
            this.adaptor.addChild(root_0, RPAREN462_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TextTest_return: (function() {
        XQueryParser.p_TextTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TextTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1361:1: p_TextTest : TEXT LPAREN RPAREN ;
    // $ANTLR start "p_TextTest"
    p_TextTest: function() {
        var retval = new XQueryParser.p_TextTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var TEXT463 = null;
        var LPAREN464 = null;
        var RPAREN465 = null;

        var TEXT463_tree=null;
        var LPAREN464_tree=null;
        var RPAREN465_tree=null;

        try {
            // xquery/XQueryParser.g:1362:9: ( TEXT LPAREN RPAREN )
            // xquery/XQueryParser.g:1362:11: TEXT LPAREN RPAREN
            root_0 = this.adaptor.nil();

            TEXT463=this.match(this.input,TEXT,XQueryParser.FOLLOW_TEXT_in_p_TextTest10188); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            TEXT463_tree = this.adaptor.create(TEXT463);
            this.adaptor.addChild(root_0, TEXT463_tree);
            }
            LPAREN464=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_TextTest10190); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN464_tree = this.adaptor.create(LPAREN464);
            this.adaptor.addChild(root_0, LPAREN464_tree);
            }
            RPAREN465=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_TextTest10192); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN465_tree = this.adaptor.create(RPAREN465);
            this.adaptor.addChild(root_0, RPAREN465_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CommentTest_return: (function() {
        XQueryParser.p_CommentTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CommentTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1366:1: p_CommentTest : COMMENT LPAREN RPAREN ;
    // $ANTLR start "p_CommentTest"
    p_CommentTest: function() {
        var retval = new XQueryParser.p_CommentTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var COMMENT466 = null;
        var LPAREN467 = null;
        var RPAREN468 = null;

        var COMMENT466_tree=null;
        var LPAREN467_tree=null;
        var RPAREN468_tree=null;

        try {
            // xquery/XQueryParser.g:1367:9: ( COMMENT LPAREN RPAREN )
            // xquery/XQueryParser.g:1367:11: COMMENT LPAREN RPAREN
            root_0 = this.adaptor.nil();

            COMMENT466=this.match(this.input,COMMENT,XQueryParser.FOLLOW_COMMENT_in_p_CommentTest10218); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            COMMENT466_tree = this.adaptor.create(COMMENT466);
            this.adaptor.addChild(root_0, COMMENT466_tree);
            }
            LPAREN467=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_CommentTest10220); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN467_tree = this.adaptor.create(LPAREN467);
            this.adaptor.addChild(root_0, LPAREN467_tree);
            }
            RPAREN468=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_CommentTest10222); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN468_tree = this.adaptor.create(RPAREN468);
            this.adaptor.addChild(root_0, RPAREN468_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_NamespaceNodeTest_return: (function() {
        XQueryParser.p_NamespaceNodeTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_NamespaceNodeTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1371:1: p_NamespaceNodeTest : NAMESPACE_NODE LPAREN RPAREN ;
    // $ANTLR start "p_NamespaceNodeTest"
    p_NamespaceNodeTest: function() {
        var retval = new XQueryParser.p_NamespaceNodeTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var NAMESPACE_NODE469 = null;
        var LPAREN470 = null;
        var RPAREN471 = null;

        var NAMESPACE_NODE469_tree=null;
        var LPAREN470_tree=null;
        var RPAREN471_tree=null;

        try {
            // xquery/XQueryParser.g:1372:9: ( NAMESPACE_NODE LPAREN RPAREN )
            // xquery/XQueryParser.g:1372:11: NAMESPACE_NODE LPAREN RPAREN
            root_0 = this.adaptor.nil();

            NAMESPACE_NODE469=this.match(this.input,NAMESPACE_NODE,XQueryParser.FOLLOW_NAMESPACE_NODE_in_p_NamespaceNodeTest10248); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            NAMESPACE_NODE469_tree = this.adaptor.create(NAMESPACE_NODE469);
            this.adaptor.addChild(root_0, NAMESPACE_NODE469_tree);
            }
            LPAREN470=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_NamespaceNodeTest10250); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN470_tree = this.adaptor.create(LPAREN470);
            this.adaptor.addChild(root_0, LPAREN470_tree);
            }
            RPAREN471=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_NamespaceNodeTest10252); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN471_tree = this.adaptor.create(RPAREN471);
            this.adaptor.addChild(root_0, RPAREN471_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PITest_return: (function() {
        XQueryParser.p_PITest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PITest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1376:1: p_PITest : PROCESSING_INSTRUCTION LPAREN ( p_NCName | p_StringLiteral )? RPAREN ;
    // $ANTLR start "p_PITest"
    p_PITest: function() {
        var retval = new XQueryParser.p_PITest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var PROCESSING_INSTRUCTION472 = null;
        var LPAREN473 = null;
        var RPAREN476 = null;
         var p_NCName474 = null;
         var p_StringLiteral475 = null;

        var PROCESSING_INSTRUCTION472_tree=null;
        var LPAREN473_tree=null;
        var RPAREN476_tree=null;

        try {
            // xquery/XQueryParser.g:1377:9: ( PROCESSING_INSTRUCTION LPAREN ( p_NCName | p_StringLiteral )? RPAREN )
            // xquery/XQueryParser.g:1377:11: PROCESSING_INSTRUCTION LPAREN ( p_NCName | p_StringLiteral )? RPAREN
            root_0 = this.adaptor.nil();

            PROCESSING_INSTRUCTION472=this.match(this.input,PROCESSING_INSTRUCTION,XQueryParser.FOLLOW_PROCESSING_INSTRUCTION_in_p_PITest10278); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            PROCESSING_INSTRUCTION472_tree = this.adaptor.create(PROCESSING_INSTRUCTION472);
            this.adaptor.addChild(root_0, PROCESSING_INSTRUCTION472_tree);
            }
            LPAREN473=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_PITest10280); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN473_tree = this.adaptor.create(LPAREN473);
            this.adaptor.addChild(root_0, LPAREN473_tree);
            }
            // xquery/XQueryParser.g:1377:41: ( p_NCName | p_StringLiteral )?
            var alt167=3;
            var LA167_0 = this.input.LA(1);

            if ( ((LA167_0>=ANCESTOR && LA167_0<=SKIP)||(LA167_0>=VALUE && LA167_0<=QUOT_ER)||LA167_0==L_NCName||LA167_0==EXPLICITLY) ) {
                alt167=1;
            }
            else if ( ((LA167_0>=APOS && LA167_0<=QUOT)) ) {
                alt167=2;
            }
            switch (alt167) {
                case 1 :
                    // xquery/XQueryParser.g:1377:42: p_NCName
                    this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_p_PITest10283);
                    p_NCName474=this.p_NCName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NCName474.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1377:53: p_StringLiteral
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_PITest10287);
                    p_StringLiteral475=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral475.getTree());


                    break;

            }

            RPAREN476=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_PITest10291); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN476_tree = this.adaptor.create(RPAREN476);
            this.adaptor.addChild(root_0, RPAREN476_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AttributeTest_return: (function() {
        XQueryParser.p_AttributeTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AttributeTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1381:1: p_AttributeTest : ATTRIBUTE LPAREN ( p_AttribNameOrWildcard ( COMMA p_TypeName )? )? RPAREN ;
    // $ANTLR start "p_AttributeTest"
    p_AttributeTest: function() {
        var retval = new XQueryParser.p_AttributeTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var ATTRIBUTE477 = null;
        var LPAREN478 = null;
        var COMMA480 = null;
        var RPAREN482 = null;
         var p_AttribNameOrWildcard479 = null;
         var p_TypeName481 = null;

        var ATTRIBUTE477_tree=null;
        var LPAREN478_tree=null;
        var COMMA480_tree=null;
        var RPAREN482_tree=null;

        try {
            // xquery/XQueryParser.g:1382:9: ( ATTRIBUTE LPAREN ( p_AttribNameOrWildcard ( COMMA p_TypeName )? )? RPAREN )
            // xquery/XQueryParser.g:1382:11: ATTRIBUTE LPAREN ( p_AttribNameOrWildcard ( COMMA p_TypeName )? )? RPAREN
            root_0 = this.adaptor.nil();

            ATTRIBUTE477=this.match(this.input,ATTRIBUTE,XQueryParser.FOLLOW_ATTRIBUTE_in_p_AttributeTest10317); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            ATTRIBUTE477_tree = this.adaptor.create(ATTRIBUTE477);
            this.adaptor.addChild(root_0, ATTRIBUTE477_tree);
            }
            LPAREN478=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_AttributeTest10319); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN478_tree = this.adaptor.create(LPAREN478);
            this.adaptor.addChild(root_0, LPAREN478_tree);
            }
            // xquery/XQueryParser.g:1382:28: ( p_AttribNameOrWildcard ( COMMA p_TypeName )? )?
            var alt169=2;
            var LA169_0 = this.input.LA(1);

            if ( ((LA169_0>=ANCESTOR && LA169_0<=SKIP)||(LA169_0>=VALUE && LA169_0<=QUOT_ER)||LA169_0==STAR||LA169_0==L_NCName||LA169_0==EXPLICITLY) ) {
                alt169=1;
            }
            switch (alt169) {
                case 1 :
                    // xquery/XQueryParser.g:1382:29: p_AttribNameOrWildcard ( COMMA p_TypeName )?
                    this.pushFollow(XQueryParser.FOLLOW_p_AttribNameOrWildcard_in_p_AttributeTest10322);
                    p_AttribNameOrWildcard479=this.p_AttribNameOrWildcard();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AttribNameOrWildcard479.getTree());
                    // xquery/XQueryParser.g:1382:52: ( COMMA p_TypeName )?
                    var alt168=2;
                    var LA168_0 = this.input.LA(1);

                    if ( (LA168_0==COMMA) ) {
                        alt168=1;
                    }
                    switch (alt168) {
                        case 1 :
                            // xquery/XQueryParser.g:1382:53: COMMA p_TypeName
                            COMMA480=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_AttributeTest10325); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            COMMA480_tree = this.adaptor.create(COMMA480);
                            this.adaptor.addChild(root_0, COMMA480_tree);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_TypeName_in_p_AttributeTest10327);
                            p_TypeName481=this.p_TypeName();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeName481.getTree());


                            break;

                    }



                    break;

            }

            RPAREN482=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_AttributeTest10333); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN482_tree = this.adaptor.create(RPAREN482);
            this.adaptor.addChild(root_0, RPAREN482_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AttribNameOrWildcard_return: (function() {
        XQueryParser.p_AttribNameOrWildcard_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AttribNameOrWildcard_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1386:1: p_AttribNameOrWildcard : ( p_AttributeName | STAR );
    // $ANTLR start "p_AttribNameOrWildcard"
    p_AttribNameOrWildcard: function() {
        var retval = new XQueryParser.p_AttribNameOrWildcard_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var STAR484 = null;
         var p_AttributeName483 = null;

        var STAR484_tree=null;

        try {
            // xquery/XQueryParser.g:1387:9: ( p_AttributeName | STAR )
            var alt170=2;
            var LA170_0 = this.input.LA(1);

            if ( ((LA170_0>=ANCESTOR && LA170_0<=SKIP)||(LA170_0>=VALUE && LA170_0<=QUOT_ER)||LA170_0==L_NCName||LA170_0==EXPLICITLY) ) {
                alt170=1;
            }
            else if ( (LA170_0==STAR) ) {
                alt170=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 170, 0, this.input);

                throw nvae;
            }
            switch (alt170) {
                case 1 :
                    // xquery/XQueryParser.g:1387:11: p_AttributeName
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_AttributeName_in_p_AttribNameOrWildcard10361);
                    p_AttributeName483=this.p_AttributeName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AttributeName483.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1387:29: STAR
                    root_0 = this.adaptor.nil();

                    STAR484=this.match(this.input,STAR,XQueryParser.FOLLOW_STAR_in_p_AttribNameOrWildcard10365); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    STAR484_tree = this.adaptor.create(STAR484);
                    this.adaptor.addChild(root_0, STAR484_tree);
                    }


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SchemaAttributeTest_return: (function() {
        XQueryParser.p_SchemaAttributeTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SchemaAttributeTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1391:1: p_SchemaAttributeTest : SCHEMA_ATTRIBUTE LPAREN p_AttributeDeclaration RPAREN ;
    // $ANTLR start "p_SchemaAttributeTest"
    p_SchemaAttributeTest: function() {
        var retval = new XQueryParser.p_SchemaAttributeTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var SCHEMA_ATTRIBUTE485 = null;
        var LPAREN486 = null;
        var RPAREN488 = null;
         var p_AttributeDeclaration487 = null;

        var SCHEMA_ATTRIBUTE485_tree=null;
        var LPAREN486_tree=null;
        var RPAREN488_tree=null;

        try {
            // xquery/XQueryParser.g:1392:9: ( SCHEMA_ATTRIBUTE LPAREN p_AttributeDeclaration RPAREN )
            // xquery/XQueryParser.g:1392:11: SCHEMA_ATTRIBUTE LPAREN p_AttributeDeclaration RPAREN
            root_0 = this.adaptor.nil();

            SCHEMA_ATTRIBUTE485=this.match(this.input,SCHEMA_ATTRIBUTE,XQueryParser.FOLLOW_SCHEMA_ATTRIBUTE_in_p_SchemaAttributeTest10391); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SCHEMA_ATTRIBUTE485_tree = this.adaptor.create(SCHEMA_ATTRIBUTE485);
            this.adaptor.addChild(root_0, SCHEMA_ATTRIBUTE485_tree);
            }
            LPAREN486=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_SchemaAttributeTest10393); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN486_tree = this.adaptor.create(LPAREN486);
            this.adaptor.addChild(root_0, LPAREN486_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_AttributeDeclaration_in_p_SchemaAttributeTest10395);
            p_AttributeDeclaration487=this.p_AttributeDeclaration();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AttributeDeclaration487.getTree());
            RPAREN488=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_SchemaAttributeTest10397); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN488_tree = this.adaptor.create(RPAREN488);
            this.adaptor.addChild(root_0, RPAREN488_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AttributeDeclaration_return: (function() {
        XQueryParser.p_AttributeDeclaration_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AttributeDeclaration_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1396:1: p_AttributeDeclaration : p_AttributeName ;
    // $ANTLR start "p_AttributeDeclaration"
    p_AttributeDeclaration: function() {
        var retval = new XQueryParser.p_AttributeDeclaration_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_AttributeName489 = null;


        try {
            // xquery/XQueryParser.g:1397:9: ( p_AttributeName )
            // xquery/XQueryParser.g:1397:11: p_AttributeName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_AttributeName_in_p_AttributeDeclaration10423);
            p_AttributeName489=this.p_AttributeName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AttributeName489.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ElementTest_return: (function() {
        XQueryParser.p_ElementTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ElementTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1401:1: p_ElementTest : ELEMENT LPAREN ( p_ElementNameOrWildcard ( COMMA p_TypeName ( QUESTION )? )? )? RPAREN ;
    // $ANTLR start "p_ElementTest"
    p_ElementTest: function() {
        var retval = new XQueryParser.p_ElementTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var ELEMENT490 = null;
        var LPAREN491 = null;
        var COMMA493 = null;
        var QUESTION495 = null;
        var RPAREN496 = null;
         var p_ElementNameOrWildcard492 = null;
         var p_TypeName494 = null;

        var ELEMENT490_tree=null;
        var LPAREN491_tree=null;
        var COMMA493_tree=null;
        var QUESTION495_tree=null;
        var RPAREN496_tree=null;

        try {
            // xquery/XQueryParser.g:1402:9: ( ELEMENT LPAREN ( p_ElementNameOrWildcard ( COMMA p_TypeName ( QUESTION )? )? )? RPAREN )
            // xquery/XQueryParser.g:1402:11: ELEMENT LPAREN ( p_ElementNameOrWildcard ( COMMA p_TypeName ( QUESTION )? )? )? RPAREN
            root_0 = this.adaptor.nil();

            ELEMENT490=this.match(this.input,ELEMENT,XQueryParser.FOLLOW_ELEMENT_in_p_ElementTest10449); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            ELEMENT490_tree = this.adaptor.create(ELEMENT490);
            this.adaptor.addChild(root_0, ELEMENT490_tree);
            }
            LPAREN491=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_ElementTest10451); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN491_tree = this.adaptor.create(LPAREN491);
            this.adaptor.addChild(root_0, LPAREN491_tree);
            }
            // xquery/XQueryParser.g:1402:26: ( p_ElementNameOrWildcard ( COMMA p_TypeName ( QUESTION )? )? )?
            var alt173=2;
            var LA173_0 = this.input.LA(1);

            if ( ((LA173_0>=ANCESTOR && LA173_0<=SKIP)||(LA173_0>=VALUE && LA173_0<=QUOT_ER)||LA173_0==STAR||LA173_0==L_NCName||LA173_0==EXPLICITLY) ) {
                alt173=1;
            }
            switch (alt173) {
                case 1 :
                    // xquery/XQueryParser.g:1402:27: p_ElementNameOrWildcard ( COMMA p_TypeName ( QUESTION )? )?
                    this.pushFollow(XQueryParser.FOLLOW_p_ElementNameOrWildcard_in_p_ElementTest10454);
                    p_ElementNameOrWildcard492=this.p_ElementNameOrWildcard();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ElementNameOrWildcard492.getTree());
                    // xquery/XQueryParser.g:1402:51: ( COMMA p_TypeName ( QUESTION )? )?
                    var alt172=2;
                    var LA172_0 = this.input.LA(1);

                    if ( (LA172_0==COMMA) ) {
                        alt172=1;
                    }
                    switch (alt172) {
                        case 1 :
                            // xquery/XQueryParser.g:1402:52: COMMA p_TypeName ( QUESTION )?
                            COMMA493=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_ElementTest10457); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            COMMA493_tree = this.adaptor.create(COMMA493);
                            this.adaptor.addChild(root_0, COMMA493_tree);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_TypeName_in_p_ElementTest10459);
                            p_TypeName494=this.p_TypeName();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeName494.getTree());
                            // xquery/XQueryParser.g:1402:69: ( QUESTION )?
                            var alt171=2;
                            var LA171_0 = this.input.LA(1);

                            if ( (LA171_0==QUESTION) ) {
                                alt171=1;
                            }
                            switch (alt171) {
                                case 1 :
                                    // xquery/XQueryParser.g:1402:69: QUESTION
                                    QUESTION495=this.match(this.input,QUESTION,XQueryParser.FOLLOW_QUESTION_in_p_ElementTest10461); if (this.state.failed) return retval;
                                    if ( this.state.backtracking===0 ) {
                                    QUESTION495_tree = this.adaptor.create(QUESTION495);
                                    this.adaptor.addChild(root_0, QUESTION495_tree);
                                    }


                                    break;

                            }



                            break;

                    }



                    break;

            }

            RPAREN496=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_ElementTest10468); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN496_tree = this.adaptor.create(RPAREN496);
            this.adaptor.addChild(root_0, RPAREN496_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ElementNameOrWildcard_return: (function() {
        XQueryParser.p_ElementNameOrWildcard_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ElementNameOrWildcard_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1406:1: p_ElementNameOrWildcard : ( p_QName | STAR );
    // $ANTLR start "p_ElementNameOrWildcard"
    p_ElementNameOrWildcard: function() {
        var retval = new XQueryParser.p_ElementNameOrWildcard_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var STAR498 = null;
         var p_QName497 = null;

        var STAR498_tree=null;

        try {
            // xquery/XQueryParser.g:1407:9: ( p_QName | STAR )
            var alt174=2;
            var LA174_0 = this.input.LA(1);

            if ( ((LA174_0>=ANCESTOR && LA174_0<=SKIP)||(LA174_0>=VALUE && LA174_0<=QUOT_ER)||LA174_0==L_NCName||LA174_0==EXPLICITLY) ) {
                alt174=1;
            }
            else if ( (LA174_0==STAR) ) {
                alt174=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 174, 0, this.input);

                throw nvae;
            }
            switch (alt174) {
                case 1 :
                    // xquery/XQueryParser.g:1407:11: p_QName
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_ElementNameOrWildcard10494);
                    p_QName497=this.p_QName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName497.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1407:21: STAR
                    root_0 = this.adaptor.nil();

                    STAR498=this.match(this.input,STAR,XQueryParser.FOLLOW_STAR_in_p_ElementNameOrWildcard10498); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    STAR498_tree = this.adaptor.create(STAR498);
                    this.adaptor.addChild(root_0, STAR498_tree);
                    }


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SchemaElementTest_return: (function() {
        XQueryParser.p_SchemaElementTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SchemaElementTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1410:1: p_SchemaElementTest : SCHEMA_ELEMENT LPAREN p_ElementDeclaration RPAREN ;
    // $ANTLR start "p_SchemaElementTest"
    p_SchemaElementTest: function() {
        var retval = new XQueryParser.p_SchemaElementTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var SCHEMA_ELEMENT499 = null;
        var LPAREN500 = null;
        var RPAREN502 = null;
         var p_ElementDeclaration501 = null;

        var SCHEMA_ELEMENT499_tree=null;
        var LPAREN500_tree=null;
        var RPAREN502_tree=null;

        try {
            // xquery/XQueryParser.g:1411:9: ( SCHEMA_ELEMENT LPAREN p_ElementDeclaration RPAREN )
            // xquery/XQueryParser.g:1411:11: SCHEMA_ELEMENT LPAREN p_ElementDeclaration RPAREN
            root_0 = this.adaptor.nil();

            SCHEMA_ELEMENT499=this.match(this.input,SCHEMA_ELEMENT,XQueryParser.FOLLOW_SCHEMA_ELEMENT_in_p_SchemaElementTest10516); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SCHEMA_ELEMENT499_tree = this.adaptor.create(SCHEMA_ELEMENT499);
            this.adaptor.addChild(root_0, SCHEMA_ELEMENT499_tree);
            }
            LPAREN500=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_SchemaElementTest10518); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN500_tree = this.adaptor.create(LPAREN500);
            this.adaptor.addChild(root_0, LPAREN500_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ElementDeclaration_in_p_SchemaElementTest10520);
            p_ElementDeclaration501=this.p_ElementDeclaration();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ElementDeclaration501.getTree());
            RPAREN502=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_SchemaElementTest10522); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN502_tree = this.adaptor.create(RPAREN502);
            this.adaptor.addChild(root_0, RPAREN502_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ElementDeclaration_return: (function() {
        XQueryParser.p_ElementDeclaration_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ElementDeclaration_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1415:1: p_ElementDeclaration : p_ElementName ;
    // $ANTLR start "p_ElementDeclaration"
    p_ElementDeclaration: function() {
        var retval = new XQueryParser.p_ElementDeclaration_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ElementName503 = null;


        try {
            // xquery/XQueryParser.g:1416:9: ( p_ElementName )
            // xquery/XQueryParser.g:1416:11: p_ElementName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ElementName_in_p_ElementDeclaration10548);
            p_ElementName503=this.p_ElementName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ElementName503.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AttributeName_return: (function() {
        XQueryParser.p_AttributeName_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AttributeName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1420:1: p_AttributeName : p_QName ;
    // $ANTLR start "p_AttributeName"
    p_AttributeName: function() {
        var retval = new XQueryParser.p_AttributeName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_QName504 = null;


        try {
            // xquery/XQueryParser.g:1421:9: ( p_QName )
            // xquery/XQueryParser.g:1421:11: p_QName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_AttributeName10574);
            p_QName504=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName504.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ElementName_return: (function() {
        XQueryParser.p_ElementName_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ElementName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1425:1: p_ElementName : p_QName ;
    // $ANTLR start "p_ElementName"
    p_ElementName: function() {
        var retval = new XQueryParser.p_ElementName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_QName505 = null;


        try {
            // xquery/XQueryParser.g:1426:9: ( p_QName )
            // xquery/XQueryParser.g:1426:11: p_QName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_ElementName10600);
            p_QName505=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName505.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TypeName_return: (function() {
        XQueryParser.p_TypeName_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TypeName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1430:1: p_TypeName : p_QName ;
    // $ANTLR start "p_TypeName"
    p_TypeName: function() {
        var retval = new XQueryParser.p_TypeName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_QName506 = null;


        try {
            // xquery/XQueryParser.g:1431:9: ( p_QName )
            // xquery/XQueryParser.g:1431:11: p_QName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_QName_in_p_TypeName10626);
            p_QName506=this.p_QName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_QName506.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_FunctionTest_return: (function() {
        XQueryParser.p_FunctionTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_FunctionTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1435:1: p_FunctionTest : ( p_Annotation )* ( p_AnyFunctionTest | p_TypedFunctionTest ) ;
    // $ANTLR start "p_FunctionTest"
    p_FunctionTest: function() {
        var retval = new XQueryParser.p_FunctionTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_Annotation507 = null;
         var p_AnyFunctionTest508 = null;
         var p_TypedFunctionTest509 = null;


        try {
            // xquery/XQueryParser.g:1436:9: ( ( p_Annotation )* ( p_AnyFunctionTest | p_TypedFunctionTest ) )
            // xquery/XQueryParser.g:1436:11: ( p_Annotation )* ( p_AnyFunctionTest | p_TypedFunctionTest )
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:1436:11: ( p_Annotation )*
            loop175:
            do {
                var alt175=2;
                var LA175_0 = this.input.LA(1);

                if ( (LA175_0==ANN_PERCENT) ) {
                    alt175=1;
                }


                switch (alt175) {
                case 1 :
                    // xquery/XQueryParser.g:1436:11: p_Annotation
                    this.pushFollow(XQueryParser.FOLLOW_p_Annotation_in_p_FunctionTest10652);
                    p_Annotation507=this.p_Annotation();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Annotation507.getTree());


                    break;

                default :
                    break loop175;
                }
            } while (true);

            // xquery/XQueryParser.g:1436:25: ( p_AnyFunctionTest | p_TypedFunctionTest )
            var alt176=2;
            var LA176_0 = this.input.LA(1);

            if ( (LA176_0==FUNCTION) ) {
                var LA176_1 = this.input.LA(2);

                if ( (LA176_1==LPAREN) ) {
                    var LA176_2 = this.input.LA(3);

                    if ( (LA176_2==STAR) ) {
                        alt176=1;
                    }
                    else if ( ((LA176_2>=ANCESTOR && LA176_2<=SKIP)||(LA176_2>=VALUE && LA176_2<=QUOT_ER)||(LA176_2>=LPAREN && LA176_2<=RPAREN)||LA176_2==L_NCName||LA176_2==EXPLICITLY) ) {
                        alt176=2;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var nvae =
                            new org.antlr.runtime.NoViableAltException("", 176, 2, this.input);

                        throw nvae;
                    }
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 176, 1, this.input);

                    throw nvae;
                }
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 176, 0, this.input);

                throw nvae;
            }
            switch (alt176) {
                case 1 :
                    // xquery/XQueryParser.g:1436:26: p_AnyFunctionTest
                    this.pushFollow(XQueryParser.FOLLOW_p_AnyFunctionTest_in_p_FunctionTest10656);
                    p_AnyFunctionTest508=this.p_AnyFunctionTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AnyFunctionTest508.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1436:46: p_TypedFunctionTest
                    this.pushFollow(XQueryParser.FOLLOW_p_TypedFunctionTest_in_p_FunctionTest10660);
                    p_TypedFunctionTest509=this.p_TypedFunctionTest();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypedFunctionTest509.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AnyFunctionTest_return: (function() {
        XQueryParser.p_AnyFunctionTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AnyFunctionTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1440:1: p_AnyFunctionTest : FUNCTION LPAREN STAR RPAREN ;
    // $ANTLR start "p_AnyFunctionTest"
    p_AnyFunctionTest: function() {
        var retval = new XQueryParser.p_AnyFunctionTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var FUNCTION510 = null;
        var LPAREN511 = null;
        var STAR512 = null;
        var RPAREN513 = null;

        var FUNCTION510_tree=null;
        var LPAREN511_tree=null;
        var STAR512_tree=null;
        var RPAREN513_tree=null;

        try {
            // xquery/XQueryParser.g:1441:9: ( FUNCTION LPAREN STAR RPAREN )
            // xquery/XQueryParser.g:1441:11: FUNCTION LPAREN STAR RPAREN
            root_0 = this.adaptor.nil();

            FUNCTION510=this.match(this.input,FUNCTION,XQueryParser.FOLLOW_FUNCTION_in_p_AnyFunctionTest10687); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            FUNCTION510_tree = this.adaptor.create(FUNCTION510);
            this.adaptor.addChild(root_0, FUNCTION510_tree);
            }
            LPAREN511=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_AnyFunctionTest10689); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN511_tree = this.adaptor.create(LPAREN511);
            this.adaptor.addChild(root_0, LPAREN511_tree);
            }
            STAR512=this.match(this.input,STAR,XQueryParser.FOLLOW_STAR_in_p_AnyFunctionTest10691); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            STAR512_tree = this.adaptor.create(STAR512);
            this.adaptor.addChild(root_0, STAR512_tree);
            }
            RPAREN513=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_AnyFunctionTest10693); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN513_tree = this.adaptor.create(RPAREN513);
            this.adaptor.addChild(root_0, RPAREN513_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TypedFunctionTest_return: (function() {
        XQueryParser.p_TypedFunctionTest_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TypedFunctionTest_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1445:1: p_TypedFunctionTest : FUNCTION LPAREN ( p_SequenceType ( COMMA p_SequenceType )* )? RPAREN AS p_SequenceType ;
    // $ANTLR start "p_TypedFunctionTest"
    p_TypedFunctionTest: function() {
        var retval = new XQueryParser.p_TypedFunctionTest_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var FUNCTION514 = null;
        var LPAREN515 = null;
        var COMMA517 = null;
        var RPAREN519 = null;
        var AS520 = null;
         var p_SequenceType516 = null;
         var p_SequenceType518 = null;
         var p_SequenceType521 = null;

        var FUNCTION514_tree=null;
        var LPAREN515_tree=null;
        var COMMA517_tree=null;
        var RPAREN519_tree=null;
        var AS520_tree=null;

        try {
            // xquery/XQueryParser.g:1446:9: ( FUNCTION LPAREN ( p_SequenceType ( COMMA p_SequenceType )* )? RPAREN AS p_SequenceType )
            // xquery/XQueryParser.g:1446:11: FUNCTION LPAREN ( p_SequenceType ( COMMA p_SequenceType )* )? RPAREN AS p_SequenceType
            root_0 = this.adaptor.nil();

            FUNCTION514=this.match(this.input,FUNCTION,XQueryParser.FOLLOW_FUNCTION_in_p_TypedFunctionTest10719); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            FUNCTION514_tree = this.adaptor.create(FUNCTION514);
            this.adaptor.addChild(root_0, FUNCTION514_tree);
            }
            LPAREN515=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_TypedFunctionTest10721); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN515_tree = this.adaptor.create(LPAREN515);
            this.adaptor.addChild(root_0, LPAREN515_tree);
            }
            // xquery/XQueryParser.g:1446:27: ( p_SequenceType ( COMMA p_SequenceType )* )?
            var alt178=2;
            var LA178_0 = this.input.LA(1);

            if ( ((LA178_0>=ANCESTOR && LA178_0<=SKIP)||(LA178_0>=VALUE && LA178_0<=QUOT_ER)||LA178_0==LPAREN||LA178_0==L_NCName||LA178_0==EXPLICITLY) ) {
                alt178=1;
            }
            switch (alt178) {
                case 1 :
                    // xquery/XQueryParser.g:1446:28: p_SequenceType ( COMMA p_SequenceType )*
                    this.pushFollow(XQueryParser.FOLLOW_p_SequenceType_in_p_TypedFunctionTest10724);
                    p_SequenceType516=this.p_SequenceType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SequenceType516.getTree());
                    // xquery/XQueryParser.g:1446:43: ( COMMA p_SequenceType )*
                    loop177:
                    do {
                        var alt177=2;
                        var LA177_0 = this.input.LA(1);

                        if ( (LA177_0==COMMA) ) {
                            alt177=1;
                        }


                        switch (alt177) {
                        case 1 :
                            // xquery/XQueryParser.g:1446:44: COMMA p_SequenceType
                            COMMA517=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_TypedFunctionTest10727); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            COMMA517_tree = this.adaptor.create(COMMA517);
                            this.adaptor.addChild(root_0, COMMA517_tree);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_SequenceType_in_p_TypedFunctionTest10729);
                            p_SequenceType518=this.p_SequenceType();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SequenceType518.getTree());


                            break;

                        default :
                            break loop177;
                        }
                    } while (true);



                    break;

            }

            RPAREN519=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_TypedFunctionTest10735); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN519_tree = this.adaptor.create(RPAREN519);
            this.adaptor.addChild(root_0, RPAREN519_tree);
            }
            AS520=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_p_TypedFunctionTest10737); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            AS520_tree = this.adaptor.create(AS520);
            this.adaptor.addChild(root_0, AS520_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_SequenceType_in_p_TypedFunctionTest10739);
            p_SequenceType521=this.p_SequenceType();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SequenceType521.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ParenthesizedItemType_return: (function() {
        XQueryParser.p_ParenthesizedItemType_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ParenthesizedItemType_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1450:1: p_ParenthesizedItemType : LPAREN p_ItemType RPAREN ;
    // $ANTLR start "p_ParenthesizedItemType"
    p_ParenthesizedItemType: function() {
        var retval = new XQueryParser.p_ParenthesizedItemType_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var LPAREN522 = null;
        var RPAREN524 = null;
         var p_ItemType523 = null;

        var LPAREN522_tree=null;
        var RPAREN524_tree=null;

        try {
            // xquery/XQueryParser.g:1451:9: ( LPAREN p_ItemType RPAREN )
            // xquery/XQueryParser.g:1451:11: LPAREN p_ItemType RPAREN
            root_0 = this.adaptor.nil();

            LPAREN522=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_ParenthesizedItemType10765); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            LPAREN522_tree = this.adaptor.create(LPAREN522);
            this.adaptor.addChild(root_0, LPAREN522_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ItemType_in_p_ParenthesizedItemType10767);
            p_ItemType523=this.p_ItemType();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ItemType523.getTree());
            RPAREN524=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_ParenthesizedItemType10769); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            RPAREN524_tree = this.adaptor.create(RPAREN524);
            this.adaptor.addChild(root_0, RPAREN524_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_StringLiteral_return: (function() {
        XQueryParser.p_StringLiteral_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_StringLiteral_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1480:1: p_StringLiteral : ( QUOT pg_QuotStringLiteralContent QUOT -> ^( StringLiteral ( pg_QuotStringLiteralContent )* ) | APOS pg_AposStringLiteralContent APOS -> ^( StringLiteral ( pg_AposStringLiteralContent )* ) );
    // $ANTLR start "p_StringLiteral"
    p_StringLiteral: function() {
        var retval = new XQueryParser.p_StringLiteral_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var QUOT525 = null;
        var QUOT527 = null;
        var APOS528 = null;
        var APOS530 = null;
         var pg_QuotStringLiteralContent526 = null;
         var pg_AposStringLiteralContent529 = null;

        var QUOT525_tree=null;
        var QUOT527_tree=null;
        var APOS528_tree=null;
        var APOS530_tree=null;
        var stream_APOS=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token APOS");
        var stream_QUOT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token QUOT");
        var stream_pg_QuotStringLiteralContent=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pg_QuotStringLiteralContent");
        var stream_pg_AposStringLiteralContent=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pg_AposStringLiteralContent");
        try {
            // xquery/XQueryParser.g:1481:9: ( QUOT pg_QuotStringLiteralContent QUOT -> ^( StringLiteral ( pg_QuotStringLiteralContent )* ) | APOS pg_AposStringLiteralContent APOS -> ^( StringLiteral ( pg_AposStringLiteralContent )* ) )
            var alt179=2;
            var LA179_0 = this.input.LA(1);

            if ( (LA179_0==QUOT) ) {
                alt179=1;
            }
            else if ( (LA179_0==APOS) ) {
                alt179=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 179, 0, this.input);

                throw nvae;
            }
            switch (alt179) {
                case 1 :
                    // xquery/XQueryParser.g:1481:11: QUOT pg_QuotStringLiteralContent QUOT
                    QUOT525=this.match(this.input,QUOT,XQueryParser.FOLLOW_QUOT_in_p_StringLiteral10820); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_QUOT.add(QUOT525);

                    if ( this.state.backtracking===0 ) {
                       this.pushStringLexer(false);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_pg_QuotStringLiteralContent_in_p_StringLiteral10824);
                    pg_QuotStringLiteralContent526=this.pg_QuotStringLiteralContent();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_pg_QuotStringLiteralContent.add(pg_QuotStringLiteralContent526.getTree());
                    QUOT527=this.match(this.input,QUOT,XQueryParser.FOLLOW_QUOT_in_p_StringLiteral10826); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_QUOT.add(QUOT527);

                    if ( this.state.backtracking===0 ) {
                       this.popLexer(); 
                    }


                    // AST REWRITE
                    // elements: pg_QuotStringLiteralContent
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1482:17: -> ^( StringLiteral ( pg_QuotStringLiteralContent )* )
                    {
                        // xquery/XQueryParser.g:1482:20: ^( StringLiteral ( pg_QuotStringLiteralContent )* )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(StringLiteral, "StringLiteral"), root_1);

                        // xquery/XQueryParser.g:1482:36: ( pg_QuotStringLiteralContent )*
                        while ( stream_pg_QuotStringLiteralContent.hasNext() ) {
                            this.adaptor.addChild(root_1, stream_pg_QuotStringLiteralContent.nextTree());

                        }
                        stream_pg_QuotStringLiteralContent.reset();

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;
                case 2 :
                    // xquery/XQueryParser.g:1483:11: APOS pg_AposStringLiteralContent APOS
                    APOS528=this.match(this.input,APOS,XQueryParser.FOLLOW_APOS_in_p_StringLiteral10865); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_APOS.add(APOS528);

                    if ( this.state.backtracking===0 ) {
                      this.pushStringLexer(true);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_pg_AposStringLiteralContent_in_p_StringLiteral10869);
                    pg_AposStringLiteralContent529=this.pg_AposStringLiteralContent();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_pg_AposStringLiteralContent.add(pg_AposStringLiteralContent529.getTree());
                    APOS530=this.match(this.input,APOS,XQueryParser.FOLLOW_APOS_in_p_StringLiteral10871); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_APOS.add(APOS530);

                    if ( this.state.backtracking===0 ) {
                       this.popLexer(); 
                    }


                    // AST REWRITE
                    // elements: pg_AposStringLiteralContent
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1484:17: -> ^( StringLiteral ( pg_AposStringLiteralContent )* )
                    {
                        // xquery/XQueryParser.g:1484:20: ^( StringLiteral ( pg_AposStringLiteralContent )* )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(StringLiteral, "StringLiteral"), root_1);

                        // xquery/XQueryParser.g:1484:36: ( pg_AposStringLiteralContent )*
                        while ( stream_pg_AposStringLiteralContent.hasNext() ) {
                            this.adaptor.addChild(root_1, stream_pg_AposStringLiteralContent.nextTree());

                        }
                        stream_pg_AposStringLiteralContent.reset();

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
             this.addString(retval.start, retval.stop); 
        }
        return retval;
    },

    // inline static return class
    pg_QuotStringLiteralContent_return: (function() {
        XQueryParser.pg_QuotStringLiteralContent_return = function(){};
        org.antlr.lang.extend(XQueryParser.pg_QuotStringLiteralContent_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1490:1: pg_QuotStringLiteralContent : ( ESCAPE_QUOT | L_CharRef | L_PredefinedEntityRef | ~ ( QUOT | AMP ) )* ;
    // $ANTLR start "pg_QuotStringLiteralContent"
    pg_QuotStringLiteralContent: function() {
        var retval = new XQueryParser.pg_QuotStringLiteralContent_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var set531 = null;

        var set531_tree=null;

        try {
            // xquery/XQueryParser.g:1491:9: ( ( ESCAPE_QUOT | L_CharRef | L_PredefinedEntityRef | ~ ( QUOT | AMP ) )* )
            // xquery/XQueryParser.g:1491:11: ( ESCAPE_QUOT | L_CharRef | L_PredefinedEntityRef | ~ ( QUOT | AMP ) )*
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:1491:11: ( ESCAPE_QUOT | L_CharRef | L_PredefinedEntityRef | ~ ( QUOT | AMP ) )*
            loop180:
            do {
                var alt180=2;
                var LA180_0 = this.input.LA(1);

                if ( ((LA180_0>=L_QuotAttrContentChar && LA180_0<=HASH)||(LA180_0>=COMMA && LA180_0<=APOS)||(LA180_0>=NCNameStartChar && LA180_0<=EXPLICITLY)) ) {
                    alt180=1;
                }


                switch (alt180) {
                case 1 :
                    // xquery/XQueryParser.g:
                    set531=this.input.LT(1);
                    if ( (this.input.LA(1)>=L_QuotAttrContentChar && this.input.LA(1)<=HASH)||(this.input.LA(1)>=COMMA && this.input.LA(1)<=APOS)||(this.input.LA(1)>=NCNameStartChar && this.input.LA(1)<=EXPLICITLY) ) {
                        this.input.consume();
                        if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, this.adaptor.create(set531));
                        this.state.errorRecovery=false;this.state.failed=false;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                        throw mse;
                    }



                    break;

                default :
                    break loop180;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pg_AposStringLiteralContent_return: (function() {
        XQueryParser.pg_AposStringLiteralContent_return = function(){};
        org.antlr.lang.extend(XQueryParser.pg_AposStringLiteralContent_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1498:1: pg_AposStringLiteralContent : ( ESCAPE_APOS | L_CharRef | L_PredefinedEntityRef | ~ ( APOS | AMP ) )* ;
    // $ANTLR start "pg_AposStringLiteralContent"
    pg_AposStringLiteralContent: function() {
        var retval = new XQueryParser.pg_AposStringLiteralContent_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var set532 = null;

        var set532_tree=null;

        try {
            // xquery/XQueryParser.g:1499:9: ( ( ESCAPE_APOS | L_CharRef | L_PredefinedEntityRef | ~ ( APOS | AMP ) )* )
            // xquery/XQueryParser.g:1499:11: ( ESCAPE_APOS | L_CharRef | L_PredefinedEntityRef | ~ ( APOS | AMP ) )*
            root_0 = this.adaptor.nil();

            // xquery/XQueryParser.g:1499:11: ( ESCAPE_APOS | L_CharRef | L_PredefinedEntityRef | ~ ( APOS | AMP ) )*
            loop181:
            do {
                var alt181=2;
                var LA181_0 = this.input.LA(1);

                if ( ((LA181_0>=L_QuotAttrContentChar && LA181_0<=HASH)||(LA181_0>=COMMA && LA181_0<=CHARREF_HEX)||(LA181_0>=QUOT && LA181_0<=EXPLICITLY)) ) {
                    alt181=1;
                }


                switch (alt181) {
                case 1 :
                    // xquery/XQueryParser.g:
                    set532=this.input.LT(1);
                    if ( (this.input.LA(1)>=L_QuotAttrContentChar && this.input.LA(1)<=HASH)||(this.input.LA(1)>=COMMA && this.input.LA(1)<=CHARREF_HEX)||(this.input.LA(1)>=QUOT && this.input.LA(1)<=EXPLICITLY) ) {
                        this.input.consume();
                        if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, this.adaptor.create(set532));
                        this.state.errorRecovery=false;this.state.failed=false;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                        throw mse;
                    }



                    break;

                default :
                    break loop181;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ElementContentChar_return: (function() {
        XQueryParser.p_ElementContentChar_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ElementContentChar_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1513:1: p_ElementContentChar : L_ElementContentChar ;
    // $ANTLR start "p_ElementContentChar"
    p_ElementContentChar: function() {
        var retval = new XQueryParser.p_ElementContentChar_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var L_ElementContentChar533 = null;

        var L_ElementContentChar533_tree=null;

        try {
            // xquery/XQueryParser.g:1514:9: ( L_ElementContentChar )
            // xquery/XQueryParser.g:1514:11: L_ElementContentChar
            root_0 = this.adaptor.nil();

            L_ElementContentChar533=this.match(this.input,L_ElementContentChar,XQueryParser.FOLLOW_L_ElementContentChar_in_p_ElementContentChar11046); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            L_ElementContentChar533_tree = this.adaptor.create(L_ElementContentChar533);
            this.adaptor.addChild(root_0, L_ElementContentChar533_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_QuotAttrContentChar_return: (function() {
        XQueryParser.p_QuotAttrContentChar_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_QuotAttrContentChar_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1518:1: p_QuotAttrContentChar : L_QuotAttrContentChar -> ^( AttributeValueChar L_QuotAttrContentChar ) ;
    // $ANTLR start "p_QuotAttrContentChar"
    p_QuotAttrContentChar: function() {
        var retval = new XQueryParser.p_QuotAttrContentChar_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var L_QuotAttrContentChar534 = null;

        var L_QuotAttrContentChar534_tree=null;
        var stream_L_QuotAttrContentChar=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token L_QuotAttrContentChar");

        try {
            // xquery/XQueryParser.g:1519:9: ( L_QuotAttrContentChar -> ^( AttributeValueChar L_QuotAttrContentChar ) )
            // xquery/XQueryParser.g:1519:11: L_QuotAttrContentChar
            L_QuotAttrContentChar534=this.match(this.input,L_QuotAttrContentChar,XQueryParser.FOLLOW_L_QuotAttrContentChar_in_p_QuotAttrContentChar11072); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_L_QuotAttrContentChar.add(L_QuotAttrContentChar534);



            // AST REWRITE
            // elements: L_QuotAttrContentChar
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 1520:17: -> ^( AttributeValueChar L_QuotAttrContentChar )
            {
                // xquery/XQueryParser.g:1520:20: ^( AttributeValueChar L_QuotAttrContentChar )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(AttributeValueChar, "AttributeValueChar"), root_1);

                this.adaptor.addChild(root_1, stream_L_QuotAttrContentChar.nextNode());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AposAttrContentChar_return: (function() {
        XQueryParser.p_AposAttrContentChar_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AposAttrContentChar_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1524:1: p_AposAttrContentChar : L_AposAttrContentChar -> ^( AttributeValueChar L_AposAttrContentChar ) ;
    // $ANTLR start "p_AposAttrContentChar"
    p_AposAttrContentChar: function() {
        var retval = new XQueryParser.p_AposAttrContentChar_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var L_AposAttrContentChar535 = null;

        var L_AposAttrContentChar535_tree=null;
        var stream_L_AposAttrContentChar=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token L_AposAttrContentChar");

        try {
            // xquery/XQueryParser.g:1525:9: ( L_AposAttrContentChar -> ^( AttributeValueChar L_AposAttrContentChar ) )
            // xquery/XQueryParser.g:1525:11: L_AposAttrContentChar
            L_AposAttrContentChar535=this.match(this.input,L_AposAttrContentChar,XQueryParser.FOLLOW_L_AposAttrContentChar_in_p_AposAttrContentChar11122); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_L_AposAttrContentChar.add(L_AposAttrContentChar535);



            // AST REWRITE
            // elements: L_AposAttrContentChar
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 1526:17: -> ^( AttributeValueChar L_AposAttrContentChar )
            {
                // xquery/XQueryParser.g:1526:20: ^( AttributeValueChar L_AposAttrContentChar )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(AttributeValueChar, "AttributeValueChar"), root_1);

                this.adaptor.addChild(root_1, stream_L_AposAttrContentChar.nextNode());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_QName_return: (function() {
        XQueryParser.p_QName_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_QName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1544:1: p_QName : ( pg_QName | p_NCName -> ^( QName p_NCName ) );
    // $ANTLR start "p_QName"
    p_QName: function() {
        var retval = new XQueryParser.p_QName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pg_QName536 = null;
         var p_NCName537 = null;

        var stream_p_NCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_NCName");
        this.setWsExplicit(true);
        try {
            // xquery/XQueryParser.g:1546:9: ( pg_QName | p_NCName -> ^( QName p_NCName ) )
            var alt182=2;
            var LA182_0 = this.input.LA(1);

            if ( ((LA182_0>=ANCESTOR && LA182_0<=SKIP)||(LA182_0>=VALUE && LA182_0<=QUOT_ER)||LA182_0==L_NCName||LA182_0==EXPLICITLY) ) {
                var LA182_1 = this.input.LA(2);

                if ( (LA182_1==COLON) ) {
                    alt182=1;
                }
                else if ( (LA182_1==EOF||(LA182_1>=AND && LA182_1<=AT)||(LA182_1>=BY && LA182_1<=CASTABLE)||LA182_1==COLLATION||LA182_1==DEFAULT||(LA182_1>=DESCENDING && LA182_1<=DIV)||LA182_1==EMPTY||LA182_1==EQ||(LA182_1>=EXCEPT && LA182_1<=EXTERNAL)||(LA182_1>=FOR && LA182_1<=GE)||(LA182_1>=GT && LA182_1<=IDIV)||LA182_1==IN||(LA182_1>=INSTANCE && LA182_1<=IS)||LA182_1==LE||(LA182_1>=LET && LA182_1<=MOD)||LA182_1==NE||LA182_1==NODE||(LA182_1>=OR && LA182_1<=ORDER)||(LA182_1>=RETURN && LA182_1<=SATISFIES)||LA182_1==STABLE||(LA182_1>=TO && LA182_1<=TREAT)||LA182_1==UNION||LA182_1==VARIABLE||LA182_1==WHERE||LA182_1==ALLOWING||LA182_1==COUNT||(LA182_1>=DECIMAL_SEPARATOR && LA182_1<=MINUS_SIGN)||(LA182_1>=NAN && LA182_1<=PREVIOUS)||LA182_1==START||LA182_1==WHEN||(LA182_1>=ZERO_DIGIT && LA182_1<=BEFORE)||LA182_1==INTO||LA182_1==MODIFY||LA182_1==UPDATING||LA182_1==WITH||LA182_1==CONTAINS||LA182_1==PARAGRAPHS||LA182_1==SCORE||LA182_1==SENTENCES||LA182_1==TIMES||LA182_1==WORDS||(LA182_1>=CHECK && LA182_1<=COLLECTION)||(LA182_1>=FOREACH && LA182_1<=ON)||(LA182_1>=CONCAT && LA182_1<=ANN_PERCENT)||(LA182_1>=COMMA && LA182_1<=SLASH_SLASH)||LA182_1==EMPTY_CLOSE_TAG||(LA182_1>=SEMICOLON && LA182_1<=VBAR)||(LA182_1>=APOS && LA182_1<=QUOT)||LA182_1==S) ) {
                    alt182=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 182, 1, this.input);

                    throw nvae;
                }
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 182, 0, this.input);

                throw nvae;
            }
            switch (alt182) {
                case 1 :
                    // xquery/XQueryParser.g:1546:11: pg_QName
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pg_QName_in_p_QName11208);
                    pg_QName536=this.pg_QName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pg_QName536.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1547:11: p_NCName
                    this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_p_QName11220);
                    p_NCName537=this.p_NCName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_NCName.add(p_NCName537.getTree());


                    // AST REWRITE
                    // elements: p_NCName
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1548:17: -> ^( QName p_NCName )
                    {
                        // xquery/XQueryParser.g:1548:20: ^( QName p_NCName )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(QName, "QName"), root_1);

                        this.adaptor.addChild(root_1, stream_p_NCName.nextTree());

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
            this.setWsExplicit(false);
        }
        return retval;
    },

    // inline static return class
    pg_FQName_return: (function() {
        XQueryParser.pg_FQName_return = function(){};
        org.antlr.lang.extend(XQueryParser.pg_FQName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1552:1: pg_FQName : ( pg_QName | p_FNCName -> ^( QName p_FNCName ) );
    // $ANTLR start "pg_FQName"
    pg_FQName: function() {
        var retval = new XQueryParser.pg_FQName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pg_QName538 = null;
         var p_FNCName539 = null;

        var stream_p_FNCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_FNCName");
        try {
            // xquery/XQueryParser.g:1553:9: ( pg_QName | p_FNCName -> ^( QName p_FNCName ) )
            var alt183=2;
            switch ( this.input.LA(1) ) {
            case ANCESTOR:
            case ANCESTOR_OR_SELF:
            case AND:
            case AS:
            case ASCENDING:
            case AT:
            case BASE_URI:
            case BOUNDARY_SPACE:
            case BY:
            case CASE:
            case CAST:
            case CASTABLE:
            case CHILD:
            case COLLATION:
            case CONSTRUCTION:
            case COPY_NAMESPACES:
            case DECLARE:
            case DEFAULT:
            case DESCENDANT:
            case DESCENDANT_OR_SELF:
            case DESCENDING:
            case DIV:
            case DOCUMENT:
            case ELSE:
            case EMPTY:
            case ENCODING:
            case EQ:
            case EVERY:
            case EXCEPT:
            case EXTERNAL:
            case FOLLOWING:
            case FOLLOWING_SIBLING:
            case FOR:
            case FUNCTION:
            case GE:
            case GREATEST:
            case GT:
            case IDIV:
            case IMPORT:
            case IN:
            case INHERIT:
            case INSTANCE:
            case INTERSECT:
            case IS:
            case LAX:
            case LE:
            case LEAST:
            case LET:
            case LT:
            case MOD:
            case MODULE:
            case NAMESPACE:
            case NE:
            case NO_INHERIT:
            case NO_PRESERVE:
            case OF:
            case OPTION:
            case OR:
            case ORDER:
            case ORDERED:
            case ORDERING:
            case PARENT:
            case PRECEDING:
            case PRECEDING_SIBLING:
            case PRESERVE:
            case RETURN:
            case SATISFIES:
            case SCHEMA:
            case SELF:
            case SOME:
            case STABLE:
            case STRICT:
            case STRIP:
            case THEN:
            case TO:
            case TREAT:
            case UNION:
            case UNORDERED:
            case VALIDATE:
            case VARIABLE:
            case VERSION:
            case WHERE:
            case XQUERY:
            case ALLOWING:
            case CATCH:
            case CONTEXT:
            case COUNT:
            case DECIMAL_FORMAT:
            case DECIMAL_SEPARATOR:
            case DIGIT:
            case END:
            case GROUP:
            case GROUPING_SEPARATOR:
            case INFINITY:
            case MINUS_SIGN:
            case NAN:
            case NEXT:
            case ONLY:
            case PATTERN_SEPARATOR:
            case PERCENT:
            case PER_MILLE:
            case PREVIOUS:
            case SLIDING:
            case START:
            case TRY:
            case TUMBLING:
            case TYPE:
            case WHEN:
            case WINDOW:
            case ZERO_DIGIT:
            case AFTER:
            case BEFORE:
            case COPY:
            case DELETE:
            case FIRST:
            case INSERT:
            case INTO:
            case LAST:
            case MODIFY:
            case NODES:
            case RENAME:
            case REPLACE:
            case REVALIDATION:
            case SKIP:
            case VALUE:
            case WITH:
            case ALL:
            case ANY:
            case CONTAINS:
            case CONTENT:
            case DIACRITICS:
            case DIFFERENT:
            case DISTANCE:
            case ENTIRE:
            case EXACTLY:
            case FROM:
            case FT_OPTION:
            case FTAND:
            case FTNOT:
            case FTOR:
            case INSENSITIVE:
            case LANGUAGE:
            case LEVELS:
            case LOWERCASE:
            case MOST:
            case NO:
            case NOT:
            case OCCURS:
            case PARAGRAPH:
            case PARAGRAPHS:
            case PHRASE:
            case RELATIONSHIP:
            case SAME:
            case SCORE:
            case SENSITIVE:
            case SENTENCE:
            case SENTENCES:
            case STEMMING:
            case STOP:
            case THESAURUS:
            case TIMES:
            case UPPERCASE:
            case USING:
            case WEIGHT:
            case WILDCARDS:
            case WITHOUT:
            case WORD:
            case WORDS:
            case BREAK:
            case CONTINUE:
            case EXIT:
            case LOOP:
            case RETURNING:
            case CHECK:
            case COLLECTION:
            case CONSTRAINT:
            case FOREACH:
            case FOREIGN:
            case INDEX:
            case INTEGRITY:
            case KEY:
            case ON:
            case UNIQUE:
            case BINARY:
            case AMP_ER:
            case APOS_ER:
            case QUOT_ER:
            case L_NCName:
            case EXPLICITLY:
                var LA183_1 = this.input.LA(2);

                if ( (LA183_1==COLON) ) {
                    alt183=1;
                }
                else if ( (LA183_1==LPAREN) ) {
                    alt183=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 183, 1, this.input);

                    throw nvae;
                }
                break;
            case ATTRIBUTE:
            case COMMENT:
            case DOCUMENT_NODE:
            case ELEMENT:
            case EMPTY_SEQUENCE:
            case IF:
            case ITEM:
            case NODE:
            case PROCESSING_INSTRUCTION:
            case SCHEMA_ATTRIBUTE:
            case SCHEMA_ELEMENT:
            case TEXT:
            case TYPESWITCH:
            case NAMESPACE_NODE:
            case SWITCH:
            case WHILE:
                alt183=1;
                break;
            case UPDATING:
                alt183=2;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 183, 0, this.input);

                throw nvae;
            }

            switch (alt183) {
                case 1 :
                    // xquery/XQueryParser.g:1553:11: pg_QName
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pg_QName_in_pg_FQName11281);
                    pg_QName538=this.pg_QName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pg_QName538.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1554:11: p_FNCName
                    this.pushFollow(XQueryParser.FOLLOW_p_FNCName_in_pg_FQName11293);
                    p_FNCName539=this.p_FNCName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_FNCName.add(p_FNCName539.getTree());


                    // AST REWRITE
                    // elements: p_FNCName
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 1555:17: -> ^( QName p_FNCName )
                    {
                        // xquery/XQueryParser.g:1555:20: ^( QName p_FNCName )
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(QName, "QName"), root_1);

                        this.adaptor.addChild(root_1, stream_p_FNCName.nextTree());

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pg_QName_return: (function() {
        XQueryParser.pg_QName_return = function(){};
        org.antlr.lang.extend(XQueryParser.pg_QName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1557:1: pg_QName : nn= p_NCName COLON nl= p_NCName -> ^( QName $nn $nl) ;
    // $ANTLR start "pg_QName"
    pg_QName: function() {
        var retval = new XQueryParser.pg_QName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var COLON540 = null;
         var nn = null;
         var nl = null;

        var COLON540_tree=null;
        var stream_COLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token COLON");
        var stream_p_NCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_NCName");
        try {
            // xquery/XQueryParser.g:1558:9: (nn= p_NCName COLON nl= p_NCName -> ^( QName $nn $nl) )
            // xquery/XQueryParser.g:1558:11: nn= p_NCName COLON nl= p_NCName
            this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_pg_QName11337);
            nn=this.p_NCName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_NCName.add(nn.getTree());
            COLON540=this.match(this.input,COLON,XQueryParser.FOLLOW_COLON_in_pg_QName11339); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_COLON.add(COLON540);

            this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_pg_QName11343);
            nl=this.p_NCName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_NCName.add(nl.getTree());


            // AST REWRITE
            // elements: nl, nn
            // token labels: 
            // rule labels: retval, nn, nl
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_nn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token nn",nn!=null?nn.tree:null);
            var stream_nl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token nl",nl!=null?nl.tree:null);

            root_0 = this.adaptor.nil();
            // 1559:17: -> ^( QName $nn $nl)
            {
                // xquery/XQueryParser.g:1559:20: ^( QName $nn $nl)
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(QName, "QName"), root_1);

                this.adaptor.addChild(root_1, stream_nn.nextTree());
                this.adaptor.addChild(root_1, stream_nl.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_NCName_return: (function() {
        XQueryParser.p_NCName_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_NCName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1589:1: p_NCName : ( L_NCName | ANCESTOR | ANCESTOR_OR_SELF | AND | AS | ASCENDING | AT | ATTRIBUTE | BASE_URI | BOUNDARY_SPACE | BY | CASE | CAST | CASTABLE | CHILD | COLLATION | COMMENT | CONSTRUCTION | COPY_NAMESPACES | DECLARE | DEFAULT | DESCENDANT | DESCENDANT_OR_SELF | DESCENDING | DIV | DOCUMENT | DOCUMENT_NODE | ELEMENT | ELSE | EMPTY | EMPTY_SEQUENCE | ENCODING | EQ | EVERY | EXCEPT | EXTERNAL | FOLLOWING | FOLLOWING_SIBLING | FOR | FUNCTION | GE | GREATEST | GT | IDIV | IF | IMPORT | IN | INHERIT | INSTANCE | INTERSECT | IS | ITEM | LAX | LE | LEAST | LET | LT | MOD | MODULE | NAMESPACE | NE | NO_INHERIT | NO_PRESERVE | NODE | OF | OPTION | OR | ORDER | ORDERED | ORDERING | PARENT | PRECEDING | PRECEDING_SIBLING | PRESERVE | PROCESSING_INSTRUCTION | RETURN | SATISFIES | SCHEMA | SCHEMA_ATTRIBUTE | SCHEMA_ELEMENT | SELF | SOME | STABLE | STRICT | STRIP | SWITCH | TEXT | THEN | TO | TREAT | TYPESWITCH | UNION | UNORDERED | VALIDATE | VARIABLE | VERSION | WHERE | XQUERY | ALLOWING | CATCH | CONTEXT | COUNT | DECIMAL_FORMAT | DECIMAL_SEPARATOR | DIGIT | END | GROUP | GROUPING_SEPARATOR | INFINITY | MINUS_SIGN | NAMESPACE_NODE | NAN | NEXT | ONLY | PATTERN_SEPARATOR | PERCENT | PER_MILLE | PREVIOUS | SLIDING | START | TRY | TUMBLING | TYPE | WHEN | WINDOW | ZERO_DIGIT | AFTER | BEFORE | COPY | DELETE | FIRST | INSERT | INTO | LAST | MODIFY | NODES | RENAME | REPLACE | REVALIDATION | SKIP | VALUE | WITH | ALL | ANY | CONTAINS | CONTENT | DIACRITICS | DIFFERENT | DISTANCE | ENTIRE | EXACTLY | FROM | FT_OPTION | FTAND | FTNOT | FTOR | INSENSITIVE | LANGUAGE | LEVELS | LOWERCASE | MOST | NO | NOT | OCCURS | PARAGRAPH | PARAGRAPHS | PHRASE | RELATIONSHIP | SAME | SCORE | SENSITIVE | SENTENCE | SENTENCES | STEMMING | STOP | THESAURUS | TIMES | UPPERCASE | USING | WEIGHT | WILDCARDS | WITHOUT | WORD | WORDS | BREAK | CONTINUE | EXIT | LOOP | RETURNING | WHILE | CHECK | COLLECTION | CONSTRAINT | EXPLICITLY | FOREACH | FOREIGN | INDEX | INTEGRITY | KEY | ON | UNIQUE | BINARY | AMP_ER | APOS_ER | QUOT_ER );
    // $ANTLR start "p_NCName"
    p_NCName: function() {
        var retval = new XQueryParser.p_NCName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var set541 = null;

        var set541_tree=null;

        try {
            // xquery/XQueryParser.g:1590:9: ( L_NCName | ANCESTOR | ANCESTOR_OR_SELF | AND | AS | ASCENDING | AT | ATTRIBUTE | BASE_URI | BOUNDARY_SPACE | BY | CASE | CAST | CASTABLE | CHILD | COLLATION | COMMENT | CONSTRUCTION | COPY_NAMESPACES | DECLARE | DEFAULT | DESCENDANT | DESCENDANT_OR_SELF | DESCENDING | DIV | DOCUMENT | DOCUMENT_NODE | ELEMENT | ELSE | EMPTY | EMPTY_SEQUENCE | ENCODING | EQ | EVERY | EXCEPT | EXTERNAL | FOLLOWING | FOLLOWING_SIBLING | FOR | FUNCTION | GE | GREATEST | GT | IDIV | IF | IMPORT | IN | INHERIT | INSTANCE | INTERSECT | IS | ITEM | LAX | LE | LEAST | LET | LT | MOD | MODULE | NAMESPACE | NE | NO_INHERIT | NO_PRESERVE | NODE | OF | OPTION | OR | ORDER | ORDERED | ORDERING | PARENT | PRECEDING | PRECEDING_SIBLING | PRESERVE | PROCESSING_INSTRUCTION | RETURN | SATISFIES | SCHEMA | SCHEMA_ATTRIBUTE | SCHEMA_ELEMENT | SELF | SOME | STABLE | STRICT | STRIP | SWITCH | TEXT | THEN | TO | TREAT | TYPESWITCH | UNION | UNORDERED | VALIDATE | VARIABLE | VERSION | WHERE | XQUERY | ALLOWING | CATCH | CONTEXT | COUNT | DECIMAL_FORMAT | DECIMAL_SEPARATOR | DIGIT | END | GROUP | GROUPING_SEPARATOR | INFINITY | MINUS_SIGN | NAMESPACE_NODE | NAN | NEXT | ONLY | PATTERN_SEPARATOR | PERCENT | PER_MILLE | PREVIOUS | SLIDING | START | TRY | TUMBLING | TYPE | WHEN | WINDOW | ZERO_DIGIT | AFTER | BEFORE | COPY | DELETE | FIRST | INSERT | INTO | LAST | MODIFY | NODES | RENAME | REPLACE | REVALIDATION | SKIP | VALUE | WITH | ALL | ANY | CONTAINS | CONTENT | DIACRITICS | DIFFERENT | DISTANCE | ENTIRE | EXACTLY | FROM | FT_OPTION | FTAND | FTNOT | FTOR | INSENSITIVE | LANGUAGE | LEVELS | LOWERCASE | MOST | NO | NOT | OCCURS | PARAGRAPH | PARAGRAPHS | PHRASE | RELATIONSHIP | SAME | SCORE | SENSITIVE | SENTENCE | SENTENCES | STEMMING | STOP | THESAURUS | TIMES | UPPERCASE | USING | WEIGHT | WILDCARDS | WITHOUT | WORD | WORDS | BREAK | CONTINUE | EXIT | LOOP | RETURNING | WHILE | CHECK | COLLECTION | CONSTRAINT | EXPLICITLY | FOREACH | FOREIGN | INDEX | INTEGRITY | KEY | ON | UNIQUE | BINARY | AMP_ER | APOS_ER | QUOT_ER )
            // xquery/XQueryParser.g:
            root_0 = this.adaptor.nil();

            set541=this.input.LT(1);
            if ( (this.input.LA(1)>=ANCESTOR && this.input.LA(1)<=SKIP)||(this.input.LA(1)>=VALUE && this.input.LA(1)<=QUOT_ER)||this.input.LA(1)==L_NCName||this.input.LA(1)==EXPLICITLY ) {
                this.input.consume();
                if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, this.adaptor.create(set541));
                this.state.errorRecovery=false;this.state.failed=false;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                throw mse;
            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_FNCName_return: (function() {
        XQueryParser.p_FNCName_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_FNCName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1608:1: p_FNCName : ( L_NCName | ANCESTOR | ANCESTOR_OR_SELF | AND | AS | ASCENDING | AT | BASE_URI | BOUNDARY_SPACE | BY | CASE | CAST | CASTABLE | CHILD | COLLATION | CONSTRUCTION | COPY_NAMESPACES | DECLARE | DEFAULT | DESCENDANT | DESCENDANT_OR_SELF | DESCENDING | DIV | DOCUMENT | ELSE | EMPTY | ENCODING | EQ | EVERY | EXCEPT | EXTERNAL | FOLLOWING | FOLLOWING_SIBLING | FOR | FUNCTION | GE | GREATEST | GT | IDIV | IMPORT | IN | INHERIT | INSTANCE | INTERSECT | IS | LAX | LE | LEAST | LET | LT | MOD | MODULE | NAMESPACE | NE | NO_INHERIT | NO_PRESERVE | OF | OPTION | OR | ORDER | ORDERED | ORDERING | PARENT | PRECEDING | PRECEDING_SIBLING | PRESERVE | RETURN | SATISFIES | SCHEMA | SELF | SOME | STABLE | STRICT | STRIP | THEN | TO | TREAT | UNION | UNORDERED | VALIDATE | VARIABLE | VERSION | WHERE | XQUERY | ALLOWING | CATCH | CONTEXT | COUNT | DECIMAL_FORMAT | DECIMAL_SEPARATOR | DIGIT | END | GROUP | GROUPING_SEPARATOR | INFINITY | MINUS_SIGN | NAN | NEXT | ONLY | PATTERN_SEPARATOR | PERCENT | PER_MILLE | PREVIOUS | SLIDING | START | TRY | TUMBLING | TYPE | WHEN | WINDOW | ZERO_DIGIT | AFTER | BEFORE | COPY | DELETE | FIRST | INSERT | INTO | LAST | MODIFY | NODES | RENAME | REPLACE | REVALIDATION | SKIP | UPDATING | VALUE | WITH | ALL | ANY | CONTAINS | CONTENT | DIACRITICS | DIFFERENT | DISTANCE | ENTIRE | EXACTLY | FROM | FT_OPTION | FTAND | FTNOT | FTOR | INSENSITIVE | LANGUAGE | LEVELS | LOWERCASE | MOST | NO | NOT | OCCURS | PARAGRAPH | PARAGRAPHS | PHRASE | RELATIONSHIP | SAME | SCORE | SENSITIVE | SENTENCE | SENTENCES | STEMMING | STOP | THESAURUS | TIMES | UPPERCASE | USING | WEIGHT | WILDCARDS | WITHOUT | WORD | WORDS | BREAK | CONTINUE | EXIT | LOOP | RETURNING | CHECK | COLLECTION | CONSTRAINT | EXPLICITLY | FOREACH | FOREIGN | INDEX | INTEGRITY | KEY | ON | UNIQUE | BINARY | AMP_ER | APOS_ER | QUOT_ER );
    // $ANTLR start "p_FNCName"
    p_FNCName: function() {
        var retval = new XQueryParser.p_FNCName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var set542 = null;

        var set542_tree=null;

        try {
            // xquery/XQueryParser.g:1609:9: ( L_NCName | ANCESTOR | ANCESTOR_OR_SELF | AND | AS | ASCENDING | AT | BASE_URI | BOUNDARY_SPACE | BY | CASE | CAST | CASTABLE | CHILD | COLLATION | CONSTRUCTION | COPY_NAMESPACES | DECLARE | DEFAULT | DESCENDANT | DESCENDANT_OR_SELF | DESCENDING | DIV | DOCUMENT | ELSE | EMPTY | ENCODING | EQ | EVERY | EXCEPT | EXTERNAL | FOLLOWING | FOLLOWING_SIBLING | FOR | FUNCTION | GE | GREATEST | GT | IDIV | IMPORT | IN | INHERIT | INSTANCE | INTERSECT | IS | LAX | LE | LEAST | LET | LT | MOD | MODULE | NAMESPACE | NE | NO_INHERIT | NO_PRESERVE | OF | OPTION | OR | ORDER | ORDERED | ORDERING | PARENT | PRECEDING | PRECEDING_SIBLING | PRESERVE | RETURN | SATISFIES | SCHEMA | SELF | SOME | STABLE | STRICT | STRIP | THEN | TO | TREAT | UNION | UNORDERED | VALIDATE | VARIABLE | VERSION | WHERE | XQUERY | ALLOWING | CATCH | CONTEXT | COUNT | DECIMAL_FORMAT | DECIMAL_SEPARATOR | DIGIT | END | GROUP | GROUPING_SEPARATOR | INFINITY | MINUS_SIGN | NAN | NEXT | ONLY | PATTERN_SEPARATOR | PERCENT | PER_MILLE | PREVIOUS | SLIDING | START | TRY | TUMBLING | TYPE | WHEN | WINDOW | ZERO_DIGIT | AFTER | BEFORE | COPY | DELETE | FIRST | INSERT | INTO | LAST | MODIFY | NODES | RENAME | REPLACE | REVALIDATION | SKIP | UPDATING | VALUE | WITH | ALL | ANY | CONTAINS | CONTENT | DIACRITICS | DIFFERENT | DISTANCE | ENTIRE | EXACTLY | FROM | FT_OPTION | FTAND | FTNOT | FTOR | INSENSITIVE | LANGUAGE | LEVELS | LOWERCASE | MOST | NO | NOT | OCCURS | PARAGRAPH | PARAGRAPHS | PHRASE | RELATIONSHIP | SAME | SCORE | SENSITIVE | SENTENCE | SENTENCES | STEMMING | STOP | THESAURUS | TIMES | UPPERCASE | USING | WEIGHT | WILDCARDS | WITHOUT | WORD | WORDS | BREAK | CONTINUE | EXIT | LOOP | RETURNING | CHECK | COLLECTION | CONSTRAINT | EXPLICITLY | FOREACH | FOREIGN | INDEX | INTEGRITY | KEY | ON | UNIQUE | BINARY | AMP_ER | APOS_ER | QUOT_ER )
            // xquery/XQueryParser.g:
            root_0 = this.adaptor.nil();

            set542=this.input.LT(1);
            if ( (this.input.LA(1)>=ANCESTOR && this.input.LA(1)<=AT)||(this.input.LA(1)>=BASE_URI && this.input.LA(1)<=COLLATION)||(this.input.LA(1)>=CONSTRUCTION && this.input.LA(1)<=DOCUMENT)||(this.input.LA(1)>=ELSE && this.input.LA(1)<=EMPTY)||(this.input.LA(1)>=ENCODING && this.input.LA(1)<=IDIV)||(this.input.LA(1)>=IMPORT && this.input.LA(1)<=IS)||(this.input.LA(1)>=LAX && this.input.LA(1)<=NO_PRESERVE)||(this.input.LA(1)>=OF && this.input.LA(1)<=PRESERVE)||(this.input.LA(1)>=RETURN && this.input.LA(1)<=SCHEMA)||(this.input.LA(1)>=SELF && this.input.LA(1)<=STRIP)||(this.input.LA(1)>=THEN && this.input.LA(1)<=TREAT)||(this.input.LA(1)>=UNION && this.input.LA(1)<=MINUS_SIGN)||(this.input.LA(1)>=NAN && this.input.LA(1)<=START)||(this.input.LA(1)>=TRY && this.input.LA(1)<=RETURNING)||(this.input.LA(1)>=CHECK && this.input.LA(1)<=QUOT_ER)||this.input.LA(1)==L_NCName||this.input.LA(1)==EXPLICITLY ) {
                this.input.consume();
                if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, this.adaptor.create(set542));
                this.state.errorRecovery=false;this.state.failed=false;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                throw mse;
            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pg_UpdateExpr_return: (function() {
        XQueryParser.pg_UpdateExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.pg_UpdateExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1646:1: pg_UpdateExpr : ( p_InsertExpr | p_DeleteExpr | p_RenameExpr | p_ReplaceExpr | p_TransformExpr );
    // $ANTLR start "pg_UpdateExpr"
    pg_UpdateExpr: function() {
        var retval = new XQueryParser.pg_UpdateExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_InsertExpr543 = null;
         var p_DeleteExpr544 = null;
         var p_RenameExpr545 = null;
         var p_ReplaceExpr546 = null;
         var p_TransformExpr547 = null;


        try {
            // xquery/XQueryParser.g:1647:9: ( p_InsertExpr | p_DeleteExpr | p_RenameExpr | p_ReplaceExpr | p_TransformExpr )
            var alt184=5;
            switch ( this.input.LA(1) ) {
            case INSERT:
                alt184=1;
                break;
            case DELETE:
                alt184=2;
                break;
            case RENAME:
                alt184=3;
                break;
            case REPLACE:
                alt184=4;
                break;
            case COPY:
                alt184=5;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 184, 0, this.input);

                throw nvae;
            }

            switch (alt184) {
                case 1 :
                    // xquery/XQueryParser.g:1647:11: p_InsertExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_InsertExpr_in_pg_UpdateExpr13334);
                    p_InsertExpr543=this.p_InsertExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_InsertExpr543.getTree());


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1648:11: p_DeleteExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_DeleteExpr_in_pg_UpdateExpr13346);
                    p_DeleteExpr544=this.p_DeleteExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_DeleteExpr544.getTree());


                    break;
                case 3 :
                    // xquery/XQueryParser.g:1649:11: p_RenameExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_RenameExpr_in_pg_UpdateExpr13358);
                    p_RenameExpr545=this.p_RenameExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_RenameExpr545.getTree());


                    break;
                case 4 :
                    // xquery/XQueryParser.g:1650:11: p_ReplaceExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ReplaceExpr_in_pg_UpdateExpr13370);
                    p_ReplaceExpr546=this.p_ReplaceExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ReplaceExpr546.getTree());


                    break;
                case 5 :
                    // xquery/XQueryParser.g:1651:11: p_TransformExpr
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_TransformExpr_in_pg_UpdateExpr13382);
                    p_TransformExpr547=this.p_TransformExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TransformExpr547.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_RevalidationDecl_return: (function() {
        XQueryParser.pm_RevalidationDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_RevalidationDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1655:1: pm_RevalidationDecl : k+= DECLARE k+= REVALIDATION (k+= STRICT | k+= LAX | k+= SKIP ) SEMICOLON ;
    // $ANTLR start "pm_RevalidationDecl"
    pm_RevalidationDecl: function() {
        var retval = new XQueryParser.pm_RevalidationDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var SEMICOLON548 = null;
        var k = null;
        var list_k=null;

        var SEMICOLON548_tree=null;
        var k_tree=null;

        try {
            // xquery/XQueryParser.g:1656:9: (k+= DECLARE k+= REVALIDATION (k+= STRICT | k+= LAX | k+= SKIP ) SEMICOLON )
            // xquery/XQueryParser.g:1656:11: k+= DECLARE k+= REVALIDATION (k+= STRICT | k+= LAX | k+= SKIP ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_RevalidationDecl13410); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            k=this.match(this.input,REVALIDATION,XQueryParser.FOLLOW_REVALIDATION_in_pm_RevalidationDecl13414); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            // xquery/XQueryParser.g:1656:38: (k+= STRICT | k+= LAX | k+= SKIP )
            var alt185=3;
            switch ( this.input.LA(1) ) {
            case STRICT:
                alt185=1;
                break;
            case LAX:
                alt185=2;
                break;
            case SKIP:
                alt185=3;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 185, 0, this.input);

                throw nvae;
            }

            switch (alt185) {
                case 1 :
                    // xquery/XQueryParser.g:1656:39: k+= STRICT
                    k=this.match(this.input,STRICT,XQueryParser.FOLLOW_STRICT_in_pm_RevalidationDecl13419); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;
                case 2 :
                    // xquery/XQueryParser.g:1656:51: k+= LAX
                    k=this.match(this.input,LAX,XQueryParser.FOLLOW_LAX_in_pm_RevalidationDecl13425); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;
                case 3 :
                    // xquery/XQueryParser.g:1656:60: k+= SKIP
                    k=this.match(this.input,SKIP,XQueryParser.FOLLOW_SKIP_in_pm_RevalidationDecl13431); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }
            SEMICOLON548=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_RevalidationDecl13436); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON548_tree = this.adaptor.create(SEMICOLON548);
            this.adaptor.addChild(root_0, SEMICOLON548_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_InsertExprTargetChoice_return: (function() {
        XQueryParser.p_InsertExprTargetChoice_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_InsertExprTargetChoice_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1660:1: p_InsertExprTargetChoice : ( ( (k+= AS (k+= FIRST | k+= LAST ) )? k+= INTO ) | ka= AFTER | kb= BEFORE );
    // $ANTLR start "p_InsertExprTargetChoice"
    p_InsertExprTargetChoice: function() {
        var retval = new XQueryParser.p_InsertExprTargetChoice_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var ka = null;
        var kb = null;
        var k = null;
        var list_k=null;

        var ka_tree=null;
        var kb_tree=null;
        var k_tree=null;

        try {
            // xquery/XQueryParser.g:1661:9: ( ( (k+= AS (k+= FIRST | k+= LAST ) )? k+= INTO ) | ka= AFTER | kb= BEFORE )
            var alt188=3;
            switch ( this.input.LA(1) ) {
            case AS:
            case INTO:
                alt188=1;
                break;
            case AFTER:
                alt188=2;
                break;
            case BEFORE:
                alt188=3;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 188, 0, this.input);

                throw nvae;
            }

            switch (alt188) {
                case 1 :
                    // xquery/XQueryParser.g:1661:11: ( (k+= AS (k+= FIRST | k+= LAST ) )? k+= INTO )
                    root_0 = this.adaptor.nil();

                    // xquery/XQueryParser.g:1661:11: ( (k+= AS (k+= FIRST | k+= LAST ) )? k+= INTO )
                    // xquery/XQueryParser.g:1661:12: (k+= AS (k+= FIRST | k+= LAST ) )? k+= INTO
                    // xquery/XQueryParser.g:1661:12: (k+= AS (k+= FIRST | k+= LAST ) )?
                    var alt187=2;
                    var LA187_0 = this.input.LA(1);

                    if ( (LA187_0==AS) ) {
                        alt187=1;
                    }
                    switch (alt187) {
                        case 1 :
                            // xquery/XQueryParser.g:1661:13: k+= AS (k+= FIRST | k+= LAST )
                            k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_p_InsertExprTargetChoice13466); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            k_tree = this.adaptor.create(k);
                            this.adaptor.addChild(root_0, k_tree);
                            }
                            if (org.antlr.lang.isNull(list_k)) list_k = [];
                            list_k.push(k);

                            // xquery/XQueryParser.g:1661:19: (k+= FIRST | k+= LAST )
                            var alt186=2;
                            var LA186_0 = this.input.LA(1);

                            if ( (LA186_0==FIRST) ) {
                                alt186=1;
                            }
                            else if ( (LA186_0==LAST) ) {
                                alt186=2;
                            }
                            else {
                                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                                var nvae =
                                    new org.antlr.runtime.NoViableAltException("", 186, 0, this.input);

                                throw nvae;
                            }
                            switch (alt186) {
                                case 1 :
                                    // xquery/XQueryParser.g:1661:20: k+= FIRST
                                    k=this.match(this.input,FIRST,XQueryParser.FOLLOW_FIRST_in_p_InsertExprTargetChoice13471); if (this.state.failed) return retval;
                                    if ( this.state.backtracking===0 ) {
                                    k_tree = this.adaptor.create(k);
                                    this.adaptor.addChild(root_0, k_tree);
                                    }
                                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                                    list_k.push(k);



                                    break;
                                case 2 :
                                    // xquery/XQueryParser.g:1661:31: k+= LAST
                                    k=this.match(this.input,LAST,XQueryParser.FOLLOW_LAST_in_p_InsertExprTargetChoice13477); if (this.state.failed) return retval;
                                    if ( this.state.backtracking===0 ) {
                                    k_tree = this.adaptor.create(k);
                                    this.adaptor.addChild(root_0, k_tree);
                                    }
                                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                                    list_k.push(k);



                                    break;

                            }



                            break;

                    }

                    k=this.match(this.input,INTO,XQueryParser.FOLLOW_INTO_in_p_InsertExprTargetChoice13484); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);




                    if ( this.state.backtracking===0 ) {
                      this.ak(list_k);
                    }


                    break;
                case 2 :
                    // xquery/XQueryParser.g:1662:11: ka= AFTER
                    root_0 = this.adaptor.nil();

                    ka=this.match(this.input,AFTER,XQueryParser.FOLLOW_AFTER_in_p_InsertExprTargetChoice13501); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    ka_tree = this.adaptor.create(ka);
                    this.adaptor.addChild(root_0, ka_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(ka);
                    }


                    break;
                case 3 :
                    // xquery/XQueryParser.g:1663:11: kb= BEFORE
                    root_0 = this.adaptor.nil();

                    kb=this.match(this.input,BEFORE,XQueryParser.FOLLOW_BEFORE_in_p_InsertExprTargetChoice13517); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    kb_tree = this.adaptor.create(kb);
                    this.adaptor.addChild(root_0, kb_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(kb);
                    }


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_InsertExpr_return: (function() {
        XQueryParser.p_InsertExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_InsertExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1667:1: p_InsertExpr : k+= INSERT (k+= NODE | k+= NODES ) p_SourceExpr p_InsertExprTargetChoice p_TargetExpr ;
    // $ANTLR start "p_InsertExpr"
    p_InsertExpr: function() {
        var retval = new XQueryParser.p_InsertExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var list_k=null;
         var p_SourceExpr549 = null;
         var p_InsertExprTargetChoice550 = null;
         var p_TargetExpr551 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:1668:9: (k+= INSERT (k+= NODE | k+= NODES ) p_SourceExpr p_InsertExprTargetChoice p_TargetExpr )
            // xquery/XQueryParser.g:1668:11: k+= INSERT (k+= NODE | k+= NODES ) p_SourceExpr p_InsertExprTargetChoice p_TargetExpr
            root_0 = this.adaptor.nil();

            k=this.match(this.input,INSERT,XQueryParser.FOLLOW_INSERT_in_p_InsertExpr13547); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            // xquery/XQueryParser.g:1668:21: (k+= NODE | k+= NODES )
            var alt189=2;
            var LA189_0 = this.input.LA(1);

            if ( (LA189_0==NODE) ) {
                alt189=1;
            }
            else if ( (LA189_0==NODES) ) {
                alt189=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 189, 0, this.input);

                throw nvae;
            }
            switch (alt189) {
                case 1 :
                    // xquery/XQueryParser.g:1668:22: k+= NODE
                    k=this.match(this.input,NODE,XQueryParser.FOLLOW_NODE_in_p_InsertExpr13552); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;
                case 2 :
                    // xquery/XQueryParser.g:1668:32: k+= NODES
                    k=this.match(this.input,NODES,XQueryParser.FOLLOW_NODES_in_p_InsertExpr13558); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;

            }

            this.pushFollow(XQueryParser.FOLLOW_p_SourceExpr_in_p_InsertExpr13561);
            p_SourceExpr549=this.p_SourceExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SourceExpr549.getTree());
            this.pushFollow(XQueryParser.FOLLOW_p_InsertExprTargetChoice_in_p_InsertExpr13563);
            p_InsertExprTargetChoice550=this.p_InsertExprTargetChoice();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_InsertExprTargetChoice550.getTree());
            this.pushFollow(XQueryParser.FOLLOW_p_TargetExpr_in_p_InsertExpr13565);
            p_TargetExpr551=this.p_TargetExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TargetExpr551.getTree());
            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_DeleteExpr_return: (function() {
        XQueryParser.p_DeleteExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_DeleteExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1672:1: p_DeleteExpr : k+= DELETE (k+= NODE | k+= NODES ) p_TargetExpr ;
    // $ANTLR start "p_DeleteExpr"
    p_DeleteExpr: function() {
        var retval = new XQueryParser.p_DeleteExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var list_k=null;
         var p_TargetExpr552 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:1673:9: (k+= DELETE (k+= NODE | k+= NODES ) p_TargetExpr )
            // xquery/XQueryParser.g:1673:11: k+= DELETE (k+= NODE | k+= NODES ) p_TargetExpr
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DELETE,XQueryParser.FOLLOW_DELETE_in_p_DeleteExpr13595); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            // xquery/XQueryParser.g:1673:21: (k+= NODE | k+= NODES )
            var alt190=2;
            var LA190_0 = this.input.LA(1);

            if ( (LA190_0==NODE) ) {
                alt190=1;
            }
            else if ( (LA190_0==NODES) ) {
                alt190=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 190, 0, this.input);

                throw nvae;
            }
            switch (alt190) {
                case 1 :
                    // xquery/XQueryParser.g:1673:22: k+= NODE
                    k=this.match(this.input,NODE,XQueryParser.FOLLOW_NODE_in_p_DeleteExpr13600); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;
                case 2 :
                    // xquery/XQueryParser.g:1673:32: k+= NODES
                    k=this.match(this.input,NODES,XQueryParser.FOLLOW_NODES_in_p_DeleteExpr13606); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;

            }

            this.pushFollow(XQueryParser.FOLLOW_p_TargetExpr_in_p_DeleteExpr13609);
            p_TargetExpr552=this.p_TargetExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TargetExpr552.getTree());
            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ReplaceExpr_return: (function() {
        XQueryParser.p_ReplaceExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ReplaceExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1677:1: p_ReplaceExpr : k+= REPLACE (k+= VALUE k+= OF )? k+= NODE p_ExprSingle[true] k+= WITH p_ExprSingle[true] ;
    // $ANTLR start "p_ReplaceExpr"
    p_ReplaceExpr: function() {
        var retval = new XQueryParser.p_ReplaceExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var list_k=null;
         var p_ExprSingle553 = null;
         var p_ExprSingle554 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:1678:9: (k+= REPLACE (k+= VALUE k+= OF )? k+= NODE p_ExprSingle[true] k+= WITH p_ExprSingle[true] )
            // xquery/XQueryParser.g:1678:11: k+= REPLACE (k+= VALUE k+= OF )? k+= NODE p_ExprSingle[true] k+= WITH p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,REPLACE,XQueryParser.FOLLOW_REPLACE_in_p_ReplaceExpr13639); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            // xquery/XQueryParser.g:1678:22: (k+= VALUE k+= OF )?
            var alt191=2;
            var LA191_0 = this.input.LA(1);

            if ( (LA191_0==VALUE) ) {
                alt191=1;
            }
            switch (alt191) {
                case 1 :
                    // xquery/XQueryParser.g:1678:23: k+= VALUE k+= OF
                    k=this.match(this.input,VALUE,XQueryParser.FOLLOW_VALUE_in_p_ReplaceExpr13644); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);

                    k=this.match(this.input,OF,XQueryParser.FOLLOW_OF_in_p_ReplaceExpr13648); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;

            }

            k=this.match(this.input,NODE,XQueryParser.FOLLOW_NODE_in_p_ReplaceExpr13654); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_ReplaceExpr13656);
            p_ExprSingle553=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle553.getTree());
            k=this.match(this.input,WITH,XQueryParser.FOLLOW_WITH_in_p_ReplaceExpr13661); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_ReplaceExpr13663);
            p_ExprSingle554=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle554.getTree());
            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_RenameExpr_return: (function() {
        XQueryParser.p_RenameExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_RenameExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1682:1: p_RenameExpr : k+= RENAME k+= NODE p_TargetExpr k+= AS p_NewNameExpr ;
    // $ANTLR start "p_RenameExpr"
    p_RenameExpr: function() {
        var retval = new XQueryParser.p_RenameExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var list_k=null;
         var p_TargetExpr555 = null;
         var p_NewNameExpr556 = null;

        var k_tree=null;

        try {
            // xquery/XQueryParser.g:1683:9: (k+= RENAME k+= NODE p_TargetExpr k+= AS p_NewNameExpr )
            // xquery/XQueryParser.g:1683:11: k+= RENAME k+= NODE p_TargetExpr k+= AS p_NewNameExpr
            root_0 = this.adaptor.nil();

            k=this.match(this.input,RENAME,XQueryParser.FOLLOW_RENAME_in_p_RenameExpr13694); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            k=this.match(this.input,NODE,XQueryParser.FOLLOW_NODE_in_p_RenameExpr13698); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            this.pushFollow(XQueryParser.FOLLOW_p_TargetExpr_in_p_RenameExpr13700);
            p_TargetExpr555=this.p_TargetExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TargetExpr555.getTree());
            k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_p_RenameExpr13704); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            this.pushFollow(XQueryParser.FOLLOW_p_NewNameExpr_in_p_RenameExpr13706);
            p_NewNameExpr556=this.p_NewNameExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NewNameExpr556.getTree());
            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SourceExpr_return: (function() {
        XQueryParser.p_SourceExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SourceExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1687:1: p_SourceExpr : p_ExprSingle[true] ;
    // $ANTLR start "p_SourceExpr"
    p_SourceExpr: function() {
        var retval = new XQueryParser.p_SourceExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ExprSingle557 = null;


        try {
            // xquery/XQueryParser.g:1688:9: ( p_ExprSingle[true] )
            // xquery/XQueryParser.g:1688:11: p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_SourceExpr13734);
            p_ExprSingle557=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle557.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TargetExpr_return: (function() {
        XQueryParser.p_TargetExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TargetExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1692:1: p_TargetExpr : p_ExprSingle[true] ;
    // $ANTLR start "p_TargetExpr"
    p_TargetExpr: function() {
        var retval = new XQueryParser.p_TargetExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ExprSingle558 = null;


        try {
            // xquery/XQueryParser.g:1693:9: ( p_ExprSingle[true] )
            // xquery/XQueryParser.g:1693:11: p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_TargetExpr13761);
            p_ExprSingle558=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle558.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_NewNameExpr_return: (function() {
        XQueryParser.p_NewNameExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_NewNameExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1697:1: p_NewNameExpr : p_ExprSingle[true] ;
    // $ANTLR start "p_NewNameExpr"
    p_NewNameExpr: function() {
        var retval = new XQueryParser.p_NewNameExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ExprSingle559 = null;


        try {
            // xquery/XQueryParser.g:1698:9: ( p_ExprSingle[true] )
            // xquery/XQueryParser.g:1698:11: p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_NewNameExpr13788);
            p_ExprSingle559=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle559.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TransformExpr_return: (function() {
        XQueryParser.p_TransformExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TransformExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // xquery/XQueryParser.g:1702:1: p_TransformExpr : k+= COPY d= DOLLAR v= p_VarName BIND p_ExprSingle[true] ( COMMA e= DOLLAR w= p_VarName BIND p_ExprSingle[true] )* k+= MODIFY p_ExprSingle[true] k+= RETURN p_ExprSingle[true] ;
    // $ANTLR start "p_TransformExpr"
    p_TransformExpr: function() {
        var retval = new XQueryParser.p_TransformExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var d = null;
        var e = null;
        var BIND560 = null;
        var COMMA562 = null;
        var BIND563 = null;
        var k = null;
        var list_k=null;
         var v = null;
         var w = null;
         var p_ExprSingle561 = null;
         var p_ExprSingle564 = null;
         var p_ExprSingle565 = null;
         var p_ExprSingle566 = null;

        var d_tree=null;
        var e_tree=null;
        var BIND560_tree=null;
        var COMMA562_tree=null;
        var BIND563_tree=null;
        var k_tree=null;

        try {
            // xquery/XQueryParser.g:1703:9: (k+= COPY d= DOLLAR v= p_VarName BIND p_ExprSingle[true] ( COMMA e= DOLLAR w= p_VarName BIND p_ExprSingle[true] )* k+= MODIFY p_ExprSingle[true] k+= RETURN p_ExprSingle[true] )
            // xquery/XQueryParser.g:1703:11: k+= COPY d= DOLLAR v= p_VarName BIND p_ExprSingle[true] ( COMMA e= DOLLAR w= p_VarName BIND p_ExprSingle[true] )* k+= MODIFY p_ExprSingle[true] k+= RETURN p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,COPY,XQueryParser.FOLLOW_COPY_in_p_TransformExpr13817); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_TransformExpr13821); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_TransformExpr13825);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (v?v.stop:null)); 
            }
            BIND560=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_p_TransformExpr13829); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            BIND560_tree = this.adaptor.create(BIND560);
            this.adaptor.addChild(root_0, BIND560_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_TransformExpr13831);
            p_ExprSingle561=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle561.getTree());
            // xquery/XQueryParser.g:1703:90: ( COMMA e= DOLLAR w= p_VarName BIND p_ExprSingle[true] )*
            loop192:
            do {
                var alt192=2;
                var LA192_0 = this.input.LA(1);

                if ( (LA192_0==COMMA) ) {
                    alt192=1;
                }


                switch (alt192) {
                case 1 :
                    // xquery/XQueryParser.g:1703:91: COMMA e= DOLLAR w= p_VarName BIND p_ExprSingle[true]
                    COMMA562=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_TransformExpr13835); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA562_tree = this.adaptor.create(COMMA562);
                    this.adaptor.addChild(root_0, COMMA562_tree);
                    }
                    e=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_TransformExpr13839); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    e_tree = this.adaptor.create(e);
                    this.adaptor.addChild(root_0, e_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_TransformExpr13843);
                    w=this.p_VarName();

                    this.state._fsp--;
                    if (this.state.failed) retur