/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.util.Dictionary;
import org.eclipse.equinox.internal.ds.ConfigurationManager;
import org.eclipse.equinox.internal.ds.SCRManager;
import org.eclipse.equinox.internal.ds.TracerMap;
import org.eclipse.equinox.internal.ds.WorkThread;
import org.eclipse.equinox.internal.util.ref.Log;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    public static BundleContext bc = null;
    private ServiceTracker cmTracker;
    private ServiceRegistration cmTrackerReg;
    private ServiceTracker debugTracker = null;
    private SCRManager scrManager = null;
    private boolean inited = false;
    public static Log log;
    public static boolean DEBUG;
    public static boolean PERF;
    public static boolean DBSTORE;
    public static boolean startup;
    static long[] time;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        time = null;
    }

    public static void timeLog(int id) {
        Activator.time[1] = time[0];
        Activator.time[0] = System.currentTimeMillis();
        log.debug(256, id, String.valueOf(Activator.time[0] - time[1]), null, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSCR() {
        Class<?> clazz;
        Activator activator = this;
        synchronized (activator) {
            if (this.inited) {
                return;
            }
            this.inited = true;
        }
        boolean lazyIniting = false;
        if (startup && time == null) {
            long tmp = System.currentTimeMillis();
            long[] lArray = new long[3];
            lArray[0] = tmp;
            lArray[2] = tmp;
            time = lArray;
            lazyIniting = true;
            if (startup) {
                Activator.timeLog(114);
            }
        }
        WorkThread.IDLE_TIMEOUT = Activator.getInteger("equinox.ds.idle_timeout", 1000);
        WorkThread.BLOCK_TIMEOUT = Activator.getInteger("equinox.ds.block_timeout", 30000);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.cmTracker = new ServiceTracker(bc, clazz2.getName(), null);
        if (startup) {
            Activator.timeLog(102);
        }
        ConfigurationManager.cmTracker = this.cmTracker;
        this.cmTracker.open();
        if (startup) {
            Activator.timeLog(103);
        }
        this.scrManager = new SCRManager(bc, log);
        if (startup) {
            Activator.timeLog(104);
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.cm.ConfigurationListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.cmTrackerReg = bc.registerService(clazz.getName(), (Object)this.scrManager, null);
        if (startup) {
            Activator.timeLog(106);
        }
        bc.addServiceListener((ServiceListener)this.scrManager);
        if (startup) {
            Activator.timeLog(107);
        }
        this.scrManager.startIt();
        if (startup) {
            Activator.timeLog(113);
        }
        if (startup && lazyIniting) {
            log.debug(256, 115, String.valueOf(time[0] - time[2]), null, false);
            time = null;
        }
    }

    public void start(BundleContext bc) throws Exception {
        Class<?> clazz;
        Activator.bc = bc;
        startup = Activator.getBoolean("equinox.measurements.bundles");
        if (startup) {
            long tmp = System.currentTimeMillis();
            long[] lArray = new long[3];
            lArray[0] = tmp;
            lArray[2] = tmp;
            time = lArray;
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.debugTracker = new ServiceTracker(bc, clazz.getName(), null);
        this.debugTracker.open();
        log = new Log(bc, false);
        DEBUG = this.getBooleanDebugOption("org.eclipse.equinox.ds/debug", false) || Activator.getBoolean("equinox.ds.debug");
        PERF = this.getBooleanDebugOption("org.eclipse.equinox.ds/performance", false) || Activator.getBoolean("equinox.ds.perf");
        DBSTORE = this.getBooleanDebugOption("org.eclipse.equinox.ds/cache_descriptions", false) || Activator.getBoolean("equinox.ds.dbstore");
        log.setDebug(DEBUG);
        boolean print = this.getBooleanDebugOption("org.eclipse.equinox.ds/print_on_console", false) || Activator.getBoolean("equinox.ds.print");
        log.setPrintOnConsole(print);
        if (DEBUG) {
            log.setMaps(TracerMap.getMap(), TracerMap.getStarts());
        }
        if (startup) {
            Activator.timeLog(100);
        }
        boolean hasHeaders = false;
        Bundle[] allBundles = bc.getBundles();
        int i = 0;
        while (i < allBundles.length) {
            Dictionary allHeaders = allBundles[i].getHeaders();
            if (allHeaders.get("Service-Component") != null) {
                hasHeaders = true;
                break;
            }
            ++i;
        }
        if (hasHeaders) {
            this.initSCR();
        } else {
            bc.addBundleListener((BundleListener)this);
        }
        if (startup) {
            log.debug(256, 108, String.valueOf(time[0] - time[2]), null, false);
            time = null;
        }
    }

    public void stop(BundleContext bc) throws Exception {
        log.info("Shutting down service component runtime!");
        if (this.scrManager != null) {
            bc.removeServiceListener((ServiceListener)this.scrManager);
        }
        if (this.cmTrackerReg != null) {
            this.cmTrackerReg.unregister();
        }
        if (this.scrManager != null) {
            bc.removeBundleListener((BundleListener)this.scrManager);
        } else {
            bc.removeBundleListener((BundleListener)this);
        }
        if (this.cmTracker != null) {
            ConfigurationManager.cmTracker = null;
            this.cmTracker.close();
            this.cmTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.scrManager != null) {
            this.scrManager.stopIt();
        }
        log.close();
        log = null;
        bc = null;
    }

    public static Filter createFilter(String filter) throws InvalidSyntaxException {
        return bc.createFilter(filter);
    }

    public void bundleChanged(BundleEvent event) {
        Dictionary allHeaders;
        if (event.getType() == 128 && (allHeaders = event.getBundle().getHeaders()).get("Service-Component") != null) {
            bc.removeBundleListener((BundleListener)this);
            this.initSCR();
        }
    }

    public static boolean getBoolean(String property) {
        String prop;
        String string = prop = bc != null ? bc.getProperty(property) : System.getProperty(property);
        return prop != null && prop.equalsIgnoreCase("true");
    }

    public static int getInteger(String property, int defaultValue) {
        String prop;
        String string = prop = bc != null ? bc.getProperty(property) : System.getProperty(property);
        if (prop != null) {
            try {
                return Integer.decode(prop);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        if (this.debugTracker == null) {
            return defaultValue;
        }
        DebugOptions options = (DebugOptions)this.debugTracker.getService();
        if (options != null && (value = options.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }
}

