/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

//------------------
//-  IJobProcessor -
//------------------

/**
 * {@link IJobProcessor}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public interface IJobProcessor {

    /**
     * initialization of a new JobProcessor
     *
     * @param backendDescriptors
     * @return
     */
    boolean init(BackendDescriptor[] backendDescriptors);

    /**
     * Adds a new Job to the processor
     *
     * @param serverJob The server job to be added to the queue
     * @param jobStatusListener The listener associated with the given server job
     * @return The unique id of the added job or 0 in case of failure
     */
    long addJob(IJob serverJob, JobPriority jobPriority, IJobStatusListener jobStatusListener);

    /**
     * Removes the Job with the given id from the queue of Jobs
     *
     * @param jobId
     */
    void removeJob(long jobId);

    /**
     * Adds a listener for global JobStatus change events
     *
     * @param jobStatusListener
     */
    void addJobStatusChangeListener(IJobStatusListener jobStatusListener);

    /**
     * Removes a listener for global JobStatus change events
     *
     * @param jobStatusListener
     */
    void removeJobStatusChangeListener(IJobStatusListener jobStatusListener);

    /**
     * Returns the current status of the Job with the given id
     *
     * @param jobId
     * @return the current status of the Job
     */
    JobStatus getJobStatus(long jobId);

    /**
     * terminates the JobProcessor
     */
    void terminate();

    /**
     * @return true if JobProcessor is going to terminate ASAP
     */
    boolean isTerminated();
}
