/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ant.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import com.openexchange.ant.data.AbstractModule;
import com.openexchange.ant.data.BinDirModule;
import com.openexchange.ant.data.DirModule;
import com.openexchange.ant.data.JarModule;

/**
 * Will prepare the set of bundles for an osgi start
 *
 * @author <a href="mailto:felix.marx@open-xchange.com">Felix Marx</a>
 */
public class PrepareOsgiTestProperties extends Task {

    private Path classpath;
    private String fileSeperator;
    private String bundlesDir;
    private HashSet<String> bundleNames;
    private String property;
    private String frameworkProperty;
    private String frameworkContains;
    private String delimiter;
    public PrepareOsgiTestProperties() {
        super();
    }

    public final void setProperty(String property) {
        this.property = property;
    }

    public final void setFrameworkProperty(String frameworkProperty) {
        this.frameworkProperty = frameworkProperty;
    }

    public final void setFrameworkContains(String frameworkContains) {
        this.frameworkContains = frameworkContains;
    }

    public final void setBundleNames(String bundleNames) {
        if (bundleNames.length() != 0){
             this.bundleNames = new HashSet<String>(Arrays.asList(bundleNames.split(",", 0)));
        }
    }
    
    public final void setBundlesDir(String bundlesDir) {
        this.bundlesDir = bundlesDir;
    }
    
    public Path createClasspath() {
        classpath = new Path(getProject());
        return classpath;
    }

    public final void setDelimiter(String delimiter) {
        if (delimiter.length() != 0) {
            this.delimiter = delimiter;
        }
    }

    public final void setFileSeperator(String fileSeperator) {
        this.fileSeperator = fileSeperator;
    }

    @Override
    public final void execute() throws BuildException {
        if (property == null) {
            throw new BuildException("Please define property.");
        }
        if (delimiter == null) {
            throw new BuildException("Please define delimiter.");
        }
        if (classpath == null) {
            throw new BuildException("Please define classpath.");
        }
        if (bundlesDir == null) {
            throw new BuildException("Please define bundlesDir.");
        }
        if (fileSeperator == null) {
            throw new BuildException("Please define fileSeperator.");
        }

        // Parse ClassPath-Jars
        log("using classpath: " + classpath, Project.MSG_INFO);
        final String[] classpathFiles = classpath.list();
        final List<AbstractModule> classpathModules = new ArrayList<AbstractModule>(classpathFiles.length);
        for (final String classpathFilename : classpathFiles) {
            final File classpathFile = new File(classpathFilename);
            if (classpathFile.isFile()) {
                classpathModules.add(new JarModule(classpathFile));
            } else {
                DirModule classpathModule = new BinDirModule(classpathFile);
                classpathModule.readLocalFiles(getProject());
                classpathModules.add(classpathModule);
            }
        }
        
        // Build structures to help bundles resolving their dependencies.
        final Map<String, AbstractModule> modulesByName = new HashMap<String, AbstractModule>();
        for (final AbstractModule module : classpathModules) {
            modulesByName.put(module.getName(), module);

        }
        
        if (modulesByName.containsKey(frameworkContains)){
            StringBuilder sb = new StringBuilder();
            sb.append(bundlesDir);
            if (sb.lastIndexOf(fileSeperator) != sb.length()) {
                sb.append(fileSeperator);
            }
            sb.append(modulesByName.get(frameworkContains).getFileOrDirName());
            getProject().setInheritedProperty(frameworkProperty, sb.toString());
        } else {
            throw new BuildException("No Framework with name " + frameworkContains + " found");
        }
        
        StringBuilder sb = new StringBuilder();
        
        //Remove framework from bundleNames just in case it is located there
        bundleNames.remove(frameworkContains);
        
        for (String s : bundleNames){
            if (modulesByName.containsKey(s)){
                if (sb.length() != 0) {
                    sb.append(delimiter);
                }
                AbstractModule aM = modulesByName.get(s);
                
                if (aM.isFragment()){
                    sb.append(aM.getFileOrDirName());
                } else {
                    sb.append(aM.getFileOrDirName()).append("@start");
                }
            } else {
                log("no classpath module for " + s, Project.MSG_ERR);
            }
        }
        
        getProject().log(property+": "+ sb.toString(), getProject().MSG_DEBUG);
        getProject().setInheritedProperty(property, sb.toString());
    }
}
