/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator.wsdl11;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.tools.common.VelocityGenerator;
import org.apache.cxf.tools.java2wsdl.generator.AbstractGenerator;
import org.apache.cxf.tools.util.FileWriterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTypeCustomGenerator
extends AbstractGenerator<File> {
    private static final String TEMPLATE_BASE = "org/apache/cxf/tools/java2wsdl/generator/wsdl11/";
    private static final String TEMPLATE_EXT = "org/apache/cxf/tools/java2wsdl/generator/wsdl11/date_type_cust.vm";
    private static final String TEMPLATE_EMB = "org/apache/cxf/tools/java2wsdl/generator/wsdl11/date_type_cust_embed.vm";
    private static final String DATE_ADAPTER = "org.apache.cxf.xjc.runtime.DataTypeAdapter";
    private static final String CALENDAR_ADAPTER = "javax.xml.bind.DatatypeConverter";
    private String wsdlName;
    private List<String> schemaFiles = new ArrayList<String>();

    public void addSchemaFiles(Collection<String> s) {
        this.schemaFiles.addAll(s);
    }

    public void setWSDLName(String ws) {
        this.wsdlName = ws;
    }

    private String getTemplate() {
        if (this.allowImports()) {
            return TEMPLATE_EXT;
        }
        return TEMPLATE_EMB;
    }

    public List<String> getSchemaNamespaces() {
        ArrayList<String> ns = new ArrayList<String>();
        for (SchemaInfo schema : this.getServiceModel().getSchemas()) {
            ns.add(schema.getNamespaceURI());
        }
        return ns;
    }

    @Override
    public File generate(File outputdir) {
        Class<?> dateType = this.getDateType();
        File xjb = this.getJAXBCustFile(outputdir);
        if (dateType != null) {
            VelocityGenerator generator = new VelocityGenerator(false);
            generator.setCommonAttributes();
            generator.setAttributes("parseMethod", this.getAdapterMethod(dateType, ".parseDateTime"));
            generator.setAttributes("printMethod", this.getAdapterMethod(dateType, ".printDateTime"));
            generator.setAttributes("datetype", dateType.getName());
            if (this.allowImports()) {
                if (this.schemaFiles.size() == 0) {
                    return null;
                }
                generator.setAttributes("schemaFiles", this.schemaFiles);
            } else {
                generator.setAttributes("wsdlName", this.wsdlName);
                List<String> ns = this.getSchemaNamespaces();
                if (ns.size() == 0) {
                    return null;
                }
                generator.setAttributes("targetNamespaces", ns);
            }
            try {
                generator.doWrite(this.getTemplate(), FileWriterUtil.getWriter(xjb));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            generator.clearAttributes();
        }
        return xjb;
    }

    protected File getJAXBCustFile(File outputdir) {
        return new File(outputdir, this.wsdlName + ".xjb");
    }

    protected String getAdapterMethod(Class<?> clz, String methodName) {
        if (clz == Date.class) {
            return DATE_ADAPTER + methodName;
        }
        return CALENDAR_ADAPTER + methodName;
    }

    protected Class<?> getDateType() {
        if (this.getServiceModel() == null) {
            return null;
        }
        for (OperationInfo op : this.getServiceModel().getInterface().getOperations()) {
            Method m = (Method)op.getProperty("operation.method");
            for (Class<?> clz : m.getParameterTypes()) {
                if (clz != Date.class && clz != Calendar.class) continue;
                return clz;
            }
            if (m.getReturnType() != Date.class && m.getReturnType() != Calendar.class) continue;
            return m.getReturnType();
        }
        return null;
    }
}

