/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples.geo;

import java.util.Iterator;
import twitter4j.GeoLocation;
import twitter4j.GeoQuery;
import twitter4j.Place;
import twitter4j.ResponseList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;

public final class SearchPlaces {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java twitter4j.examples.geo.SearchPlaces [ip address] or [latitude] [longitude]");
            System.exit(-1);
        }
        try {
            Twitter twitter = new TwitterFactory().getInstance();
            GeoQuery query = args.length == 2 ? new GeoQuery(new GeoLocation(Double.parseDouble(args[0]), Double.parseDouble(args[1]))) : new GeoQuery(args[0]);
            ResponseList places = twitter.searchPlaces(query);
            if (places.size() == 0) {
                System.out.println("No location associated with the specified IP address or lat/lang");
            } else {
                Iterator i$ = places.iterator();
                while (i$.hasNext()) {
                    Place place = (Place)i$.next();
                    System.out.println("id: " + place.getId() + " name: " + place.getFullName());
                    Place[] containedWithinArray = place.getContainedWithIn();
                    if (null == containedWithinArray || containedWithinArray.length == 0) continue;
                    System.out.println("  contained within:");
                    Place[] arr$ = containedWithinArray;
                    int len$ = arr$.length;
                    for (int i$2 = 0; i$2 < len$; ++i$2) {
                        Place containedWithinPlace = arr$[i$2];
                        System.out.println("  id: " + containedWithinPlace.getId() + " name: " + containedWithinPlace.getFullName());
                    }
                }
            }
            System.exit(0);
        }
        catch (TwitterException te) {
            te.printStackTrace();
            System.out.println("Failed to retrieve places: " + te.getMessage());
            System.exit(-1);
        }
    }
}

