/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.catalina.websocket.WsOutbound;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.websocket.WebSocket;

public class TomcatWebSocket
extends WebSocket {
    private final WsOutbound outbound;

    public TomcatWebSocket(WsOutbound outbound, AtmosphereConfig config) {
        super(config);
        this.outbound = outbound;
    }

    public String toString() {
        return this.outbound.toString();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void write(String s) throws IOException {
        this.outbound.writeTextMessage(CharBuffer.wrap(s));
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.outbound.writeBinaryMessage(ByteBuffer.wrap(b, offset, length));
    }

    @Override
    public void close() {
        try {
            this.outbound.close(1005, ByteBuffer.wrap(new byte[0]));
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
        }
    }
}

