/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackMessageSizeInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TrackMessageSizeInterceptor.class);
    private static final byte[] END = "|".getBytes();
    private static final String IN_ENCODING = "UTF-8";
    private static final String OUT_ENCODING = "UTF-8";
    private byte[] end = END;
    private String endString = "|";
    private final Charset inCharset = Charset.forName("UTF-8");
    private final Charset outCharset = Charset.forName("UTF-8");
    private final Interceptor interceptor = new Interceptor();

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.MESSAGE_DELIMITER);
        if (s != null) {
            this.end = s.getBytes();
            this.endString = s;
        }
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        super.inspect(r);
        AsyncIOWriter writer = response.getAsyncIOWriter();
        if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
            ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(this.interceptor);
        } else {
            logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return " Track Message Size Interceptor using " + this.endString;
    }

    private final class Interceptor
    extends AsyncIOInterceptorAdapter {
        private Interceptor() {
        }

        @Override
        public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
            response.setCharacterEncoding("UTF-8");
            CharBuffer cb = TrackMessageSizeInterceptor.this.inCharset.newDecoder().decode(ByteBuffer.wrap(responseDraft, 0, responseDraft.length));
            int size = cb.length();
            CharBuffer cb2 = CharBuffer.wrap(Integer.toString(size) + TrackMessageSizeInterceptor.this.endString);
            ByteBuffer bb = ByteBuffer.allocate((cb2.length() + size) * 2);
            CharsetEncoder encoder = TrackMessageSizeInterceptor.this.outCharset.newEncoder();
            encoder.encode(cb2, bb, false);
            encoder.encode(cb, bb, false);
            bb.flip();
            byte[] b = new byte[bb.limit()];
            bb.get(b);
            return b;
        }
    }
}

