/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.params;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.HttpParams;

public class BasicHttpParams
extends AbstractHttpParams
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7086398485908701455L;
    private final HashMap parameters = new HashMap();

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public HttpParams setParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public boolean removeParameter(String name) {
        if (this.parameters.containsKey(name)) {
            this.parameters.remove(name);
            return true;
        }
        return false;
    }

    public void setParameters(String[] names, Object value) {
        for (int i = 0; i < names.length; ++i) {
            this.setParameter(names[i], value);
        }
    }

    public boolean isParameterSet(String name) {
        return this.getParameter(name) != null;
    }

    public boolean isParameterSetLocally(String name) {
        return this.parameters.get(name) != null;
    }

    public void clear() {
        this.parameters.clear();
    }

    public HttpParams copy() {
        try {
            return (HttpParams)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new UnsupportedOperationException("Cloning not supported");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BasicHttpParams clone = (BasicHttpParams)super.clone();
        this.copyParams(clone);
        return clone;
    }

    protected void copyParams(HttpParams target) {
        Iterator iter = this.parameters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            if (!(me.getKey() instanceof String)) continue;
            target.setParameter((String)me.getKey(), me.getValue());
        }
    }
}

