/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.session.dataobject;

import java.util.*;

import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.datatypes.DataType;
import com.openexchange.usm.api.session.DataObject;

public class DataObjectUtil {
	public static DataObject findDataObject(String objectID, DataObject... objects) {
		if (objectID != null && objects != null) {
			for (DataObject o : objects) {
				if (objectID.equals(o.getID()))
					return o;
			}
		}
		return null;
	}

	public static void modify(DataObject object, DataObject modification) {
		ContentType type = object.getContentType();
		int len = type.getFields().length;
		// The following 3 calls may not all be necessary, depending on implementation (some or all of the information may actually be stored in fields), but a duplicate copy doesn't hurt
		object.setID(modification.getID());
		object.setParentFolderID(modification.getParentFolderID());
		object.setTimestamp(modification.getTimestamp());
		for (int i = 0; i < len; i++)
			object.setFieldContent(i, modification.getFieldContent(i));
	}

	public static DataObject copyAndModify(DataObject source, DataObject modification, boolean linkUUIDs) {
		if (!source.getContentType().getID().equals(modification.getContentType().getID()))
			throw new IllegalArgumentException("ContentType mismatch");
		DataObject result = source.createCopy(linkUUIDs);
		result.commitChanges();
		modify(result, modification);
		return result;
	}

	public static DataObject copyModifications(DataObject object, DataObject modification) {
		if (!object.getContentType().getID().equals(modification.getContentType().getID()))
			throw new IllegalArgumentException("ContentType mismatch");
		// The following 3 calls may not all be necessary, depending on implementation (some or all of the information may actually be stored in fields), but a duplicate copy doesn't hurt
		object.setID(modification.getID());
		object.setParentFolderID(modification.getParentFolderID());
		return copyModifiedFields(object, modification);
	}

	public static DataObject copyModifiedFields(DataObject object, DataObject modification) {
		object.setTimestamp(modification.getTimestamp());
		int len = object.getContentType().getFields().length;
		for (int i = 0; i < len; i++) {
			if (modification.isFieldModified(i))
				object.setFieldContent(i, modification.getFieldContent(i));
		}
		return object;
	}

	public static boolean isFieldEqual(DataObject o1, DataObject o2, String field) {
		if (!o1.getContentType().getID().equals(o2.getContentType().getID()))
			throw new IllegalArgumentException("ContentType mismatch");
		int index = o1.getFieldIndex(field);
		DataType<?> dataType = o1.getContentType().getFields()[index].getFieldType();
		return dataType.isEqual(o1.getFieldContent(index), o2.getFieldContent(index));
	}

	public static boolean isEqual(Object v1, Object v2) {
		return (v1 == null) ? v2 == null : v1.equals(v2);
	}

	public static List<DataObject> toList(DataObject[] array) {
		List<DataObject> result = new ArrayList<DataObject>(array.length);
		for (DataObject o : array)
			result.add(o);
		return result;
	}

	public static DataObject[] toArray(Collection<DataObject> collection) {
		return collection.toArray(new DataObject[collection.size()]);
	}
}
