/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.datatypes;

import java.io.Serializable;

import org.json.JSONException;

/**
 * Abstract base class for common DataTypes.
 * 
 * @author afe
 *
 * @param <T> Java type of object that is stored by the DataType
 */
public abstract class AbstractDataType<T extends Serializable> implements DataType<T> {

	protected void generateTypeError(Object o) {
		throw new IllegalArgumentException(o.getClass().getName() + " is no " + getName());
	}

	public T createNewObject() {
		return null;
	}

	/**
	 * Must be overwritten for all DataTypes that do not use immutable Objects
	 */
	public T createCopy(Object source) {
		return checkValue(source);
	}

	public boolean isEqual(Object object, Object object2) {
		return (object == null) ? object2 == null : object.equals(object2);
	}

	public boolean isDefaultValue(Object object) {
		return object == null;
	}

	protected Number convertToNumber(Object o) throws JSONException {
		if (o instanceof Number)
			return (Number) o;
		try {
			return Double.valueOf(o.toString());
		} catch (NumberFormatException e) {
			throw new JSONException("Element is not a Number");
		}
	}
}
