/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.perf;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class AntPerformanceListener
implements BuildListener {
    private HashMap targetStats = new HashMap();
    private HashMap taskStats = new HashMap();
    private StopWatch master = null;
    private long start_time = 0L;

    public void buildStarted(BuildEvent buildEvent) {
        this.master = new StopWatch();
        this.start_time = this.master.start();
    }

    public void buildFinished(BuildEvent buildEvent) {
        Object object;
        Comparable<StringBuffer> comparable;
        Target target;
        Object object2;
        String string;
        Object object3;
        Object object4;
        long l = this.master.stop();
        TreeMap treeMap = new TreeMap(new StopWatchComparator());
        Iterator iterator = this.targetStats.keySet().iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            object3 = this.targetStats.get(object4);
            treeMap.put(object3, object4);
        }
        object4 = new TreeMap(new StopWatchComparator());
        iterator = this.taskStats.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            string = this.taskStats.get(object3);
            ((TreeMap)object4).put((String)string, (Object)object3);
        }
        object3 = new StringBuffer();
        string = System.getProperty("line.separator");
        ((StringBuffer)object3).append(string).append("Statistics:").append(string);
        ((StringBuffer)object3).append("-------------- Target Results ---------------------").append(string);
        iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (StopWatch)iterator.next();
            target = (Target)treeMap.get(object2);
            comparable = new StringBuffer();
            if (target.getProject().getName() != null) {
                ((StringBuffer)comparable).append(target.getProject().getName()).append(".");
            }
            object = this.format(((StopWatch)object2).total());
            ((StringBuffer)comparable).append(target.getName()).append(": ").append((String)object);
            ((StringBuffer)object3).append(((StringBuffer)comparable).toString()).append(string);
        }
        ((StringBuffer)object3).append(string);
        ((StringBuffer)object3).append("-------------- Task Results -----------------------").append(string);
        iterator = ((TreeMap)object4).keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (StopWatch)iterator.next();
            target = (Task)((TreeMap)object4).get(object2);
            comparable = new StringBuffer();
            object = target.getOwningTarget();
            if (object.getProject().getName() != null) {
                ((StringBuffer)comparable).append(object.getProject().getName()).append(".");
            }
            ((StringBuffer)comparable).append(object.getName()).append(".");
            ((StringBuffer)comparable).append(target.getTaskName()).append(": ").append(this.format(((StopWatch)object2).total()));
            ((StringBuffer)object3).append(((StringBuffer)comparable).toString()).append(string);
        }
        ((StringBuffer)object3).append(string);
        ((StringBuffer)object3).append("-------------- Totals -----------------------------").append(string);
        object2 = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss.SSS");
        ((StringBuffer)object3).append("Start time: " + ((DateFormat)object2).format(new Date(this.start_time))).append(string);
        ((StringBuffer)object3).append("Stop time: " + ((DateFormat)object2).format(new Date(l))).append(string);
        ((StringBuffer)object3).append("Total time: " + this.format(this.master.total())).append(string);
        System.out.println(((StringBuffer)object3).toString());
        target = buildEvent.getProject();
        comparable = null;
        if (target != null && (object = target.getProperty("performance.log")) != null) {
            comparable = new File((String)object);
        }
        if (comparable != null) {
            try {
                object = new FileWriter((File)comparable);
                ((Writer)object).write(((StringBuffer)object3).toString());
                ((OutputStreamWriter)object).flush();
                ((OutputStreamWriter)object).close();
                System.out.println("Wrote stats to: " + ((File)comparable).getAbsolutePath() + string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.targetStats = new HashMap();
        this.taskStats = new HashMap();
    }

    private String format(long l) {
        String string = String.valueOf(l);
        String string2 = "000";
        int n = 3 - string.length();
        string = n >= 0 ? "0." + string2.substring(0, n) + string : string.substring(0, string.length() - 3) + "." + string.substring(string.length() - 3);
        return string + " sec";
    }

    public void targetStarted(BuildEvent buildEvent) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.targetStats.put(buildEvent.getTarget(), stopWatch);
    }

    public void targetFinished(BuildEvent buildEvent) {
        StopWatch stopWatch = (StopWatch)this.targetStats.get(buildEvent.getTarget());
        stopWatch.stop();
    }

    public void taskStarted(BuildEvent buildEvent) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.taskStats.put(buildEvent.getTask(), stopWatch);
    }

    public void taskFinished(BuildEvent buildEvent) {
        StopWatch stopWatch = (StopWatch)this.taskStats.get(buildEvent.getTask());
        stopWatch.stop();
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    public static void main(String[] stringArray) {
        AntPerformanceListener antPerformanceListener = new AntPerformanceListener();
        System.out.println(antPerformanceListener.format(1L));
        System.out.println(antPerformanceListener.format(10L));
        System.out.println(antPerformanceListener.format(100L));
        System.out.println(antPerformanceListener.format(1000L));
        System.out.println(antPerformanceListener.format(100000L));
        System.out.println(antPerformanceListener.format(1000000L));
        System.out.println(antPerformanceListener.format(10000000L));
        System.out.println(antPerformanceListener.format(100000000L));
        System.out.println(antPerformanceListener.format(1000000000L));
    }

    public class StopWatch {
        private long _start_time = 0L;
        private long _stop_time = 0L;
        private long _total_time = 0L;

        public StopWatch() {
            this.start();
        }

        public long start() {
            this._start_time = System.currentTimeMillis();
            return this._start_time;
        }

        public long stop() {
            long l = System.currentTimeMillis();
            this._total_time += l - this._start_time;
            this._start_time = 0L;
            this._stop_time = 0L;
            return l;
        }

        public long total() {
            return this._total_time;
        }

        public long elapsed() {
            return System.currentTimeMillis() - this._start_time;
        }
    }

    public class StopWatchComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            StopWatch stopWatch = (StopWatch)object;
            StopWatch stopWatch2 = (StopWatch)object2;
            if (stopWatch.total() < stopWatch2.total()) {
                return -1;
            }
            if (stopWatch.total() == stopWatch2.total()) {
                return 0;
            }
            return 1;
        }
    }
}

