/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalDestination;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.http.AddressType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public class LocalTransportFactory
extends AbstractTransportFactory
implements DestinationFactory,
ConduitInitiator {
    public static final String TRANSPORT_ID = "http://cxf.apache.org/transports/local";
    public static final List<String> DEFAULT_NAMESPACES = Arrays.asList("http://cxf.apache.org/transports/local");
    public static final String MESSAGE_FILTER_PROPERTIES = LocalTransportFactory.class.getName() + ".filterProperties";
    public static final String MESSAGE_INCLUDE_PROPERTIES = LocalTransportFactory.class.getName() + ".includeProperties";
    private static final Logger LOG = LogUtils.getL7dLogger(LocalTransportFactory.class);
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    private static final String NULL_ADDRESS = LocalTransportFactory.class.getName() + ".nulladdress";
    private ConcurrentMap<String, Destination> destinations = new ConcurrentHashMap<String, Destination>();
    private Set<String> messageFilterProperties;
    private Set<String> messageIncludeProperties;
    private Set<String> uriPrefixes = new HashSet<String>(URI_PREFIXES);
    private volatile Executor executor;

    public LocalTransportFactory() {
        this((Bus)null);
    }

    public LocalTransportFactory(Bus b) {
        super(DEFAULT_NAMESPACES, b);
        this.messageFilterProperties = new HashSet<String>();
        this.messageIncludeProperties = new HashSet<String>();
        this.messageFilterProperties.add("org.apache.cxf.client");
        this.messageIncludeProperties.add(Message.PROTOCOL_HEADERS);
        this.messageIncludeProperties.add(Message.ENCODING);
        this.messageIncludeProperties.add("Content-Type");
        this.messageIncludeProperties.add("Accept");
        this.messageIncludeProperties.add(Message.RESPONSE_CODE);
    }

    @Override
    @Resource(name="cxf")
    public void setBus(Bus b) {
        super.setBus(b);
    }

    @Override
    public Destination getDestination(EndpointInfo ei) throws IOException {
        return this.getDestination(ei, this.createReference(ei));
    }

    protected Destination getDestination(EndpointInfo ei, EndpointReferenceType reference) throws IOException {
        AddressType tp;
        Destination d = null;
        String addr = reference.getAddress().getValue();
        if (addr == null && (tp = ei.getExtensor(AddressType.class)) != null) {
            addr = tp.getLocation();
        }
        if (addr == null) {
            addr = NULL_ADDRESS;
        }
        if ((d = (Destination)this.destinations.get(addr)) == null) {
            d = this.createDestination(ei, reference);
            this.destinations.put(addr, d);
        }
        return d;
    }

    private Destination createDestination(EndpointInfo ei, EndpointReferenceType reference) {
        LOG.info("Creating destination for address " + reference.getAddress().getValue());
        return new LocalDestination(this, reference, ei);
    }

    void remove(LocalDestination destination) {
        for (Map.Entry e : this.destinations.entrySet()) {
            if (e.getValue() != destination) continue;
            this.destinations.remove(e.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getExecutor() {
        if (this.executor == null && this.bus != null) {
            LocalTransportFactory localTransportFactory = this;
            synchronized (localTransportFactory) {
                WorkQueueManager manager;
                if (this.executor == null && (manager = this.bus.getExtension(WorkQueueManager.class)) != null) {
                    this.executor = manager.getNamedWorkQueue("local-transport");
                    if (this.executor == null) {
                        this.executor = manager.getAutomaticWorkQueue();
                    }
                }
            }
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Conduit getConduit(EndpointInfo ei) throws IOException {
        return new LocalConduit(this, (LocalDestination)this.getDestination(ei));
    }

    @Override
    public Conduit getConduit(EndpointInfo ei, EndpointReferenceType target) throws IOException {
        return new LocalConduit(this, (LocalDestination)this.getDestination(ei, target));
    }

    EndpointReferenceType createReference(EndpointInfo ei) {
        EndpointReferenceType epr = new EndpointReferenceType();
        AttributedURIType address = new AttributedURIType();
        address.setValue(ei.getAddress());
        epr.setAddress(address);
        return epr;
    }

    @Override
    public Set<String> getUriPrefixes() {
        return this.uriPrefixes;
    }

    public void setUriPrefixes(Set<String> s) {
        this.uriPrefixes = s;
    }

    public Set<String> getMessageFilterProperties() {
        return this.messageFilterProperties;
    }

    public void setMessageFilterProperties(Set<String> props) {
        this.messageFilterProperties = props;
    }

    public Set<String> getIncludeMessageProperties() {
        return this.messageIncludeProperties;
    }

    public void setMessageIncludeProperties(Set<String> props) {
        this.messageIncludeProperties = props;
    }

    public void copy(Message message, Message copy) {
        Set<Object> includes;
        Set<Object> filter = CastUtils.cast((Set)message.get(MESSAGE_FILTER_PROPERTIES));
        if (filter == null) {
            filter = this.messageFilterProperties;
        }
        if ((includes = CastUtils.cast((Set)message.get(MESSAGE_INCLUDE_PROPERTIES))) == null) {
            includes = this.messageIncludeProperties;
        }
        for (Map.Entry e : message.entrySet()) {
            if (!includes.contains(e.getKey()) && !this.messageIncludeProperties.contains(e.getKey()) || filter.contains(e.getKey())) continue;
            copy.put(e.getKey(), e.getValue());
        }
    }

    static {
        URI_PREFIXES.add("local://");
    }
}

