/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.activator.impl;


import com.openexchange.groupware.update.DefaultUpdateTaskProviderService;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.util.activator.ServiceDependencyResolver;


/**
 * {@link UpdateTaskServiceWithDependencies}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v1.0.2
 */
public final class UpdateTaskServiceWithDependencies<U extends UpdateTaskV2>
extends ServiceWithDependenciesTemplate<UpdateTaskProviderService, DefaultUpdateTaskProviderService> {
    
    public static final <X extends UpdateTaskV2> ServiceWithDependencies<DefaultUpdateTaskProviderService> find(final Class<X> updateTaskClass) {
        return new UpdateTaskServiceWithDependencies<X>(updateTaskClass, ConstructorServiceWithDependencies.find(updateTaskClass, UpdateTaskV2.class));
    }
    
    private ServiceWithDependencies<U> swd;
    
    public UpdateTaskServiceWithDependencies(final Class<U> updateTaskClass,
        final ServiceWithDependencies<U> swd) {
        super(
            DefaultUpdateTaskProviderService.class,
            UpdateTaskProviderService.class,
            swd.mandatoryServiceDependencies(),
            swd.optionalServiceDependencies(),
            swd.serviceSetClasses(),
            swd.serviceListingClasses()
        );
        this.swd = swd;
    }
    
    @Override
    public DefaultUpdateTaskProviderService createInstance(final ServiceDependencyResolver resolver) {
        final U task = swd.createInstance(resolver);
        final DefaultUpdateTaskProviderService service = new DefaultUpdateTaskProviderService(task);
        return service;
    }

}
