/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.activator.impl;

import java.lang.annotation.Annotation;
import java.util.Set;


import org.osgi.framework.ServiceReference;
import com.openexchange.annotation.Nullable;


/**
 * {@link ServiceDependency}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v1.0.1
 */
public interface ServiceDependency<S> {
    
    String identify();
    
    String asFilter();
    
    Set<String> propertiesOfInterest();
    
    /**
     * @return whether the dependency is necessary or optional
     * @since v1.3.5
     */
    DependencyNecessity necessity();
    
    boolean matchesService(final Object serviceInstance, final ServiceReference<?> reference);
    
    boolean matchesDependency(final Class<?> serviceClass, final @Nullable Annotation[] annotations);
    
}
