/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.activator.impl;



import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import com.openexchange.annotation.Nullable;
import com.openexchange.dispatcher.DispatcherPrefixService;


/**
 * {@link DispatcherPrefixServiceRegisterer}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v7.8.2
 */
public abstract class DispatcherPrefixServiceTrackerCustomizer implements ServiceTrackerCustomizer<DispatcherPrefixService, DispatcherPrefixService> {
    
    private final BundleContext bundleContext;
    
    public DispatcherPrefixServiceTrackerCustomizer(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
    
    @Override
    public @Nullable DispatcherPrefixService addingService(final @Nullable ServiceReference<DispatcherPrefixService> reference) {
        final DispatcherPrefixService service = bundleContext.getService(reference);
        if (service != null) {
            try {
                onDispatcherPrefixServiceAvailable(service);
                return service;
            } catch (final Exception e) {
                bundleContext.ungetService(reference);
                return null;
            }
        } else {
            return null;
        }
    }
    @Override
    public void modifiedService(@Nullable ServiceReference<DispatcherPrefixService> reference, @Nullable DispatcherPrefixService service) {
    }
    @Override
    public void removedService(@Nullable ServiceReference<DispatcherPrefixService> reference, @Nullable DispatcherPrefixService service) {
        if (reference != null) {
            bundleContext.ungetService(reference);
        }
    }
    protected abstract void onDispatcherPrefixServiceAvailable(final DispatcherPrefixService dispatcherPrefixService) throws Exception;
}
