/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.activator.impl;

import static com.openexchange.util.custom.base.NullUtil.logger;
import java.io.Closeable;
import java.util.Deque;
import java.util.concurrent.LinkedBlockingDeque;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;


/**
 * {@link ActivatorRegistryImpl}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v7.8.2
 */
public final class ActivatorRegistryImpl implements Closeable, ActivatorRegistry {

    private static final Logger LOG = logger(ActivatorRegistryImpl.class);
    
    public final Deque<Registration> registrations;
    public final Deque<ServiceTracker<?, ?>> trackers;
    
    public ActivatorRegistryImpl() {
        this.registrations = new LinkedBlockingDeque<Registration>();
        this.trackers = new LinkedBlockingDeque<ServiceTracker<?, ?>>();
    }

    @Override
    public void close() {
        RegistrationTools.closeAll(registrations, LOG);
        RegistrationTools.closeAllReflectively(trackers, LOG);        
    }

    @Override
    public void add(Registration registration) {
        this.registrations.addLast(registration);
    }

    @Override
    public void add(ServiceTracker<?, ?> serviceTracker) {
        this.trackers.addLast(serviceTracker);
    }
    
}
