/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
/*
 * Copyright (C) 2007 MicroDoc GmbH, Munich, Germany
 */

package com.openexchange.usm.util;

import java.util.BitSet;

public class BitSetEncoder {
	private static final byte[] BITS = { 1, 2, 4, 8, 16, 32, 64, -128 };

	public static byte[] toByteArray(BitSet s) {
		int length = s.length();
		byte[] bytes = new byte[(length + 7) >> 3];
		for (int i = 0; i < length; i++) {
			if (s.get(i))
				bytes[i >> 3] |= BITS[i % 8];
		}
		return bytes;
	}

	public static BitSet fromByteArray(byte[] bytes) {
		BitSet set = new BitSet(bytes.length << 3);
		for (int i = 0; i < bytes.length; i++) {
			for (int j = 0; j < BITS.length; j++)
				if ((bytes[i] & BITS[j]) != 0)
					set.set((i << 3) + j);
		}
		return set;
	}

	public static String toBase64(BitSet s) {
		return Toolkit.encodeBase64(toByteArray(s));
	}

	public static BitSet fromBase64(String s) {
		return fromByteArray(Toolkit.decodeBase64(s));
	}
}
