/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.session.tasks;

import org.apache.commons.logging.Log;
import com.openexchange.usm.session.impl.SessionImpl;
import com.openexchange.usm.session.impl.SessionManagerImpl;

/**
 * {@link CustomPropertyCleanupTask}
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public class CustomPropertyCleanupTask implements Runnable {

    /**
     * Initial delay after startup of SessionManager/TimerService after which the cleanup task is first performed
     */
    public static final long INITIAL_DELAY = 60L * 1000L; // 1 minute

    /**
     * Interval between executions of the cleanup task
     */
    public static final long EXECUTION_INTERVAL = 60L * 1000L; // 1 minute

    private final SessionManagerImpl _sessionManager;

    public CustomPropertyCleanupTask(SessionManagerImpl sessionManager) {
        _sessionManager = sessionManager;
    }

    @Override
    public void run() {
        Log log = _sessionManager.getJournal();
        log.debug("Removing out-dated custom properties of USM sessions");
        long now = System.currentTimeMillis();
        int count = 0;
        for (SessionImpl session : _sessionManager.getSessionStorage().getSessionList()) {
            count += session.removeOutdatedCustomProperties(now);
        }
        log.debug(count + " out-dated custom properties of USM sessions removed");
    }
}
