/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.mapping.storage.sql.osgi;

import com.openexchange.usm.api.database.DatabaseAccess;
import com.openexchange.usm.api.mapping.storage.ContextUUIDMappingStorage;
import com.openexchange.usm.api.mapping.storage.FolderIDMappingStorage;
import com.openexchange.usm.mapping.storage.sql.impl.ContextUUIDMappingSQL;
import com.openexchange.usm.mapping.storage.sql.impl.FolderIDMappingSQL;
import com.openexchange.usm.util.AbstractUSMActivator;

/**
 * {@link MappingStorageActivator}
 * 
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class MappingStorageActivator extends AbstractUSMActivator {

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { DatabaseAccess.class };
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#register(org.osgi.framework.BundleContext)
     */
    @Override
    protected void register() {
        DatabaseAccess dbAccess = (DatabaseAccess) getService(DatabaseAccess.class);

        registerService(FolderIDMappingStorage.class, new FolderIDMappingSQL(dbAccess));
        LOG.info("USM FolderIDMappingStorageSQL registered.");
        registerService(ContextUUIDMappingStorage.class, new ContextUUIDMappingSQL(dbAccess));
        LOG.info("USM ObjectIDMappingStorageSQL registered.");

    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#unregister(org.osgi.framework.BundleContext)
     */
    @Override
    protected void unregister() {
        LOG.info("USM MySQL Mapping Storage unregistered.");
    }

}
