/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.mimemail;

import java.io.IOException;
import java.io.PipedInputStream;

/**
 * {@link ExtendedPipedInputStream}
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public class ExtendedPipedInputStream extends PipedInputStream {

    private IOException _exception = null;

    @Override
    public synchronized int available() throws IOException {
        if (_exception != null)
            throw _exception;
        return super.available();
    }

    @Override
    public synchronized int read() throws IOException {
        if (_exception != null)
            throw _exception;
        return super.read();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (_exception != null)
            throw _exception;
        return super.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (_exception != null)
            throw _exception;
        super.close();
    }

    public void setException(Exception e) {
        _exception = (e instanceof IOException) ? (IOException) e : new IOException("Error while writing to connected OutputStream", e);
    }
}
