/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.datatypes.mail;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.usm.api.datatypes.AbstractDataType;
import com.openexchange.usm.api.session.Session;

public class HeadersDataType extends AbstractDataType<Headers> {
	
    public HeadersDataType() {
	    super("Headers");
	}

	@Override
    public void addToJSONArray(Session session, JSONArray parent, Object value) throws JSONException {
		parent.put((value == null) ? new JSONObject() : ((Headers) value).toJSONObject());
	}

	@Override
    public Headers checkValue(Object o) {
		if (o != null && !(o instanceof Headers))
			generateTypeError(o);
		return (Headers) o;
	}

	@Override
    public Headers extractFromJSONArray(Session session, JSONArray array, int index) throws JSONException {
		return array.isNull(index) ? new Headers() : new Headers(array.optJSONObject(index));
	}

	@Override
    public Headers extractFromJSONObject(Session session, JSONObject jsonObject, String field) throws JSONException {
		return jsonObject.isNull(field) ? new Headers() : new Headers(jsonObject.optJSONObject(field));
	}

	@Override
    public void storeInJSONObject(Session session, JSONObject parent, String field, Object value) throws JSONException {
		if (value instanceof Headers)
			parent.put(field, ((Headers) value).toJSONObject());
		else
			parent.put(field, new Headers().toJSONObject());
	}
}
