/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.session.assets;

/**
 * These are the possible settings for conflict resolution for conflicts
 * on simultaneous updates both from a client and the server.
 * 
 * @author afe
 *
 */
public enum ConflictResolution {
	/**
	 * Generate an error (Exception) to report the conflict to the protocol / client
	 */
	ERROR,
	/**
	 * On conflicts, use client value
	 */
	USE_CLIENT,
	/**
	 * On conflicts, use server value
	 */
	USE_SERVER,
	/**
	 * As ERROR, but deletions have higher priority than changes, i.e. if a deletion and a change
	 * occur on the same element, the deletion is used and no error is reported.
	 */
	ERROR_DELETE_OVER_CHANGE,
	/**
	 * As USE_CLIENT, but deletions have higher priority than changes, i.e. if a server deletion
	 * and a client change occur on the same element, the deletion is used and no error is reported.
	 */
	USE_CLIENT_DELETE_OVER_CHANGE,
	/**
	 * As USE_SERVER, but deletions have higher priority than changes, i.e. if a client deletion
	 * and a server change occur on the same element, the deletion is used and no error is reported.
	 */
	USE_SERVER_DELETE_OVER_CHANGE;

	public boolean isDeleteOverChange() {
		return this == ERROR_DELETE_OVER_CHANGE || this == USE_CLIENT_DELETE_OVER_CHANGE
				|| this == USE_SERVER_DELETE_OVER_CHANGE;
	}
}
