/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.ox.json;

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONString;

/**
 * Container that is used for return values of a Ajax call. It can store/represent
 * either a JSONArray or a JSONObject or, if the result is not a valid JSONArray or JSONObject,
 * it will provide the result in its original String representation.
 * It also implements the JSONString interface to allow for easy conversion to String.
 * For standard errors (according to OX HTTP API), the result will be reported as a
 * JSONObject and the method isError() will return true.
 * 
 * @author afe
 *
 */
public interface JSONResult extends JSONString {
	/**
	 * @return type of the parsed result of the JSONResult
	 */
	JSONResultType getResultType();

	/**
	 * 
	 * @return JSONArray of response if a JSONArray was returned
	 * @throws IllegalStateException if result was no JSONArray
	 */
	JSONArray getJSONArray();

	/**
	 * 
	 * @return JSONObject of response if a JSONObject was returned (which is also the case for a standard error return value)
	 * @throws IllegalStateException if result was no JSONObject
	 */
	JSONObject getJSONObject();

	/**
	 * 
	 * @return Original String representation if result could not be parsed as JSONObject or JSONArray
	 * @throws IllegalStateException if result is a JSONObject or a JSONArray
	 */
	String getString();
}
