/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.io;

import java.io.IOException;
import java.io.InputStream;

/**
 * {@link InputStreamProvider} Interface that provides InputStreams to some data.
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public interface InputStreamProvider {

    /**
     * On each call, returns a new InputStream for the same data that is provided by this InputStreamProvider. The caller has to make sure
     * that the InputStream gets closed after usage.
     * 
     * @return new InputStream from which the provided data can be read
     * @throws IOException If an error occurs creating the InputStream
     */
    InputStream getInputStream() throws IOException;
}
