/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.exceptions;

import org.json.JSONObject;

/**
 * Special Exception that can be thrown by ContentTypeTransferHandlers to indicate that the requested operation is not supported. This can
 * be the case for some special content types like Mail (for which creation of a Mail object in a Folder is not allowed, only sending of
 * mail to some user).
 * 
 * @author afe
 */
public class UnsupportedContentOperationException extends USMException {

    private static final long serialVersionUID = -1L;

    public UnsupportedContentOperationException(int errorCode, String message) {
        super(errorCode, message);
    }

    @Override
    public JSONObject getErrorDetailsForJSONResponse() {
        return null;
    }

}
