/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.exceptions;

import org.json.JSONObject;

/**
 * Special Exception that is thrown by the USM if a Folder can not be located
 * by its folderid, either in the cache (if cached data is available) or directly
 * on the OX server.
 * 
 * @author afe
 *
 */
public class FolderNotFoundException extends USMException {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private final JSONObject _jsonError;

	public FolderNotFoundException(int errorCode, String message) {
		super(errorCode, message);
		_jsonError = null;
	}

	public FolderNotFoundException(int errorCode, String message, Throwable cause) {
		super(errorCode, message, cause);
		_jsonError = null;
	}
	
	public FolderNotFoundException(int errorCode, String message, JSONObject errorDetails) {
        super(errorCode, message);
        _jsonError = errorDetails;
    }

	@Override
	public JSONObject getErrorDetailsForJSONResponse() {
		return null;
	}

	@Override
	public JSONObject getOxErrorForJSONResponse() {
		return _jsonError;
	}
	
	@Override
	public String toString() {
	    StringBuilder sb = new StringBuilder(super.toString());
        if (_jsonError != null)
            sb.append(", json-error=").append(_jsonError);
        return sb.toString();
	}
	
	@Override
	public String getMessage() {
	    StringBuilder sb = new StringBuilder(super.getMessage());
        if (_jsonError != null)
            sb.append(", json-error=").append(_jsonError);
        return sb.toString();
	}
}
