/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.exceptions;

import org.json.JSONObject;


/**
 * Special exception that can be thrown by ContentTypeTransferHandlers or the OX
 * access system if an error occurred during the update process with the OX server
 * that was caused by an intermediate external update on the server (i.e. the
 * provided DataObjects for updates were too old).
 * 
 * @author afe
 *
 */
public class ConflictingChangeException extends OXCommunicationException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;



	public ConflictingChangeException(int errorCode, String message, JSONObject errorDetails) {
		super(errorCode, message, errorDetails);
	}
}
