/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.office.tools.database;

import java.util.HashMap;
import java.util.Map;

/**
 * {@link DatabaseException}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 * @since v7.10.1
 */
@SuppressWarnings("serial")
public class DatabaseException extends Exception {
	private Map<String, String> dbProperties = new HashMap<>();;

    /**
     * Initializes a new {@link DatabaseException}.
     */
    public DatabaseException() {
        super();
    }

    /**
     * Initializes a new {@link DatabaseException}.
     * @param message
     */
    public DatabaseException(String message) {
        super(message);
    }

    /**
     * Initializes a new {@link DatabaseException}.
     * @param message
     */
    public DatabaseException(String message, Throwable e) {
        super(message, e);
    }

    /**
     * Initializes a new {@link DatabaseException}.
     * @param message
     */
    public DatabaseException(String message, Throwable e, Map<String, String> properties) {
        super(message, e);
        dbProperties = properties;
    }

    /**
     * Provides more information about the database properties
     * used, when the exception occurred. Can be used
     * @return
     */
    public Map<String, String> getDBProperties() {
        return dbProperties;
    }

	@Override
	public String getMessage() {
      final Map<String, String> dbProps = getDBProperties();

      final StringBuffer tmp = new StringBuffer(super.getMessage());
      tmp.append(", database connection properties: ");
      tmp.append(getDatabasePropertiesAsString(dbProps));
      return tmp.toString();
	}

    private static String getDatabasePropertiesAsString(final Map<String, String> props) {
	  final StringBuffer tmp = new StringBuffer(256);
	  if ((null != props) && !props.isEmpty()) {
	      boolean first = true;
	      for (String key : props.keySet()) {
	          if (first) {
	             first = false;
	          } else {
	              tmp.append(", ");
	          }
	          tmp.append(key);
	          tmp.append("=");
	          tmp.append(props.get(key));
	      }
	  }
	
	  return tmp.toString();
	}    
}
