/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.eclipse.wst.xml.xpath2.api.CollationProvider;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.XercesLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DynamicContextBuilder
implements DynamicContext {
    private static DatatypeFactory _datatypeFactory;
    private TimeZone _systemTimezone = TimeZone.getDefault();
    private Duration _tz = _datatypeFactory.newDuration(this._systemTimezone.getRawOffset());
    private GregorianCalendar _currentDateTime;
    private Map<QName, ResultSequence> _variables = new HashMap<QName, ResultSequence>();
    private final StaticContext _staticContext;
    private Map<String, List<Document>> _collections;
    private Map<URI, Document> _loaded_documents = new HashMap<URI, Document>();

    public DynamicContextBuilder(StaticContext sc) {
        this._staticContext = sc;
    }

    @Override
    public Duration getTimezoneOffset() {
        return this._tz;
    }

    @Override
    public GregorianCalendar getCurrentDateTime() {
        if (this._currentDateTime == null) {
            this._currentDateTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        }
        return this._currentDateTime;
    }

    @Override
    public Node getLimitNode() {
        return null;
    }

    @Override
    public ResultSequence getVariable(QName name) {
        return this._variables.get(name);
    }

    @Override
    public Document getDocument(URI resolved) {
        Document doc = null;
        if (this._loaded_documents.containsKey(resolved)) {
            doc = this._loaded_documents.get(resolved);
        } else {
            doc = this.retrieve_doc(resolved);
            this._loaded_documents.put(resolved, doc);
        }
        return doc;
    }

    private Document retrieve_doc(URI uri) {
        try {
            XercesLoader loader = new XercesLoader();
            loader.set_validating(false);
            Document doc = loader.load(new URL(uri.toString()).openStream());
            doc.setDocumentURI(uri.toString());
            return doc;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public URI resolveUri(String uri) {
        try {
            URI realURI = URI.create(uri);
            if (realURI.isAbsolute()) {
                return realURI;
            }
            return this._staticContext.getBaseUri().resolve(uri);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    @Override
    public Map<String, List<Document>> getCollections() {
        return this._collections;
    }

    @Override
    public List<Document> getDefaultCollection() {
        return this.getCollections().get("http://www.w3.org/2005/xpath-functions/collection/default");
    }

    public DynamicContextBuilder withVariable(QName qName, ResultSequence values) {
        this._variables.put(qName, values);
        return this;
    }

    public DynamicContextBuilder withTimezoneOffset(Duration d) {
        this._tz = d;
        return this;
    }

    public void withCollections(Map<String, List<Document>> map) {
        this._collections = map;
    }

    @Override
    public CollationProvider getCollationProvider() {
        return this._staticContext.getCollationProvider();
    }

    static {
        try {
            _datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Cannot initialize XML datatypes", e);
        }
    }
}

