/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.office.hazelcast.serialization.document;

import org.springframework.stereotype.Service;

import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Portable;
import com.openexchange.hazelcast.serialization.AbstractCustomPortableFactory;
import com.openexchange.office.tools.annotation.RegisteredService;


/**
 * {@link PortableDocumentFactory}
 *
 * @author <a href="mailto:marc.arens@open-xchange.com">Carsten Driesner</a>
 * @since 7.8.0
 */
@Service
@RegisteredService
public class PortableDocumentFactory extends AbstractCustomPortableFactory {

    @Override
    public Portable create() {
        return new PortableDocumentState();
    }

    @Override
    public int getClassId() {
        return PortableDocumentState.CLASS_ID;
    }

    @Override
    public ClassDefinition getClassDefinition() {
        return PortableDocumentState.CLASS_DEFINITION;
    }

}
