plugins {
    `java-library`
}

val jarContents: Configuration by configurations.creating {
    description = "Contents of this jars are provided by com.openexchange.office.dependencies bundle"
}

repositories {
    mavenCentral()
}

dependencies {
    jarContents("ch.qos.logback:logback-classic:1.2.11")
    jarContents("org.apache.commons:commons-text:1.10.0")
    jarContents("javax.activation:activation:1.1.1")
    jarContents("javax.validation:validation-api:2.0.1.Final")
    jarContents("org.apache.activemq:activemq-pool:5.16.7")
    jarContents("org.apache.activemq:activemq-client:5.16.7")
    jarContents("org.springframework:spring-web:5.3.32")
    jarContents("org.springframework:spring-jms:5.3.32")
    jarContents("org.springframework:spring-context:5.3.32")
    jarContents("org.springframework.boot:spring-boot-autoconfigure:2.7.18")
    jarContents("com.google.protobuf:protobuf-java:3.6.1")
    jarContents("io.dropwizard.metrics:metrics-core:4.1.36")
    jarContents("io.dropwizard.metrics:metrics-jmx:4.1.36")
    jarContents("com.udojava:JMXWrapper:1.4")
    jarContents("io.leangen.geantyref:geantyref:1.3.11")
    api(files("lib/com.openexchange.office.dependencies.jar") {
        builtBy("dependenciesJar")
    })
}

val jarTask = tasks.register<Jar>("dependenciesJar") {
    destinationDirectory.set(layout.projectDirectory.dir("lib"))
    archiveClassifier.set("")
    manifest {
      from(file("META-INF/MANIFEST.MF"))
    }
    from({
        jarContents.map { zipTree(it) }
    })
}

defaultTasks("dependenciesJar")
