/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import java.lang.reflect.Type;

public abstract class JodaDateSerializerBase<T>
extends JodaSerializerBase<T>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final JacksonJodaDateFormat _format;
    protected final boolean _usesArrays;
    protected final SerializationFeature _featureForNumeric;

    protected JodaDateSerializerBase(Class<T> type, JacksonJodaDateFormat format, boolean usesArrays, SerializationFeature numericFeature) {
        super(type);
        this._format = format;
        this._usesArrays = usesArrays;
        this._featureForNumeric = numericFeature;
    }

    public abstract JodaDateSerializerBase<T> withFormat(JacksonJodaDateFormat var1);

    @Deprecated
    public final boolean isEmpty(T value) {
        return this.isEmpty(null, value);
    }

    public boolean isEmpty(SerializerProvider prov, T value) {
        return value == null;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value ann;
        if (property != null && (ann = prov.getAnnotationIntrospector().findFormat((Annotated)property.getMember())) != null) {
            JacksonJodaDateFormat format = this._format;
            Boolean useTimestamp = ann.getShape().isNumeric() ? Boolean.TRUE : (ann.getShape() == JsonFormat.Shape.STRING ? Boolean.FALSE : (ann.getShape() == JsonFormat.Shape.ARRAY ? Boolean.TRUE : null));
            if (useTimestamp != null) {
                format = format.withUseTimestamp(useTimestamp);
            }
            format = format.withFormat(ann.getPattern().trim());
            format = format.withLocale(ann.getLocale());
            if ((format = format.withTimeZone(ann.getTimeZone())) != this._format) {
                return this.withFormat(format);
            }
        }
        return this;
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        if (this._useTimestamp(provider)) {
            return this.createSchemaNode(this._usesArrays ? "array" : "number", true);
        }
        return this.createSchemaNode("string", true);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this._acceptJsonFormatVisitor(visitor, typeHint, this._useTimestamp(visitor.getProvider()));
    }

    protected void _acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint, boolean asNumber) throws JsonMappingException {
        if (asNumber) {
            if (this._usesArrays) {
                JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
                if (v2 != null) {
                    v2.itemsFormat(JsonFormatTypes.INTEGER);
                }
            } else {
                JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
                if (v2 != null) {
                    v2.numberType(JsonParser.NumberType.LONG);
                    v2.format(JsonValueFormat.UTC_MILLISEC);
                }
            }
        } else {
            JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
            if (v2 != null) {
                v2.format(JsonValueFormat.DATE_TIME);
            }
        }
    }

    protected boolean _useTimestamp(SerializerProvider provider) {
        return this._format.useTimestamp(provider, this._featureForNumeric);
    }
}

