/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions.encoders;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import com.google.gson.JsonObject;
import com.openexchange.logback.extensions.encoders.CustomField;
import com.openexchange.logback.extensions.encoders.JSONFieldName;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class JSONEncoder
extends EncoderBase<ILoggingEvent> {
    public static final FastDateFormat LOGSTASH_TIMEFORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private final List<CustomField> customFields = new ArrayList<CustomField>();

    public void addCustomField(CustomField customField) {
        this.customFields.add(customField);
    }

    public byte[] headerBytes() {
        return null;
    }

    public byte[] encode(ILoggingEvent event) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            JsonObject j = new JsonObject();
            j.addProperty(JSONFieldName.timestamp.getJSONName(), LOGSTASH_TIMEFORMAT.format(event.getTimeStamp()));
            j.addProperty(JSONFieldName.version.getJSONName(), (Number)1);
            j.addProperty(JSONFieldName.level.getJSONName(), event.getLevel().levelStr);
            j.addProperty(JSONFieldName.logger.getJSONName(), event.getLoggerName());
            j.addProperty(JSONFieldName.thread.getJSONName(), event.getThreadName());
            j.addProperty(JSONFieldName.message.getJSONName(), event.getFormattedMessage());
            j.addProperty(JSONFieldName.line.getJSONName(), (Number)this.getLineNumber(event));
            j.addProperty(JSONFieldName.clazz.getJSONName(), this.getFullyQualifiedName(event));
            if (event.getMarker() != null) {
                j.addProperty(JSONFieldName.marker.getJSONName(), event.getMarker().getName());
            }
            if (event.getThrowableProxy() != null) {
                j.addProperty(JSONFieldName.stacktrace.getJSONName(), ThrowableProxyUtil.asString((IThrowableProxy)event.getThrowableProxy()));
            }
            Map mdc = event.getMDCPropertyMap();
            for (String key : mdc.keySet()) {
                j.addProperty(key, (String)mdc.get(key));
            }
            for (CustomField customField : this.customFields) {
                j.addProperty(customField.getKey(), customField.getValue());
            }
            IOUtils.write((String)IOUtils.LINE_SEPARATOR, (OutputStream)outputStream);
            outputStream.write(j.toString().getBytes());
        }
        catch (IOException e) {
            this.addStatus((Status)new ErrorStatus("An I/O error occurred during event encoding", (Object)this, (Throwable)e));
        }
        return outputStream.toByteArray();
    }

    public byte[] footerBytes() {
        return null;
    }

    private int getLineNumber(ILoggingEvent event) {
        StackTraceElement[] cda = event.getCallerData();
        if (cda != null && cda.length > 0) {
            return cda[0].getLineNumber();
        }
        return -1;
    }

    private String getFullyQualifiedName(ILoggingEvent event) {
        StackTraceElement[] cda = event.getCallerData();
        if (cda != null && cda.length > 0) {
            return cda[0].getClassName();
        }
        return "?";
    }
}

