/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions.appenders.logstash;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.spi.ContextAwareBase;
import com.openexchange.logback.extensions.appenders.ExceptionHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.KafkaFuture;

public class LogstashExceptionHandler
implements ExceptionHandler {
    private final Map<Class<? extends Exception>, KafkaFuture.BiConsumer<Exception, ILoggingEvent>> exceptionHandlers;
    private final ContextAwareBase contextAwareBase;
    private final String peerId;

    public LogstashExceptionHandler(final ContextAwareBase contextAwareBase, final String peerId) {
        this.contextAwareBase = contextAwareBase;
        this.peerId = peerId;
        HashMap<Class<TimeoutException>, Object> exh = new HashMap<Class<TimeoutException>, Object>();
        exh.put(InterruptedException.class, new KafkaFuture.BiConsumer<Exception, ILoggingEvent>(){

            public void accept(Exception e, ILoggingEvent event) {
                contextAwareBase.addError("Connection to " + peerId + " interrupted.", (Throwable)e);
            }
        });
        exh.put(ConnectException.class, new KafkaFuture.BiConsumer<Exception, ILoggingEvent>(){

            public void accept(Exception e, ILoggingEvent event) {
                contextAwareBase.addError("Connection to " + peerId + " refused.", (Throwable)e);
            }
        });
        exh.put(IOException.class, new KafkaFuture.BiConsumer<Exception, ILoggingEvent>(){

            public void accept(Exception e, ILoggingEvent event) {
                contextAwareBase.addError("Connection to " + peerId + " failed.", (Throwable)e);
            }
        });
        exh.put(InterruptedException.class, new KafkaFuture.BiConsumer<Exception, ILoggingEvent>(){

            public void accept(Exception e, ILoggingEvent event) {
                contextAwareBase.addError("Connection to " + peerId + " interupted.", (Throwable)e);
            }
        });
        exh.put(TimeoutException.class, new KafkaFuture.BiConsumer<Exception, ILoggingEvent>(){

            public void accept(Exception e, ILoggingEvent event) {
                contextAwareBase.addError("Connection to " + peerId + " timed out.", (Throwable)e);
            }
        });
        this.exceptionHandlers = Collections.unmodifiableMap(exh);
    }

    @Override
    public void handle(Exception e) {
        this.handle(e, null);
    }

    @Override
    public void handle(Exception e, ILoggingEvent event) {
        KafkaFuture.BiConsumer<Exception, ILoggingEvent> exceptionHandler = this.exceptionHandlers.get(e.getClass());
        if (exceptionHandler == null) {
            this.contextAwareBase.addError("Connection error to " + this.peerId + ".", (Throwable)e);
            return;
        }
        exceptionHandler.accept((Object)e, (Object)event);
    }
}

