/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class ResendSecondaryEmailResult {
    public static final ResendSecondaryEmailResult OTHER = new ResendSecondaryEmailResult().withTag(Tag.OTHER);
    private Tag _tag;
    private String successValue;
    private String notPendingValue;
    private String rateLimitedValue;

    private ResendSecondaryEmailResult() {
    }

    private ResendSecondaryEmailResult withTag(Tag _tag) {
        ResendSecondaryEmailResult result = new ResendSecondaryEmailResult();
        result._tag = _tag;
        return result;
    }

    private ResendSecondaryEmailResult withTagAndSuccess(Tag _tag, String successValue) {
        ResendSecondaryEmailResult result = new ResendSecondaryEmailResult();
        result._tag = _tag;
        result.successValue = successValue;
        return result;
    }

    private ResendSecondaryEmailResult withTagAndNotPending(Tag _tag, String notPendingValue) {
        ResendSecondaryEmailResult result = new ResendSecondaryEmailResult();
        result._tag = _tag;
        result.notPendingValue = notPendingValue;
        return result;
    }

    private ResendSecondaryEmailResult withTagAndRateLimited(Tag _tag, String rateLimitedValue) {
        ResendSecondaryEmailResult result = new ResendSecondaryEmailResult();
        result._tag = _tag;
        result.rateLimitedValue = rateLimitedValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isSuccess() {
        return this._tag == Tag.SUCCESS;
    }

    public static ResendSecondaryEmailResult success(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new ResendSecondaryEmailResult().withTagAndSuccess(Tag.SUCCESS, value);
    }

    public String getSuccessValue() {
        if (this._tag != Tag.SUCCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.SUCCESS, but was Tag." + this._tag.name());
        }
        return this.successValue;
    }

    public boolean isNotPending() {
        return this._tag == Tag.NOT_PENDING;
    }

    public static ResendSecondaryEmailResult notPending(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new ResendSecondaryEmailResult().withTagAndNotPending(Tag.NOT_PENDING, value);
    }

    public String getNotPendingValue() {
        if (this._tag != Tag.NOT_PENDING) {
            throw new IllegalStateException("Invalid tag: required Tag.NOT_PENDING, but was Tag." + this._tag.name());
        }
        return this.notPendingValue;
    }

    public boolean isRateLimited() {
        return this._tag == Tag.RATE_LIMITED;
    }

    public static ResendSecondaryEmailResult rateLimited(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new ResendSecondaryEmailResult().withTagAndRateLimited(Tag.RATE_LIMITED, value);
    }

    public String getRateLimitedValue() {
        if (this._tag != Tag.RATE_LIMITED) {
            throw new IllegalStateException("Invalid tag: required Tag.RATE_LIMITED, but was Tag." + this._tag.name());
        }
        return this.rateLimitedValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.successValue, this.notPendingValue, this.rateLimitedValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ResendSecondaryEmailResult) {
            ResendSecondaryEmailResult other = (ResendSecondaryEmailResult)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case SUCCESS: {
                    return this.successValue == other.successValue || this.successValue.equals(other.successValue);
                }
                case NOT_PENDING: {
                    return this.notPendingValue == other.notPendingValue || this.notPendingValue.equals(other.notPendingValue);
                }
                case RATE_LIMITED: {
                    return this.rateLimitedValue == other.rateLimitedValue || this.rateLimitedValue.equals(other.rateLimitedValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ResendSecondaryEmailResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ResendSecondaryEmailResult value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case SUCCESS: {
                    g.writeStartObject();
                    this.writeTag("success", g);
                    g.writeFieldName("success");
                    StoneSerializers.string().serialize(value.successValue, g);
                    g.writeEndObject();
                    break;
                }
                case NOT_PENDING: {
                    g.writeStartObject();
                    this.writeTag("not_pending", g);
                    g.writeFieldName("not_pending");
                    StoneSerializers.string().serialize(value.notPendingValue, g);
                    g.writeEndObject();
                    break;
                }
                case RATE_LIMITED: {
                    g.writeStartObject();
                    this.writeTag("rate_limited", g);
                    g.writeFieldName("rate_limited");
                    StoneSerializers.string().serialize(value.rateLimitedValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public ResendSecondaryEmailResult deserialize(JsonParser p) throws IOException, JsonParseException {
            ResendSecondaryEmailResult value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("success".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("success", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = ResendSecondaryEmailResult.success(fieldValue);
            } else if ("not_pending".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("not_pending", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = ResendSecondaryEmailResult.notPending(fieldValue);
            } else if ("rate_limited".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("rate_limited", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = ResendSecondaryEmailResult.rateLimited(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        SUCCESS,
        NOT_PENDING,
        RATE_LIMITED,
        OTHER;

    }
}

