/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlCloseCodec;
import com.hazelcast.client.impl.protocol.codec.SqlExecuteCodec;
import com.hazelcast.client.impl.protocol.codec.SqlFetchCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.LazyTarget;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.client.SqlClientResult;
import com.hazelcast.sql.impl.client.SqlError;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;

public class SqlClientService
implements SqlService {
    private final HazelcastClientInstanceImpl client;
    private final ILogger logger;
    private final boolean skipUpdateStatistics;

    public SqlClientService(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(this.getClass());
        this.skipUpdateStatistics = this.skipUpdateStatistics();
    }

    @Override
    @Nonnull
    public SqlResult execute(@Nonnull SqlStatement statement) {
        ClientConnection connection = this.getQueryConnection();
        QueryId id = QueryId.create(connection.getRemoteUuid());
        try {
            List<Object> params = statement.getParameters();
            ArrayList<Data> params0 = new ArrayList<Data>(params.size());
            for (Object param : params) {
                params0.add(this.serializeParameter(param));
            }
            ClientMessage requestMessage = SqlExecuteCodec.encodeRequest(statement.getSql(), params0, statement.getTimeoutMillis(), statement.getCursorBufferSize(), statement.getSchema(), statement.getExpectedResultType().getId(), id, this.skipUpdateStatistics);
            SqlClientResult res = new SqlClientResult(this, connection, id, statement.getCursorBufferSize());
            ClientInvocationFuture future = this.invokeAsync(requestMessage, connection);
            future.whenComplete(ExceptionUtil.withTryCatch(this.logger, (message, error) -> this.handleExecuteResponse(connection, res, (ClientMessage)message, (Throwable)error))).get();
            return res;
        }
        catch (Exception e) {
            throw this.rethrow(e, connection);
        }
    }

    private boolean skipUpdateStatistics() {
        String connectionType = this.client.getConnectionManager().getConnectionType();
        return connectionType.equals("MCJVM");
    }

    private void handleExecuteResponse(ClientConnection connection, SqlClientResult res, ClientMessage message, Throwable error) {
        if (error != null) {
            res.onExecuteError(this.rethrow(error, connection));
            return;
        }
        SqlExecuteCodec.ResponseParameters response = SqlExecuteCodec.decodeResponse(message);
        HazelcastSqlException responseError = SqlClientService.handleResponseError(response.error);
        if (responseError != null) {
            res.onExecuteError(responseError);
            return;
        }
        res.onExecuteResponse(response.rowMetadata != null ? new SqlRowMetadata(response.rowMetadata) : null, response.rowPage, response.updateCount);
    }

    public void fetchAsync(Connection connection, QueryId queryId, int cursorBufferSize, SqlClientResult res) {
        ClientMessage requestMessage = SqlFetchCodec.encodeRequest(queryId, cursorBufferSize);
        ClientInvocationFuture future = this.invokeAsync(requestMessage, connection);
        future.whenComplete(ExceptionUtil.withTryCatch(this.logger, (message, error) -> this.handleFetchResponse(connection, res, (ClientMessage)message, (Throwable)error)));
    }

    private void handleFetchResponse(Connection connection, SqlClientResult res, ClientMessage message, Throwable error) {
        if (error != null) {
            res.onFetchFinished(null, this.rethrow(error, connection));
            return;
        }
        SqlFetchCodec.ResponseParameters responseParameters = SqlFetchCodec.decodeResponse(message);
        HazelcastSqlException responseError = SqlClientService.handleResponseError(responseParameters.error);
        if (responseError != null) {
            res.onFetchFinished(null, responseError);
            return;
        }
        assert (responseParameters.rowPage != null);
        res.onFetchFinished(responseParameters.rowPage, null);
    }

    void close(Connection connection, QueryId queryId) {
        try {
            ClientMessage requestMessage = SqlCloseCodec.encodeRequest(queryId);
            this.invoke(requestMessage, connection);
        }
        catch (Exception e) {
            throw this.rethrow(e, connection);
        }
    }

    public ClientConnection getQueryConnection() {
        try {
            ClientConnection connection = this.client.getConnectionManager().getConnectionForSql();
            if (connection == null) {
                throw this.rethrow(QueryException.error(1001, "Client is not connected"));
            }
            return connection;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public ClientMessage invokeOnConnection(Connection connection, ClientMessage request) {
        try {
            return this.invoke(request, connection);
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    private Data serializeParameter(Object parameter) {
        try {
            return this.getSerializationService().toData(parameter);
        }
        catch (Exception e) {
            throw this.rethrow(QueryException.error("Failed to serialize query parameter " + parameter + ": " + e.getMessage()));
        }
    }

    Object deserializeRowValue(Object value) {
        try {
            return this.getSerializationService().toObject(value);
        }
        catch (Exception e) {
            throw this.rethrow(QueryException.error("Failed to deserialize query result value: " + e.getMessage()));
        }
    }

    Object deserializeRowValue(LazyTarget value) {
        try {
            return value.deserialize(this.getSerializationService());
        }
        catch (Exception e) {
            throw this.rethrow(QueryException.error("Failed to deserialize query result value: " + e.getMessage()));
        }
    }

    public UUID getClientId() {
        return this.client.getLocalEndpoint().getUuid();
    }

    private InternalSerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    private ClientInvocationFuture invokeAsync(ClientMessage request, Connection connection) {
        ClientInvocation invocation = new ClientInvocation(this.client, request, null, connection);
        return invocation.invoke();
    }

    private ClientMessage invoke(ClientMessage request, Connection connection) throws Exception {
        ClientInvocationFuture fut = this.invokeAsync(request, connection);
        return (ClientMessage)fut.get();
    }

    private static HazelcastSqlException handleResponseError(SqlError error) {
        if (error != null) {
            return new HazelcastSqlException(error.getOriginatingMemberId(), error.getCode(), error.getMessage(), null, error.getSuggestion());
        }
        return null;
    }

    private RuntimeException rethrow(Throwable cause, Connection connection) {
        if (!connection.isAlive()) {
            return QueryUtils.toPublicException(QueryException.memberConnection(connection.getRemoteAddress()), this.getClientId());
        }
        return this.rethrow(cause);
    }

    RuntimeException rethrow(Throwable cause) {
        if (cause.getCause() instanceof AccessControlException) {
            return (AccessControlException)cause.getCause();
        }
        return QueryUtils.toPublicException(cause, this.getClientId());
    }
}

