/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.everit.json.schema.loader;

import com.hazelcast.org.everit.json.schema.ArraySchema;
import com.hazelcast.org.everit.json.schema.NumberSchema;
import com.hazelcast.org.everit.json.schema.ObjectSchema;
import com.hazelcast.org.everit.json.schema.Schema;
import com.hazelcast.org.everit.json.schema.StringSchema;
import com.hazelcast.org.everit.json.schema.loader.ArraySchemaLoader;
import com.hazelcast.org.everit.json.schema.loader.ExclusiveLimitHandler;
import com.hazelcast.org.everit.json.schema.loader.ExtractionResult;
import com.hazelcast.org.everit.json.schema.loader.JsonObject;
import com.hazelcast.org.everit.json.schema.loader.JsonValue;
import com.hazelcast.org.everit.json.schema.loader.KeyConsumer;
import com.hazelcast.org.everit.json.schema.loader.LoaderConfig;
import com.hazelcast.org.everit.json.schema.loader.ObjectSchemaLoader;
import com.hazelcast.org.everit.json.schema.loader.PropertySnifferSchemaExtractor;
import com.hazelcast.org.everit.json.schema.loader.SchemaExtractor;
import com.hazelcast.org.everit.json.schema.loader.SchemaLoader;
import com.hazelcast.org.everit.json.schema.loader.StringSchemaLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

abstract class AbstractSchemaExtractor
implements SchemaExtractor {
    static final List<String> NUMBER_SCHEMA_PROPS = Arrays.asList("minimum", "maximum", "exclusiveMinimum", "exclusiveMaximum", "multipleOf");
    static final List<String> STRING_SCHEMA_PROPS = Arrays.asList("minLength", "maxLength", "pattern", "format");
    protected JsonObject schemaJson;
    private KeyConsumer consumedKeys;
    final SchemaLoader defaultLoader;
    private ExclusiveLimitHandler exclusiveLimitHandler;

    AbstractSchemaExtractor(SchemaLoader defaultLoader) {
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    @Override
    public final ExtractionResult extract(JsonObject schemaJson) {
        this.schemaJson = Objects.requireNonNull(schemaJson, "schemaJson cannot be null");
        this.exclusiveLimitHandler = ExclusiveLimitHandler.ofSpecVersion(this.config().specVersion);
        this.consumedKeys = new KeyConsumer(schemaJson);
        return new ExtractionResult(this.consumedKeys.collect(), this.extract());
    }

    JsonValue require(String key) {
        return this.consumedKeys.require(key);
    }

    Optional<JsonValue> maybe(String key) {
        return this.consumedKeys.maybe(key);
    }

    boolean containsKey(String key) {
        return this.schemaJson.containsKey(key);
    }

    boolean schemaHasAnyOf(Collection<String> propNames) {
        return propNames.stream().anyMatch(this.schemaJson::containsKey);
    }

    LoaderConfig config() {
        return this.schemaJson.ls.config;
    }

    ObjectSchema.Builder buildObjectSchema() {
        this.config().specVersion.objectKeywords().forEach(this.consumedKeys::keyConsumed);
        return new ObjectSchemaLoader(this.schemaJson.ls, this.config(), this.defaultLoader).load();
    }

    ArraySchema.Builder buildArraySchema() {
        this.config().specVersion.arrayKeywords().forEach(this.consumedKeys::keyConsumed);
        return new ArraySchemaLoader(this.schemaJson.ls, this.config(), this.defaultLoader).load();
    }

    NumberSchema.Builder buildNumberSchema() {
        PropertySnifferSchemaExtractor.NUMBER_SCHEMA_PROPS.forEach(this.consumedKeys::keyConsumed);
        NumberSchema.Builder builder = NumberSchema.builder();
        this.maybe("minimum").map(JsonValue::requireNumber).ifPresent(builder::minimum);
        this.maybe("maximum").map(JsonValue::requireNumber).ifPresent(builder::maximum);
        this.maybe("multipleOf").map(JsonValue::requireNumber).ifPresent(builder::multipleOf);
        this.maybe("exclusiveMinimum").ifPresent(exclMin -> this.exclusiveLimitHandler.handleExclusiveMinimum((JsonValue)exclMin, builder));
        this.maybe("exclusiveMaximum").ifPresent(exclMax -> this.exclusiveLimitHandler.handleExclusiveMaximum((JsonValue)exclMax, builder));
        return builder;
    }

    StringSchema.Builder buildStringSchema() {
        PropertySnifferSchemaExtractor.STRING_SCHEMA_PROPS.forEach(this.consumedKeys::keyConsumed);
        return new StringSchemaLoader(this.schemaJson.ls, this.config().formatValidators).load();
    }

    abstract List<Schema.Builder<?>> extract();
}

