/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.monitor.LocalRecordStoreStats;
import com.hazelcast.internal.monitor.impl.LocalRecordStoreStatsImpl;
import com.hazelcast.internal.monitor.impl.LocalReplicationStatsImpl;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.operation.MapReplicationOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadataImpl;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryReason;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.MapIndexInfo;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MapReplicationStateHolder
implements IdentifiedDataSerializable,
Versioned {
    protected transient Map<String, RecordStore<Record>> storesByMapName;
    protected transient Map<String, LocalReplicationStatsImpl> statsByMapName = new ConcurrentHashMap<String, LocalReplicationStatsImpl>();
    protected transient Map<String, List> data;
    protected transient Map<String, Boolean> loaded;
    protected transient List<MapIndexInfo> mapIndexInfos;
    protected Map<String, int[]> merkleTreeDiffByMapName = Collections.emptyMap();
    protected MapReplicationOperation operation;
    private Map<String, LocalRecordStoreStats> recordStoreStatsPerMapName;

    public void setMerkleTreeDiffByMapName(Map<String, int[]> merkleTreeDiffByMapName) {
        this.merkleTreeDiffByMapName = merkleTreeDiffByMapName == null ? Collections.emptyMap() : merkleTreeDiffByMapName;
    }

    public void setOperation(MapReplicationOperation operation) {
        this.operation = operation;
    }

    void prepare(PartitionContainer container, Collection<ServiceNamespace> namespaces, int replicaIndex) {
        this.storesByMapName = MapUtil.createHashMap(namespaces.size());
        this.loaded = MapUtil.createHashMap(namespaces.size());
        this.mapIndexInfos = new ArrayList<MapIndexInfo>(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            Indexes indexes;
            MapContainer mapContainer;
            MapConfig mapConfig;
            ObjectNamespace mapNamespace = (ObjectNamespace)namespace;
            String mapName = mapNamespace.getObjectName();
            RecordStore recordStore = container.getExistingRecordStore(mapName);
            if (recordStore == null || (mapConfig = (mapContainer = recordStore.getMapContainer()).getMapConfig()).getTotalBackupCount() < replicaIndex) continue;
            this.loaded.put(mapName, recordStore.isLoaded());
            this.storesByMapName.put(mapName, recordStore);
            this.statsByMapName.put(mapName, mapContainer.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(mapName).getReplicationStats());
            HashSet<IndexConfig> indexConfigs = new HashSet<IndexConfig>();
            if (mapContainer.isGlobalIndexEnabled()) {
                indexes = mapContainer.getIndexes();
                for (InternalIndex index : indexes.getIndexes()) {
                    indexConfigs.add(index.getConfig());
                }
                indexConfigs.addAll(indexes.getIndexDefinitions());
            } else {
                indexes = mapContainer.getIndexes(container.getPartitionId());
                if (indexes != null && indexes.haveAtLeastOneIndexOrDefinition()) {
                    for (InternalIndex index : indexes.getIndexes()) {
                        indexConfigs.add(index.getConfig());
                    }
                    indexConfigs.addAll(indexes.getIndexDefinitions());
                }
            }
            MapIndexInfo mapIndexInfo = new MapIndexInfo(mapName);
            mapIndexInfo.addIndexCofigs(indexConfigs);
            this.mapIndexInfos.add(mapIndexInfo);
        }
    }

    void applyState() {
        String mapName;
        ThreadUtil.assertRunningOnPartitionThread();
        this.applyIndexesState();
        if (!MapUtil.isNullOrEmpty(this.data)) {
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                mapName = entry.getKey();
                boolean isDifferentialReplication = this.merkleTreeDiffByMapName.containsKey(mapName);
                List keyRecordExpiry = (List)entry.getValue();
                RecordStore recordStore = this.operation.getRecordStore(mapName);
                this.initializeRecordStore(mapName, recordStore);
                recordStore.setPreMigrationLoadedStatus(this.loaded.get(mapName));
                MapContainer mapContainer = recordStore.getMapContainer();
                PartitionContainer partitionContainer = recordStore.getMapContainer().getMapServiceContext().getPartitionContainer(this.operation.getPartitionId());
                for (Map.Entry<String, IndexConfig> indexDefinition : mapContainer.getIndexDefinitions().entrySet()) {
                    Indexes indexes = mapContainer.getIndexes(partitionContainer.getPartitionId());
                    indexes.addOrGetIndex(indexDefinition.getValue());
                }
                Indexes indexes = mapContainer.getIndexes(partitionContainer.getPartitionId());
                boolean populateIndexes = MapReplicationStateHolder.indexesMustBePopulated(indexes, this.operation);
                InternalIndex[] indexesSnapshot = null;
                if (populateIndexes) {
                    indexesSnapshot = indexes.getIndexes();
                    Indexes.beginPartitionUpdate(indexesSnapshot);
                    indexes.clearAll();
                }
                long nowInMillis = Clock.currentTimeMillis();
                if (isDifferentialReplication) {
                    this.forEachReplicatedRecord(keyRecordExpiry, mapContainer, recordStore, populateIndexes, nowInMillis, recordStore::putOrUpdateReplicatedRecord);
                } else {
                    this.forEachReplicatedRecord(keyRecordExpiry, mapContainer, recordStore, populateIndexes, nowInMillis, recordStore::putReplicatedRecord);
                }
                if (!populateIndexes) continue;
                Indexes.markPartitionAsIndexed(partitionContainer.getPartitionId(), indexesSnapshot);
            }
        }
        for (Map.Entry<String, Object> entry : this.recordStoreStatsPerMapName.entrySet()) {
            mapName = entry.getKey();
            LocalRecordStoreStats stats = (LocalRecordStoreStats)entry.getValue();
            RecordStore recordStore = this.operation.getRecordStore(mapName);
            recordStore.setStats(stats);
        }
    }

    private void forEachReplicatedRecord(List keyRecordExpiry, MapContainer mapContainer, RecordStore recordStore, boolean populateIndexes, long nowInMillis, ReplicatedRecordProcessor replicatedRecordProcessor) {
        long ownedEntryCountOnThisNode = this.entryCountOnThisNode(mapContainer);
        EvictionConfig evictionConfig = mapContainer.getMapConfig().getEvictionConfig();
        boolean perNodeEvictionConfigured = mapContainer.getEvictor() != Evictor.NULL_EVICTOR && evictionConfig.getMaxSizePolicy() == MaxSizePolicy.PER_NODE;
        for (int i = 0; i < keyRecordExpiry.size(); i += 3) {
            Data dataKey = (Data)keyRecordExpiry.get(i);
            Record record = (Record)keyRecordExpiry.get(i + 1);
            ExpiryMetadata expiryMetadata = (ExpiryMetadata)keyRecordExpiry.get(i + 2);
            if (perNodeEvictionConfigured) {
                if (ownedEntryCountOnThisNode >= (long)evictionConfig.getSize()) {
                    if (this.operation.getReplicaIndex() == 0) {
                        recordStore.doPostEvictionOperations(dataKey, record.getValue(), ExpiryReason.NOT_EXPIRED);
                    }
                } else {
                    replicatedRecordProcessor.processRecord(dataKey, record, expiryMetadata, populateIndexes, nowInMillis);
                    ++ownedEntryCountOnThisNode;
                }
            } else {
                replicatedRecordProcessor.processRecord(dataKey, record, expiryMetadata, populateIndexes, nowInMillis);
                if (recordStore.shouldEvict()) {
                    recordStore.evictEntries(dataKey);
                    break;
                }
            }
            recordStore.disposeDeferredBlocks();
        }
    }

    protected void initializeRecordStore(String mapName, RecordStore recordStore) {
        if (!this.merkleTreeDiffByMapName.containsKey(mapName)) {
            recordStore.reset();
        }
    }

    private long entryCountOnThisNode(MapContainer mapContainer) {
        int replicaIndex = this.operation.getReplicaIndex();
        long owned = 0L;
        if (mapContainer.getEvictor() != Evictor.NULL_EVICTOR && MaxSizePolicy.PER_NODE == mapContainer.getMapConfig().getEvictionConfig().getMaxSizePolicy()) {
            MapService mapService = (MapService)this.operation.getService();
            MapServiceContext mapServiceContext = mapService.getMapServiceContext();
            IPartitionService partitionService = mapServiceContext.getNodeEngine().getPartitionService();
            int partitionCount = partitionService.getPartitionCount();
            for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
                RecordStore store;
                if (!(replicaIndex == 0 ? partitionService.isPartitionOwner(partitionId) : !partitionService.isPartitionOwner(partitionId)) || (store = mapServiceContext.getExistingRecordStore(partitionId, mapContainer.getName())) == null) continue;
                owned += (long)store.size();
            }
        }
        return owned;
    }

    private void applyIndexesState() {
        if (this.mapIndexInfos != null) {
            for (MapIndexInfo mapIndexInfo : this.mapIndexInfos) {
                this.addIndexes(mapIndexInfo.getMapName(), mapIndexInfo.getIndexConfigs());
            }
        }
    }

    private void addIndexes(String mapName, Collection<IndexConfig> indexConfigs) {
        if (indexConfigs == null) {
            return;
        }
        RecordStore recordStore = this.operation.getRecordStore(mapName);
        MapContainer mapContainer = recordStore.getMapContainer();
        if (mapContainer.isGlobalIndexEnabled()) {
            for (IndexConfig indexConfig : indexConfigs) {
                Indexes indexes = mapContainer.getIndexes();
                if (indexes.getIndex(indexConfig.getName()) != null) continue;
                indexes.addOrGetIndex(indexConfig);
            }
        } else {
            Indexes indexes = mapContainer.getIndexes(this.operation.getPartitionId());
            indexes.createIndexesFromRecordedDefinitions();
            for (IndexConfig indexConfig : indexConfigs) {
                indexes.addOrGetIndex(indexConfig);
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.storesByMapName.size());
        for (Map.Entry<String, RecordStore<Record>> entry : this.storesByMapName.entrySet()) {
            String mapName = entry.getKey();
            RecordStore<Record> recordStore = entry.getValue();
            out.writeString(mapName);
            if (out.getVersion().isGreaterOrEqual(Versions.V5_0)) {
                this.writeRecordStoreV5(mapName, recordStore, out);
            } else {
                this.writeRecordStoreV42(mapName, recordStore, out);
            }
            recordStore.getStats().writeData(out);
        }
        out.writeInt(this.loaded.size());
        for (Map.Entry<String, Object> entry : this.loaded.entrySet()) {
            out.writeString(entry.getKey());
            out.writeBoolean((Boolean)entry.getValue());
        }
        out.writeInt(this.mapIndexInfos.size());
        for (MapIndexInfo mapIndexInfo : this.mapIndexInfos) {
            out.writeObject(mapIndexInfo);
        }
    }

    private void writeRecordStoreV5(String mapName, RecordStore<Record> recordStore, ObjectDataOutput out) throws IOException {
        if (this.merkleTreeDiffByMapName.containsKey(mapName)) {
            out.writeBoolean(true);
            this.writeDifferentialData(mapName, recordStore, out);
        } else {
            out.writeBoolean(false);
            this.writeRecordStoreData(recordStore, out);
        }
    }

    private void writeRecordStoreV42(String mapName, RecordStore<Record> recordStore, ObjectDataOutput out) throws IOException {
        this.writeRecordStoreData(recordStore, out);
    }

    protected void writeDifferentialData(String mapName, RecordStore<Record> recordStore, ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeRecordStoreData(RecordStore<Record> recordStore, ObjectDataOutput out) throws IOException {
        SerializationService ss = MapReplicationStateHolder.getSerializationService(recordStore.getMapContainer());
        out.writeInt(recordStore.size());
        recordStore.forEach((dataKey, record) -> {
            try {
                IOUtil.writeData(out, dataKey);
                ExpiryMetadata expiryMetadata = recordStore.getExpirySystem().getExpiredMetadata((Data)dataKey);
                Records.writeRecord(out, record, ss.toData(record.getValue()), expiryMetadata);
                Version version = out.getVersion();
                if (version.isGreaterOrEqual(Versions.V5_0)) {
                    Records.writeExpiry(out, expiryMetadata);
                }
            }
            catch (IOException e) {
                throw ExceptionUtil.rethrow(e);
            }
        }, this.operation.getReplicaIndex() != 0, true);
        this.statsByMapName.get(recordStore.getName()).incrementFullPartitionReplicationRecordsCount(recordStore.size());
    }

    protected static SerializationService getSerializationService(MapContainer mapContainer) {
        return mapContainer.getMapServiceContext().getNodeEngine().getSerializationService();
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.data = MapUtil.createHashMap(size);
        this.merkleTreeDiffByMapName = new HashMap<String, int[]>();
        this.recordStoreStatsPerMapName = MapUtil.createHashMap(size);
        for (int i = 0; i < size; ++i) {
            boolean differentialReplication;
            String mapName = in.readString();
            boolean bl = differentialReplication = in.getVersion().isGreaterOrEqual(Versions.V5_0) && in.readBoolean();
            if (differentialReplication) {
                this.readDifferentialData(mapName, in);
                continue;
            }
            this.readRecordStoreData(mapName, in);
        }
        int loadedSize = in.readInt();
        this.loaded = MapUtil.createHashMap(loadedSize);
        for (int i = 0; i < loadedSize; ++i) {
            this.loaded.put(in.readString(), in.readBoolean());
        }
        int mapIndexInfoSize = in.readInt();
        this.mapIndexInfos = new ArrayList<MapIndexInfo>(mapIndexInfoSize);
        for (int i = 0; i < mapIndexInfoSize; ++i) {
            MapIndexInfo mapIndexInfo = (MapIndexInfo)in.readObject();
            this.mapIndexInfos.add(mapIndexInfo);
        }
    }

    protected void readDifferentialData(String mapName, ObjectDataInput in) throws IOException {
        int[] diffNodeOrder = in.readIntArray();
        this.merkleTreeDiffByMapName.put(mapName, diffNodeOrder);
        this.readRecordStoreData(mapName, in);
    }

    protected void readRecordStoreData(String mapName, ObjectDataInput in) throws IOException {
        int numOfRecords = in.readInt();
        ArrayList<Object> keyRecord = new ArrayList<Object>(numOfRecords * 3);
        for (int j = 0; j < numOfRecords; ++j) {
            Version version = in.getVersion();
            boolean isV5 = version.isGreaterOrEqual(Versions.V5_0);
            Data dataKey = IOUtil.readData(in);
            ExpiryMetadata expiryMetadata = null;
            if (!isV5) {
                expiryMetadata = new ExpiryMetadataImpl();
            }
            Record record = Records.readRecord(in, expiryMetadata);
            if (isV5) {
                expiryMetadata = Records.readExpiry(in);
            }
            keyRecord.add(dataKey);
            keyRecord.add(record);
            keyRecord.add(expiryMetadata);
        }
        if (in.getVersion().isGreaterOrEqual(Versions.V4_2)) {
            LocalRecordStoreStatsImpl stats = new LocalRecordStoreStatsImpl();
            stats.readData(in);
            this.recordStoreStatsPerMapName.put(mapName, stats);
        }
        this.data.put(mapName, keyRecord);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 103;
    }

    private static boolean indexesMustBePopulated(Indexes indexes, MapReplicationOperation operation) {
        if (!indexes.haveAtLeastOneIndex()) {
            return false;
        }
        if (indexes.isGlobal()) {
            return false;
        }
        return operation.getReplicaIndex() == 0;
    }

    private static interface ReplicatedRecordProcessor {
        public void processRecord(Data var1, Record var2, ExpiryMetadata var3, boolean var4, long var5);
    }
}

