/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.RabinFingerprint;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class Schema
implements IdentifiedDataSerializable {
    private String typeName;
    private TreeMap<String, FieldDescriptor> fieldDefinitionMap;
    private int numberVarSizeFields;
    private int fixedSizeFieldsLength;
    private transient long schemaId;

    public Schema() {
    }

    public Schema(String typeName, TreeMap<String, FieldDescriptor> fieldDefinitionMap) {
        this.typeName = typeName;
        this.fieldDefinitionMap = fieldDefinitionMap;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var5_9;
        ArrayList<Object> fixedSizeFields = new ArrayList<Object>();
        ArrayList<FieldDescriptor> booleanFields = new ArrayList<FieldDescriptor>();
        ArrayList<FieldDescriptor> variableSizeFields = new ArrayList<FieldDescriptor>();
        for (FieldDescriptor fieldDescriptor : this.fieldDefinitionMap.values()) {
            FieldType fieldType = fieldDescriptor.getType();
            if (FieldOperations.fieldOperations(fieldType).typeSizeInBytes() == -1) {
                variableSizeFields.add(fieldDescriptor);
                continue;
            }
            if (FieldType.BOOLEAN.equals((Object)fieldType)) {
                booleanFields.add(fieldDescriptor);
                continue;
            }
            fixedSizeFields.add(fieldDescriptor);
        }
        fixedSizeFields.sort(Comparator.comparingInt(d -> FieldOperations.fieldOperations(((FieldDescriptor)d).getType()).typeSizeInBytes()).reversed());
        int offset = 0;
        for (Object descriptor : fixedSizeFields) {
            ((FieldDescriptor)descriptor).setOffset(offset);
            offset += FieldOperations.fieldOperations(((FieldDescriptor)descriptor).getType()).typeSizeInBytes();
        }
        boolean bl = false;
        for (FieldDescriptor fieldDescriptor : booleanFields) {
            fieldDescriptor.setOffset(offset);
            fieldDescriptor.setBitOffset((byte)(var5_9 % 8));
            if (++var5_9 % 8 != false) continue;
            ++offset;
        }
        if (var5_9 % 8 != false) {
            ++offset;
        }
        this.fixedSizeFieldsLength = offset;
        int index = 0;
        for (FieldDescriptor fieldDescriptor : variableSizeFields) {
            fieldDescriptor.setIndex(index++);
        }
        this.numberVarSizeFields = index;
        this.schemaId = RabinFingerprint.fingerprint64(this);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Collection<FieldDescriptor> getFields() {
        return this.fieldDefinitionMap.values();
    }

    public Set<String> getFieldNames() {
        return this.fieldDefinitionMap.keySet();
    }

    public int getNumberOfVariableSizeFields() {
        return this.numberVarSizeFields;
    }

    public int getFixedSizeFieldsLength() {
        return this.fixedSizeFieldsLength;
    }

    public int getFieldCount() {
        return this.fieldDefinitionMap.size();
    }

    public FieldDescriptor getField(String fieldName) {
        return this.fieldDefinitionMap.get(fieldName);
    }

    public boolean hasField(String fieldName) {
        return this.fieldDefinitionMap.containsKey(fieldName);
    }

    public long getSchemaId() {
        return this.schemaId;
    }

    public String toString() {
        return "Schema { className = " + this.typeName + " numberOfComplexFields = " + this.numberVarSizeFields + " primitivesLength = " + this.fixedSizeFieldsLength + ", map = " + this.fieldDefinitionMap + '}';
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.typeName);
        out.writeInt(this.fieldDefinitionMap.size());
        Collection<FieldDescriptor> fields = this.fieldDefinitionMap.values();
        for (FieldDescriptor descriptor : fields) {
            out.writeString(descriptor.getFieldName());
            out.writeByte(descriptor.getType().getId());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.typeName = in.readString();
        int fieldDefinitionsSize = in.readInt();
        this.fieldDefinitionMap = new TreeMap(Comparator.naturalOrder());
        for (int i = 0; i < fieldDefinitionsSize; ++i) {
            String fieldName = in.readString();
            byte type = in.readByte();
            FieldType fieldType = FieldType.get(type);
            FieldDescriptor descriptor = new FieldDescriptor(fieldName, fieldType);
            this.fieldDefinitionMap.put(fieldName, descriptor);
        }
        this.init();
    }

    @Override
    public int getFactoryId() {
        return SchemaDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        return this.numberVarSizeFields == schema.numberVarSizeFields && this.fixedSizeFieldsLength == schema.fixedSizeFieldsLength && this.schemaId == schema.schemaId && Objects.equals(this.typeName, schema.typeName) && Objects.equals(this.fieldDefinitionMap, schema.fieldDefinitionMap);
    }

    public int hashCode() {
        return (int)this.schemaId;
    }
}

