/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.dto;

import com.hazelcast.cp.internal.raft.impl.RaftDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class AppendSuccessResponse
implements IdentifiedDataSerializable {
    private RaftEndpoint follower;
    private int term;
    private long lastLogIndex;
    private long queryRound;

    public AppendSuccessResponse() {
    }

    public AppendSuccessResponse(RaftEndpoint follower, int term, long lastLogIndex, long queryRound) {
        this.follower = follower;
        this.term = term;
        this.lastLogIndex = lastLogIndex;
        this.queryRound = queryRound;
    }

    public RaftEndpoint follower() {
        return this.follower;
    }

    public int term() {
        return this.term;
    }

    public long lastLogIndex() {
        return this.lastLogIndex;
    }

    public long queryRound() {
        return this.queryRound;
    }

    @Override
    public int getFactoryId() {
        return RaftDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.term);
        out.writeObject(this.follower);
        out.writeLong(this.lastLogIndex);
        out.writeLong(this.queryRound);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.term = in.readInt();
        this.follower = (RaftEndpoint)in.readObject();
        this.lastLogIndex = in.readLong();
        this.queryRound = in.readLong();
    }

    public String toString() {
        return "AppendSuccessResponse{follower=" + this.follower + ", term=" + this.term + ", lastLogIndex=" + this.lastLogIndex + ", queryRound=" + this.queryRound + '}';
    }
}

