/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.Client;
import com.hazelcast.client.impl.ClientImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.connection.tcp.TcpClientConnection;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.impl.TranslateToPublicAddressProvider;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.InitialMembershipEvent;
import com.hazelcast.cluster.InitialMembershipListener;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MemberSelector;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.MemberSelectingCollection;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class ClientClusterServiceImpl
implements ClientClusterService {
    private static final int INITIAL_MEMBERS_TIMEOUT_SECONDS = 120;
    private static final MemberListSnapshot EMPTY_SNAPSHOT = new MemberListSnapshot(-1, new LinkedHashMap());
    private final HazelcastClientInstanceImpl client;
    private final AtomicReference<MemberListSnapshot> memberListSnapshot = new AtomicReference<MemberListSnapshot>(EMPTY_SNAPSHOT);
    private final ConcurrentMap<UUID, MembershipListener> listeners = new ConcurrentHashMap<UUID, MembershipListener>();
    private final Set<String> labels;
    private final ILogger logger;
    private final ClientConnectionManager connectionManager;
    private final Object clusterViewLock = new Object();
    private final TranslateToPublicAddressProvider translateToPublicAddress;
    private CountDownLatch initialListFetchedLatch = new CountDownLatch(1);

    public ClientClusterServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.labels = Collections.unmodifiableSet(client.getClientConfig().getLabels());
        this.logger = client.getLoggingService().getLogger(ClientClusterService.class);
        this.connectionManager = client.getConnectionManager();
        this.translateToPublicAddress = new TranslateToPublicAddressProvider(client.getClientConfig().getNetworkConfig(), client.getProperties(), this.logger);
    }

    @Override
    public Member getMember(@Nonnull UUID uuid) {
        Preconditions.checkNotNull(uuid, "UUID must not be null");
        return (Member)this.memberListSnapshot.get().members.get(uuid);
    }

    @Override
    public Collection<Member> getMemberList() {
        return this.memberListSnapshot.get().members.values();
    }

    @Override
    public Collection<Member> getMembers(@Nonnull MemberSelector selector) {
        Preconditions.checkNotNull(selector, "selector must not be null");
        return new MemberSelectingCollection<Member>(this.getMemberList(), selector);
    }

    @Override
    public Member getMasterMember() {
        Collection<Member> memberList = this.getMemberList();
        Iterator<Member> iterator = memberList.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.getMemberList().size();
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis();
    }

    @Override
    public boolean translateToPublicAddress() {
        return this.translateToPublicAddress.get();
    }

    @Override
    public Client getLocalClient() {
        ClientConnectionManager cm = this.client.getConnectionManager();
        TcpClientConnection connection = (TcpClientConnection)cm.getRandomConnection();
        InetSocketAddress inetSocketAddress = connection != null ? connection.getLocalSocketAddress() : null;
        UUID clientUuid = cm.getClientUuid();
        return new ClientImpl(clientUuid, inetSocketAddress, this.client.getName(), this.labels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public UUID addMembershipListener(@Nonnull MembershipListener listener) {
        Preconditions.checkNotNull(listener, "Listener can't be null");
        Object object = this.clusterViewLock;
        synchronized (object) {
            UUID id = this.addMembershipListenerWithoutInit(listener);
            if (listener instanceof InitialMembershipListener) {
                Cluster cluster = this.client.getCluster();
                Collection<Member> members = this.memberListSnapshot.get().members.values();
                if (!members.isEmpty()) {
                    InitialMembershipEvent event = new InitialMembershipEvent(cluster, this.toUnmodifiableHasSet(members));
                    ((InitialMembershipListener)listener).init(event);
                }
            }
            return id;
        }
    }

    private UUID addMembershipListenerWithoutInit(@Nonnull MembershipListener listener) {
        UUID id = UuidUtil.newUnsecureUUID();
        this.listeners.put(id, listener);
        return id;
    }

    @Override
    public boolean removeMembershipListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId can't be null");
        return this.listeners.remove(registrationId) != null;
    }

    public void start(Collection<EventListener> configuredListeners) {
        configuredListeners.stream().filter(listener -> listener instanceof MembershipListener).forEach(listener -> this.addMembershipListener((MembershipListener)listener));
    }

    public void waitInitialMemberListFetched() {
        try {
            boolean success = this.initialListFetchedLatch.await(120L, TimeUnit.SECONDS);
            if (!success) {
                throw new IllegalStateException("Could not get initial member list from cluster!");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMemberListVersion() {
        Object object = this.clusterViewLock;
        synchronized (object) {
            MemberListSnapshot clusterViewSnapshot;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Resetting the member list version ");
            }
            if ((clusterViewSnapshot = this.memberListSnapshot.get()) != EMPTY_SNAPSHOT) {
                this.memberListSnapshot.set(new MemberListSnapshot(0, clusterViewSnapshot.members));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMemberList() {
        List<MembershipEvent> events = null;
        Object object = this.clusterViewLock;
        synchronized (object) {
            MemberListSnapshot clusterViewSnapshot;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Resetting the member list ");
            }
            if ((clusterViewSnapshot = this.memberListSnapshot.get()) != EMPTY_SNAPSHOT) {
                Collection<Member> prevMembers = clusterViewSnapshot.members.values();
                this.memberListSnapshot.set(new MemberListSnapshot(0, new LinkedHashMap()));
                events = this.detectMembershipEvents(prevMembers, Collections.EMPTY_SET);
            }
        }
        if (events != null) {
            this.fireEvents(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.clusterViewLock;
        synchronized (object) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Resetting the cluster snapshot");
            }
            this.initialListFetchedLatch = new CountDownLatch(1);
            this.memberListSnapshot.set(EMPTY_SNAPSHOT);
        }
    }

    private void applyInitialState(int version, Collection<MemberInfo> memberInfos) {
        MemberListSnapshot snapshot = this.createSnapshot(version, memberInfos);
        this.translateToPublicAddress.refresh(this.client.getClusterDiscoveryService().current().getAddressProvider(), memberInfos);
        this.memberListSnapshot.set(snapshot);
        this.logger.info(this.membersString(snapshot));
        Set<Member> members = this.toUnmodifiableHasSet(snapshot.members.values());
        InitialMembershipEvent event = new InitialMembershipEvent(this.client.getCluster(), members);
        for (MembershipListener listener : this.listeners.values()) {
            if (!(listener instanceof InitialMembershipListener)) continue;
            ((InitialMembershipListener)listener).init(event);
        }
    }

    private MemberListSnapshot createSnapshot(int memberListVersion, Collection<MemberInfo> memberInfos) {
        LinkedHashMap<UUID, MemberImpl> newMembers = new LinkedHashMap<UUID, MemberImpl>();
        for (MemberInfo memberInfo : memberInfos) {
            Map<EndpointQualifier, Address> addressMap = memberInfo.getAddressMap();
            MemberImpl.Builder memberBuilder = addressMap == null || addressMap.isEmpty() ? new MemberImpl.Builder(memberInfo.getAddress()) : new MemberImpl.Builder(addressMap).address(addressMap.getOrDefault(EndpointQualifier.CLIENT, addressMap.get(EndpointQualifier.MEMBER)));
            memberBuilder.version(memberInfo.getVersion()).uuid(memberInfo.getUuid()).attributes(memberInfo.getAttributes()).liteMember(memberInfo.isLiteMember()).memberListJoinVersion(memberInfo.getMemberListJoinVersion());
            newMembers.put(memberInfo.getUuid(), memberBuilder.build());
        }
        return new MemberListSnapshot(memberListVersion, newMembers);
    }

    private Set<Member> toUnmodifiableHasSet(Collection<Member> members) {
        return Collections.unmodifiableSet(new HashSet<Member>(members));
    }

    private List<MembershipEvent> detectMembershipEvents(Collection<Member> prevMembers, Set<Member> currentMembers) {
        MemberListSnapshot memberListSnapshot;
        LinkedList<Member> newMembers = new LinkedList<Member>();
        HashSet<Member> deadMembers = new HashSet<Member>(prevMembers);
        for (Member member : currentMembers) {
            if (deadMembers.remove(member)) continue;
            newMembers.add(member);
        }
        LinkedList<MembershipEvent> events = new LinkedList<MembershipEvent>();
        for (Member member : deadMembers) {
            events.add(new MembershipEvent(this.client.getCluster(), member, 2, currentMembers));
            ClientConnection connection = this.connectionManager.getConnection(member.getUuid());
            if (connection == null) continue;
            connection.close(null, new TargetDisconnectedException("The client has closed the connection to this member, after receiving a member left event from the cluster. " + connection));
        }
        for (Member member : newMembers) {
            events.add(new MembershipEvent(this.client.getCluster(), member, 1, currentMembers));
        }
        if (events.size() != 0 && (memberListSnapshot = this.memberListSnapshot.get()).members.values().size() != 0) {
            this.logger.info(this.membersString(memberListSnapshot));
        }
        return events;
    }

    private String membersString(MemberListSnapshot snapshot) {
        Collection members = snapshot.members.values();
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        sb.append(members.size());
        sb.append("] {");
        for (Member member : members) {
            sb.append("\n\t").append(member);
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMembersViewEvent(int memberListVersion, Collection<MemberInfo> memberInfos) {
        MemberListSnapshot clusterViewSnapshot;
        if (this.logger.isFinestEnabled()) {
            MemberListSnapshot snapshot = this.createSnapshot(memberListVersion, memberInfos);
            this.logger.finest("Handling new snapshot with membership version: " + memberListVersion + ", membersString " + this.membersString(snapshot));
        }
        if ((clusterViewSnapshot = this.memberListSnapshot.get()) == EMPTY_SNAPSHOT) {
            Object object = this.clusterViewLock;
            synchronized (object) {
                clusterViewSnapshot = this.memberListSnapshot.get();
                if (clusterViewSnapshot == EMPTY_SNAPSHOT) {
                    this.applyInitialState(memberListVersion, memberInfos);
                    this.initialListFetchedLatch.countDown();
                    return;
                }
            }
        }
        List<MembershipEvent> events = Collections.emptyList();
        if (memberListVersion >= clusterViewSnapshot.version) {
            Object object = this.clusterViewLock;
            synchronized (object) {
                clusterViewSnapshot = this.memberListSnapshot.get();
                if (memberListVersion >= clusterViewSnapshot.version) {
                    Collection<Member> prevMembers = clusterViewSnapshot.members.values();
                    MemberListSnapshot snapshot = this.createSnapshot(memberListVersion, memberInfos);
                    this.memberListSnapshot.set(snapshot);
                    Set<Member> currentMembers = this.toUnmodifiableHasSet(snapshot.members.values());
                    events = this.detectMembershipEvents(prevMembers, currentMembers);
                }
            }
        }
        this.fireEvents(events);
    }

    private void fireEvents(List<MembershipEvent> events) {
        for (MembershipEvent event : events) {
            for (MembershipListener listener : this.listeners.values()) {
                if (event.getEventType() == 1) {
                    listener.memberAdded(event);
                    continue;
                }
                listener.memberRemoved(event);
            }
        }
    }

    private static final class MemberListSnapshot {
        private final int version;
        private final LinkedHashMap<UUID, Member> members;

        private MemberListSnapshot(int version, LinkedHashMap<UUID, Member> members) {
            this.version = version;
            this.members = members;
        }
    }
}

