/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class IndexInfo
implements IdentifiedDataSerializable,
Comparable<IndexInfo> {
    private String attributeName;
    private boolean ordered;

    public IndexInfo() {
    }

    public IndexInfo(String attributeName, boolean ordered) {
        this.attributeName = attributeName;
        this.ordered = ordered;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.attributeName);
        out.writeBoolean(this.ordered);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributeName = in.readUTF();
        this.ordered = in.readBoolean();
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 98;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexInfo indexInfo = (IndexInfo)o;
        if (this.ordered != indexInfo.ordered) {
            return false;
        }
        return this.attributeName != null ? this.attributeName.equals(indexInfo.attributeName) : indexInfo.attributeName == null;
    }

    public int hashCode() {
        int result = this.attributeName != null ? this.attributeName.hashCode() : 0;
        result = 31 * result + (this.ordered ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(IndexInfo other) {
        int attributeNameCompareResult = this.attributeName.compareTo(other.attributeName);
        if (attributeNameCompareResult == 0) {
            return Boolean.valueOf(this.ordered).compareTo(other.ordered);
        }
        return attributeNameCompareResult;
    }
}

