/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.nio.ClassNameFilter;
import com.hazelcast.util.Preconditions;

public final class SerializationClassNameFilter
implements ClassNameFilter {
    private static final String DESERIALIZATION_ERROR = "Resolving class %s is not allowed.";
    private final ClassFilter blacklist;
    private final ClassFilter whitelist;

    public SerializationClassNameFilter(JavaSerializationFilterConfig config) {
        Preconditions.checkNotNull(config, "JavaSerializationFilterConfig has to be provided");
        this.blacklist = config.getBlacklist();
        this.whitelist = config.getWhitelist();
    }

    @Override
    public void filter(String className) throws SecurityException {
        if (this.blacklist.isListed(className) || !this.whitelist.isEmpty() && !this.whitelist.isListed(className)) {
            throw new SecurityException(String.format(DESERIALIZATION_ERROR, className));
        }
    }
}

