/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions.appenders.logstash;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import com.openexchange.logback.extensions.appenders.AbstractRemoteAppender;
import com.openexchange.logback.extensions.appenders.logstash.LogstashAppenderMBean;
import com.openexchange.logback.extensions.appenders.logstash.LogstashAppenderProperty;
import com.openexchange.logback.extensions.appenders.logstash.LogstashExceptionHandler;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;

public class LogstashAppender
extends AbstractRemoteAppender<Socket>
implements SocketConnector.ExceptionHandler,
LogstashAppenderMBean {
    private static final AtomicReference<LogstashAppender> REF = new AtomicReference();
    private static final String NAME = "logstash";
    private static final int ACCEPT_TIMEOUT_CONNECTION = 10000;
    private int port;
    private String remoteHost;
    private InetAddress address;
    private String peerId;
    private Future<?> connectionOverwatch;
    private int reconnectionDelay;
    private Duration eventDelayLimit;
    private int acceptConnectionTimeout;
    private Boolean keepAlive;
    private OutputStream socketOutputStream;

    public static LogstashAppender getInstance() {
        return REF.get();
    }

    @Override
    protected String getAppenderName() {
        return NAME;
    }

    @Override
    public void start() {
        REF.set(this);
        if (this.isStarted()) {
            return;
        }
        this.exceptionHandler = new LogstashExceptionHandler((ContextAwareBase)this, this.peerId);
        int errorCount = 0;
        if (this.port <= 0) {
            ++errorCount;
            this.addWarn("No port was configured for appender " + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.remoteHost == null) {
            ++errorCount;
            this.addWarn("No remote host was configured for appender " + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        this.setOptionalProperties();
        if (errorCount == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException ex) {
                this.addError("unknown host: " + this.remoteHost, ex);
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            this.peerId = this.remoteHost + ":" + this.port;
            super.start();
        }
    }

    private void setOptionalProperties() {
        this.keepAlive = this.getProperty(LogstashAppenderProperty.keepAlive, false);
        this.acceptConnectionTimeout = this.getProperty(LogstashAppenderProperty.acceptConnectionTimeout, 10000);
    }

    @Override
    protected void postStop() {
        this.connectionOverwatch.cancel(true);
        this.closeStreams(this.socketOutputStream);
        REF.set(null);
    }

    public void connectionFailed(SocketConnector connector, Exception ex) {
        this.handleConnectionException(ex);
    }

    private void handleConnectionException(Exception ex) {
        this.exceptionHandler.handle(ex);
        try {
            this.cleanQueueIfNecessary();
        }
        catch (IOException e) {
            this.addError("Failed while cleaning queue.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispatchEvents() {
        ILoggingEvent event = null;
        Socket s = (Socket)this.getConnector();
        try {
            s.setSoTimeout(this.acceptConnectionTimeout);
            this.socketOutputStream = new BufferedOutputStream(s.getOutputStream());
            this.addInfo("Dispatching events...");
            while (true) {
                if (this.connectionOverwatch.isDone()) {
                    throw new IOException("Remote peer " + this.peerId + " closed the connection.");
                }
                event = (ILoggingEvent)this.queue.take();
                this.writeBytes(this.socketOutputStream, this.encoder.encode((Object)event));
                event = null;
            }
        }
        catch (IOException ex) {
            this.handleConnectionException(ex);
            CloseUtil.closeQuietly((Socket)s);
            this.addInfo("Connection to " + this.peerId + " closed.");
            if (event != null) {
                this.doAppend(event);
            }
            s = null;
        }
        catch (InterruptedException ex) {
            try {
                this.handleConnectionException(ex);
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly((Socket)s);
                this.addInfo("Connection to " + this.peerId + " closed.");
                if (event != null) {
                    this.doAppend(event);
                }
                s = null;
                throw throwable;
            }
            CloseUtil.closeQuietly((Socket)s);
            this.addInfo("Connection to " + this.peerId + " closed.");
            if (event != null) {
                this.doAppend(event);
            }
            s = null;
        }
    }

    private SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    @Override
    protected Callable<Socket> createConnector() {
        this.addInfo("Creating socket connector for " + this.peerId + " ...");
        DefaultSocketConnector connector = new DefaultSocketConnector(this.address, this.port, 0L, (long)this.reconnectionDelay);
        connector.setExceptionHandler((SocketConnector.ExceptionHandler)this);
        connector.setSocketFactory(this.getSocketFactory());
        this.addInfo("Socket connector for " + this.peerId + " created.");
        return connector;
    }

    @Override
    protected Socket waitForConnectorInitialisation() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.addInfo("Trying to connect to " + this.peerId + "...");
        Socket s = (Socket)this.connectorTask.get(this.getConnectionTimeout(), TimeUnit.MILLISECONDS);
        s.setKeepAlive(this.keepAlive);
        this.addInfo("Connection established to " + this.peerId + ".");
        this.connectorTask = null;
        this.connectionOverwatch = this.getContext().getScheduledExecutorService().submit(new ConnectionOverwatch(s.getInputStream()));
        return s;
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(int delay) {
        this.reconnectionDelay = delay;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    @Override
    public void setEventDelayLimit(Duration eventDelayLimit) {
        this.eventDelayLimit = eventDelayLimit;
    }

    public Duration getEventDelayLimit() {
        return this.eventDelayLimit;
    }

    void setAcceptConnectionTimeout(int acceptConnectionTimeout) {
        this.acceptConnectionTimeout = acceptConnectionTimeout;
    }

    private void closeStreams(OutputStream ... outputStreams) {
        for (OutputStream os : outputStreams) {
            this.closeStream(os);
            os = null;
        }
    }

    private void closeStream(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException e) {
            this.addStatus((Status)new ErrorStatus("Could not close output stream for " + this.getClass().getSimpleName() + ".", (Object)this, (Throwable)e));
        }
    }

    private class ConnectionOverwatch
    implements Runnable {
        private final InputStream inputStream;

        public ConnectionOverwatch(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (this.inputStream.read() != -1) {
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    continue;
                }
                catch (Exception e) {
                    LogstashAppender.this.addError("An unexpected error occurred: ", e);
                }
                break;
            }
        }
    }
}

