/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.MediaMetadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class MediaInfo {
    public static final MediaInfo PENDING = new MediaInfo().withTag(Tag.PENDING);
    private Tag _tag;
    private MediaMetadata metadataValue;

    private MediaInfo() {
    }

    private MediaInfo withTag(Tag _tag) {
        MediaInfo result = new MediaInfo();
        result._tag = _tag;
        return result;
    }

    private MediaInfo withTagAndMetadata(Tag _tag, MediaMetadata metadataValue) {
        MediaInfo result = new MediaInfo();
        result._tag = _tag;
        result.metadataValue = metadataValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPending() {
        return this._tag == Tag.PENDING;
    }

    public boolean isMetadata() {
        return this._tag == Tag.METADATA;
    }

    public static MediaInfo metadata(MediaMetadata value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MediaInfo().withTagAndMetadata(Tag.METADATA, value);
    }

    public MediaMetadata getMetadataValue() {
        if (this._tag != Tag.METADATA) {
            throw new IllegalStateException("Invalid tag: required Tag.METADATA, but was Tag." + this._tag.name());
        }
        return this.metadataValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.metadataValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MediaInfo) {
            MediaInfo other = (MediaInfo)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PENDING: {
                    return true;
                }
                case METADATA: {
                    return this.metadataValue == other.metadataValue || this.metadataValue.equals(other.metadataValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<MediaInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MediaInfo value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PENDING: {
                    g.writeString("pending");
                    break;
                }
                case METADATA: {
                    g.writeStartObject();
                    this.writeTag("metadata", g);
                    g.writeFieldName("metadata");
                    MediaMetadata.Serializer.INSTANCE.serialize(value.metadataValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public MediaInfo deserialize(JsonParser p) throws IOException, JsonParseException {
            MediaInfo value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("pending".equals(tag)) {
                value = PENDING;
            } else if ("metadata".equals(tag)) {
                MediaMetadata fieldValue = null;
                Serializer.expectField("metadata", p);
                fieldValue = (MediaMetadata)MediaMetadata.Serializer.INSTANCE.deserialize(p);
                value = MediaInfo.metadata(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PENDING,
        METADATA;

    }
}

