/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import COSE.HeaderKeys;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;

public class Attribute {
    protected CBORObject objProtected = CBORObject.NewMap();
    protected CBORObject objUnprotected = CBORObject.NewMap();
    protected CBORObject objDontSend = CBORObject.NewMap();
    protected byte[] rgbProtected;
    protected byte[] externalData = new byte[0];
    @Deprecated
    public static final int ProtectedAttributes = 1;
    @Deprecated
    public static final int UnprotectedAttributes = 2;
    @Deprecated
    public static final int DontSendAttributes = 4;
    public static final int PROTECTED = 1;
    public static final int UNPROTECTED = 2;
    public static final int DO_NOT_SEND = 4;

    public void addAttribute(CBORObject label, CBORObject value, int where) throws CoseException {
        this.removeAttribute(label);
        if (label.getType() != CBORType.Integer && label.getType() != CBORType.TextString) {
            throw new CoseException("Labels must be integers or strings");
        }
        switch (where) {
            case 1: {
                if (this.rgbProtected != null) {
                    throw new CoseException("Cannot modify protected attribute if signature has been computed");
                }
                this.objProtected.Add((Object)label, (Object)value);
                break;
            }
            case 2: {
                this.objUnprotected.Add((Object)label, (Object)value);
                break;
            }
            case 4: {
                this.objDontSend.Add((Object)label, (Object)value);
                break;
            }
            default: {
                throw new CoseException("Invalid attribute location given");
            }
        }
    }

    public void addAttribute(HeaderKeys label, CBORObject value, int where) throws CoseException {
        this.addAttribute(label.AsCBOR(), value, where);
    }

    public void addAttribute(HeaderKeys label, byte[] value, int where) throws CoseException {
        this.addAttribute(label.AsCBOR(), CBORObject.FromObject((byte[])value), where);
    }

    @Deprecated
    public void AddProtected(CBORObject label, CBORObject value) throws CoseException {
        this.addAttribute(label, value, 1);
    }

    @Deprecated
    public void AddProtected(HeaderKeys label, CBORObject value) throws CoseException {
        this.addAttribute(label, value, 1);
    }

    @Deprecated
    public void AddProtected(HeaderKeys label, byte[] value) throws CoseException {
        this.addAttribute(label, value, 1);
    }

    @Deprecated
    public void AddUnprotected(CBORObject label, CBORObject value) throws CoseException {
        this.addAttribute(label, value, 2);
    }

    @Deprecated
    public void AddUnprotected(HeaderKeys label, CBORObject value) throws CoseException {
        this.addAttribute(label, value, 2);
    }

    @Deprecated
    public void AddUnprotected(HeaderKeys label, byte[] value) throws CoseException {
        this.addAttribute(label, value, 2);
    }

    public CBORObject findAttribute(CBORObject label) {
        return this.findAttribute(label, 7);
    }

    public CBORObject findAttribute(CBORObject label, int where) {
        if ((where & 1) == 1 && this.objProtected.ContainsKey(label)) {
            return this.objProtected.get(label);
        }
        if ((where & 2) == 2 && this.objUnprotected.ContainsKey(label)) {
            return this.objUnprotected.get(label);
        }
        if ((where & 4) == 4 && this.objDontSend.ContainsKey(label)) {
            return this.objDontSend.get(label);
        }
        return null;
    }

    public CBORObject findAttribute(HeaderKeys label) {
        return this.findAttribute(label.AsCBOR(), 7);
    }

    public CBORObject findAttribute(HeaderKeys label, int where) {
        return this.findAttribute(label.AsCBOR(), where);
    }

    public CBORObject getProtectedAttributes() {
        return this.objProtected;
    }

    public CBORObject getUnprotectedAttributes() {
        return this.objUnprotected;
    }

    public CBORObject getDoNotSendAttributes() {
        return this.objDontSend;
    }

    public void removeAttribute(CBORObject label) throws CoseException {
        if (this.objProtected.ContainsKey(label)) {
            if (this.rgbProtected != null) {
                throw new CoseException("Operation would modify integrity protected attributes");
            }
            this.objProtected.Remove(label);
        }
        if (this.objUnprotected.ContainsKey(label)) {
            this.objUnprotected.Remove(label);
        }
        if (this.objDontSend.ContainsKey(label)) {
            this.objDontSend.Remove(label);
        }
    }

    public void removeAttribute(HeaderKeys label) throws CoseException {
        this.removeAttribute(label.AsCBOR());
    }

    public byte[] getExternal() {
        return this.externalData;
    }

    public void setExternal(byte[] rgbData) {
        if (rgbData == null) {
            rgbData = new byte[]{};
        }
        this.externalData = rgbData;
    }
}

