/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.record.DataRecordWithStats;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.SimpleRecord;
import com.hazelcast.map.impl.record.SimpleRecordWithLFUEviction;
import com.hazelcast.map.impl.record.SimpleRecordWithLRUEviction;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.version.Version;
import java.io.IOException;

public enum RecordReaderWriter {
    DATA_RECORD_WITH_STATS_READER_WRITER(2){

        @Override
        void writeRecord(ObjectDataOutput out, Record record, Data dataValue, ExpiryMetadata expiryMetadata) throws IOException {
            IOUtil.writeData(out, dataValue);
            Version version = out.getVersion();
            if (version.isGreaterOrEqual(Versions.V5_0)) {
                out.writeInt(record.getRawCreationTime());
                out.writeInt(record.getRawLastAccessTime());
                out.writeInt(record.getRawLastUpdateTime());
                out.writeInt(record.getHits());
                out.writeInt(record.getVersion());
                out.writeInt(record.getRawLastStoredTime());
            } else {
                out.writeInt(expiryMetadata.getRawTtl());
                out.writeInt(expiryMetadata.getRawMaxIdle());
                out.writeInt(record.getRawCreationTime());
                out.writeInt(record.getRawLastAccessTime());
                out.writeInt(record.getRawLastUpdateTime());
                out.writeInt(record.getHits());
                out.writeLong(record.getVersion());
                out.writeInt(record.getRawLastStoredTime());
                out.writeInt(expiryMetadata.getRawExpirationTime());
            }
        }

        @Override
        public Record readRecord(ObjectDataInput in, ExpiryMetadata expiryMetadata) throws IOException {
            DataRecordWithStats record = new DataRecordWithStats();
            record.setValue(IOUtil.readData(in));
            Version version = in.getVersion();
            if (version.isGreaterOrEqual(Versions.V5_0)) {
                record.setRawCreationTime(in.readInt());
                record.setRawLastAccessTime(in.readInt());
                record.setRawLastUpdateTime(in.readInt());
                record.setHits(in.readInt());
                record.setVersion(in.readInt());
                record.setRawLastStoredTime(in.readInt());
            } else {
                expiryMetadata.setRawTtl(in.readInt());
                expiryMetadata.setRawMaxIdle(in.readInt());
                record.setRawCreationTime(in.readInt());
                record.setRawLastAccessTime(in.readInt());
                record.setRawLastUpdateTime(in.readInt());
                record.setHits(in.readInt());
                record.setVersion(RecordReaderWriter.longToIntVersion(in.readLong()));
                record.setRawLastStoredTime(in.readInt());
                expiryMetadata.setRawExpirationTime(in.readInt());
            }
            return record;
        }
    }
    ,
    SIMPLE_DATA_RECORD_READER_WRITER(3){

        @Override
        void writeRecord(ObjectDataOutput out, Record record, Data dataValue, ExpiryMetadata expiryMetadata) throws IOException {
            IOUtil.writeData(out, dataValue);
            out.writeInt(record.getVersion());
            Version version = out.getVersion();
            if (!version.isGreaterOrEqual(Versions.V5_0)) {
                expiryMetadata.write(out);
            }
        }

        @Override
        public Record readRecord(ObjectDataInput in, ExpiryMetadata expiryMetadata) throws IOException {
            SimpleRecord<Data> record = new SimpleRecord<Data>();
            record.setValue(IOUtil.readData(in));
            record.setVersion(in.readInt());
            Version version = in.getVersion();
            if (!version.isGreaterOrEqual(Versions.V5_0)) {
                expiryMetadata.read(in);
            }
            return record;
        }
    }
    ,
    SIMPLE_DATA_RECORD_WITH_LRU_EVICTION_READER_WRITER(4){

        @Override
        void writeRecord(ObjectDataOutput out, Record record, Data dataValue, ExpiryMetadata expiryMetadata) throws IOException {
            IOUtil.writeData(out, dataValue);
            out.writeInt(record.getVersion());
            out.writeInt(record.getRawLastAccessTime());
            Version version = out.getVersion();
            if (!version.isGreaterOrEqual(Versions.V5_0)) {
                expiryMetadata.write(out);
            }
        }

        @Override
        public Record readRecord(ObjectDataInput in, ExpiryMetadata expiryMetadata) throws IOException {
            SimpleRecordWithLRUEviction<Data> record = new SimpleRecordWithLRUEviction<Data>();
            record.setValue(IOUtil.readData(in));
            record.setVersion(in.readInt());
            record.setRawLastAccessTime(in.readInt());
            Version version = in.getVersion();
            if (!version.isGreaterOrEqual(Versions.V5_0)) {
                expiryMetadata.read(in);
            }
            return record;
        }
    }
    ,
    SIMPLE_DATA_RECORD_WITH_LFU_EVICTION_READER_WRITER(5){

        @Override
        void writeRecord(ObjectDataOutput out, Record record, Data dataValue, ExpiryMetadata expiryMetadata) throws IOException {
            IOUtil.writeData(out, dataValue);
            out.writeInt(record.getVersion());
            out.writeInt(record.getHits());
            Version version = out.getVersion();
            if (!version.isGreaterOrEqual(Versions.V5_0)) {
                expiryMetadata.write(out);
            }
        }

        @Override
        public Record readRecord(ObjectDataInput in, ExpiryMetadata expiryMetadata) throws IOException {
            SimpleRecordWithLFUEviction<Data> record = new SimpleRecordWithLFUEviction<Data>();
            record.setValue(IOUtil.readData(in));
            record.setVersion(in.readInt());
            record.setHits(in.readInt());
            Version version = in.getVersion();
            if (!version.isGreaterOrEqual(Versions.V5_0)) {
                expiryMetadata.read(in);
            }
            return record;
        }
    };

    private byte id;

    private RecordReaderWriter(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static RecordReaderWriter getById(int id) {
        switch (id) {
            case 2: {
                return DATA_RECORD_WITH_STATS_READER_WRITER;
            }
            case 3: {
                return SIMPLE_DATA_RECORD_READER_WRITER;
            }
            case 4: {
                return SIMPLE_DATA_RECORD_WITH_LRU_EVICTION_READER_WRITER;
            }
            case 5: {
                return SIMPLE_DATA_RECORD_WITH_LFU_EVICTION_READER_WRITER;
            }
        }
        throw new IllegalArgumentException("Not known RecordReaderWriter type-id: " + id);
    }

    private static int longToIntVersion(long version) {
        return version >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)version;
    }

    abstract void writeRecord(ObjectDataOutput var1, Record var2, Data var3, ExpiryMetadata var4) throws IOException;

    public abstract Record readRecord(ObjectDataInput var1, ExpiryMetadata var2) throws IOException;

    private static class TypeId {
        private static final byte DATA_RECORD_WITH_STATS_TYPE_ID = 2;
        private static final byte SIMPLE_DATA_RECORD_TYPE_ID = 3;
        private static final byte SIMPLE_DATA_RECORD_WITH_LRU_EVICTION_TYPE_ID = 4;
        private static final byte SIMPLE_DATA_RECORD_WITH_LFU_EVICTION_TYPE_ID = 5;

        private TypeId() {
        }
    }
}

