/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.core.JobSuspensionCause;
import com.hazelcast.jet.core.metrics.JobMetrics;
import com.hazelcast.jet.impl.AbstractJobProxy;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobMetricsUtil;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.operation.GetJobConfigOperation;
import com.hazelcast.jet.impl.operation.GetJobMetricsOperation;
import com.hazelcast.jet.impl.operation.GetJobStatusOperation;
import com.hazelcast.jet.impl.operation.GetJobSubmissionTimeOperation;
import com.hazelcast.jet.impl.operation.GetJobSuspensionCauseOperation;
import com.hazelcast.jet.impl.operation.JoinSubmittedJobOperation;
import com.hazelcast.jet.impl.operation.ResumeJobOperation;
import com.hazelcast.jet.impl.operation.SubmitJobOperation;
import com.hazelcast.jet.impl.operation.TerminateJobOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class JobProxy
extends AbstractJobProxy<NodeEngineImpl, Address> {
    public JobProxy(NodeEngineImpl nodeEngine, long jobId, Address coordinator) {
        super(nodeEngine, jobId, coordinator);
    }

    public JobProxy(NodeEngineImpl engine, long jobId, boolean isLightJob, @Nonnull Object jobDefinition, @Nonnull JobConfig config) {
        super(engine, jobId, isLightJob, jobDefinition, config);
    }

    @Override
    @Nonnull
    public JobStatus getStatus0() {
        assert (!this.isLightJob());
        try {
            return (JobStatus)((Object)this.invokeOp(new GetJobStatusOperation(this.getId())).get());
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    @Nonnull
    public JobSuspensionCause getSuspensionCause() {
        this.checkNotLightJob("suspensionCause");
        try {
            return (JobSuspensionCause)this.invokeOp(new GetJobSuspensionCauseOperation(this.getId())).get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    @Nonnull
    public JobMetrics getMetrics() {
        this.checkNotLightJob("metrics");
        try {
            List shards = (List)this.invokeOp(new GetJobMetricsOperation(this.getId())).get();
            return JobMetricsUtil.toJobMetrics(shards);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    protected Address findLightJobCoordinator() {
        return ((NodeEngineImpl)this.container()).getThisAddress();
    }

    @Override
    protected CompletableFuture<Void> invokeSubmitJob(Data dag, JobConfig config) {
        return this.invokeOp(new SubmitJobOperation(this.getId(), dag, (Data)this.serializationService().toData(config), this.isLightJob()));
    }

    @Override
    protected CompletableFuture<Void> invokeJoinJob() {
        return this.invokeOp(new JoinSubmittedJobOperation(this.getId(), this.isLightJob()));
    }

    @Override
    protected CompletableFuture<Void> invokeTerminateJob(TerminationMode mode) {
        return this.invokeOp(new TerminateJobOperation(this.getId(), mode, this.isLightJob()));
    }

    @Override
    public void resume() {
        this.checkNotLightJob("resume");
        try {
            this.invokeOp(new ResumeJobOperation(this.getId())).get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public JobStateSnapshot cancelAndExportSnapshot(String name) {
        return this.doExportSnapshot(name, true);
    }

    @Override
    public JobStateSnapshot exportSnapshot(String name) {
        return this.doExportSnapshot(name, false);
    }

    private JobStateSnapshot doExportSnapshot(String name, boolean cancelJob) {
        this.checkNotLightJob("export snapshot");
        JetServiceBackend jetServiceBackend = (JetServiceBackend)((NodeEngineImpl)this.container()).getService("hz:impl:jetService");
        try {
            Operation operation = jetServiceBackend.createExportSnapshotOperation(this.getId(), name, cancelJob);
            this.invokeOp(operation).get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return jetServiceBackend.getJet().getJobStateSnapshot(name);
    }

    @Override
    protected long doGetJobSubmissionTime() {
        try {
            return (Long)this.invokeOp(new GetJobSubmissionTimeOperation(this.getId(), this.isLightJob())).get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    protected JobConfig doGetJobConfig() {
        try {
            return (JobConfig)this.invokeOp(new GetJobConfigOperation(this.getId())).get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    protected SerializationService serializationService() {
        return ((NodeEngineImpl)this.container()).getSerializationService();
    }

    @Override
    protected LoggingService loggingService() {
        return ((NodeEngineImpl)this.container()).getLoggingService();
    }

    @Override
    protected boolean isRunning() {
        return ((NodeEngineImpl)this.container()).isRunning();
    }

    private <T> CompletableFuture<T> invokeOp(Operation op) {
        return ((NodeEngineImpl)this.container()).getOperationService().createInvocationBuilder("hz:impl:jetService", op, (Address)this.coordinatorId()).invoke();
    }

    @Override
    @Nonnull
    protected Address masterId() {
        Address masterAddress = ((NodeEngineImpl)this.container()).getMasterAddress();
        if (masterAddress == null) {
            throw new IllegalStateException("Master address unknown: instance is not yet initialized or is shut down");
        }
        return masterAddress;
    }
}

